/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class DHKeyParams
implements Zeroizeable,
Serializable {
    private static final long serialVersionUID = -7775390436623170896L;
    private BigInteger a;
    private BigInteger b;
    private int c;
    private boolean d = false;

    public DHKeyParams() {
    }

    public DHKeyParams(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, 0);
    }

    public DHKeyParams(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        this.a = bigInteger;
        this.b = bigInteger2;
        this.c = n2;
    }

    public DHKeyParams(DHKeyParams dHKeyParams) {
        this.a = dHKeyParams.getP();
        this.b = dHKeyParams.getG();
        this.c = dHKeyParams.getL();
    }

    public BigInteger getP() {
        return this.a;
    }

    public BigInteger getG() {
        return this.b;
    }

    public int getL() {
        return this.c;
    }

    public String toString() {
        return "[ P: " + this.a.toString(16) + " G: " + this.b.toString(16) + " L: " + this.c + " ]";
    }

    public boolean isZeroized() {
        return this.d;
    }

    public boolean testZeroizationState() {
        return this.d;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.a = BigInteger.ZERO;
        this.b = BigInteger.ZERO;
        this.c = 0;
        this.d = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(new Integer(this.c));
        objectOutputStream.writeObject(new Boolean(this.d));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (BigInteger)objectInputStream.readObject();
        this.b = (BigInteger)objectInputStream.readObject();
        this.c = (Integer)objectInputStream.readObject();
        this.d = (Boolean)objectInputStream.readObject();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

