/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmLicenseElementException;
import com.macrovision.flexlm.HostId;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.TokenizedLicenseLine;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerLine
extends LicenseElement
implements FlexlmConstants {
    private String serverName;
    private int port;
    private String spxPort;
    private String protocol;
    private String hostIdString;

    public ServerLine(TokenizedLicenseLine tokenizedLicenseLine, LicenseCertificate licenseCertificate, VendorInfo vendorInfo) throws FlexlmLicenseElementException {
        this.lineText = tokenizedLicenseLine.getLineText();
        this.rawLineText = tokenizedLicenseLine.getRawLineText();
        tokenizedLicenseLine.findPositionalsAndKeywordValues(null);
        Vector vector = tokenizedLicenseLine.getPositionalParameters();
        if (vector.size() >= 3) {
            this.serverName = (String)vector.elementAt(1);
            this.hostIdString = (String)vector.elementAt(2);
            this.hostid = HostId.parseHostId(this.hostIdString, vendorInfo);
            if (vector.size() > 3) {
                String string = (String)vector.elementAt(3);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                int n = stringTokenizer.countTokens();
                switch (n) {
                    case 1: {
                        this.port = ServerLine.parsePort(stringTokenizer.nextToken(), tokenizedLicenseLine);
                        break;
                    }
                    case 2: {
                        this.protocol = stringTokenizer.nextToken();
                        if (this.protocol.equalsIgnoreCase("TCP")) {
                            this.port = ServerLine.parsePort(stringTokenizer.nextToken(), tokenizedLicenseLine);
                            break;
                        }
                        if (this.protocol.equalsIgnoreCase("SPX")) {
                            this.spxPort = stringTokenizer.nextToken();
                            break;
                        }
                        throw new FlexlmLicenseElementException(-500, 4060, tokenizedLicenseLine.getFilename(), tokenizedLicenseLine.getLineNumber(), tokenizedLicenseLine.getLineText(), null);
                    }
                    default: {
                        throw new FlexlmLicenseElementException(-500, 4059, tokenizedLicenseLine.getFilename(), tokenizedLicenseLine.getLineNumber(), tokenizedLicenseLine.getLineText(), null);
                    }
                }
            }
        } else {
            throw new FlexlmLicenseElementException(-508, 4019, tokenizedLicenseLine.getFilename(), tokenizedLicenseLine.getLineNumber(), tokenizedLicenseLine.getLineText(), null);
        }
        this.isDirty = false;
    }

    private static int parsePort(String string, TokenizedLicenseLine tokenizedLicenseLine) throws FlexlmLicenseElementException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FlexlmLicenseElementException(-500, 4018, tokenizedLicenseLine.getFilename(), tokenizedLicenseLine.getLineNumber(), tokenizedLicenseLine.getLineText(), null);
        }
        return n;
    }

    @Override
    public void authenticate() throws FlexlmException {
    }

    @Override
    public boolean isAuthentic() {
        return true;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.isDirty = true;
        this.serverName = string;
    }

    @Override
    public HostId getHostId() {
        return this.hostid;
    }

    @Override
    public String getHostIdString() {
        return this.hostid == null ? this.convertEncoding(this.hostIdString) : this.convertEncoding(this.hostid.toString());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public int getPortNumber() {
        return this.port;
    }

    public void setPortNumber(int n) {
        this.isDirty = true;
        this.port = n;
    }

    public String getSpxPort() {
        return this.spxPort;
    }

    public void setSpxPort(String string) {
        this.spxPort = string;
    }

    public String toString() {
        String string = "";
        if (this.protocol != null) {
            string = this.protocol.equalsIgnoreCase("TCP") ? this.protocol + ":" + Integer.toString(this.port) : this.protocol + ":" + this.spxPort;
        } else if (this.port > 0) {
            string = Integer.toString(this.port);
        }
        String string2 = this.getHostId() == null ? this.hostIdString : this.getHostId().toString();
        return "SERVER " + this.getServerName() + " " + string2 + " " + string;
    }
}

