/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.javaseis.properties.DataFormat;
import org.javaseis.properties.DataType;

public class DataDefinition
implements Serializable {
    protected DataType _dataType;
    protected DataFormat _traceFormat;
    protected ByteOrder _byteOrder;

    public DataDefinition(DataType dataType, DataFormat traceFormat) {
        this(dataType, traceFormat, ByteOrder.nativeOrder());
    }

    public DataDefinition(DataType dataType, DataFormat traceFormat, ByteOrder byteOrder) {
        this._dataType = dataType;
        this._traceFormat = traceFormat;
        this._byteOrder = byteOrder;
    }

    public static DataDefinition getDefault() {
        return new DataDefinition(DataType.CUSTOM, DataFormat.FLOAT, ByteOrder.nativeOrder());
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public DataFormat getTraceFormat() {
        return this._traceFormat;
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    public String getDataTypeString() {
        return this._dataType.toString();
    }

    public String getTraceFormatString() {
        return this._traceFormat.toString();
    }

    public String getByteOrderString() {
        return this._byteOrder.toString();
    }

    public int getBytesPerSample() {
        int bytesPerSample = this._traceFormat.getBytesPerSample();
        return bytesPerSample;
    }
}

