/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.javaseis.io.VirtualFolders;
import org.javaseis.io.VirtualIO;
import org.javaseis.util.SeisException;

public class BufferedVirtualIO
extends VirtualIO {
    private static final Logger LOG = Logger.getLogger(BufferedVirtualIO.class.getName());
    private long _initialPosition = -1L;
    private long _currentPosition = -1L;
    private boolean _isContiguous;
    private ByteBuffer _buffer;
    private int _bufferSize;
    private int _blockSize = 0;
    private long _diskWrites;
    private long _gapsFilled;
    private long _gapsNotFilled;
    private long _writes;

    public BufferedVirtualIO(String path, String openMode, VirtualFolders vFolders, int cacheSize, int blockSize) throws SeisException {
        super(path, openMode, vFolders);
        if (openMode.compareToIgnoreCase("r") == 0) {
            throw new IllegalArgumentException("BufferedVirtualIO can only be used when writing");
        }
        this._bufferSize = cacheSize;
        this._blockSize = blockSize;
        this._buffer = ByteBuffer.allocateDirect(this._bufferSize);
    }

    public BufferedVirtualIO(String path, String openMode, int cacheSize, int blockSize) throws SeisException {
        super(path, openMode);
        if (openMode.compareToIgnoreCase("r") == 0) {
            throw new IllegalArgumentException("BufferedVirtualIO can only be used when writing");
        }
        this._blockSize = blockSize;
        this._bufferSize = cacheSize;
        this._buffer = ByteBuffer.allocateDirect(this._bufferSize);
    }

    @Override
    public int write(ByteBuffer buffer) throws SeisException {
        ++this._writes;
        if (this._buffer.remaining() < buffer.limit()) {
            super.setPosition(this._initialPosition);
            this._buffer.flip();
            ++this._diskWrites;
            int w1 = super.write(this._buffer);
            this._buffer.clear();
            this._initialPosition += (long)w1;
        }
        if (!this._isContiguous) {
            long gap = this._currentPosition - this._initialPosition - (long)this._buffer.position();
            if (gap < (long)this._blockSize && gap < (long)this._buffer.remaining()) {
                ++this._gapsFilled;
                int i = 0;
                while ((long)i < gap) {
                    this._buffer.put((byte)0);
                    ++i;
                }
                this._isContiguous = true;
            } else {
                ++this._gapsNotFilled;
            }
        }
        if (this._isContiguous) {
            int used = buffer.limit();
            this._buffer.put(buffer);
            return used;
        }
        super.setPosition(this._initialPosition);
        this._buffer.flip();
        ++this._diskWrites;
        super.write(this._buffer);
        super.setPosition(this._currentPosition);
        ++this._diskWrites;
        int written = super.write(buffer);
        this._buffer.clear();
        this._currentPosition = -1L;
        this._initialPosition = -1L;
        return written;
    }

    @Override
    public void close() throws SeisException {
        if (this._initialPosition >= 0L) {
            super.setPosition(this._initialPosition);
            this._buffer.flip();
            ++this._diskWrites;
            super.write(this._buffer);
        }
        super.close();
    }

    public long[] getWriteStats() {
        return new long[]{this._writes, this._diskWrites, this._gapsFilled, this._gapsNotFilled};
    }

    @Override
    public void flush() throws SeisException {
        if (this._initialPosition >= 0L) {
            super.setPosition(this._initialPosition);
            this._buffer.flip();
            ++this._diskWrites;
            super.write(this._buffer);
            this._buffer.clear();
            this._currentPosition = -1L;
            this._initialPosition = -1L;
        }
        super.flush();
    }

    @Override
    public long setPosition(long newPosition) throws SeisException {
        long retPosition;
        if (this._initialPosition < 0L && this._currentPosition < 0L) {
            this._initialPosition = newPosition;
            this._isContiguous = true;
            retPosition = this._initialPosition;
        } else if (this._initialPosition + (long)this._buffer.position() == newPosition) {
            this._isContiguous = true;
            retPosition = newPosition;
        } else {
            this._isContiguous = false;
            this._currentPosition = newPosition;
            retPosition = newPosition;
        }
        return retPosition;
    }
}

