/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Iterator;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.MultiArrayPositionIterator;

public class MultiArrayTraceIterator<E>
implements Iterable,
Iterator<E> {
    private final IMultiArray _seismicArray;
    private final MultiArrayPositionIterator _positionIterator;
    private final E _trace;
    private int[] _tracePosition;

    public MultiArrayTraceIterator(IMultiArray multiArray, E trace) {
        this._seismicArray = multiArray;
        this._trace = trace;
        this._tracePosition = new int[multiArray.getDimensions()];
        this._positionIterator = new MultiArrayPositionIterator(multiArray, this._tracePosition);
    }

    public MultiArrayTraceIterator(IMultiArray multiArray, E trace, int direction) {
        this._seismicArray = multiArray;
        this._trace = trace;
        this._tracePosition = new int[multiArray.getDimensions()];
        this._positionIterator = new MultiArrayPositionIterator(multiArray, this._tracePosition, direction);
    }

    @Override
    public final boolean hasNext() {
        return this._positionIterator.hasNext();
    }

    @Override
    public E next() {
        this._tracePosition = this._positionIterator.next();
        if (this._trace instanceof float[]) {
            this._seismicArray.getTrace((float[])this._trace, this._tracePosition);
        } else if (this._trace instanceof int[]) {
            this._seismicArray.getTrace((int[])this._trace, this._tracePosition);
        } else {
            throw new RuntimeException("Data type not recognized");
        }
        return this._trace;
    }

    public int[] getPosition() {
        return this._tracePosition;
    }

    public final void putData(E data) {
        if (data instanceof float[]) {
            this._seismicArray.putTrace((float[])data, this._tracePosition);
        } else if (data instanceof int[]) {
            this._seismicArray.putTrace((int[])data, this._tracePosition);
        } else {
            throw new RuntimeException("Data type not recognized");
        }
    }

    public void reset() {
        this._positionIterator.reset();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Optional method Iterator.remove() is not implemented");
    }

    public Iterator iterator() {
        return new MultiArrayTraceIterator<E>(this._seismicArray, this._trace);
    }
}

