/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import edu.mines.jtk.util.RandomFloat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.javaseis.array.IMultiArray;
import org.javaseis.array.JPerfTestShapes;
import org.javaseis.array.MultiArray;
import org.javaseis.array.MultiArrayPositionIterator;
import org.javaseis.array.TransposeType;

public class JPerfTestMultiArrayTranspose {
    private int _logLevel;
    private boolean _doChecks;

    public JPerfTestMultiArrayTranspose() {
        this(Level.INFO, false);
    }

    public JPerfTestMultiArrayTranspose(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    private void testTranspose2D(int i0, int i1) {
        MultiArray m = new MultiArray(2, Integer.TYPE, new int[]{i0, i1});
        m.allocate();
        double arraySize = (double)(m.getArrayLength() * 4L) / 1048576.0;
        this.fillArray(m);
        this.logFine("After fill");
        this.printArray(m);
        double startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T21);
        double elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T21: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 1");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArrayTranspose21(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T21);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T21: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 2");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m);
        }
    }

    private void testTranspose3D(int i0, int i1, int i2) {
        MultiArray m = new MultiArray(3, Integer.TYPE, new int[]{i0, i1, i2});
        m.allocate();
        double arraySize = (double)(m.getArrayLength() * 4L) / 1048576.0;
        this.fillArray(m);
        this.logFine("After fill");
        this.printArray(m);
        double startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T213);
        double elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T213: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 1");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArrayTranspose213(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T213);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T213: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 2");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T132);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T132: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 1");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArrayTranspose132(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T132);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T132: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 2");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T312);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T312: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 1");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArrayTranspose312(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T231);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T231: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 2");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T321);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T321: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 1");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArrayTranspose321(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T321);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T321: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 2");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T231);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T231: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 1");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArrayTranspose231(m);
        }
        startTime = JPerfTestMultiArrayTranspose.getTime();
        m.transpose(TransposeType.T312);
        elapsedTime = JPerfTestMultiArrayTranspose.getTime() - startTime;
        this.logInfo("T312: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter transpose 2");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m);
        }
    }

    private void fillArray(IMultiArray m) {
        int imin = 0;
        int imax = Integer.MAX_VALUE;
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] buf = new int[m.getShape()[0]];
        RandomFloat r = new RandomFloat(1);
        while (it.hasNext()) {
            int[] pos = it.next();
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = imin + Math.round((float)imax * r.uniform());
            }
            m.putTrace(buf, pos);
        }
    }

    private void checkArray(IMultiArray m) {
        int imin = 0;
        int imax = Integer.MAX_VALUE;
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] buf = new int[m.getShape()[0]];
        int[] bufTrue = new int[m.getShape()[0]];
        RandomFloat r = new RandomFloat(1);
        while (it.hasNext()) {
            int[] pos = it.next();
            m.getTrace(buf, pos);
            for (int i = 0; i < buf.length; ++i) {
                bufTrue[i] = imin + Math.round((float)imax * r.uniform());
                if (buf[i] == bufTrue[i]) continue;
                System.err.println("Check failed at position " + Arrays.toString(pos) + " expected " + bufTrue[i] + " actual " + buf[i]);
            }
        }
    }

    private void checkArrayTranspose21(IMultiArray m) {
        int imin = 0;
        int imax = Integer.MAX_VALUE;
        int[] buf = new int[1];
        RandomFloat r = new RandomFloat(1);
        int[] shape = m.getShape();
        int[] pos = new int[shape.length];
        for (int i0 = 0; i0 < shape[0]; ++i0) {
            pos[0] = i0;
            for (int i1 = 0; i1 < shape[1]; ++i1) {
                pos[1] = i1;
                m.getSample(buf, pos);
                int bufTrue = imin + Math.round((float)imax * r.uniform());
                if (buf[0] == bufTrue) continue;
                System.err.println("Check failed at position " + Arrays.toString(pos) + " expected " + bufTrue + " actual " + buf[0]);
            }
        }
    }

    private void checkArrayTranspose213(IMultiArray m) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private void checkArrayTranspose132(IMultiArray m) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private void checkArrayTranspose312(IMultiArray m) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private void checkArrayTranspose321(IMultiArray m) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private void checkArrayTranspose231(IMultiArray m) {
        throw new UnsupportedOperationException("method not implemented");
    }

    private void printArray(IMultiArray m) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        MultiArrayPositionIterator it = new MultiArrayPositionIterator(m, new int[m.getDimensions()]);
        int[] shape = m.getShape();
        int[] buf = new int[shape[0]];
        while (it.hasNext()) {
            int[] pos = it.next();
            System.out.println("Values at position " + Arrays.toString(pos));
            m.getTrace(buf, pos);
            for (int i0 = 0; i0 < shape[0]; ++i0) {
                System.out.println("val[" + i0 + "] = " + buf[i0]);
            }
        }
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    public static void main(String[] args) {
        Boolean memoryPrint = false;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        JPerfTestMultiArrayTranspose tester = new JPerfTestMultiArrayTranspose();
        List<int[]> shapes2 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.TWO);
        for (int[] shape : shapes2) {
            tester.testTranspose2D(shape[0], shape[1]);
            System.gc();
        }
        List<int[]> shapes3 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        for (int[] shape : shapes3) {
            tester.testTranspose3D(shape[0], shape[1], shape[2]);
            System.gc();
        }
    }
}

