/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.velocity;

import java.util.Arrays;
import org.javaseis.grid.BinGrid;
import org.javaseis.io.Seisio;
import org.javaseis.properties.AxisLabel;
import org.javaseis.util.SeisException;
import org.javaseis.velocity.IModelAdapter;
import org.javaseis.velocity.ModelHelper;

public class UniformModelAdapter
implements IModelAdapter {
    private String pathName;
    private Seisio seisio;
    private long[] shape;
    private int m1;
    private int m2;
    private int m3;
    private double[] origins;
    private double om1;
    private double om2;
    private double om3;
    private double[] deltas;
    private float dm1;
    private float dm2;
    private float dm3;
    private float[] xmin;
    private float[] xmax;
    private double x3i;
    private double x3tol;
    private float[][] x3frame;
    private int kframe0;
    private int kframe1;
    private float[][] frame0;
    private float[][] frame1;
    private float[][][] fbuf = new float[2][][];
    private int i1;
    private int i2;
    private int i3;
    private boolean recip;
    private ModelHelper.AttributeType _attributeType = ModelHelper.AttributeType.UNKNOWN;
    private ModelHelper.OrientationType _orientationType = ModelHelper.OrientationType.NONE;
    private double azimuthTol = Math.toRadians(1.0E-4);
    private BinGrid _binGridModel = null;
    private BinGrid _binGridUser = null;
    private boolean _translationRequired = false;

    public UniformModelAdapter(String path) {
        this.pathName = path;
        this.init();
    }

    @Override
    public void setReciprocalFlag(boolean value) {
        this.recip = value;
    }

    @Override
    public boolean getReciprocalFlag() {
        return this.recip;
    }

    @Override
    public void setFrameTolerance(double tol) {
        this.x3tol = tol;
    }

    @Override
    public double getFrameTolerance() {
        return this.x3tol;
    }

    private void init() {
        try {
            this.seisio = new Seisio(this.pathName);
            this.seisio.open("r");
        }
        catch (SeisException e) {
            throw new RuntimeException(e);
        }
        try {
            this._binGridModel = this.seisio.getBinGrid();
        }
        catch (SeisException e) {
            System.err.println("UniformModelAdapter: Model file " + this.pathName + " has no bin grid!" + "  Will assume that model is commensurate with user bin grid");
            e.printStackTrace();
            this._binGridModel = null;
        }
        this.shape = this.seisio.getGridDefinition().getAxisLengths();
        this.origins = this.seisio.getGridDefinition().getAxisPhysicalOrigins();
        this.deltas = this.seisio.getGridDefinition().getAxisPhysicalDeltas();
        this._orientationType = this.setOrientationType(this.seisio.getGridDefinition().getAxisLabels());
        this.i1 = 0;
        this.i2 = 1;
        this.i3 = 2;
        this.m1 = (int)this.shape[this.i1];
        this.m2 = (int)this.shape[this.i2];
        this.m3 = (int)this.shape[this.i3];
        int maxtrc = Math.max(this.m2, this.m3);
        this.frame0 = new float[maxtrc][this.m1];
        this.frame1 = new float[maxtrc][this.m1];
        this.x3frame = new float[this.m2][this.m1];
        this.om1 = (float)this.origins[this.i1];
        this.om2 = (float)this.origins[this.i2];
        this.om3 = (float)this.origins[this.i3];
        this.dm1 = (float)this.deltas[this.i1];
        this.dm2 = (float)this.deltas[this.i2];
        this.dm3 = (float)this.deltas[this.i3];
        this.xmax = new float[3];
        this.xmax[this.i1] = (float)(this.origins[this.i1] + this.deltas[this.i1] * (double)(this.m1 - 1));
        this.xmax[this.i2] = (float)(this.origins[this.i2] + this.deltas[this.i2] * (double)(this.m2 - 1));
        this.xmax[this.i3] = (float)(this.origins[this.i3] + this.deltas[this.i3] * (double)(this.m3 - 1));
        this.fbuf[0] = this.frame0;
        this.fbuf[1] = this.frame1;
        this.x3i = -1.0;
        this.kframe0 = Integer.MIN_VALUE;
        this.kframe1 = Integer.MAX_VALUE;
        this.x3tol = 1.4E-45f;
        try {
            this.updateCache(this.om3);
        }
        catch (SeisException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private ModelHelper.OrientationType setOrientationType(AxisLabel[] axisLabels) {
        if (axisLabels[0].equals(AxisLabel.CROSSLINE) && axisLabels[1].equals(AxisLabel.INLINE) && axisLabels[2].equals(AxisLabel.DEPTH)) {
            return ModelHelper.OrientationType.XYZ;
        }
        if (axisLabels[0].equals(AxisLabel.CROSSLINE) && axisLabels[1].equals(AxisLabel.INLINE) && axisLabels[2].equals(AxisLabel.TIME)) {
            return ModelHelper.OrientationType.XYT;
        }
        if (axisLabels[0].equals(AxisLabel.DEPTH) && axisLabels[1].equals(AxisLabel.CROSSLINE) && axisLabels[2].equals(AxisLabel.INLINE)) {
            return ModelHelper.OrientationType.ZXY;
        }
        if (axisLabels[0].equals(AxisLabel.TIME) && axisLabels[1].equals(AxisLabel.CROSSLINE) && axisLabels[2].equals(AxisLabel.INLINE)) {
            return ModelHelper.OrientationType.TXY;
        }
        return ModelHelper.OrientationType.NONE;
    }

    @Override
    public void interpolateFrame(int n1, double o1, double d1, int n2, double o2, double d2, double x3, float[][] frame) {
        if (this._translationRequired) {
            double[] newCoords = this.translateCoordinates(new double[]{o1, o2, x3});
            this.interpolateFramePrivate(n1, newCoords[0], d1, n2, newCoords[1], d2, newCoords[2], frame);
        } else {
            this.interpolateFramePrivate(n1, o1, d1, n2, o2, d2, x3, frame);
        }
    }

    private void interpolateFramePrivate(int n1, double o1, double d1, int n2, double o2, double d2, double x3, float[][] frame) {
        try {
            this.updateCache(x3);
        }
        catch (SeisException e) {
            throw new RuntimeException(e.getMessage());
        }
        double x2 = o2;
        int j = 0;
        while (j < n2) {
            this.interpolateTracePrivate(n1, o1, d1, x2, x3, frame[j]);
            ++j;
            x2 += d2;
        }
    }

    @Override
    public float interpolateSample(double x1, double x2, double x3) {
        if (this._translationRequired) {
            double[] newCoords = this.translateCoordinates(new double[]{x1, x2, x3});
            return this.interpolateSamplePrivate(newCoords[0], newCoords[1], newCoords[2]);
        }
        return this.interpolateSamplePrivate(x1, x2, x3);
    }

    private float interpolateSamplePrivate(double x1, double x2, double x3) {
        try {
            this.updateCache(x3);
        }
        catch (SeisException e) {
            throw new RuntimeException(e.getMessage());
        }
        double ftr = (x2 - this.om2) / (double)this.dm2;
        int itr0 = (int)ftr;
        int itr1 = itr0 + 1;
        double b0 = 0.0;
        double b1 = 1.0;
        if (itr1 >= this.m2) {
            itr0 = this.m2 - 2;
            itr1 = this.m2 - 1;
            b0 = 0.0;
            b1 = 1.0;
        } else if (itr0 < 0) {
            itr0 = 0;
            itr1 = 1;
            b0 = 1.0;
            b1 = 0.0;
        } else {
            b1 = ftr - (double)itr0;
            b0 = 1.0 - b1;
        }
        double fs = (x1 - this.om1) / (double)this.dm1;
        int is0 = (int)fs;
        int is1 = is0 + 1;
        double a0 = 0.0;
        double a1 = 1.0;
        if (is1 >= this.m1) {
            is0 = this.m1 - 2;
            is1 = this.m1 - 1;
            a0 = 0.0;
            a1 = 1.0;
        } else if (is0 < 0) {
            is0 = 0;
            is1 = 1;
            a0 = 1.0;
            a1 = 0.0;
        } else {
            a1 = fs - (double)is0;
            a0 = 1.0 - a1;
        }
        double val = b0 * a0 * (double)this.x3frame[itr0][is0] + b1 * a0 * (double)this.x3frame[itr1][is0] + b0 * a1 * (double)this.x3frame[itr0][is1] + b1 * a1 * (double)this.x3frame[itr1][is1];
        if (this.recip) {
            val = 1.0 / val;
        }
        return (float)val;
    }

    @Override
    public void interpolateTrace(int n1, double o1, double d1, double x2, double x3, float[] trc) {
        if (this._translationRequired) {
            double[] newCoords = this.translateCoordinates(new double[]{o1, x2, x3});
            this.interpolateTracePrivate(n1, newCoords[0], d1, newCoords[1], newCoords[2], trc);
        } else {
            this.interpolateTracePrivate(n1, o1, d1, x2, x3, trc);
        }
    }

    private void interpolateTracePrivate(int n1, double o1, double d1, double x2, double x3, float[] trc) {
        try {
            this.updateCache(x3);
        }
        catch (SeisException e) {
            throw new RuntimeException(e.getMessage());
        }
        double ftr = (x2 - this.om2) / (double)this.dm2;
        int itr0 = (int)ftr;
        int itr1 = itr0 + 1;
        double b0 = 0.0;
        double b1 = 1.0;
        if (itr1 >= this.m2) {
            itr0 = this.m2 - 2;
            itr1 = this.m2 - 1;
            b0 = 0.0;
            b1 = 1.0;
        } else if (itr0 < 0) {
            itr0 = 0;
            itr1 = 1;
            b0 = 1.0;
            b1 = 0.0;
        } else {
            b1 = ftr - (double)itr0;
            b0 = 1.0 - b1;
        }
        double x1 = o1;
        double fs = 0.0;
        int is0 = 0;
        int is1 = 1;
        double a0 = 0.0;
        double a1 = 1.0;
        int i = 0;
        while (i < n1) {
            fs = (x1 - this.om1) / (double)this.dm1;
            is0 = (int)fs;
            is1 = is0 + 1;
            if (is1 >= this.m1) {
                is0 = this.m1 - 2;
                is1 = this.m1 - 1;
                a0 = 0.0;
                a1 = 1.0;
            } else if (is0 < 0) {
                is0 = 0;
                is1 = 1;
                a0 = 1.0;
                a1 = 0.0;
            } else {
                a1 = fs - (double)is0;
                a0 = 1.0 - a1;
            }
            trc[i] = (float)(b0 * a0 * (double)this.x3frame[itr0][is0] + b1 * a0 * (double)this.x3frame[itr1][is0] + b0 * a1 * (double)this.x3frame[itr0][is1] + b1 * a1 * (double)this.x3frame[itr1][is1]);
            if (this.recip) {
                trc[i] = 1.0f / trc[i];
            }
            ++i;
            x1 += d1;
        }
    }

    private void updateCache(double x3) throws SeisException {
        if (Math.abs(x3 - this.x3i) < this.x3tol) {
            return;
        }
        this.x3i = x3;
        float f3 = (float)((x3 - this.origins[this.i3]) / this.deltas[this.i3]);
        int kframe = (int)f3;
        int[] pos = new int[3];
        float a0 = 0.0f;
        float a1 = 1.0f;
        if (kframe + 1 >= this.m3) {
            kframe = this.m3 - 2;
            a0 = 0.0f;
            a1 = 1.0f;
        } else if (kframe < 0) {
            kframe = 0;
            a0 = 1.0f;
            a1 = 0.0f;
        } else {
            a1 = f3 - (float)kframe;
            a0 = 1.0f - a1;
        }
        if (kframe != this.kframe0) {
            if (kframe == this.kframe1) {
                this.kframe0 = this.kframe1;
                this.kframe1 = this.kframe0 + 1;
                float[][] tmp = this.fbuf[0];
                this.fbuf[0] = this.fbuf[1];
                this.fbuf[1] = tmp;
                this.seisio.setTraceDataArray(this.fbuf[1]);
                pos[this.i3] = this.kframe1;
                this.seisio.readFrame(pos);
                if (this.recip) {
                    this.reciprocalValues(this.fbuf[1]);
                }
            } else {
                this.kframe0 = kframe;
                this.kframe1 = this.kframe0 + 1;
                this.seisio.setTraceDataArray(this.fbuf[0]);
                pos[this.i3] = this.kframe0;
                this.seisio.readFrame(pos);
                if (this.recip) {
                    this.reciprocalValues(this.fbuf[0]);
                }
                this.seisio.setTraceDataArray(this.fbuf[1]);
                pos[this.i3] = this.kframe1;
                this.seisio.readFrame(pos);
                if (this.recip) {
                    this.reciprocalValues(this.fbuf[1]);
                }
            }
        }
        this.frame0 = this.fbuf[0];
        this.frame1 = this.fbuf[1];
        int j = 0;
        while ((long)j < this.shape[this.i2]) {
            int i = 0;
            while ((long)i < this.shape[this.i1]) {
                this.x3frame[j][i] = a0 * this.frame0[j][i] + a1 * this.frame1[j][i];
                ++i;
            }
            ++j;
        }
        this.x3i = x3;
    }

    private void reciprocalValues(float[][] buf) {
        for (int j = 0; j < buf.length; ++j) {
            for (int i = 0; i < buf[j].length; ++i) {
                buf[j][i] = 1.0f / buf[j][i];
            }
        }
    }

    public String toString() {
        String string = "";
        string = string + "Path   : " + this.pathName + "\n";
        string = string + "Shape  : " + Arrays.toString(this.shape) + "\n";
        string = string + "Origins: " + Arrays.toString(this.origins) + "\n";
        string = string + "Deltas : " + Arrays.toString(this.deltas) + "\n";
        return string;
    }

    public void setAttributeType(ModelHelper.AttributeType type) {
        this._attributeType = type;
    }

    @Override
    public ModelHelper.AttributeType getAttributeType() {
        return this._attributeType;
    }

    @Override
    public ModelHelper.OrientationType getOrientationType() {
        return this._orientationType;
    }

    @Override
    public void setBinGrid(BinGrid binGrid) {
        double thetaModel;
        this._binGridUser = binGrid;
        if (this._binGridModel == null || this.binGridsEqual(this._binGridUser, this._binGridModel)) {
            this._translationRequired = false;
            return;
        }
        this._translationRequired = true;
        double thetaUser = Math.atan2(this._binGridUser.getWY1() - this._binGridUser.getWY0(), this._binGridUser.getWX1() - this._binGridUser.getWX0());
        if (Math.abs(thetaUser - (thetaModel = Math.atan2(this._binGridModel.getWY1() - this._binGridModel.getWY0(), this._binGridModel.getWX1() - this._binGridModel.getWX0()))) > this.azimuthTol) {
            throw new RuntimeException("BinGrid must be aligned with model BinGrid!");
        }
    }

    private boolean binGridsEqual(BinGrid binGrid1, BinGrid binGrid2) {
        if (binGrid1.getWX0() != binGrid2.getWX0()) {
            return false;
        }
        if (binGrid1.getWY0() != binGrid2.getWY0()) {
            return false;
        }
        if (binGrid1.getWX1() != binGrid2.getWX1()) {
            return false;
        }
        if (binGrid1.getWY1() != binGrid2.getWY1()) {
            return false;
        }
        if (binGrid1.getWX2() != binGrid2.getWX2()) {
            return false;
        }
        if (binGrid1.getWY2() != binGrid2.getWY2()) {
            return false;
        }
        if (binGrid1.getLX0() != binGrid2.getLX0()) {
            return false;
        }
        if (binGrid1.getLY0() != binGrid2.getLY0()) {
            return false;
        }
        if (binGrid1.getLX1() != binGrid2.getLX1()) {
            return false;
        }
        if (binGrid1.getLY1() != binGrid2.getLY1()) {
            return false;
        }
        if (binGrid1.getLX2() != binGrid2.getLX2()) {
            return false;
        }
        if (binGrid1.getLY2() != binGrid2.getLY2()) {
            return false;
        }
        if (binGrid1.getLDX() != binGrid2.getLDX()) {
            return false;
        }
        if (binGrid1.getLDY() != binGrid2.getLDY()) {
            return false;
        }
        if (binGrid1.getGX0() != binGrid2.getGX0()) {
            return false;
        }
        if (binGrid1.getGY0() != binGrid2.getGY0()) {
            return false;
        }
        if (binGrid1.getGDX() != binGrid2.getGDX()) {
            return false;
        }
        return binGrid1.getGDY() == binGrid2.getGDY();
    }

    private double[] translateCoordinates(double[] userCoords) {
        double[] modelCoords = null;
        switch (this._orientationType) {
            case XYZ: 
            case XYT: {
                double[] modelXY = this._binGridModel.worldToGrid(this._binGridUser.gridToWorld(new double[]{userCoords[0], userCoords[1]}));
                modelCoords = new double[]{modelXY[0], modelXY[1], userCoords[2]};
                break;
            }
            case ZXY: 
            case TXY: {
                double[] modelXY = this._binGridModel.worldToGrid(this._binGridUser.gridToWorld(new double[]{userCoords[1], userCoords[2]}));
                modelCoords = new double[]{userCoords[0], modelXY[0], modelXY[1]};
                break;
            }
            case NONE: {
                throw new RuntimeException("OrientationType should not be set to NONE at \"runtime\"");
            }
        }
        return modelCoords;
    }
}

