/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util;

public final class ArrayUtil {
    private ArrayUtil() {
        throw new AssertionError((Object)"Do not instantiate.");
    }

    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        long threshold = Integer.MAX_VALUE;
        long srcOffset = 8L * (long)srcPos;
        long destOffset = 8L * (long)destPos;
        if (srcOffset < threshold && destOffset < threshold) {
            System.arraycopy(src, srcPos, dest, destPos, length);
            return;
        }
        if (!src.getClass().isArray()) {
            throw new ArrayStoreException("src argument is not an array: " + src);
        }
        if (!dest.getClass().isArray()) {
            throw new ArrayStoreException("dest argument is not an array: " + dest);
        }
        if (src.getClass() != dest.getClass()) {
            throw new IllegalArgumentException("src and dest must be arrays of same type: " + src.getClass() + " != " + dest.getClass());
        }
        if (src instanceof Object[]) {
            Object[] sa = (Object[])src;
            Object[] da = (Object[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof double[]) {
            double[] sa = (double[])src;
            double[] da = (double[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof float[]) {
            float[] sa = (float[])src;
            float[] da = (float[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof long[]) {
            long[] sa = (long[])src;
            long[] da = (long[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof int[]) {
            int[] sa = (int[])src;
            int[] da = (int[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof short[]) {
            short[] sa = (short[])src;
            short[] da = (short[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof char[]) {
            char[] sa = (char[])src;
            char[] da = (char[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof byte[]) {
            byte[] sa = (byte[])src;
            byte[] da = (byte[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        if (src instanceof boolean[]) {
            boolean[] sa = (boolean[])src;
            boolean[] da = (boolean[])dest;
            for (int i = 0; i < length; ++i) {
                da[destPos + i] = sa[srcPos + i];
            }
            return;
        }
        throw new IllegalStateException("Unforseen Object class " + src.getClass() + "  src = " + src);
    }

    public static void main(String[] args) {
        int N = 0x3FFFFFFF;
        int NCOPY = 5;
        float[] src = new float[N];
        float[] dest = new float[NCOPY];
        int srcPos = 0;
        ArrayUtil.arraycopy(src, srcPos, dest, 0, NCOPY);
        srcPos = 0x1FFFFFFF;
        assert (4L * (long)srcPos < 0x80000000L);
        ArrayUtil.arraycopy(src, srcPos, dest, 0, NCOPY);
        assert (4L * (long)(++srcPos) == 0x80000000L);
        ArrayUtil.arraycopy(src, srcPos, dest, 0, NCOPY);
        srcPos = N - NCOPY;
        assert (4L * (long)srcPos > 0x80000000L);
        ArrayUtil.arraycopy(src, srcPos, dest, 0, NCOPY);
    }
}

