/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.properties;

import org.javaseis.properties.SeisPropertyType;
import org.javaseis.util.SeisException;

public class SeisTraceProperty {
    String _name;
    String _description;
    SeisPropertyType _type;
    int _nvals;
    int _offset;
    int _length;

    public SeisTraceProperty() {
        this._name = null;
        this._description = null;
        this._type = null;
        this._nvals = 0;
        this._offset = 0;
        this._length = 0;
    }

    public SeisTraceProperty(String name, String description, SeisPropertyType type, int nvals, int offset) {
        this._name = name;
        this._description = description;
        this._type = type;
        this._nvals = nvals;
        this._offset = offset;
        this._length = this._nvals * type.length();
    }

    public SeisTraceProperty(SeisTraceProperty prop) {
        this._name = new String(prop._name);
        this._description = new String(prop._description);
        this._type = prop._type;
        this._nvals = prop._nvals;
        this._offset = prop._offset;
        this._length = prop._length;
    }

    public SeisTraceProperty(String name, String s) throws SeisException {
        this.set(name, s);
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public SeisPropertyType getType() {
        return this._type;
    }

    public int getNvals() {
        return this._nvals;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public int getLength() {
        return this._length;
    }

    public void set(String name, String description, SeisPropertyType type, int nvals, int offset) {
        this._name = name;
        this._description = description;
        this._type = type;
        this._nvals = nvals;
        this._offset = offset;
        this._length = this._nvals * type.length();
    }

    private static String[] stringToArray(String s, String sep, char start, char end) {
        int i2;
        int i1 = 0;
        if (s.charAt(i1) == start) {
            ++i1;
        }
        if (s.charAt((i2 = s.length()) - 1) == end) {
            --i2;
        }
        if (i2 <= i1) {
            return null;
        }
        StringBuffer buf = new StringBuffer(s.substring(i1, i2));
        int arraysize = 1;
        for (int i = 0; i < buf.length(); ++i) {
            if (sep.indexOf(buf.charAt(i)) == -1) continue;
            ++arraysize;
        }
        String[] elements = new String[arraysize];
        int z = 0;
        if (buf.toString().indexOf(sep) != -1) {
            while (buf.length() > 0) {
                if (buf.toString().indexOf(sep) == -1) continue;
                int y = buf.toString().indexOf(sep);
                if (y != buf.toString().lastIndexOf(sep)) {
                    elements[z] = buf.toString().substring(0, y);
                    ++z;
                    buf.delete(0, y + 1);
                    continue;
                }
                if (buf.toString().lastIndexOf(sep) != y) continue;
                elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep));
                buf.delete(0, buf.toString().indexOf(sep) + 1);
                elements[++z] = buf.toString();
                ++z;
                buf.delete(0, buf.length());
            }
        } else {
            elements[0] = buf.toString();
        }
        buf = null;
        return elements;
    }

    public void set(String name, String s) throws SeisException {
        this._name = name;
        String[] vals = SeisTraceProperty.stringToArray(s, ",", '\"', '\"');
        if (vals.length != 4) {
            throw new SeisException("Could not parse SeisPropertyDescription string " + s);
        }
        this._description = vals[0];
        this._type = null;
        for (SeisPropertyType t : SeisPropertyType.values()) {
            if (!vals[1].equals(t.toString())) continue;
            this._type = t;
            break;
        }
        if (this._type == null) {
            throw new SeisException("Could not match SeisPropertyDescription type " + vals[1]);
        }
        this._nvals = Integer.parseInt(vals[2]);
        this._offset = Integer.parseInt(vals[3]);
        this._length = this._nvals * this._type.length();
    }

    public String toPropString() {
        StringBuffer b = new StringBuffer("\"");
        b.append(this._description);
        b.append(",");
        b.append(this._type.toString());
        b.append(",");
        b.append(Integer.toString(this._nvals));
        b.append(",");
        b.append(Integer.toString(this._offset));
        b.append("\"");
        return b.toString();
    }

    public SeisTraceProperty clone() {
        String name = new String(this._name);
        String description = new String(this._description);
        return new SeisTraceProperty(name, description, this._type, this._nvals, this._offset);
    }
}

