/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.logging.Logger;
import org.javaseis.io.ExtentListEntry;
import org.javaseis.io.ExtentManager;
import org.javaseis.io.ExtentPolicy;
import org.javaseis.io.IVirtualIO;
import org.javaseis.io.JSRandomAccessFile;
import org.javaseis.io.JSUtilFile;
import org.javaseis.io.VirtualFolders;
import org.javaseis.tests.TestUtil;
import org.javaseis.util.SeisException;

public class VirtualIO
implements IVirtualIO {
    static final int OPEN_RETRY_COUNT = 25;
    private static final Logger _logger = Logger.getLogger(VirtualIO.class.getName());
    protected static int MAX_FILES = 9999;
    protected boolean _isVirtual;
    protected boolean _isReadOnly;
    protected boolean _isChanged;
    protected boolean _trackTime;
    protected String _filePath;
    protected File _dataFile;
    protected JSRandomAccessFile _dataStream;
    protected String _dataMode;
    protected int _fileIndex;
    protected long _filePosition;
    protected long _fileOffset;
    protected long _extentSize;
    protected long _extentStartOffset;
    protected long _numBytes;
    protected long _ioTime;
    protected long _virtualTime;
    protected long _t0;
    protected long _t0v;
    protected ExtentManager _extentManager;
    private static final float _mbf = 953.6743f;

    private static void checkPath(String path, boolean isVirtual) throws SeisException {
        if (isVirtual) {
            if (!path.endsWith(".xml")) {
                throw new SeisException("Attempt to open a virtual file with invalid path '" + path + "' (must end with '.xml')");
            }
        } else if (path.endsWith(".xml")) {
            throw new SeisException("Attempt to open a non-virtual file with invalid path '" + path + "' (must not end with '.xml')");
        }
    }

    public VirtualIO(String path) throws SeisException {
        boolean isVirtual = false;
        VirtualIO.checkPath(path, isVirtual);
        this.openCreate(isVirtual, path, null, null, 0L, 0, 0L);
    }

    public VirtualIO(String path, String extentBaseName, VirtualFolders vFolders, long fileSize, int numExtents, long frameSize) throws SeisException {
        boolean isVirtual = true;
        VirtualIO.checkPath(path, isVirtual);
        this.openCreate(isVirtual, path, extentBaseName, vFolders, fileSize, numExtents, frameSize);
    }

    private void openCreate(boolean isVirtual, String path, String extentBaseName, VirtualFolders vFolders, long fileSize, int numExtents, long frameSize) throws SeisException {
        this._isVirtual = isVirtual;
        this._dataFile = new File(path);
        this._filePath = this._dataFile.getAbsolutePath();
        if (isVirtual) {
            this._extentManager = new ExtentManager(path, extentBaseName, vFolders, fileSize, numExtents, frameSize);
            this._dataStream = null;
            this._dataFile = null;
        } else {
            this._extentManager = null;
            try {
                this._dataStream = new JSRandomAccessFile(this._filePath, "rw");
            }
            catch (FileNotFoundException ex) {
                throw new SeisException("Could not create file: " + this._filePath, ex);
            }
            catch (IOException ex) {
                throw new SeisException("VirtualIO.openCreate: " + ex.getMessage() + " " + this._filePath, ex);
            }
        }
        this._dataMode = "rw";
        this._isReadOnly = false;
        this._isChanged = false;
        this._trackTime = false;
        this._filePosition = -999L;
        this._fileIndex = -999;
        this._ioTime = 0L;
        this._numBytes = 0L;
    }

    public VirtualIO(String path, String openMode) throws SeisException {
        boolean isVirtual = false;
        VirtualIO.checkPath(path, isVirtual);
        this.openExisting(isVirtual, path, openMode, null);
    }

    public VirtualIO(String path, String openMode, VirtualFolders vFolders) throws SeisException {
        if (vFolders == null) {
            throw new IllegalArgumentException("vFolders argument is null");
        }
        boolean isVirtual = true;
        VirtualIO.checkPath(path, isVirtual);
        this.openExisting(isVirtual, path, openMode, vFolders);
    }

    private void openExisting(boolean isVirtual, String path, String openMode, VirtualFolders vFolders) throws SeisException {
        this._isVirtual = isVirtual;
        if (openMode.equals("r") || openMode.equals("R")) {
            this._isReadOnly = true;
            this._dataMode = "r";
        } else {
            this._isReadOnly = false;
            this._dataMode = "rw";
        }
        this._dataFile = new File(path);
        this._filePath = this._dataFile.getAbsolutePath();
        if (this._isVirtual) {
            if (vFolders == null) {
                throw new IllegalArgumentException("vFolders argument is null");
            }
            this._extentManager = new ExtentManager(path, this._dataMode, vFolders);
            this.openVirtual();
        } else {
            this.openNonVirtual();
        }
        this._ioTime = 0L;
        this._numBytes = 0L;
    }

    protected void openVirtual() throws SeisException {
        this._isVirtual = true;
        this._dataStream = null;
        this._filePosition = -999L;
        this._fileIndex = -999;
    }

    protected void openNonVirtual() throws SeisException {
        if (this._isVirtual) {
            throw new SeisException("Attempt to open virtual file in non-virtual mode: " + this._filePath);
        }
        try {
            this._dataStream = new JSRandomAccessFile(this._filePath, this._dataMode);
        }
        catch (IOException ex) {
            throw new SeisException("Error opening file: " + this._filePath, ex);
        }
        this._filePosition = 0L;
    }

    @Override
    public void close() throws SeisException {
        if (this._isVirtual) {
            this._extentManager.close();
        }
        if (this._dataStream != null) {
            try {
                this._dataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._dataStream = null;
        }
    }

    @Override
    public void flush() throws SeisException {
        try {
            if (this._dataStream != null) {
                this._dataStream.flush();
            }
        }
        catch (IOException ex) {
            throw new SeisException("Could not flush data to disk\n" + ex.getMessage());
        }
    }

    @Override
    public String getPath() {
        return this._filePath;
    }

    @Override
    public boolean isVirtual() {
        return this._isVirtual;
    }

    @Override
    public ExtentPolicy getExtentPolicy() {
        return this._extentManager.getExtentPolicy();
    }

    @Override
    public FileDescriptor getFD() {
        FileDescriptor fd;
        try {
            fd = this._dataStream.getFD();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get FileDescriptor");
        }
        return fd;
    }

    @Override
    public int read(ByteBuffer buffer) throws SeisException {
        if (this._trackTime) {
            this._t0v = System.nanoTime();
        }
        int readLength = 0;
        int splitReadLen = 0;
        int bufferLength = buffer.remaining();
        if (this._isVirtual && (long)bufferLength > this._extentSize - this._fileOffset) {
            splitReadLen = (int)(this._extentSize - this._fileOffset);
            int oldLimit = buffer.limit();
            if (splitReadLen > 0) {
                buffer.limit(buffer.position() + splitReadLen);
                splitReadLen = this.readBuffer(buffer);
            }
            buffer.limit(oldLimit);
            long newPosition = this._extentStartOffset + this._extentSize;
            if (this._trackTime) {
                this._trackTime = false;
                this.setPosition(newPosition);
                this._trackTime = true;
            } else {
                this.setPosition(newPosition);
            }
        }
        if ((readLength = this.readBuffer(buffer)) + splitReadLen < bufferLength) {
            readLength = bufferLength;
            while (buffer.position() < bufferLength) {
                buffer.put((byte)0);
            }
        }
        this._filePosition += (long)readLength;
        this._fileOffset += (long)readLength;
        this._numBytes += (long)(readLength + splitReadLen);
        if (this._trackTime) {
            this._virtualTime += System.nanoTime() - this._t0v;
        }
        return readLength + splitReadLen;
    }

    @Override
    public int write(ByteBuffer buffer) throws SeisException {
        if (this._trackTime) {
            this._t0v = System.nanoTime();
        }
        int writeLength = 0;
        int splitWriteLen = 0;
        int bufferLength = buffer.remaining();
        if (this._isVirtual && (long)bufferLength > this._extentSize - this._fileOffset) {
            splitWriteLen = (int)(this._extentSize - this._fileOffset);
            int oldLimit = buffer.limit();
            if (splitWriteLen > 0) {
                buffer.limit(buffer.position() + splitWriteLen);
                splitWriteLen = this.writeBuffer(buffer);
            }
            buffer.limit(oldLimit);
            long newPosition = this._extentStartOffset + this._extentSize;
            if (this._trackTime) {
                this._trackTime = false;
                this.setPosition(newPosition);
                this._trackTime = true;
            } else {
                this.setPosition(newPosition);
            }
        }
        this._filePosition += (long)(writeLength += this.writeBuffer(buffer));
        this._fileOffset += (long)writeLength;
        this._numBytes += (long)(writeLength + splitWriteLen);
        if (this._trackTime) {
            this._virtualTime += System.nanoTime() - this._t0v;
        }
        return writeLength + splitWriteLen;
    }

    @Override
    public long setPosition(long newPosition) throws SeisException {
        if (!this._isVirtual) {
            try {
                if (this._filePosition != newPosition) {
                    this._dataStream.position(newPosition);
                }
            }
            catch (IOException ex) {
                throw new SeisException("Error setting position: " + this._fileOffset + "\n" + ex.getMessage());
            }
            this._filePosition = newPosition;
            return this._filePosition;
        }
        if (this._trackTime) {
            this._t0v = System.nanoTime();
        }
        int extent_index = this._fileIndex;
        long file_offset = this._fileOffset;
        this.openExtent(newPosition);
        this._fileOffset = newPosition - this._extentStartOffset;
        if (this._fileOffset < 0L || this._fileOffset >= this._extentSize) {
            throw new SeisException("Invalid offset in extent " + this._fileIndex + ": " + this._fileOffset);
        }
        try {
            if (extent_index != this._fileIndex || file_offset != this._fileOffset) {
                this._dataStream.position(this._fileOffset);
            }
        }
        catch (IOException ex) {
            String msg = String.format("Error setting position in extent %d\n", this._fileIndex);
            msg = msg + String.format("File position = %d\n", this._filePosition);
            msg = msg + String.format("Extent position = %d\n", this._fileOffset);
            msg = msg + String.format("Extent size = %d\n", this._extentSize);
            msg = msg + String.format("Extent starting offset = %d\n", this._extentStartOffset);
            msg = msg + String.format("Path=%s\n", this._dataStream.getAbsolutePath());
            try {
                msg = msg + String.format("Hostname=%s\n", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            throw new SeisException(msg, ex);
        }
        this._filePosition = newPosition;
        if (this._trackTime) {
            this._virtualTime += System.nanoTime() - this._t0v;
        }
        return this._filePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openExtent(long newPosition) throws SeisException {
        int index;
        String vfile;
        ExtentListEntry extent;
        block16: {
            if (newPosition < 0L) {
                throw new IllegalArgumentException("Position is invalid " + newPosition);
            }
            extent = this._extentManager.getExtent(newPosition);
            vfile = extent.getPath();
            index = extent.getIndex();
            if (this._fileIndex == index) {
                return;
            }
            try {
                if (this._dataStream != null) {
                    this._dataStream.close();
                }
            }
            catch (IOException ex) {
                if (this._isReadOnly) {
                    _logger.warning("Error encountered closing virtual file extent, but the dataset is in read-only mode" + ex);
                    break block16;
                }
                throw new SeisException("Error closing virtual file extent " + this._fileIndex + ": " + vfile, ex);
            }
            finally {
                this._dataStream = null;
            }
        }
        int cnt = 0;
        while (this._dataStream == null && cnt < 25) {
            try {
                Thread.sleep(1000 * cnt);
                ++cnt;
                this._dataStream = new JSRandomAccessFile(vfile, this._dataMode);
            }
            catch (InterruptedException ex) {
            }
            catch (IOException ex) {}
        }
        try {
            if (this._dataStream == null) {
                this._dataStream = new JSRandomAccessFile(vfile, this._dataMode);
            }
        }
        catch (IOException ex) {
            throw new SeisException("Error opening virtual file extent " + index + ": " + vfile, ex);
        }
        this._fileIndex = index;
        this._extentStartOffset = extent.getStartOffset();
        this._extentSize = extent.getExtentSize();
    }

    @Override
    public int readBuffer(ByteBuffer buffer) throws SeisException {
        int readLength = 0;
        if (this._trackTime) {
            this._t0 = System.nanoTime();
        }
        try {
            readLength = this._dataStream.read(buffer);
            if (readLength < 0) {
                readLength = 0;
            }
        }
        catch (IOException ex) {
            throw new SeisException("Read error at position " + this._filePosition + " (length=" + buffer.remaining() + "): " + this._filePath + "\n", ex);
        }
        if (this._trackTime) {
            this._ioTime += System.nanoTime() - this._t0;
        }
        return readLength;
    }

    @Override
    public int readBuffer(ByteBuffer buffer, int len) throws SeisException {
        int readLength = 0;
        if (this._trackTime) {
            this._t0 = System.nanoTime();
        }
        try {
            buffer.clear();
            buffer.limit(len);
            readLength = this._dataStream.read(buffer);
        }
        catch (IOException ex) {
            throw new SeisException("Read error at position " + this._filePosition + " (length=" + buffer.remaining() + "): " + this._filePath + "\n", ex);
        }
        if (this._trackTime) {
            this._ioTime += System.nanoTime() - this._t0;
        }
        return readLength;
    }

    @Override
    public int writeBuffer(ByteBuffer buffer) throws SeisException {
        int writeLength = 0;
        if (this._trackTime) {
            this._t0 = System.nanoTime();
        }
        try {
            writeLength = this._dataStream.write(buffer);
        }
        catch (IOException ex) {
            String msg = "Error when writing buffer to file '" + this._dataStream.getAbsolutePath() + "'\n";
            msg = msg + String.format("File position = %d\n", this._filePosition);
            msg = msg + String.format("Extent position = %d\n", this._fileOffset);
            msg = msg + String.format("Buffer capacity = %d\n", buffer.capacity());
            msg = msg + String.format("Buffer current position = %d\n", buffer.position());
            String parentdir = new File(this._dataStream.getAbsolutePath()).getParent();
            if (parentdir != null && !parentdir.isEmpty()) {
                msg = msg + String.format("Free space = %d\n", JSUtilFile.diskCapacityBytes(parentdir));
            }
            try {
                msg = msg + String.format("Hostname=%s\n", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            throw new SeisException(msg, ex);
        }
        if (this._trackTime) {
            this._ioTime += System.nanoTime() - this._t0;
        }
        return writeLength;
    }

    @Override
    public ExtentListEntry[] getExtents() {
        return this._extentManager.getExtents();
    }

    @Override
    public void trackTime(boolean flag) {
        this._trackTime = flag;
        if (this._isVirtual) {
            this._extentManager.trackTime(flag);
        }
    }

    @Override
    public float getIoRate() {
        if (!this._trackTime || this._ioTime == 0L) {
            return 0.0f;
        }
        return 953.6743f * (float)this._numBytes / (float)this._ioTime;
    }

    @Override
    public float getIoTime() {
        return 1.0E-9f * (float)this._ioTime;
    }

    @Override
    public long getIoBytes() {
        return this._numBytes;
    }

    @Override
    public float getVirtualTime() {
        if (!this._trackTime || !this._isVirtual) {
            return 0.0f;
        }
        return 1.0E-9f * (float)this._virtualTime;
    }

    @Override
    public float getVirtualRate() {
        if (!this._trackTime || this._virtualTime == 0L) {
            return 0.0f;
        }
        return 953.6743f * (float)this._numBytes / (float)this._virtualTime;
    }

    @Override
    public float getLockTime() {
        if (!this._isVirtual) {
            return 0.0f;
        }
        return this._extentManager.getLockTime();
    }

    @Override
    public float getLoadTime() {
        if (!this._isVirtual) {
            return 0.0f;
        }
        return this._extentManager.getLoadTime();
    }

    @Override
    public boolean delete() {
        return this._extentManager.delete();
    }

    public static void main(String[] args) throws SeisException {
        int i;
        String name = "VirtualIOTest";
        String baseDir = TestUtil.getDatasetPath(name);
        System.out.println("baseDir: " + baseDir);
        VirtualFolders vFolders = TestUtil.getVirtualFolders(baseDir);
        String path = baseDir + File.separator + "VirtualIOTest.xml";
        System.out.println("path: " + path);
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        long extentSizeBytes = 0x100000L;
        long frameSize = 192000L;
        int bufSize = 4 * (int)frameSize;
        long fileLength = bufSize * 10;
        int numExtents = (int)(fileLength / extentSizeBytes) + 1;
        VirtualIO vio = new VirtualIO(path, name, vFolders, fileLength, numExtents, frameSize);
        vio.close();
        vio = null;
        System.gc();
        vio = new VirtualIO(path, "rw", vFolders);
        ByteBuffer buf = ByteBuffer.allocateDirect(bufSize);
        IntBuffer ibuf = buf.asIntBuffer();
        int[] ival = new int[(int)frameSize];
        long position = 0L;
        vio.trackTime(true);
        for (i = 0; i < 10; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(position);
            Arrays.fill(ival, i);
            ibuf.put(ival);
            vio.write(buf);
            position += (long)bufSize;
        }
        System.out.println("I/O time " + vio.getIoTime() + " s");
        System.out.println("I/O write rate " + vio.getIoRate() + " Mb/s");
        System.out.println("Virtual I/O lock overhead " + vio.getLockTime() + " s");
        System.out.println("Virtual I/O load overhead " + vio.getLoadTime() + " s");
        System.out.println("Virtual I/O total overhead " + vio.getVirtualTime() + " s");
        System.out.println("Virtual I/O rate " + vio.getVirtualRate() + " Mb/s");
        vio.close();
        vio = null;
        System.gc();
        vio = new VirtualIO(path, "r", vFolders);
        vio.trackTime(true);
        position = 0L;
        for (i = 0; i < 10; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(position);
            vio.read(buf);
            ibuf.get(ival);
            int j = 0;
            while ((long)j < frameSize) {
                assert (ival[j] == i) : "VirtualIO Read Verification Failed";
                ++j;
            }
            position += (long)bufSize;
        }
        System.out.println("I/O read rate " + vio.getIoRate() + " Mb/s");
        vio.close();
        assert (vio.delete());
        System.out.println("*** " + vio.getClass().toString() + " Success ***");
    }
}

