/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.imaging;

import java.util.Arrays;
import java.util.Random;
import org.javaseis.array.TransposeType;
import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.DistributedArrayPositionIterator;
import org.javaseis.parallel.DistributedArrayTraceIterator;
import org.javaseis.parallel.UniprocessorContext;
import org.javaseis.util.ArrayUtil;

public class DistributedArrayFrequencySlice {
    private int _nt;
    private int _nx;
    private int _ny;
    private int _nf;
    private int _if1;
    private int _ifn;
    private float _dt;
    private float _df;
    private SeisFft _tfft;
    private int _nfft;
    private int _nyq;
    private DistributedArray _da;

    public DistributedArrayFrequencySlice(DistributedArray da, int nt, float dt, float padt, float fmin, float fmax) {
        this(nt, dt, padt, fmin, fmax);
        this.setDistributedArray(da);
    }

    public DistributedArrayFrequencySlice(int nt, float sr, float padt, float fmin, float fmax) {
        this._nt = nt;
        this._tfft = new SeisFft(this._nt, padt);
        this._nfft = this._tfft.getLength();
        this._nyq = this._nfft / 2;
        this._dt = sr / 1000.0f;
        this._df = 1.0f / (this._dt * (float)this._tfft.getLength());
        this._if1 = (int)Math.rint(fmin / this._df);
        if (this._if1 < 0) {
            this._if1 = 0;
        }
        this._ifn = (int)Math.rint(fmax / this._df);
        if (this._ifn <= this._if1 || this._ifn > this._nyq) {
            this._ifn = this._nyq;
        }
        this._nf = this._ifn - this._if1 + 1;
    }

    public int getTransformLength() {
        return this._nfft;
    }

    public float getSampleFrequency() {
        return this._df;
    }

    public float getDeltaOmega() {
        return this._df * 2.0f * (float)Math.PI;
    }

    public int getFrequencyCount() {
        return this._nf;
    }

    public int getStartFrequencyIndex() {
        return this._if1;
    }

    public int getEndFrequencyIndex() {
        return this._ifn;
    }

    public IFFT getFft() {
        return this._tfft;
    }

    public void setDistributedArray(DistributedArray da) {
        this._da = da;
    }

    public DistributedArray getDistributedArray() {
        return this._da;
    }

    public void forwardTransform(DistributedArray da) {
        float[] c = new float[2 * this._nyq + 2];
        float[] cf = new float[2 * this._nf];
        this._nx = da.getLength(1);
        this._ny = da.getLength(2);
        DistributedArray r = da.distributedView();
        da.setElementCount(2);
        da.setShape(new int[]{this._nf, this._nx, this._ny});
        int[] position = new int[]{0, 0, 0};
        int idir = 1;
        if (2 * this._nf > this._nt) {
            idir = -1;
        }
        DistributedArrayPositionIterator dapi = new DistributedArrayPositionIterator(r, position, idir);
        while (dapi.hasNext()) {
            dapi.next();
            r.getTrace(c, position);
            Arrays.fill(c, this._nt, 2 * this._nyq + 2, 0.0f);
            this._tfft.realToComplex(c);
            ArrayUtil.arraycopy(c, 2 * this._if1, cf, 0, 2 * this._nf);
            da.putTrace(cf, position);
        }
        da.makeLegalForTranspose();
        da.transpose(TransposeType.T231);
    }

    public void inverseTransform(DistributedArray da) {
        if (da.getLength(2) != this._nf || da.getElementCount() != 2) {
            throw new IllegalArgumentException("Distributed array shape does not match");
        }
        da.makeLegalForTranspose();
        da.transpose(TransposeType.T312);
        float[] c = new float[2 + 2 * this._nyq];
        float[] cf = new float[2 * this._nf];
        this._nx = da.getLength(1);
        this._ny = da.getLength(2);
        DistributedArray cda = da.distributedView();
        da.setElementCount(1);
        da.setShape(new int[]{this._nt, this._nx, this._ny});
        int[] position = new int[]{0, 0, 0};
        int idir = 1;
        if (2 * this._nf < this._nt) {
            idir = -1;
        }
        DistributedArrayPositionIterator dapi = new DistributedArrayPositionIterator(cda, position, idir);
        while (dapi.hasNext()) {
            dapi.next();
            cda.getTrace(cf, position);
            Arrays.fill(c, 0, 2 * this._if1, 0.0f);
            ArrayUtil.arraycopy(cf, 0, c, 2 * this._if1, 2 * this._nf);
            Arrays.fill(c, 2 * this._ifn, 2 * this._nyq, 0.0f);
            this._tfft.complexToReal(c);
            da.putTrace(c, position);
        }
    }

    public static void main(String[] args) {
        UniprocessorContext pc = new UniprocessorContext();
        int nx = 20;
        int ny = 15;
        int nt = 30;
        float dt = 1.0f;
        float padt = 50.0f;
        float fmin = 0.0f;
        float fmax = 0.0f;
        DistributedArrayFrequencySlice dafs = new DistributedArrayFrequencySlice(nt, dt, padt, fmin, fmax);
        int[] len = new int[]{nt, nx, ny};
        if (nt < 2 * dafs._nf) {
            len[0] = 2 * dafs._nf;
        }
        DistributedArray da = new DistributedArray(pc, len);
        float[] trc = new float[len[0]];
        DistributedArrayTraceIterator<float[]> dati = new DistributedArrayTraceIterator<float[]>(da, trc);
        Random r = new Random(12345L);
        while (dati.hasNext()) {
            dati.next();
            for (int i = 0; i < nt; ++i) {
                trc[i] = r.nextFloat();
            }
            int[] pos = dati.getPosition();
            da.putTrace(trc, pos);
        }
        dafs.forwardTransform(da);
        dafs.inverseTransform(da);
        dati.reset();
        r.setSeed(12345L);
        double rms = 0.0;
        while (dati.hasNext()) {
            dati.next();
            for (int i = 0; i < nt; ++i) {
                rms += Math.pow(trc[i] - r.nextFloat(), 2.0);
            }
        }
        System.out.println("DistributedArrayFrequencySlice RMS difference = " + Math.sqrt(rms / (double)(nx * ny * nt)));
    }
}

