/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.compress;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Logger;
import org.javaseis.properties.DataFormat;
import org.javaseis.util.SeisException;

public class TraceCompressor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TraceCompressor.class.getName());
    private static final float RMAXINT2 = 32766.0f;
    private static final float RMAXINT1 = 126.0f;
    protected static final int CLIPPING_MAX_INT08 = 127;
    protected static final int CLIPPING_MIN_INT08 = -128;
    protected static final int CLIPPING_MAX_INT16 = Short.MAX_VALUE;
    protected static final int CLIPPING_MIN_INT16 = Short.MIN_VALUE;
    protected static int WNDWLEN16 = 100;
    protected static int WNDWLEN08 = 25;
    protected DataFormat _traceFormat;
    protected int _numWindows;
    protected int _numSamples;
    protected int _numSamplesX;
    protected int _bytesPerSample;
    protected int _recordLengthInBytes;
    protected int _recordLengthInShorts;
    protected int _recordLengthInFloats;
    protected int _scalarsLengthInBytes;
    protected int _scalarsLengthInShorts;
    protected int _buffer16LengthInFloats;
    protected int _buffer08LengthInFloats;
    protected char[] _buffer16;
    protected byte[] _buffer08;
    protected float[] _scalars;
    protected ByteBuffer _bufferViewByte;
    protected ShortBuffer _bufferViewShort;
    protected FloatBuffer _bufferViewFloat;
    protected short[] _traceDataShort;
    protected byte[] _traceDataByte;
    protected int _tracePosition;

    public TraceCompressor(DataFormat traceFormat, int numSamples, ByteBuffer bufferByte) {
        switch (traceFormat) {
            case SEISPEG: {
                throw new IllegalArgumentException("Cannot use TraceCompressor for SEISPEG format");
            }
            case FLOAT: {
                this._traceFormat = traceFormat;
                this._bytesPerSample = traceFormat.getBytesPerSample();
                break;
            }
            case INT16: {
                this._traceFormat = traceFormat;
                this._bytesPerSample = traceFormat.getBytesPerSample();
                break;
            }
            case INT08: {
                this._traceFormat = traceFormat;
                this._bytesPerSample = traceFormat.getBytesPerSample();
                break;
            }
            case COMPRESSED_INT16: {
                this._traceFormat = traceFormat;
                this._bytesPerSample = traceFormat.getBytesPerSample();
                break;
            }
            case COMPRESSED_INT08: {
                this._traceFormat = traceFormat;
                this._bytesPerSample = traceFormat.getBytesPerSample();
                break;
            }
            default: {
                this._traceFormat = DataFormat.FLOAT;
                this._bytesPerSample = DataFormat.FLOAT.getBytesPerSample();
            }
        }
        int remainder = 0;
        switch (this._traceFormat) {
            case SEISPEG: {
                throw new IllegalArgumentException("Cannot use TraceCompressor for SEISPEG format");
            }
            case FLOAT: {
                this._recordLengthInFloats = this._numSamples = numSamples;
                this._bufferViewFloat = bufferByte.asFloatBuffer();
                break;
            }
            case INT16: {
                this._recordLengthInShorts = this._numSamples = numSamples;
                this._bufferViewShort = bufferByte.asShortBuffer();
                this._traceDataShort = new short[this._numSamples];
                break;
            }
            case INT08: {
                this._recordLengthInBytes = this._numSamples = numSamples;
                this._bufferViewByte = bufferByte;
                this._traceDataByte = new byte[this._numSamples];
                break;
            }
            case COMPRESSED_INT16: {
                this._numWindows = (numSamples - 1) / WNDWLEN16 + 1;
                this._numSamples = numSamples;
                remainder = numSamples % 2;
                this._numSamplesX = remainder == 0 ? numSamples : numSamples + (2 - remainder);
                this._recordLengthInBytes = 4 * this._numWindows + this._bytesPerSample * this._numSamplesX;
                this._scalars = new float[this._numWindows];
                this._buffer16 = new char[this._numSamplesX];
                this._bufferViewByte = bufferByte;
                this._bufferViewFloat = bufferByte.asFloatBuffer();
                this._recordLengthInFloats = this._recordLengthInBytes / 4;
                this._recordLengthInShorts = this._recordLengthInBytes / 2;
                this._scalarsLengthInShorts = this._numWindows * 2;
                this._scalarsLengthInBytes = this._scalarsLengthInShorts * 2;
                this._buffer16LengthInFloats = this._numSamplesX / 2;
                break;
            }
            case COMPRESSED_INT08: {
                this._numWindows = (numSamples + WNDWLEN08 - 1) / WNDWLEN08;
                this._numSamples = numSamples;
                remainder = numSamples % 4;
                this._numSamplesX = remainder == 0 ? numSamples : numSamples + (4 - remainder);
                this._recordLengthInBytes = 4 * this._numWindows + this._bytesPerSample * this._numSamplesX;
                this._scalars = new float[this._numWindows];
                this._buffer08 = new byte[this._numSamplesX];
                this._bufferViewByte = bufferByte;
                this._bufferViewFloat = bufferByte.asFloatBuffer();
                this._recordLengthInFloats = this._recordLengthInBytes / 4;
                this._scalarsLengthInBytes = this._numWindows * 4;
                this._buffer08LengthInFloats = this._numSamplesX / 4;
                break;
            }
        }
        this._tracePosition = 0;
    }

    public static int getRecordLength(DataFormat traceFormat, int numSamples) throws SeisException {
        int length = 0;
        int numWindows = 0;
        int numSamplesX = 0;
        int bytesPerSample = 0;
        switch (traceFormat) {
            case SEISPEG: 
            case FLOAT: 
            case INT16: 
            case INT08: 
            case COMPRESSED_INT16: 
            case COMPRESSED_INT08: {
                break;
            }
            default: {
                traceFormat = DataFormat.FLOAT;
            }
        }
        switch (traceFormat) {
            case SEISPEG: 
            case FLOAT: 
            case INT16: 
            case INT08: {
                bytesPerSample = traceFormat.getBytesPerSample();
                length = bytesPerSample * numSamples;
                break;
            }
            case COMPRESSED_INT16: {
                numWindows = (numSamples - 1) / WNDWLEN16 + 1;
                int remainder = numSamples % 2;
                numSamplesX = remainder == 0 ? numSamples : numSamples + (2 - remainder);
                bytesPerSample = traceFormat.getBytesPerSample();
                length = 4 * numWindows + bytesPerSample * numSamplesX;
                break;
            }
            case COMPRESSED_INT08: {
                numWindows = (numSamples + WNDWLEN08 - 1) / WNDWLEN08;
                int remainder = numSamples % 4;
                numSamplesX = remainder == 0 ? numSamples : numSamples + (4 - remainder);
                bytesPerSample = traceFormat.getBytesPerSample();
                length = 4 * numWindows + bytesPerSample * numSamplesX;
                break;
            }
        }
        return length;
    }

    public int getPosition() {
        return this._tracePosition;
    }

    public int setPosition(int tracePosition) {
        this._tracePosition = tracePosition;
        switch (this._traceFormat) {
            case SEISPEG: {
                throw new RuntimeException("Cannot use TraceCompressor for SEISPEG format");
            }
            case FLOAT: {
                this._bufferViewFloat.position(this._tracePosition * this._recordLengthInFloats);
                break;
            }
            case INT16: {
                this._bufferViewShort.position(this._tracePosition * this._recordLengthInShorts);
                break;
            }
            case INT08: {
                this._bufferViewByte.position(this._tracePosition * this._recordLengthInBytes);
                break;
            }
            case COMPRESSED_INT16: {
                try {
                    this._bufferViewByte.position(this._tracePosition * this._recordLengthInBytes);
                }
                catch (Throwable t) {
                    LOG.severe("Error with bufferViewByte: " + this._bufferViewByte);
                    t.printStackTrace();
                    throw new RuntimeException(t);
                }
                try {
                    this._bufferViewFloat.position(this._tracePosition * this._recordLengthInFloats);
                    break;
                }
                catch (Throwable t) {
                    LOG.severe("Error with bufferViewFloat" + this._bufferViewFloat);
                    t.printStackTrace();
                    throw new RuntimeException(t);
                }
            }
            case COMPRESSED_INT08: {
                this._bufferViewByte.position(this._tracePosition * this._recordLengthInBytes);
                this._bufferViewFloat.position(this._tracePosition * this._recordLengthInFloats);
            }
        }
        return this._tracePosition;
    }

    public void packFrame(int numTraces, float[][] traceData) {
        block6: for (int i = 0; i < numTraces; ++i) {
            this.setPosition(i);
            switch (this._traceFormat) {
                case SEISPEG: {
                    throw new RuntimeException("Cannot use TraceCompressor for SEISPEG format");
                }
                case FLOAT: 
                case INT16: 
                case INT08: {
                    this.packTrace(traceData[i]);
                    continue block6;
                }
                case COMPRESSED_INT16: {
                    this.packTrace16(traceData[i]);
                    continue block6;
                }
                case COMPRESSED_INT08: {
                    this.packTrace08(traceData[i]);
                    continue block6;
                }
            }
        }
    }

    public void unpackFrame(int numTraces, float[][] traceData) {
        block6: for (int i = 0; i < numTraces; ++i) {
            this.setPosition(i);
            switch (this._traceFormat) {
                case SEISPEG: {
                    throw new RuntimeException("Cannot unpack frame for SEISPEG format");
                }
                case FLOAT: 
                case INT16: 
                case INT08: {
                    this.unpackTrace(traceData[i]);
                    continue block6;
                }
                case COMPRESSED_INT16: {
                    this.unpackTrace16(traceData[i]);
                    continue block6;
                }
                case COMPRESSED_INT08: {
                    this.unpackTrace08(traceData[i]);
                    continue block6;
                }
            }
        }
    }

    public void packTrace(float[] traceData) {
        switch (this._traceFormat) {
            case SEISPEG: {
                throw new RuntimeException("Cannot pack traces for SEISPEG format");
            }
            case FLOAT: {
                this._bufferViewFloat.put(traceData, 0, this._numSamples);
                break;
            }
            case INT16: {
                this.arrayCopyFloatToShort(this._numSamples, traceData, this._traceDataShort);
                this._bufferViewShort.put(this._traceDataShort, 0, this._numSamples);
                break;
            }
            case INT08: {
                this.arrayCopyFloatToByte(this._numSamples, traceData, this._traceDataByte);
                this._bufferViewByte.put(this._traceDataByte, 0, this._numSamples);
                break;
            }
        }
    }

    public void packTrace08(float[] traceData) {
        int k1 = 0;
        int k2 = 0;
        for (int i = 0; i < this._numWindows; ++i) {
            int k;
            k1 = k2;
            if ((k2 = k1 + WNDWLEN08) > this._numSamples) {
                k2 = this._numSamples;
            }
            float valueMax = 0.0f;
            for (k = k1; k < k2; ++k) {
                float valueAbs = Math.abs(traceData[k]);
                if (!(valueAbs > valueMax)) continue;
                valueMax = valueAbs;
            }
            float scalar = 0.0f;
            if ((double)valueMax > 0.0) {
                scalar = 126.0f / valueMax;
            }
            this._scalars[i] = scalar;
            for (k = k1; k < k2; ++k) {
                byte b = (byte)(127.5 + (double)(scalar * traceData[k]));
                this._buffer08[k] = (byte)(b & 0xFF);
            }
        }
        this._bufferViewFloat.put(this._scalars);
        this._bufferViewByte.position(this._bufferViewByte.position() + this._scalarsLengthInBytes);
        this._bufferViewByte.put(this._buffer08);
        this._bufferViewFloat.position(this._bufferViewFloat.position() + this._buffer08LengthInFloats);
    }

    public void packTrace16(float[] traceData) {
        int k1 = 0;
        int k2 = 0;
        for (int i = 0; i < this._numWindows; ++i) {
            int k;
            k1 = k2;
            if ((k2 = k1 + WNDWLEN16) > this._numSamples) {
                k2 = this._numSamples;
            }
            float valueMax = 0.0f;
            for (k = k1; k < k2; ++k) {
                float value = Math.abs(traceData[k]);
                if (!(value > valueMax)) continue;
                valueMax = value;
            }
            float scalar = 0.0f;
            if ((double)valueMax > 0.0) {
                scalar = 32766.0f / valueMax;
            }
            this._scalars[i] = scalar;
            for (k = k1; k < k2; ++k) {
                this._buffer16[k] = (char)(32767.5 + (double)(scalar * traceData[k]));
            }
        }
        try {
            this._bufferViewFloat.put(this._scalars);
            this._bufferViewByte.position(this._bufferViewByte.position() + this._scalarsLengthInBytes);
        }
        catch (Throwable t) {
            LOG.severe("Error with bufferViewByte: " + this._bufferViewByte);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        for (int k = 0; k < this._numSamples; ++k) {
            this._bufferViewByte.putChar(this._buffer16[k]);
        }
        try {
            this._bufferViewFloat.position(this._bufferViewFloat.position() + this._buffer16LengthInFloats);
        }
        catch (Throwable t) {
            LOG.severe("Error with bufferViewFloat: " + this._bufferViewFloat);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public void unpackTrace(float[] traceData) {
        switch (this._traceFormat) {
            case SEISPEG: {
                throw new RuntimeException("Cannot unpack traces for SEISPEG format");
            }
            case FLOAT: {
                this._bufferViewFloat.get(traceData, 0, this._numSamples);
                break;
            }
            case INT16: {
                this._bufferViewShort.get(this._traceDataShort, 0, this._numSamples);
                this.arrayCopyShortToFloat(this._numSamples, this._traceDataShort, traceData);
                break;
            }
            case INT08: {
                this._bufferViewByte.get(this._traceDataByte, 0, this._numSamples);
                this.arrayCopyByteToFloat(this._numSamples, this._traceDataByte, traceData);
                break;
            }
        }
    }

    public void unpackTrace08(float[] traceData) {
        int k1 = 0;
        int k2 = 0;
        this._bufferViewFloat.get(this._scalars);
        this._bufferViewByte.position(this._bufferViewByte.position() + this._scalarsLengthInBytes);
        this._bufferViewByte.get(this._buffer08);
        for (int i = 0; i < this._numWindows; ++i) {
            k1 = k2;
            if ((k2 = k1 + WNDWLEN08) > this._numSamples) {
                k2 = this._numSamples;
            }
            float scalar = 0.0f;
            if ((double)this._scalars[i] > 0.0) {
                scalar = 1.0f / this._scalars[i];
            }
            for (int k = k1; k < k2; ++k) {
                byte b = this._buffer08[k];
                int firstByte = 0xFF & b;
                traceData[k] = scalar * (float)(firstByte - 127);
            }
        }
    }

    public void unpackTrace16(float[] traceData) {
        int k1 = 0;
        int k2 = 0;
        this._bufferViewFloat.get(this._scalars);
        this._bufferViewByte.position(this._bufferViewByte.position() + this._scalarsLengthInBytes);
        for (int k = 0; k < this._numSamples; ++k) {
            this._buffer16[k] = this._bufferViewByte.getChar();
        }
        for (int i = 0; i < this._numWindows; ++i) {
            k1 = k2;
            if ((k2 = k1 + WNDWLEN16) > this._numSamples) {
                k2 = this._numSamples;
            }
            float scalar = 0.0f;
            if ((double)this._scalars[i] > 0.0) {
                scalar = 1.0f / this._scalars[i];
            }
            for (int k = k1; k < k2; ++k) {
                char sval = this._buffer16[k];
                traceData[k] = scalar * (float)(sval - Short.MAX_VALUE);
            }
        }
    }

    protected void arrayCopyFloatToShort(int numSamples, float[] traceIn, short[] traceOut) {
        for (int i = 0; i < numSamples; ++i) {
            float value = traceIn[i];
            value = Math.min(value, 32767.0f);
            value = Math.max(value, -32768.0f);
            traceOut[i] = (short)value;
        }
    }

    protected void arrayCopyFloatToByte(int numSamples, float[] traceIn, byte[] traceOut) {
        for (int i = 0; i < numSamples; ++i) {
            float value = traceIn[i];
            value = Math.min(value, 127.0f);
            value = Math.max(value, -128.0f);
            traceOut[i] = (byte)value;
        }
    }

    protected void arrayCopyShortToFloat(int numSamples, short[] traceIn, float[] traceOut) {
        for (int i = 0; i < numSamples; ++i) {
            traceOut[i] = traceIn[i];
        }
    }

    protected void arrayCopyByteToFloat(int numSamples, byte[] traceIn, float[] traceOut) {
        for (int i = 0; i < numSamples; ++i) {
            traceOut[i] = traceIn[i];
        }
    }

    public static void main(String[] args) throws SeisException {
        int j;
        int i;
        int numSamples = 251;
        int numTraces = 60;
        DataFormat traceFormat = DataFormat.FLOAT;
        int recordLength = TraceCompressor.getRecordLength(traceFormat, numSamples);
        ByteBuffer bufferByte = ByteBuffer.allocateDirect(recordLength * numTraces);
        float[][] origTraceData = new float[numTraces][numSamples];
        float[][] testTraceData = new float[numTraces][numSamples];
        double pi = Math.PI;
        double omega1 = pi / (double)(numSamples - 1);
        for (i = 0; i < numTraces; ++i) {
            double omega2 = (double)(i + 10) * omega1;
            for (j = 0; j < numSamples; ++j) {
                double t = j;
                origTraceData[i][j] = (float)(Math.cos(omega1 * t) * Math.sin(omega2 * t));
                testTraceData[i][j] = origTraceData[i][j];
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data generated for DataFormat.FLOAT");
        System.out.println("jsTraceCompressor: Test DataFormat.COMPRESSED_INT08...");
        traceFormat = DataFormat.COMPRESSED_INT08;
        TraceCompressor traceCompressor = new TraceCompressor(traceFormat, numSamples, bufferByte);
        traceCompressor.packFrame(numTraces, origTraceData);
        System.out.println("jsTraceCompressor: Synthetic data packed.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                testTraceData[i][j] = 0.0f;
            }
        }
        traceCompressor.unpackFrame(numTraces, testTraceData);
        System.out.println("jsTraceCompressor: Synthetic data unpacked.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                if (!((double)Math.abs(testTraceData[i][j] - origTraceData[i][j]) > 0.025)) continue;
                throw new SeisException("Error validating compression for trace " + i + " sample=" + j + " packed[trace][sample]=" + origTraceData[i][j] + " unpacked[trace][sample]=" + testTraceData[i][j]);
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data validated.");
        traceCompressor = null;
        bufferByte.position(0);
        System.gc();
        System.out.println("jsTraceCompressor: Test DataFormat.COMPRESSED_INT16...");
        traceFormat = DataFormat.COMPRESSED_INT16;
        traceCompressor = new TraceCompressor(traceFormat, numSamples, bufferByte);
        traceCompressor.packFrame(numTraces, origTraceData);
        System.out.println("jsTraceCompressor: Synthetic data packed.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                testTraceData[i][j] = 0.0f;
            }
        }
        traceCompressor.unpackFrame(numTraces, testTraceData);
        System.out.println("jsTraceCompressor: Synthetic data unpacked.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                if (!((double)Math.abs(testTraceData[i][j] - origTraceData[i][j]) > 0.001)) continue;
                throw new SeisException("Error validating compression for trace " + i + " sample=" + j + " packed[trace][sample]=" + origTraceData[i][j] + " unpacked[trace][sample]=" + testTraceData[i][j]);
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data validated.");
        traceCompressor = null;
        bufferByte.position(0);
        System.gc();
        System.out.println("jsTraceCompressor: Test DataFormat.FLOAT...");
        traceFormat = DataFormat.FLOAT;
        traceCompressor = new TraceCompressor(traceFormat, numSamples, bufferByte);
        traceCompressor.packFrame(numTraces, origTraceData);
        System.out.println("jsTraceCompressor: Synthetic data packed.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                testTraceData[i][j] = 0.0f;
            }
        }
        traceCompressor.unpackFrame(numTraces, testTraceData);
        System.out.println("jsTraceCompressor: Synthetic data unpacked.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                if (!((double)Math.abs(testTraceData[i][j] - origTraceData[i][j]) > 0.001)) continue;
                throw new SeisException("Error validating compression for trace " + i + " sample=" + j + " packed[trace][sample]=" + origTraceData[i][j] + " unpacked[trace][sample]=" + testTraceData[i][j]);
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data validated.");
        traceCompressor = null;
        bufferByte.position(0);
        System.gc();
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                origTraceData[i][j] = (float)((double)j * 0.1);
                testTraceData[i][j] = origTraceData[i][j];
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data generated for DataFormat.INT08.");
        System.out.println("jsTraceCompressor: Test DataFormat.INT08...");
        traceFormat = DataFormat.INT08;
        traceCompressor = new TraceCompressor(traceFormat, numSamples, bufferByte);
        traceCompressor.packFrame(numTraces, origTraceData);
        System.out.println("jsTraceCompressor: Synthetic data packed.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                testTraceData[i][j] = 0.0f;
            }
        }
        traceCompressor.unpackFrame(numTraces, testTraceData);
        System.out.println("jsTraceCompressor: Synthetic data unpacked.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                if (!(Math.abs(testTraceData[i][j] - origTraceData[i][j]) > 1.0f)) continue;
                throw new SeisException("Error validating compression for trace " + i + " sample=" + j + " packed[trace][sample]=" + origTraceData[i][j] + " unpacked[trace][sample]=" + testTraceData[i][j]);
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data validated.");
        traceCompressor = null;
        bufferByte.position(0);
        System.gc();
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                origTraceData[i][j] = (float)((double)j * 25.6);
                testTraceData[i][j] = origTraceData[i][j];
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data generated for DataFormat.INT16.");
        System.out.println("jsTraceCompressor: Test DataFormat.INT16...");
        traceFormat = DataFormat.INT16;
        traceCompressor = new TraceCompressor(traceFormat, numSamples, bufferByte);
        traceCompressor.packFrame(numTraces, origTraceData);
        System.out.println("jsTraceCompressor: Synthetic data packed.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                testTraceData[i][j] = 0.0f;
            }
        }
        traceCompressor.unpackFrame(numTraces, testTraceData);
        System.out.println("jsTraceCompressor: Synthetic data unpacked.");
        for (i = 0; i < numTraces; ++i) {
            for (j = 0; j < numSamples; ++j) {
                if (!(Math.abs(testTraceData[i][j] - origTraceData[i][j]) > 1.0f)) continue;
                throw new SeisException("Error validating compression for trace " + i + " sample=" + j + " packed[trace][sample]=" + origTraceData[i][j] + " unpacked[trace][sample]=" + testTraceData[i][j]);
            }
        }
        System.out.println("jsTraceCompressor: Synthetic data validated.");
        traceCompressor = null;
        bufferByte.position(0);
        System.gc();
    }
}

