/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.DHDefaultParams;
import com.certicom.ecc.jcae.RNGSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.spec.X942ParameterSpec;
import com.certicom.ecc.spec.X942PrivateKeySpec;
import com.certicom.ecc.spec.X942PublicKeySpec;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKPGenSpi
extends KeyPairGeneratorSpi {
    private static final AlgorithmParameterSpec c = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P512), new BigInteger(1, DHDefaultParams.DEFAULT_Q512), new BigInteger(1, DHDefaultParams.DEFAULT_G512));
    private static final AlgorithmParameterSpec d = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P768), new BigInteger(1, DHDefaultParams.DEFAULT_Q768), new BigInteger(1, DHDefaultParams.DEFAULT_G768));
    private static final AlgorithmParameterSpec e = new DSAParameterSpec(new BigInteger(1, DHDefaultParams.DEFAULT_P1024), new BigInteger(1, DHDefaultParams.DEFAULT_Q1024), new BigInteger(1, DHDefaultParams.DEFAULT_G1024));
    private SecureRandom f;
    private AlgorithmParameterSpec g;
    CryptoTransform a;
    KeyFactory b;

    public DHKPGenSpi() throws InstantiationException {
        try {
            this.b = KeyFactory.getInstance("DH", "Certicom");
            this.a = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "DHKEYGEN");
        }
        catch (Exception exception) {
            throw new InstantiationException(exception.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        DHPublicKeySpec dHPublicKeySpec;
        DHPrivateKeySpec dHPrivateKeySpec;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.f == null) {
            this.f = RNGSpi.a();
        }
        if (this.g == null) {
            this.g = e;
        }
        if (this.a.getMode() == 0) {
            try {
                this.initialize(this.g, this.f);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        Object[] objectArray = (Object[])this.a.transformToObject(null, 0, 0, true);
        if (this.g instanceof DSAParameterSpec) {
            bigInteger2 = ((DSAParameterSpec)this.g).getP();
            bigInteger = ((DSAParameterSpec)this.g).getG();
        } else {
            bigInteger2 = ((DHParameterSpec)this.g).getP();
            bigInteger = ((DHParameterSpec)this.g).getG();
        }
        if (this.g instanceof X942ParameterSpec) {
            dHPrivateKeySpec = new X942PrivateKeySpec(new BigInteger(1, (byte[])objectArray[0]), bigInteger2, bigInteger, ((X942ParameterSpec)this.g).getQ(), ((X942ParameterSpec)this.g).getJ(), ((X942ParameterSpec)this.g).getSeed(), ((X942ParameterSpec)this.g).getCounter());
            dHPublicKeySpec = new X942PublicKeySpec(new BigInteger(1, (byte[])objectArray[1]), bigInteger2, bigInteger, ((X942ParameterSpec)this.g).getQ(), ((X942ParameterSpec)this.g).getJ(), ((X942ParameterSpec)this.g).getSeed(), ((X942ParameterSpec)this.g).getCounter());
        } else {
            dHPrivateKeySpec = new DHPrivateKeySpec(new BigInteger(1, (byte[])objectArray[0]), bigInteger2, bigInteger);
            dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(1, (byte[])objectArray[1]), bigInteger2, bigInteger);
        }
        try {
            PrivateKey privateKey = this.b.generatePrivate(dHPrivateKeySpec);
            PublicKey publicKey = this.b.generatePublic(dHPublicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
            return null;
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        Object[] objectArray = null;
        if (algorithmParameterSpec instanceof DSAParameterSpec) {
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            try {
                byArray3 = Conversion.I2OSP(dSAParameterSpec.getP(), -1);
            }
            catch (ConversionException conversionException) {
                byArray3 = dSAParameterSpec.getP().toByteArray();
            }
            try {
                byArray2 = Conversion.I2OSP(dSAParameterSpec.getQ(), -1);
            }
            catch (ConversionException conversionException) {
                byArray2 = dSAParameterSpec.getQ().toByteArray();
            }
            try {
                byArray = Conversion.I2OSP(dSAParameterSpec.getG(), -1);
            }
            catch (ConversionException conversionException) {
                byArray = dSAParameterSpec.getG().toByteArray();
            }
            objectArray = new Object[]{byArray3, byArray2, byArray};
        } else if (algorithmParameterSpec instanceof DHParameterSpec) {
            byte[] byArray;
            byte[] byArray4;
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            try {
                byArray4 = Conversion.I2OSP(dHParameterSpec.getP(), -1);
            }
            catch (ConversionException conversionException) {
                byArray4 = dHParameterSpec.getP().toByteArray();
            }
            int n2 = dHParameterSpec.getL();
            Object var7_16 = n2 < 0 || n2 > dHParameterSpec.getP().bitLength() ? null : null;
            try {
                byArray = Conversion.I2OSP(dHParameterSpec.getG(), -1);
            }
            catch (ConversionException conversionException) {
                byArray = dHParameterSpec.getG().toByteArray();
            }
            objectArray = new Object[]{byArray4, var7_16, byArray};
        }
        if (objectArray == null) {
            throw new InvalidAlgorithmParameterException("wrong params.");
        }
        this.g = algorithmParameterSpec;
        this.f = secureRandom;
        this.a.init(5, objectArray, this.f);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        block5: {
            try {
                if (n2 == 512) {
                    this.initialize(c, secureRandom);
                    break block5;
                }
                if (n2 == 768) {
                    this.initialize(d, secureRandom);
                    break block5;
                }
                if (n2 == 1024) {
                    this.initialize(e, secureRandom);
                    break block5;
                }
                throw new IllegalArgumentException("no default parameters size: " + n2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
            }
        }
    }
}

