/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class SharedInfoParameterSpec
implements Zeroizeable,
AlgorithmParameterSpec {
    private byte[][] a = null;
    private boolean b = false;

    protected SharedInfoParameterSpec() {
    }

    public SharedInfoParameterSpec(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        this.a = new byte[byArray.length][];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == null) continue;
            this.a[i2] = new byte[byArray[i2].length];
            System.arraycopy(byArray[i2], 0, this.a[i2], 0, byArray[i2].length);
        }
    }

    public SharedInfoParameterSpec(byte[][] byArray, int[] nArray, int[] nArray2) {
        if (byArray == null || nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        if (byArray.length != nArray.length || nArray.length != nArray2.length) {
            throw new IllegalArgumentException("different length arguments");
        }
        this.a = new byte[byArray.length][];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == null) continue;
            if (nArray[i2] + nArray2[i2] > byArray[i2].length) {
                throw new IllegalArgumentException("wrong length arguments.");
            }
            this.a[i2] = new byte[byArray[i2].length];
            System.arraycopy(byArray[i2], nArray[i2], this.a[i2], 0, nArray2[i2]);
        }
    }

    public byte[][] getSharedInfo() {
        if (this.a == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[this.a.length][];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (this.a[i2] == null) continue;
            byArrayArray[i2] = new byte[this.a[i2].length];
            System.arraycopy(this.a[i2], 0, byArrayArray[i2], 0, byArrayArray[i2].length);
        }
        return byArrayArray;
    }

    public byte[] getSharedInfo(int n2) {
        if (this.a == null) {
            return null;
        }
        if (n2 < 0 || n2 > this.a.length) {
            throw new IllegalArgumentException("index incorrect.");
        }
        if (this.a[n2] == null) {
            return null;
        }
        byte[] byArray = new byte[this.a[n2].length];
        System.arraycopy(this.a[n2], 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isZeroized() {
        return this.b;
    }

    public boolean testZeroizationState() {
        return this.b;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (this.a[i2] == null) continue;
                Arrays.fill(this.a[i2], (byte)0);
            }
        }
        this.b = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            stringBuffer.append(Integer.toString(i2)).append(" = ");
            if (this.a[i2] != null) {
                stringBuffer.append(Conversion.OS2Hex(this.a[i2], 2)).append(" ");
                continue;
            }
            stringBuffer.append("null ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

