/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.provider.EccPoint;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ECKeyFactory;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.PointSpec;
import com.certicom.ecc.system.SystemConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class ECKeyDerive
extends CryptoTransform
implements Serializable {
    private static final long serialVersionUID = 1427362633185714629L;
    private ECPrivateKey a;

    public ECKeyDerive() {
        super("KEYDERIVE");
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isVerifiable() {
        return false;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 5) {
            throw new IllegalArgumentException("Only supports GENKEY");
        }
        if (objectArray == null || objectArray.length != 1 || !(objectArray[0] instanceof ECPrivateKey)) {
            throw new IllegalArgumentException("Need ECPrivateKey");
        }
        this.a = (ECPrivateKey)objectArray[0];
    }

    public int outputSize(int n2, boolean bl) {
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        try {
            ECPublicKeySpec eCPublicKeySpec;
            if (this.a == null) {
                throw new IllegalStateException("Not initialized");
            }
            BigInteger bigInteger = new BigInteger(1, this.a.getExp());
            EccPoint eccPoint = (EccPoint)ECFactory.a(this.a.getECParams()).c().a(bigInteger);
            int n4 = SystemConfig.getConfig().getFormat();
            int n5 = SystemConfig.getConfig().getPtCompression();
            ECPublicKeySpec eCPublicKeySpec2 = eCPublicKeySpec = new ECPublicKeySpec(n4, n5, new PointSpec(eccPoint.e().f(), eccPoint.f().f(), this.a.getECParams()), this.a.getECParams());
            return eCPublicKeySpec2;
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable.getMessage());
        }
        finally {
            this.a = null;
        }
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
        if (object instanceof ECPublicKeySpec) {
            try {
                ECKeyFactory.a((ECPublicKeySpec)object);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.a);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.a = (ECPrivateKey)objectInputStream.readObject();
    }
}

