/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Volume;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Volume.VolumeProject;
import com.PecosLibrary.Volume.VolumeStackController;
import com.PecosLibrary.Windows.JDBC.TableWrapperWidget;
import com.PecosLibrary.Windows.Volume.Import.ImportVolumeSegyDialog;
import com.PecosLibrary.Windows.Volume.Stack.Attributes.VolumeStack_AttributeComputationWidget;
import com.PecosLibrary.Windows.Volume.Stack.VolumeStack_SimpleViewerWidget;
import com.PecosLibrary.Windows.Volume.Stack.VolumeStack_SingleTraceAnalysisWidget;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AppFrame_VolumeProjectTree
extends JFrame
implements ActionListener,
Messenger.Listener,
MouseListener {
    protected Timer m_timer = new Timer(1000, this);
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected int m_nextComponentIndex = 1;
    protected JTree m_tree;
    protected DefaultMutableTreeNode m_topNode = new DefaultMutableTreeNode();
    protected DefaultMutableTreeNode m_stacksNode = new DefaultMutableTreeNode();
    protected JButton m_reloadTreeButton;
    protected JPopupMenu m_stacksPopupMenu;
    protected JMenuItem m_addStackMI;
    protected ImportVolumeSegyDialog m_importStackDialog;

    public AppFrame_VolumeProjectTree() {
        try {
            Messenger.singleton().addListener(this);
            this.getContentPane().setLayout(new BorderLayout());
            JSplitPane splitter = new JSplitPane(1);
            this.m_mainPanel.setLayout(this.m_cardLayout);
            splitter.setRightComponent(this.m_mainPanel);
            LinearLayoutWidget left = LinearLayoutWidget.vert(3, null);
            this.m_reloadTreeButton = left.createButton("Reload tree", this, 0);
            this.m_topNode.setUserObject(new TreeNodeData());
            this.m_tree = new JTree(this.m_topNode);
            this.m_tree.setRootVisible(true);
            this.m_tree.addMouseListener(this);
            left.addComponent(new JScrollPane(this.m_tree), 10);
            splitter.setLeftComponent(left);
            this.getContentPane().add((Component)splitter, "Center");
            this.m_stacksPopupMenu = new JPopupMenu();
            this.m_addStackMI = new JMenuItem("Add stack");
            this.m_addStackMI.addActionListener(this);
            this.m_stacksPopupMenu.add(this.m_addStackMI);
            HashMap<String, String> map = SharedApplicationData.singleton().LaunchCodes;
            String projectName = map.get("ProjectName");
            projectName = "Waha";
            SharedApplicationData.singleton();
            String volumeProjectsPath = SharedApplicationData.volumeProjectPath();
            String fullPath = volumeProjectsPath + "/" + projectName;
            boolean projectExists = Tools_FileSystem.exists_path(fullPath);
            if (!projectExists) {
                System.exit(0);
            }
            VolumeProject.singleton().setName(projectName);
            this.setTitle(projectName);
            this.setSize(1100, 900);
            this.setLocationRelativeTo(null);
            this.setTitle("Volume project - " + projectName);
            this.setDefaultCloseOperation(3);
            int runCount = RefractionStaticsProject.singleton().runCount();
            this.reloadTree();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadStacks() {
        try {
            String dir = VolumeProject.singleton().stackContainerPath();
            File f = new File(dir);
            if (!f.exists()) {
                return;
            }
            File[] files = f.listFiles();
            if (files == null) {
                return;
            }
            ParameterTree p = new ParameterTree();
            for (File temp : files) {
                String paramFileName;
                if (!temp.isDirectory() || !Tools_FileSystem.exists_file(paramFileName = temp.getAbsolutePath() + "/ProjectDescription.xml")) continue;
                p.read(paramFileName);
                VolumeStackController stackController = new VolumeStackController(temp.getName());
                TreeNodeData nodeData = new TreeNodeData();
                nodeData.StackController = stackController;
                nodeData.NodeLabel = temp.getName();
                nodeData.NodeType = TreeNodeType.Stack;
                DefaultMutableTreeNode stackNode = new DefaultMutableTreeNode(nodeData);
                this.m_stacksNode.add(stackNode);
                nodeData = new TreeNodeData();
                nodeData.StackController = stackController;
                nodeData.StackName = temp.getName();
                nodeData.NodeLabel = "View profiles";
                nodeData.NodeType = TreeNodeType.ViewStackProfile;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeData);
                stackNode.add(node);
                nodeData = new TreeNodeData();
                nodeData.StackController = stackController;
                nodeData.StackName = temp.getName();
                nodeData.NodeLabel = "View trace table";
                nodeData.NodeType = TreeNodeType.ViewStackTraceTable;
                node = new DefaultMutableTreeNode(nodeData);
                stackNode.add(node);
                nodeData = new TreeNodeData();
                nodeData.StackController = stackController;
                nodeData.StackName = temp.getName();
                nodeData.NodeLabel = "SWFT";
                nodeData.NodeType = TreeNodeType.SWFT;
                node = new DefaultMutableTreeNode(nodeData);
                stackNode.add(node);
                nodeData = new TreeNodeData();
                nodeData.StackController = stackController;
                nodeData.StackName = temp.getName();
                nodeData.NodeLabel = "Compute attributes";
                nodeData.NodeType = TreeNodeType.ComputeAttributes;
                node = new DefaultMutableTreeNode(nodeData);
                stackNode.add(node);
                nodeData = new TreeNodeData();
                nodeData.StackController = stackController;
                nodeData.StackName = temp.getName();
                nodeData.NodeLabel = "View attributes";
                nodeData.NodeType = TreeNodeType.ViewAttributes;
                node = new DefaultMutableTreeNode(nodeData);
                stackNode.add(node);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadTree() {
        try {
            this.m_mainPanel.removeAll();
            this.m_topNode.removeAllChildren();
            this.m_mainPanel.add((Component)new JPanel(), "Primer");
            TreeNodeData nodeData = new TreeNodeData();
            nodeData.NodeLabel = "Stacks";
            nodeData.NodeType = TreeNodeType.StackContainer;
            this.m_stacksNode = new DefaultMutableTreeNode("Stacks");
            this.m_stacksNode.setUserObject(nodeData);
            this.m_topNode.add(this.m_stacksNode);
            this.reloadStacks();
            this.m_tree.setRootVisible(true);
            this.m_tree.repaint();
            ((DefaultTreeModel)this.m_tree.getModel()).reload();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void viewTraceTable(TreeNodeData nodeData) {
        try {
            if (nodeData.DisplayComponent == null) {
                IDatabaseConnection db = nodeData.StackController.traceTableConnection();
                nodeData.ComponentName = "name_" + Integer.toString(this.m_nextComponentIndex);
                nodeData.DisplayComponent = new TableWrapperWidget(db, "Trace", DatabaseEnum.StackTraceTable);
                this.m_mainPanel.add((Component)nodeData.DisplayComponent, nodeData.ComponentName);
                ++this.m_nextComponentIndex;
            }
            this.m_cardLayout.show(this.m_mainPanel, nodeData.ComponentName);
            ++this.m_nextComponentIndex;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void viewSWFT(TreeNodeData nodeData) {
        try {
            if (nodeData.DisplayComponent == null) {
                nodeData.ComponentName = "name_" + Integer.toString(this.m_nextComponentIndex);
                nodeData.DisplayComponent = new VolumeStack_SingleTraceAnalysisWidget(nodeData.StackController);
                this.m_mainPanel.add((Component)nodeData.DisplayComponent, nodeData.ComponentName);
                ++this.m_nextComponentIndex;
            }
            this.m_cardLayout.show(this.m_mainPanel, nodeData.ComponentName);
            ++this.m_nextComponentIndex;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void viewStackProfile(TreeNodeData nodeData) {
        try {
            if (nodeData.DisplayComponent == null) {
                nodeData.ComponentName = "name_" + Integer.toString(this.m_nextComponentIndex);
                nodeData.DisplayComponent = new VolumeStack_SimpleViewerWidget(nodeData.StackController);
                this.m_mainPanel.add((Component)nodeData.DisplayComponent, nodeData.ComponentName);
                ++this.m_nextComponentIndex;
            }
            this.m_cardLayout.show(this.m_mainPanel, nodeData.ComponentName);
            ++this.m_nextComponentIndex;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void computeAttributes(TreeNodeData nodeData) {
        try {
            if (nodeData.DisplayComponent == null) {
                nodeData.ComponentName = "name_" + Integer.toString(this.m_nextComponentIndex);
                nodeData.DisplayComponent = new VolumeStack_AttributeComputationWidget(nodeData.StackController);
                this.m_mainPanel.add((Component)nodeData.DisplayComponent, nodeData.ComponentName);
                ++this.m_nextComponentIndex;
            }
            this.m_cardLayout.show(this.m_mainPanel, nodeData.ComponentName);
            ++this.m_nextComponentIndex;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        try {
            if (event.getSource() == this.m_tree) {
                int selRow = this.m_tree.getRowForLocation(event.getX(), event.getY());
                if (selRow < 0) {
                    return;
                }
                TreePath path = this.m_tree.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return;
                }
                Object obj = path.getLastPathComponent();
                if (!(obj instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (!(node.getUserObject() instanceof TreeNodeData)) {
                    return;
                }
                TreeNodeData nodeData = (TreeNodeData)node.getUserObject();
                if (nodeData.NodeType == TreeNodeType.SWFT) {
                    this.viewSWFT(nodeData);
                    return;
                }
                if (nodeData.NodeType == TreeNodeType.ViewStackTraceTable) {
                    this.viewTraceTable(nodeData);
                    return;
                }
                if (nodeData.NodeType == TreeNodeType.ViewStackProfile) {
                    this.viewStackProfile(nodeData);
                    return;
                }
                if (nodeData.NodeType == TreeNodeType.ComputeAttributes) {
                    this.computeAttributes(nodeData);
                    return;
                }
                if (event.isPopupTrigger() && nodeData.NodeType == TreeNodeType.StackContainer) {
                    this.m_stacksPopupMenu.show(this.m_tree, event.getX(), event.getY());
                    return;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadTreeButton) {
                this.reloadTree();
                return;
            }
            if (e.getSource() == this.m_addStackMI) {
                if (this.m_importStackDialog == null) {
                    this.m_importStackDialog = new ImportVolumeSegyDialog();
                }
                this.m_importStackDialog.showDialog();
                this.reloadTree();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class TreeNodeData {
        public TreeNodeType NodeType = TreeNodeType.Root;
        public boolean HasDisplay = false;
        public JComponent DisplayComponent = null;
        public String ComponentName = "";
        public String NodeLabel = "Project navigation";
        public String StackName = "";
        public VolumeStackController StackController;

        protected TreeNodeData() {
        }

        public String toString() {
            return this.NodeLabel;
        }
    }

    protected static enum TreeNodeType {
        Root,
        StackContainer,
        Stack,
        ViewStackProfile,
        ViewStackTraceTable,
        ComputeAttributes,
        ViewAttributes,
        SWFT;

    }
}

