/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Synthetic;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_Exporter;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class SyntheticModel
implements Java2D_PaintableInterface {
    protected boolean m_bContentsChangedSinceLastPaint = true;
    protected double m_gridSize = 2.5;
    protected int m_numX;
    protected int m_numZ;
    protected float[][] m_velGrid;
    protected float[][] m_velGridBack;
    protected float m_velMin;
    protected float m_velMax;
    protected int m_numBuffX = 400;
    protected int m_numBuffZ = 300;
    protected int m_totalX;
    protected int m_totalZ;
    protected float[][] m_amp_Plus1;
    protected float[][] m_amp;
    protected float[][] m_amp_Minus1;
    protected float[][] m_velocity;
    protected float m_sampleInterval;
    protected int m_numTimeSteps;
    protected int m_shotGridSpacing;
    protected int m_shotX;
    protected int m_recGridSpacing;
    protected int m_numReceivers;
    protected int[] m_receiverIndexX;
    protected float[][] m_receiverData;
    protected Segy_Exporter m_exporter = null;
    protected boolean m_testSpike = false;
    protected float[] m_tempArray;

    public SyntheticModel() {
        try {
            this.createModel(7000.0, 3000.0, 1500.0, 5000.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != 1092922) {
                file.close();
                return;
            }
            int version = file.readInt();
            if (version == 1000) {
                this.m_numX = file.readInt();
                this.m_numZ = file.readInt();
                this.m_velGrid = new float[this.m_numX][this.m_numZ];
                this.m_velGridBack = new float[this.m_numX][this.m_numZ];
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * this.m_numX * this.m_numZ);
                file.read(buff.array(), 0, 4 * this.m_numX * this.m_numZ);
                int num = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        this.m_velGrid[x][z] = buff.getFloat();
                        num += 4;
                    }
                }
            }
            file.close();
            this.computeVelRange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = 1092922;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_numX);
                file.writeInt(this.m_numZ);
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * this.m_numX * this.m_numZ);
                int num = 0;
                for (int x = 0; x < this.m_numX; ++x) {
                    for (int z = 0; z < this.m_numZ; ++z) {
                        buff.putFloat(num, this.m_velGrid[x][z]);
                        num += 4;
                    }
                }
                file.write(buff.array(), 0, num);
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected Segy_Dictionary dictionary() {
        try {
            Segy_Dictionary dict = new Segy_Dictionary();
            dict.addDefaultEntries();
            dict.removeEntry("Shot", "LineNumber");
            dict.removeEntry("Receiver", "LineNumber");
            return dict;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void shoot(String segyFileName, double maxOffset, double maxTime, double recSpacing, double shotSpacing, int maxShots) {
        try {
            this.m_exporter = new Segy_Exporter();
            this.m_exporter.Dictionary = this.dictionary();
            this.m_exporter.FileName = segyFileName;
            this.m_exporter.OutputSampleCount = (int)(1000.0 * maxTime / 4.0);
            this.m_exporter.OutputDigi = 4.0f;
            this.m_exporter.prepareFile();
            double ff = 0.4 * this.m_gridSize / (1.414 * (double)this.m_velMax);
            this.m_sampleInterval = (float)ff;
            this.m_numTimeSteps = (int)(maxTime / (double)this.m_sampleInterval);
            this.m_recGridSpacing = (int)(0.5 + recSpacing / this.m_gridSize);
            this.m_recGridSpacing = Math.max(4, this.m_recGridSpacing);
            this.m_recGridSpacing = Math.min(20, this.m_recGridSpacing);
            if (this.m_recGridSpacing % 2 == 1) {
                ++this.m_recGridSpacing;
            }
            this.m_shotGridSpacing = this.m_recGridSpacing;
            if (shotSpacing > recSpacing) {
                this.m_shotGridSpacing = 2 * this.m_recGridSpacing;
            }
            double maxFreq = 30.0;
            double alpha = Math.PI * 2 * maxFreq;
            double beta = 56.2;
            this.prepShootGrids();
            this.prepReceivers();
            double sinAlpha = 157.07963267948966;
            double expAlpha = Math.log(10.0) / 0.05;
            int numShots = 0;
            this.m_shotX = this.m_numBuffX + this.m_recGridSpacing / 2;
            this.m_testSpike = false;
            this.m_shotX = this.m_numBuffX + 95;
            while (numShots < 1 && this.m_shotX < this.m_numX + this.m_numBuffX) {
                System.out.println("shotX = " + this.m_shotX);
                this.resetGrids();
                for (int it = 0; it < this.m_numTimeSteps; ++it) {
                    this.updateTraces(it);
                    double time = this.m_sampleInterval * (float)it;
                    double at = alpha * time;
                    double cos = Math.cos(0.5 * at);
                    double sin = Math.sin(0.5 * at);
                    double exp = Math.exp(-at * at / beta);
                    this.m_amp[this.m_shotX][0] = 1000000.0f * (float)(sin * exp);
                    if (this.m_testSpike) {
                        this.m_amp[this.m_shotX][0] = it == 0 ? 1000000.0f : 0.0f;
                    }
                    this.propagate(it);
                    this.shiftGrids();
                }
                Ensemble ensemble = this.extractEnsemble(this.m_shotX, maxOffset);
                this.m_exporter.appendEnsemble(ensemble);
                ++numShots;
                this.m_shotX += this.m_shotGridSpacing;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.m_amp_Plus1 = null;
            this.m_amp = null;
            this.m_amp_Minus1 = null;
            this.m_velocity = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void propagate(int it) {
        try {
            float temp;
            float temp2;
            int z;
            int x;
            for (x = 1; x < this.m_totalX - 1; ++x) {
                for (z = 1; z < this.m_totalZ - 1; ++z) {
                    temp2 = this.m_amp[x + 1][z] + this.m_amp[x - 1][z] + this.m_amp[x][z + 1] + this.m_amp[x][z - 1] - 4.0f * this.m_amp[x][z];
                    this.m_amp_Plus1[x][z] = 2.0f * this.m_amp[x][z] - this.m_amp_Minus1[x][z] + this.m_velocity[x][z] * temp2;
                }
            }
            for (x = 1; x < this.m_totalX - 1; ++x) {
                z = this.m_totalZ - 1;
                temp2 = this.m_amp[x + 1][z] + this.m_amp[x - 1][z] + this.m_amp[x][z - 1] - 4.0f * this.m_amp[x][z];
                this.m_amp_Plus1[x][z] = 2.0f * this.m_amp[x][z] - this.m_amp_Minus1[x][z] + this.m_velocity[x][z] * temp2;
            }
            int num = 0;
            for (int x2 = 1; x2 < this.m_totalX - 1; ++x2) {
                int z2 = 0;
                if (this.m_shotX == x2) {
                    ++num;
                }
                temp = this.m_amp[x2 + 1][z2] + this.m_amp[x2 - 1][z2] + this.m_amp[x2][z2 + 1] - 4.0f * this.m_amp[x2][z2];
                this.m_amp_Plus1[x2][z2] = 2.0f * this.m_amp[x2][z2] - this.m_amp_Minus1[x2][z2] + this.m_velocity[x2][z2] * temp;
                if (!this.m_testSpike || it >= 50 || x2 != this.m_shotX) continue;
                System.out.println("  " + it + "  " + this.m_amp_Plus1[x2][z2] + "  " + this.m_amp_Plus1[x2 + 1][z2] + "  " + this.m_amp_Plus1[x2 + 2][z2] + "  " + this.m_amp_Plus1[x2 + 3][z2] + "  " + this.m_amp_Plus1[x2 + 4][z2]);
            }
            for (z = 1; z < this.m_totalZ - 1; ++z) {
                int x3 = 0;
                temp = this.m_amp[x3 + 1][z] + this.m_amp[x3][z + 1] + this.m_amp[x3][z - 1] - 4.0f * this.m_amp[x3][z];
                this.m_amp_Plus1[x3][z] = 2.0f * this.m_amp[x3][z] - this.m_amp_Minus1[x3][z] + this.m_velocity[x3][z] * temp;
            }
            for (z = 1; z < this.m_totalZ - 1; ++z) {
                int x4 = this.m_totalX - 1;
                temp = this.m_amp[x4 - 1][z] + this.m_amp[x4][z + 1] + this.m_amp[x4][z - 1] - 4.0f * this.m_amp[x4][z];
                this.m_amp_Plus1[x4][z] = 2.0f * this.m_amp[x4][z] - this.m_amp_Minus1[x4][z] + this.m_velocity[x4][z] * temp;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected Ensemble extractEnsemble(int shotX, double maxOffset) {
        try {
            Ensemble ensemble = new Ensemble();
            int indexRecX = ensemble.dictionary().addEntry("Receiver", "Easting", DataType.Double);
            int indexRecY = ensemble.dictionary().addEntry("Receiver", "Northing", DataType.Double);
            int indexRecZ = ensemble.dictionary().addEntry("Receiver", "Elevation", DataType.Double);
            int indexRecLine = ensemble.dictionary().addEntry("Receiver", "LineNumber", DataType.Int);
            int indexRecPoint = ensemble.dictionary().addEntry("Receiver", "PointNumber", DataType.Int);
            int indexShotX = ensemble.dictionary().addEntry("Shot", "Easting", DataType.Double);
            int indexShotY = ensemble.dictionary().addEntry("Shot", "Northing", DataType.Double);
            int indexShotZ = ensemble.dictionary().addEntry("Shot", "Elevation", DataType.Double);
            int indexShotLine = ensemble.dictionary().addEntry("Shot", "LineNumber", DataType.Int);
            int indexShotPoint = ensemble.dictionary().addEntry("Shot", "PointNumber", DataType.Int);
            int indexShotFFID = ensemble.dictionary().addEntry("Shot", "FFID", DataType.Int);
            for (int n = 0; n < this.m_numReceivers; ++n) {
                int x = this.m_receiverIndexX[n];
                double offset = this.m_gridSize * (double)Math.abs(x - shotX);
                if (!(offset <= maxOffset)) continue;
                EnsembleTrace trace = ensemble.addTrace();
                trace.header().putDouble(indexShotX, (double)(shotX - this.m_numBuffX) * this.m_gridSize);
                trace.header().putDouble(indexShotY, 0.0);
                trace.header().putDouble(indexShotZ, 1000.0);
                trace.header().putInt(indexShotLine, 500);
                trace.header().putInt(indexShotPoint, shotX);
                trace.header().putInt(indexShotFFID, shotX);
                trace.header().putDouble(indexRecX, (double)(x - this.m_numBuffX) * this.m_gridSize);
                trace.header().putDouble(indexRecY, 0.0);
                trace.header().putDouble(indexRecZ, 1000.0);
                trace.header().putInt(indexRecLine, 500);
                trace.header().putInt(indexRecPoint, x);
                this.filter(this.m_receiverData[n]);
                trace.data().insertArray(this.m_receiverData[n], this.m_numTimeSteps);
                trace.data().setSampleInterval(1000.0f * this.m_sampleInterval);
                trace.data().setFirstSampleCoord(0.0f);
            }
            return ensemble;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void filter(float[] array) {
        try {
            int n;
            if (this.m_tempArray == null) {
                this.m_tempArray = new float[array.length];
            }
            if (this.m_tempArray.length != array.length) {
                this.m_tempArray = new float[array.length];
            }
            for (n = 0; n < array.length; ++n) {
                this.m_tempArray[n] = array[n];
            }
            for (n = 1; n < array.length - 1; ++n) {
                array[n] = 0.25f * this.m_tempArray[n - 1] + 0.5f * this.m_tempArray[n] + 0.25f * this.m_tempArray[n + 1];
            }
            for (n = 0; n < array.length; ++n) {
                this.m_tempArray[n] = array[n];
            }
            for (n = 1; n < array.length - 1; ++n) {
                array[n] = 0.25f * this.m_tempArray[n - 1] + 0.5f * this.m_tempArray[n] + 0.25f * this.m_tempArray[n + 1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateTraces(int t) {
        try {
            for (int n = 0; n < this.m_numReceivers; ++n) {
                int x = this.m_receiverIndexX[n];
                this.m_receiverData[n][t] = this.m_amp_Plus1[x][0];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shiftGrids() {
        try {
            for (int x = 0; x < this.m_totalX; ++x) {
                for (int z = 0; z < this.m_totalZ; ++z) {
                    this.m_amp_Minus1[x][z] = this.m_amp[x][z];
                    this.m_amp[x][z] = this.m_amp_Plus1[x][z];
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void resetGrids() {
        try {
            for (int x = 0; x < this.m_totalX; ++x) {
                for (int z = 0; z < this.m_totalZ; ++z) {
                    this.m_amp_Plus1[x][z] = 0.0f;
                    this.m_amp[x][z] = 0.0f;
                    this.m_amp_Minus1[x][z] = 0.0f;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepReceivers() {
        try {
            this.m_numReceivers = this.m_numX / this.m_recGridSpacing;
            this.m_receiverIndexX = new int[this.m_numReceivers];
            this.m_receiverData = new float[this.m_numReceivers][this.m_numTimeSteps];
            for (int n = 0; n < this.m_numReceivers; ++n) {
                this.m_receiverIndexX[n] = this.m_numBuffX + n * this.m_recGridSpacing;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepShootGrids() {
        try {
            int x;
            int z;
            float v;
            float beta;
            float alpha;
            float endVel;
            int x2;
            this.m_totalX = this.m_numX + 2 * this.m_numBuffX;
            this.m_totalZ = this.m_numZ + this.m_numBuffZ;
            this.m_amp_Plus1 = new float[this.m_totalX][this.m_totalZ];
            this.m_amp = new float[this.m_totalX][this.m_totalZ];
            this.m_amp_Minus1 = new float[this.m_totalX][this.m_totalZ];
            this.m_velocity = new float[this.m_totalX][this.m_totalZ];
            for (x2 = 0; x2 < this.m_numX; ++x2) {
                for (int z2 = 0; z2 < this.m_numZ; ++z2) {
                    this.m_velocity[x2 + this.m_numBuffX][z2] = this.m_velGrid[x2][z2];
                }
            }
            for (x2 = this.m_numBuffX; x2 < this.m_numBuffX + this.m_numX; ++x2) {
                float startVel = this.m_velocity[x2][this.m_numZ - 1];
                endVel = 100.0f;
                alpha = (endVel - startVel) / (float)this.m_numBuffZ;
                beta = startVel - alpha * (float)(this.m_numZ - 1);
                for (int z3 = this.m_numZ; z3 < this.m_totalZ; ++z3) {
                    this.m_velocity[x2][z3] = v = alpha * (float)z3 + beta;
                    if (x2 != this.m_numBuffX) continue;
                    System.out.println(z3 + "  " + v);
                }
            }
            for (z = 0; z < this.m_totalZ; ++z) {
                float startVel = this.m_velocity[this.m_numBuffX][z];
                endVel = 100.0f;
                alpha = (startVel - endVel) / (float)this.m_numBuffX;
                beta = endVel;
                for (x = 0; x < this.m_numBuffX; ++x) {
                    this.m_velocity[x][z] = v = alpha * (float)x + beta;
                }
            }
            for (z = 0; z < this.m_totalZ; ++z) {
                float startVel = this.m_velocity[this.m_numBuffX + this.m_numX - 1][z];
                endVel = 100.0f;
                alpha = (endVel - startVel) / (float)this.m_numBuffX;
                beta = startVel - alpha * (float)(this.m_numBuffX + this.m_numX);
                for (x = this.m_numBuffX + this.m_numX; x < this.m_totalX; ++x) {
                    this.m_velocity[x][z] = v = alpha * (float)x + beta;
                }
            }
            for (x2 = 0; x2 < this.m_totalX; ++x2) {
                for (int z4 = 0; z4 < this.m_totalZ; ++z4) {
                    double alpha2 = (double)(this.m_velocity[x2][z4] * this.m_sampleInterval) / this.m_gridSize;
                    this.m_velocity[x2][z4] = (float)(alpha2 * alpha2);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeVelRange() {
        try {
            this.m_velMin = Float.MAX_VALUE;
            this.m_velMax = Float.MIN_VALUE;
            for (int x = 0; x < this.m_numX; ++x) {
                for (int z = 0; z < this.m_numZ; ++z) {
                    this.m_velMin = Math.min(this.m_velMin, this.m_velGrid[x][z]);
                    this.m_velMax = Math.max(this.m_velMax, this.m_velGrid[x][z]);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createModel(double width, double height, double v0, double v1) {
        try {
            width = Math.max(3000.0, width);
            width = Math.min(20000.0, width);
            height = Math.max(600.0, height);
            height = Math.min(4000.0, height);
            this.m_numX = 1 + (int)(width / this.m_gridSize);
            this.m_numZ = 1 + (int)(height / this.m_gridSize);
            this.m_velGrid = new float[this.m_numX][this.m_numZ];
            this.m_velGridBack = new float[this.m_numX][this.m_numZ];
            for (int x = 0; x < this.m_numX; ++x) {
                for (int z = 0; z < this.m_numZ; ++z) {
                    this.m_velGrid[x][z] = (float)(v0 + (v1 - v0) * (double)z / (double)(this.m_numZ - 1));
                }
            }
            this.computeVelRange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected float getSmoothedValue(int xc, int zc, int rad) {
        try {
            int minx = Math.max(0, xc - rad);
            int maxx = Math.min(this.m_numX - 1, xc + rad);
            int minz = Math.max(0, zc - rad);
            int maxz = Math.min(this.m_numZ - 1, zc + rad);
            double sum = 0.0;
            double count = 1.0E-8;
            for (int x = minx; x <= maxx; ++x) {
                for (int z = minz; z <= maxz; ++z) {
                    sum += (double)this.m_velGrid[x][z];
                    count += 1.0;
                }
            }
            return (float)(sum / count);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999.0f;
        }
    }

    public void smooth(double radius) {
        try {
            int x;
            int rad = (int)(0.5 + radius / this.m_gridSize);
            rad = Math.max(1, rad);
            rad = Math.min(10, rad);
            for (x = 0; x < this.m_numX; ++x) {
                for (int z = 0; z < this.m_numZ; ++z) {
                    this.m_velGridBack[x][z] = this.m_velGrid[x][z];
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                double gx = this.m_gridSize * (double)x;
                for (int z = 0; z < this.m_numZ; ++z) {
                    double gy = this.m_gridSize * (double)z;
                    this.m_velGridBack[x][z] = this.getSmoothedValue(x, z, rad);
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (int z = 0; z < this.m_numZ; ++z) {
                    this.m_velGrid[x][z] = this.m_velGridBack[x][z];
                }
            }
            this.computeVelRange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void smoothInsidePolygon(Java2D_Polygon p, double radius) {
        try {
            int x;
            if (p == null) {
                return;
            }
            int rad = (int)(0.5 + radius / this.m_gridSize);
            rad = Math.max(1, rad);
            rad = Math.min(10, rad);
            for (x = 0; x < this.m_numX; ++x) {
                for (int z = 0; z < this.m_numZ; ++z) {
                    this.m_velGridBack[x][z] = this.m_velGrid[x][z];
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                double gx = this.m_gridSize * (double)x;
                for (int z = 0; z < this.m_numZ; ++z) {
                    double gy = this.m_gridSize * (double)z;
                    if (!p.contains(gx, gy)) continue;
                    this.m_velGridBack[x][z] = this.getSmoothedValue(x, z, rad);
                }
            }
            for (x = 0; x < this.m_numX; ++x) {
                for (int z = 0; z < this.m_numZ; ++z) {
                    this.m_velGrid[x][z] = this.m_velGridBack[x][z];
                }
            }
            this.computeVelRange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setRectangle(double top, double bottom, double west, double east, double v) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                double gx = this.m_gridSize * (double)x;
                for (int z = 0; z < this.m_numZ; ++z) {
                    double gy = this.m_gridSize * (double)z;
                    if (!(gy >= top) || !(gy <= bottom) || !(gx >= west) || !(gx <= east)) continue;
                    this.m_velGrid[x][z] = (float)v;
                }
            }
            this.computeVelRange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPolygon(Java2D_Polygon p, double v) {
        try {
            for (int x = 0; x < this.m_numX; ++x) {
                double gx = this.m_gridSize * (double)x;
                for (int z = 0; z < this.m_numZ; ++z) {
                    double gy = this.m_gridSize * (double)z;
                    if (!p.contains(gx, gy)) continue;
                    this.m_velGrid[x][z] = (float)v;
                }
            }
            this.computeVelRange();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            this.m_bContentsChangedSinceLastPaint = false;
            System.out.println("model, Java2D_Paint");
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int sx = 1 + (int)(this.m_gridSize * scaleX);
            int sy = 1 + (int)(this.m_gridSize * scaleY);
            for (int x = 0; x < this.m_numX; ++x) {
                double gx = this.m_gridSize * (double)x - 0.5 * this.m_gridSize;
                int ix = (int)(scaleX * gx + shiftX);
                for (int z = 0; z < this.m_numZ; ++z) {
                    double gy = this.m_gridSize * (double)z - 0.5 * this.m_gridSize;
                    int iy = (int)(scaleY * gy + shiftY);
                    g2d.setColor(colorWrapper.colorUsingValue(this.m_velGrid[x][z]));
                    g2d.fillRect(ix, iy, sx, sy);
                }
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeX.expandRange(-500.0);
            rangeX.expandRange((double)this.m_numX * this.m_gridSize + 500.0);
            rangeY.expandRange(-100.0);
            rangeY.expandRange((double)this.m_numZ * this.m_gridSize + 100.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            rangeC.expandRange(this.m_velMin);
            rangeC.expandRange(this.m_velMax);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

