/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.VelocityManager;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class VelocityVersionSelectionWidget
extends LinearLayoutWidget
implements ActionListener,
ItemListener,
GenericObjectListener.Listener,
VelocityManager.Listener {
    protected VelocityManager m_velManager;
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected JButton m_reloadButton;
    protected JButton m_newButton;
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public VelocityVersionSelectionWidget(GenericObjectListener.Listener listener) {
        super(LinearLayoutWidget.Direction.Horizontal, 3, "Select velocity field version");
        try {
            this.m_listener.addListener(listener);
            this.m_velManager = RefractionStaticsProject.singleton().getVelocityManager();
            this.m_velManager.addListener(this);
            this.addComponent(this.m_versionCombo, 100);
            this.m_versionCombo.listener().addListener(this);
            this.m_reloadButton = Tools_Bitmap.makeButton(this, BitmapEnum.Refresh, (ActionListener)this);
            this.m_newButton = Tools_Bitmap.makeButton(this, BitmapEnum.FileNew, (ActionListener)this);
            this.reloadListOfVelocities();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleVelocityManager(String name, VelocityManager.Message message) {
        try {
            if (message == VelocityManager.Message.VersionAdded) {
                this.reloadListOfVelocities();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getSelectedVersion() {
        try {
            return this.m_versionCombo.getSelectedString();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void reloadListOfVelocities() {
        try {
            ArrayList<String> files = this.m_velManager.getVersionList();
            this.m_versionCombo.setStringArray(files);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_versionCombo) {
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadButton) {
                this.reloadListOfVelocities();
                return;
            }
            if (e.getSource() == this.m_newButton) {
                String name = JOptionPane.showInputDialog(null, "Name of the new velocity version", "Version name", -1);
                if (name == null) {
                    return;
                }
                if (name.length() < 1) {
                    JOptionPane.showMessageDialog(null, "Name is zero length", "Name not valid", 0);
                    return;
                }
                if (!Tools_Strings.isAlphaNumeric(name, true, true)) {
                    JOptionPane.showMessageDialog(null, "Name cannot contains spaces or special characters", "Name not valid", 0);
                    return;
                }
                name = this.m_velManager.addVersion(name);
                this.m_versionCombo.setPreferredSelected(name);
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

