/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Stack;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class StackingLines
implements Java2D_PaintableInterface {
    protected int m_inlineSkip = 1;
    protected int m_crosslineSkip = 1;
    protected int m_inlineMin;
    protected int m_inlineMax;
    protected int m_crosslineMin;
    protected int m_crosslineMax;
    protected ArrayList<StackLine_Inline> InlineList = new ArrayList();
    protected ArrayList<StackLine_Crossline> CrosslineList = new ArrayList();

    public StackingLines(int crosslineSkip, int inlineSkip) {
        try {
            this.m_inlineSkip = Math.max(1, inlineSkip);
            this.m_crosslineSkip = Math.max(1, crosslineSkip);
            this.reloadMaps();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadMaps() {
        try {
            Object line;
            int first;
            this.CrosslineList.clear();
            this.InlineList.clear();
            this.m_inlineMax = Integer.MIN_VALUE;
            this.m_inlineMin = Integer.MAX_VALUE;
            this.m_crosslineMax = Integer.MIN_VALUE;
            this.m_crosslineMin = Integer.MAX_VALUE;
            this.expand("Shot");
            this.expand("Receiver");
            int temp = this.m_crosslineMin / this.m_crosslineSkip;
            for (first = temp * this.m_crosslineSkip; first < this.m_crosslineMin; first += this.m_crosslineSkip) {
            }
            if (first > this.m_crosslineMax) {
                first = (this.m_crosslineMax + this.m_crosslineMin) / 2;
            }
            while (first < this.m_crosslineMax) {
                line = new StackLine_Crossline();
                ((StackLine_Crossline)line).Crossline = first;
                ((StackLine_Crossline)line).InlineMax = this.m_inlineMax;
                ((StackLine_Crossline)line).InlineMin = this.m_inlineMin;
                this.CrosslineList.add((StackLine_Crossline)line);
                first += this.m_crosslineSkip;
            }
            temp = this.m_inlineMin / this.m_inlineSkip;
            for (first = temp * this.m_inlineSkip; first < this.m_inlineMin; first += this.m_inlineSkip) {
            }
            if (first > this.m_inlineMax) {
                first = (this.m_inlineMax + this.m_inlineMin) / 2;
            }
            while (first < this.m_inlineMax) {
                line = new StackLine_Inline();
                ((StackLine_Inline)line).CrosslineMax = this.m_crosslineMax;
                ((StackLine_Inline)line).CrosslineMin = this.m_crosslineMin;
                ((StackLine_Inline)line).Inline = first;
                this.InlineList.add((StackLine_Inline)line);
                first += this.m_inlineSkip;
            }
            Grid3D_Conversion grid = RefractionStaticsProject.singleton().getGrid3D_Conversion();
            for (StackLine_Crossline stackLine_Crossline : this.CrosslineList) {
                stackLine_Crossline.X1 = grid.getWorldX(stackLine_Crossline.InlineMin, stackLine_Crossline.Crossline);
                stackLine_Crossline.Y1 = grid.getWorldY(stackLine_Crossline.InlineMin, stackLine_Crossline.Crossline);
                stackLine_Crossline.X2 = grid.getWorldX(stackLine_Crossline.InlineMax, stackLine_Crossline.Crossline);
                stackLine_Crossline.Y2 = grid.getWorldY(stackLine_Crossline.InlineMax, stackLine_Crossline.Crossline);
            }
            for (StackLine_Inline stackLine_Inline : this.InlineList) {
                stackLine_Inline.X1 = grid.getWorldX(stackLine_Inline.Inline, stackLine_Inline.CrosslineMin);
                stackLine_Inline.Y1 = grid.getWorldY(stackLine_Inline.Inline, stackLine_Inline.CrosslineMin);
                stackLine_Inline.X2 = grid.getWorldX(stackLine_Inline.Inline, stackLine_Inline.CrosslineMax);
                stackLine_Inline.Y2 = grid.getWorldY(stackLine_Inline.Inline, stackLine_Inline.CrosslineMax);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void expand(String tableName) {
        try {
            Grid3D_Conversion grid = RefractionStaticsProject.singleton().getGrid3D_Conversion();
            String query = "SELECT Easting, Northing FROM " + tableName;
            Table_Abstract table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                grid.setWorldLocation(x, y);
                this.m_inlineMax = Math.max(this.m_inlineMax, grid.Inline);
                this.m_inlineMin = Math.min(this.m_inlineMin, grid.Inline);
                this.m_crosslineMax = Math.max(this.m_crosslineMax, grid.Crossline);
                this.m_crosslineMin = Math.min(this.m_crosslineMin, grid.Crossline);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            int iy2;
            int ix2;
            int iy1;
            int ix1;
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(Color.red);
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            for (StackLine_Crossline stackLine_Crossline : this.CrosslineList) {
                ix1 = (int)(scaleX * stackLine_Crossline.X1 + shiftX);
                iy1 = (int)(scaleY * stackLine_Crossline.Y1 + shiftY);
                ix2 = (int)(scaleX * stackLine_Crossline.X2 + shiftX);
                iy2 = (int)(scaleY * stackLine_Crossline.Y2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
            for (StackLine_Inline stackLine_Inline : this.InlineList) {
                ix1 = (int)(scaleX * stackLine_Inline.X1 + shiftX);
                iy1 = (int)(scaleY * stackLine_Inline.Y1 + shiftY);
                ix2 = (int)(scaleX * stackLine_Inline.X2 + shiftX);
                iy2 = (int)(scaleY * stackLine_Inline.Y2 + shiftY);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static class StackLine_Crossline {
        public int InlineMin;
        public int InlineMax;
        public int Crossline;
        public double X1;
        public double Y1;
        public double X2;
        public double Y2;
        public ArrayList<Entry> EntryList = new ArrayList();
    }

    public static class StackLine_Inline {
        public int Inline;
        public int CrosslineMin;
        public int CrosslineMax;
        public double X1;
        public double Y1;
        public double X2;
        public double Y2;
        public ArrayList<Entry> EntryList = new ArrayList();
    }

    public static class Entry {
        public int Inline;
        public int Crossline;
    }
}

