/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shear;

import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Ensemble.EnsembleTrace;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class HodorGramWidget
extends JPanel {
    protected EnsembleTrace m_traceA = null;
    protected EnsembleTrace m_traceB = null;
    protected double m_t1 = -100.0;
    protected double m_t2 = -100.0;
    protected CubicTraceInterpolator m_ctiA = new CubicTraceInterpolator();
    protected CubicTraceInterpolator m_ctiB = new CubicTraceInterpolator();

    public void setTimes(double t1, double t2) {
        this.m_t1 = t1;
        this.m_t2 = t2;
        this.repaint();
    }

    public void setTraces(EnsembleTrace traceA, EnsembleTrace traceB) {
        try {
            this.m_traceA = traceA;
            this.m_traceB = traceB;
            this.m_ctiA.prepareInput(traceA);
            this.m_ctiB.prepareInput(traceB);
            this.repaint();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            double t;
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getSize().width;
            int h = this.getSize().height;
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, w, h);
            g2d.setColor(Color.lightGray);
            double digi = 1.0;
            double max = 1.0E-10;
            for (t = this.m_t1; t <= this.m_t2; t += digi) {
                float da = 1000.0f * this.m_ctiA.interpolate((float)t);
                float db = 1000.0f * this.m_ctiB.interpolate((float)t);
                max = Math.max(max, (double)Math.abs(da));
                max = Math.max(max, (double)Math.abs(db));
            }
            int buff = 5;
            int midX = w / 2;
            int midY = h / 2;
            int square = Math.min(w - 2 * buff, h - 2 * buff);
            int half = square / 2;
            double alpha = (double)half / max;
            g2d.setColor(Color.black);
            for (t = this.m_t1 + digi; t <= this.m_t2; t += digi) {
                float da1 = 1000.0f * this.m_ctiA.interpolate((float)(t - digi));
                float db1 = 1000.0f * this.m_ctiB.interpolate((float)(t - digi));
                float da2 = 1000.0f * this.m_ctiA.interpolate((float)t);
                float db2 = 1000.0f * this.m_ctiB.interpolate((float)t);
                int ix1 = midX + (int)(alpha * (double)da1);
                int iy1 = midY - (int)(alpha * (double)db1);
                int ix2 = midX + (int)(alpha * (double)da2);
                int iy2 = midY - (int)(alpha * (double)db2);
                g2d.drawLine(ix1, iy1, ix2, iy2);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

