/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class VerboseOptionDialog
extends JDialog
implements ActionListener {
    protected ArrayList<Wrapper> m_wrappers = new ArrayList();
    protected JCheckBox m_checkQuit = new JCheckBox("Quit showing suggestions");
    public String SelectedButtonText = "";

    public VerboseOptionDialog(String preliminaryText, Frame parent, String title, OptionList list) {
        super(parent, title, true);
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = LinearLayoutWidget.vert(5, null);
            if (preliminaryText != null) {
                JLabel lbl = main.createLabel(preliminaryText, 0, 0);
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            int counter = 0;
            Color evenColor = new Color(255, 255, 255);
            Color oddColor = new Color(255, 255, 255);
            for (Option option : list.List) {
                Wrapper wrapper = new Wrapper();
                wrapper.UserOption = option;
                wrapper.MainWidget = main.createVertical(3, option.BoxTitle, 0);
                if (option.Description != null) {
                    wrapper.Label = wrapper.MainWidget.createLabel(option.Description, 0, 0);
                }
                wrapper.Button = wrapper.MainWidget.createButton(option.ButtonText, this, 0);
                this.m_wrappers.add(wrapper);
                ++counter;
            }
            main.addComponent(this.m_checkQuit, 0);
            this.getContentPane().add((Component)main, "Center");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 50, this.getSize().height);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_checkQuit.isSelected()) {
                SharedApplicationData.singleton().getParameterTree().bool_put("ShowSuggestions", false);
                SharedApplicationData.singleton().saveParameterTree();
                RefractionProjectSuggestions.singleton();
                RefractionProjectSuggestions.On = false;
            }
            for (Wrapper wrapper : this.m_wrappers) {
                if (e.getSource() != wrapper.Button) continue;
                this.SelectedButtonText = wrapper.Button.getText();
            }
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static class OptionList {
        public ArrayList<Option> List = new ArrayList();

        public void add(String label, String description, String button) {
            try {
                Option opt = new Option();
                opt.BoxTitle = label;
                opt.ButtonText = button;
                opt.Description = description;
                this.List.add(opt);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public static class Option {
        public String BoxTitle = "";
        public String ButtonText = "";
        public String Description = "";
    }

    protected class Wrapper {
        public Option UserOption;
        public LinearLayoutWidget MainWidget;
        public JLabel Label;
        public JButton Button;

        protected Wrapper() {
        }
    }
}

