/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Ensemble.EnsembleHeaderSelectorWidget;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ParameterTreeWidgetManager {
    protected ArrayList<Connector_EnsembleHeaderSelectorWidget> m_listHeaderWidget = new ArrayList();
    protected ArrayList<Connector_RadioArray> m_listRadioArray = new ArrayList();
    protected ArrayList<Connector_TextField> m_listTextField = new ArrayList();
    protected ArrayList<Connector_CheckBox> m_listCheckBox = new ArrayList();
    protected ArrayList<Connector_ComboBox> m_listComboBox = new ArrayList();
    protected ParameterTree m_tree;

    public boolean hasKey_HeaderWidget(String key) throws Exception {
        try {
            for (Connector_EnsembleHeaderSelectorWidget conn : this.m_listHeaderWidget) {
                if (!conn.Key.equalsIgnoreCase(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addHeaderWidget(String key, EnsembleHeaderSelectorWidget widget, String defTable, String defColumn) {
        try {
            if (key == null) {
                throw new Exception("key == null");
            }
            if (key.isEmpty()) {
                throw new Exception("Cannot have empty key");
            }
            if (this.hasKey(key)) {
                throw new Exception("Key already exists: " + key);
            }
            this.m_listHeaderWidget.add(new Connector_EnsembleHeaderSelectorWidget(key, widget, defTable, defColumn));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readParameters_HeaderWidget() {
        try {
            for (Connector_EnsembleHeaderSelectorWidget conn : this.m_listHeaderWidget) {
                String col = this.m_tree.string_get(conn.KeyColumn, conn.DefaultColumn);
                String tbl = this.m_tree.string_get(conn.KeyTable, conn.DefaultTable);
                conn.HeaderWidget.setPreferredTableAndColumn(tbl, col);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveParameters_HeaderWidget() {
        try {
            for (Connector_EnsembleHeaderSelectorWidget conn : this.m_listHeaderWidget) {
                this.m_tree.string_put(conn.KeyColumn, conn.HeaderWidget.getColumn());
                this.m_tree.string_put(conn.KeyTable, conn.HeaderWidget.getTable());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasKey_RadioArray(String key) throws Exception {
        try {
            for (Connector_RadioArray conn : this.m_listRadioArray) {
                if (!conn.Key.equalsIgnoreCase(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addRadioArray(String key, int def) {
        try {
            if (key == null) {
                throw new Exception("key == null");
            }
            if (key.isEmpty()) {
                throw new Exception("Cannot have empty key");
            }
            if (this.hasKey(key)) {
                throw new Exception("Key already exists: " + key);
            }
            this.m_listRadioArray.add(new Connector_RadioArray(key, def));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addRadioButtonToArray(String key, JRadioButton btn) {
        try {
            for (Connector_RadioArray conn : this.m_listRadioArray) {
                if (!conn.Key.equalsIgnoreCase(key)) continue;
                conn.RadioArray.add(btn);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void readParameters_RadioArray() {
        try {
            for (Connector_RadioArray conn : this.m_listRadioArray) {
                if (conn.RadioArray.size() < 1) continue;
                for (JRadioButton btn : conn.RadioArray) {
                    btn.setSelected(false);
                }
                int index = this.m_tree.int_get(conn.Key, conn.DefaultIndex);
                index = Math.max(0, index);
                index = Math.min(conn.RadioArray.size() - 1, index);
                conn.RadioArray.get(index).setSelected(true);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveParameters_RadioArray() {
        try {
            for (Connector_RadioArray conn : this.m_listRadioArray) {
                this.m_tree.int_put(conn.Key, conn.DefaultIndex);
                for (int n = 0; n < conn.RadioArray.size(); ++n) {
                    if (!conn.RadioArray.get(n).isSelected()) continue;
                    this.m_tree.int_put(conn.Key, n);
                    return;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addTextFieldConnector(String key, JTextField tf, String def) throws Exception {
        try {
            if (def == null) {
                throw new Exception("def == null");
            }
            if (key == null) {
                throw new Exception("key == null");
            }
            if (tf == null) {
                throw new Exception("tf == null");
            }
            if (key.isEmpty()) {
                throw new Exception("Cannot have empty key");
            }
            if (this.hasKey(key)) {
                throw new Exception("Key already exists: " + key);
            }
            this.m_listTextField.add(new Connector_TextField(key, tf, def));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasKey_TextField(String key) throws Exception {
        try {
            for (Connector_TextField conn : this.m_listTextField) {
                if (!conn.Key.equalsIgnoreCase(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readParameters_TextField() {
        try {
            for (Connector_TextField conn : this.m_listTextField) {
                String s = this.m_tree.string_get(conn.Key, conn.Default);
                conn.Text.setText(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveParameters_TextField() {
        try {
            for (Connector_TextField conn : this.m_listTextField) {
                this.m_tree.string_put(conn.Key, conn.Text.getText());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addCheckBoxConnector(String key, JCheckBox tf, boolean def) throws Exception {
        try {
            if (key == null) {
                throw new Exception("key == null");
            }
            if (tf == null) {
                throw new Exception("tf == null");
            }
            if (key.isEmpty()) {
                throw new Exception("Cannot have empty key");
            }
            if (this.hasKey(key)) {
                throw new Exception("Key already exists: " + key);
            }
            this.m_listCheckBox.add(new Connector_CheckBox(key, tf, def));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasKey_CheckBox(String key) throws Exception {
        try {
            for (Connector_CheckBox conn : this.m_listCheckBox) {
                if (!conn.Key.equalsIgnoreCase(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readParameters_CheckBox() {
        try {
            for (Connector_CheckBox conn : this.m_listCheckBox) {
                boolean s = this.m_tree.bool_get(conn.Key, conn.Default);
                conn.Check.setSelected(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveParameters_CheckBox() {
        try {
            for (Connector_CheckBox conn : this.m_listCheckBox) {
                this.m_tree.bool_put(conn.Key, conn.Check.isSelected());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addComboBoxConnector(String key, JComboBox<String> tf, int def) throws Exception {
        try {
            if (key == null) {
                throw new Exception("key == null");
            }
            if (tf == null) {
                throw new Exception("tf == null");
            }
            if (key.isEmpty()) {
                throw new Exception("Cannot have empty key");
            }
            if (this.hasKey(key)) {
                throw new Exception("Key already exists: " + key);
            }
            this.m_listComboBox.add(new Connector_ComboBox(key, tf, def));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasKey_ComboBox(String key) throws Exception {
        try {
            for (Connector_ComboBox conn : this.m_listComboBox) {
                if (!conn.Key.equalsIgnoreCase(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readParameters_ComboBox() {
        try {
            for (Connector_ComboBox conn : this.m_listComboBox) {
                int s = this.m_tree.int_get(conn.Key, conn.Default);
                if (s < 0 || s >= conn.Combo.getItemCount()) continue;
                conn.Combo.setSelectedIndex(s);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void saveParameters_ComboBox() {
        try {
            for (Connector_ComboBox conn : this.m_listComboBox) {
                this.m_tree.int_put(conn.Key, conn.Combo.getSelectedIndex());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ParameterTree tree() {
        return this.m_tree;
    }

    public void setTree(ParameterTree tree) {
        try {
            this.m_tree = tree;
            this.readParameters();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void readParameters() {
        try {
            if (this.m_tree == null) {
                return;
            }
            this.readParameters_TextField();
            this.readParameters_RadioArray();
            this.readParameters_HeaderWidget();
            this.readParameters_CheckBox();
            this.readParameters_ComboBox();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void saveParameters() {
        try {
            if (this.m_tree == null) {
                return;
            }
            this.saveParameters_TextField();
            this.saveParameters_RadioArray();
            this.saveParameters_HeaderWidget();
            this.saveParameters_CheckBox();
            this.saveParameters_ComboBox();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean hasKey(String key) throws Exception {
        try {
            return this.hasKey_TextField(key) || this.hasKey_RadioArray(key) || this.hasKey_HeaderWidget(key) || this.hasKey_CheckBox(key) || this.hasKey_ComboBox(key);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected class Connector_EnsembleHeaderSelectorWidget {
        public EnsembleHeaderSelectorWidget HeaderWidget;
        public String Key;
        public String KeyTable;
        public String KeyColumn;
        public String DefaultTable;
        public String DefaultColumn;

        public Connector_EnsembleHeaderSelectorWidget(String key, EnsembleHeaderSelectorWidget widget, String defTable, String defColumn) {
            this.HeaderWidget = widget;
            this.Key = key;
            this.KeyTable = key + "_Table";
            this.KeyColumn = key + "_Column";
            this.DefaultTable = defTable;
            this.DefaultColumn = defColumn;
        }
    }

    protected class Connector_RadioArray {
        public ArrayList<JRadioButton> RadioArray = new ArrayList();
        public String Key;
        public int DefaultIndex;

        public Connector_RadioArray(String key, int def) {
            this.Key = key;
            this.DefaultIndex = def;
        }

        public void addRadioButton(JRadioButton rad) {
            if (rad != null) {
                this.RadioArray.add(rad);
            }
        }
    }

    protected class Connector_TextField {
        public JTextField Text;
        public String Key;
        public String Default;

        public Connector_TextField(String key, JTextField tf, String def) {
            this.Key = key;
            this.Default = def;
            if (this.Default.isEmpty()) {
                this.Default = "";
            }
            this.Text = tf;
        }
    }

    protected class Connector_CheckBox {
        public JCheckBox Check;
        public String Key;
        public boolean Default;

        public Connector_CheckBox(String key, JCheckBox tf, boolean def) {
            this.Key = key;
            this.Default = def;
            this.Check = tf;
        }
    }

    protected class Connector_ComboBox {
        public JComboBox<String> Combo;
        public String Key;
        public int Default;

        public Connector_ComboBox(String key, JComboBox<String> tf, int def) {
            this.Key = key;
            this.Default = def;
            this.Combo = tf;
        }
    }
}

