/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

public class JavaSystemPropertiesWidget
extends ScrollTable {
    public JavaSystemPropertiesWidget() {
        try {
            this.m_table.setModel(new PropsModel());
            this.setMininimumColumnWidth(0, 400);
            this.setMininimumColumnWidth(1, 800);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class PropsModel
    extends AbstractTableModel {
        protected ArrayList<String> m_keys = new ArrayList();
        protected ArrayList<String> m_vals = new ArrayList();

        public PropsModel() {
            try {
                String pathSeparator = ":";
                String classPath = "";
                Properties props = System.getProperties();
                for (Object key : props.keySet()) {
                    this.m_keys.add(key.toString());
                }
                Collections.sort(this.m_keys);
                for (String k : this.m_keys) {
                    String v = props.getProperty(k);
                    this.m_vals.add(v);
                    try {
                        if (k.equalsIgnoreCase("path.separator")) {
                            pathSeparator = v;
                        }
                        if (!k.equalsIgnoreCase("java.class.path")) continue;
                        classPath = v;
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
                try {
                    if (classPath.length() > 5) {
                        ArrayList<String> path = Tools_Strings.tokenizer(classPath, pathSeparator, false);
                        System.out.println("---------------java.class.path-----------------");
                        for (String p : path) {
                            System.out.println(p);
                        }
                        System.out.println(" ");
                    }
                }
                catch (Exception err2) {
                    err2.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public int getRowCount() {
            return this.m_keys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row < 0 || row >= this.m_keys.size()) {
                    return "";
                }
                if (column == 0) {
                    return this.m_keys.get(row);
                }
                if (column == 1) {
                    return this.m_vals.get(row);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
            return " ";
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (column == 0) {
                    return "Property name";
                }
                if (column == 1) {
                    return "Property value";
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
            return "Error";
        }
    }
}

