/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CompressSegyDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected FileWidget m_inputWidget;
    protected FileWidget m_outputWidget;
    protected JTextField m_text = new JTextField("300");
    protected JLabel m_label = new JLabel("");
    protected JButton m_btnOK;
    protected JButton m_btnCancel;
    protected JButton m_btnConvertDigi;
    protected JCheckBox m_checkWindowed = new JCheckBox("Windowed compression format");
    protected boolean m_dim3D;

    public CompressSegyDialog() {
        try {
            this.m_inputWidget = new FileWidget(true, 3, "Input directory", this);
            this.m_outputWidget = new FileWidget(true, 3, "Output directory", this);
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            main.addComponent(this.m_inputWidget, 0);
            main.addComponent(this.m_outputWidget, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Number of output samples", 0);
            grid.addSimple(0, new JLabel("Number of samples"), this.m_text);
            this.m_dim3D = RefractionStaticsProject.singleton().dim3D();
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this.m_btnOK = bottom.createButton("Convert files", this, 0);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            this.m_btnConvertDigi = bottom.createButton("Convert Digi", this, 0);
            bottom.addComponent(this.m_label, 10);
            bottom.addComponent(this.m_checkWindowed, 0);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(850, this.getSize().height);
            this.setTitle("segy file conversion utility");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected void convert(String fileName) {
        try {
            boolean okay;
            boolean bl = okay = fileName.endsWith("sgy") || fileName.endsWith("segy") || fileName.endsWith("SGY") || fileName.endsWith("SEGY");
            if (!okay) {
                return;
            }
            int maxSamplesPerTrace = Tools_Widget.extractInteger(this.m_text, 100, 10, 100000);
            String inputDir = this.m_inputWidget.getText();
            String outputDir = this.m_outputWidget.getText();
            String inputFileName = inputDir + "/" + fileName;
            String outputFileName = outputDir + "/" + fileName;
            Segy segy = new Segy();
            segy.setFileName(inputFileName);
            if (!segy.isFileOK()) {
                return;
            }
            if (this.m_checkWindowed.isSelected()) {
                Object baseName = "";
                if (outputFileName.endsWith(".xtref")) {
                    int endChar = outputFileName.length() - ".xtref".length();
                    baseName = outputFileName.substring(0, endChar);
                } else {
                    baseName = outputFileName;
                }
                outputFileName = outputFileName + "_wcf";
                segy.outputWindowedCompression(outputFileName, maxSamplesPerTrace);
            } else {
                segy.outputCompressedVersion(outputFileName, maxSamplesPerTrace);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean work() {
        try {
            String inputDir = this.m_inputWidget.getText();
            String outputDir = this.m_outputWidget.getText();
            this.m_label.setForeground(Color.RED);
            if (!Tools_FileSystem.exists_path(inputDir)) {
                this.m_label.setText("Input directory does not exist");
                return false;
            }
            if (!Tools_FileSystem.exists_path(outputDir)) {
                this.m_label.setText("Output directory does not exist");
                return false;
            }
            if (outputDir.equalsIgnoreCase(inputDir)) {
                this.m_label.setText("Same directories");
                return false;
            }
            this.m_label.setForeground(Color.BLUE);
            this.m_label.setText("");
            this.m_label.paintImmediately(0, 0, 1000, 30);
            ArrayList<String> files = Tools_FileSystem.files(inputDir, false, false);
            for (String fileName : files) {
                this.m_label.setText(fileName);
                this.m_label.paintImmediately(0, 0, 1000, 30);
                this.convert(fileName);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean convertDigi() {
        try {
            String inputDir = this.m_inputWidget.getText();
            this.m_label.setForeground(Color.RED);
            if (!Tools_FileSystem.exists_path(inputDir)) {
                this.m_label.setText("Input directory does not exist");
                return false;
            }
            this.m_label.setForeground(Color.BLUE);
            this.m_label.setText("");
            this.m_label.paintImmediately(0, 0, 1000, 30);
            ArrayList<String> files = Tools_FileSystem.files(inputDir, false, false);
            for (String string : files) {
                String string2 = inputDir + "/" + string;
                this.m_label.setText(string2);
                this.m_label.paintImmediately(0, 0, 1000, 30);
                Segy segy = new Segy();
                segy.setFileName(string2);
                if (!segy.isFileOK()) continue;
                segy.changeSampleInterval(4000);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnConvertDigi) {
                this.convertDigi();
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                if (!this.work()) {
                    return;
                }
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

