/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Uphole;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeImportData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Page_ImportUphole_Name
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener,
DocumentListener,
ItemListener {
    protected UpholeImportData m_data;
    protected boolean m_ok = false;
    protected LinearLayoutWidget m_mainPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
    protected LinearLayoutWidget m_buttonPanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
    protected LinearLayoutWidget m_namePanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Model name");
    protected JTextField m_nameText = new JTextField("");
    protected LinearLayoutWidget m_tablePanel = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Select imported table");
    protected ComboStringListWrapper m_tableCombo = new ComboStringListWrapper();
    protected JComboBox<String> m_sepCombo = new JComboBox();
    protected JLabel m_statusLabel = new JLabel(" ", 0);
    protected JLabel m_infoLabel = new JLabel("In order to create a uphole model, you must first import an ASCII table containing your uphole data.");
    protected GridLayoutWidget m_listWidget = new GridLayoutWidget(3, "List of columns");
    protected int m_indexColumn;

    public Page_ImportUphole_Name(UpholeImportData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.addComponent(this.m_mainPanel, 0);
            this.m_mainPanel.addComponent(this.m_infoLabel, 0);
            this.m_infoLabel.setForeground(Color.blue);
            this.m_mainPanel.addComponent(new JLabel(" ", 0), 10);
            this.m_mainPanel.addComponent(this.m_namePanel, 0);
            this.m_namePanel.addComponent(this.m_nameText, 0);
            this.m_nameText.getDocument().addDocumentListener(this);
            this.m_mainPanel.addComponent(this.m_tablePanel, 0);
            this.m_tablePanel.addComponent(this.m_tableCombo, 0);
            this.m_tableCombo.setStringArray(RefractionStaticsProject.singleton().importDatabase().getTableNames());
            this.m_tableCombo.addActionListener(this);
            this.m_mainPanel.addComponent(this.m_statusLabel, 0);
            this.m_statusLabel.setForeground(Color.red);
            this.m_mainPanel.addComponent(this.m_listWidget, 0);
            for (int n = 0; n < 10; ++n) {
                JLabel label = new JLabel(" ");
                this.m_listWidget.addComponent(label, n, 1);
            }
            this.scanColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void scanColumns() {
        try {
            String tableName = this.m_tableCombo.getSelectedString();
            if (tableName.length() > 0 && RefractionStaticsProject.singleton().importDatabase().tableExists(tableName)) {
                String sql = "SELECT * FROM " + tableName;
                Table_Abstract table = RefractionStaticsProject.singleton().importDatabase().extractTableDataUsingQuery(this.m_tableCombo.getSelectedString(), sql, 1);
                ArrayList<String> columnList = table.column_listOfNames();
                int tracker = 0;
                this.m_listWidget.removeAll();
                if (columnList.size() < 2) {
                    this.m_statusLabel.setText("Error. Only one column found.");
                    this.m_statusLabel.setForeground(Color.red);
                    this.m_ok = false;
                } else {
                    this.m_ok = true;
                }
                for (String column : columnList) {
                    JLabel lbl = new JLabel(column);
                    this.m_listWidget.addComponent(lbl, tracker, 1);
                    if (this.m_ok) {
                        lbl.setForeground(Color.blue);
                    } else {
                        lbl.setForeground(Color.red);
                    }
                    ++tracker;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void check() {
        try {
            this.m_ok = false;
            String name = this.m_nameText.getText();
            if (name.length() < 1) {
                this.m_statusLabel.setText("Enter a name for the model");
                this.m_statusLabel.setForeground(Color.red);
                return;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_statusLabel.setText("Name cannot contain spaces or special characters");
                this.m_statusLabel.setForeground(Color.red);
                return;
            }
            if (Tools_Strings.startsWithNumber(name)) {
                this.m_statusLabel.setText("Name cannot start with a number");
                this.m_statusLabel.setForeground(Color.red);
                return;
            }
            String table = this.m_tableCombo.getSelectedString();
            if (table.length() < 1) {
                this.m_statusLabel.setText("Please select an uphole survey to import");
                this.m_statusLabel.setForeground(Color.red);
                return;
            }
            this.m_statusLabel.setText("Parameters OK");
            this.m_statusLabel.setForeground(Color.blue);
            this.m_ok = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void leavingPage() {
        try {
            this.m_data.ImportFileName = this.m_tableCombo.getSelectedString();
            this.m_data.ImportSurveyName = this.m_nameText.getText();
            this.m_data.UseComma = this.m_sepCombo.getSelectedIndex() == 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.check();
            if (e.getSource() == this.m_tableCombo) {
                this.scanColumns();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        return this.m_ok;
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.check();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.check();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.check();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.check();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void activatePage() {
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.check();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

