/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Uphole;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_CustomModel;
import com.PecosLibrary.Refraction.Uphole.UpholeImportData;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.table.DefaultTableModel;

public class Page_ImportUphole_Columns
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    protected UpholeImportData m_data;
    protected ArrayList<String> m_depthColumns = new ArrayList();
    protected ArrayList<String> m_timeColumns = new ArrayList();
    protected ArrayList<String> m_velColumns = new ArrayList();
    protected ScrollTable m_mappingScrollTable = new ScrollTable();
    protected Table_Memory m_columnTable = new Table_Memory();
    protected Table_CustomModel m_columnModel;
    protected JCheckBox m_chkImportVel = new JCheckBox("Import velocity");
    protected int m_index;
    protected int m_indexTime;
    protected int m_indexDepth;
    protected int m_indexVel;

    public Page_ImportUphole_Columns(UpholeImportData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.addComponent(this.m_chkImportVel, 0);
            this.m_chkImportVel.setSelected(false);
            this.m_chkImportVel.addActionListener(this);
            this.m_mappingScrollTable.table().setGridColor(Color.black);
            this.m_mappingScrollTable.table().setShowGrid(true);
            this.addComponent(this.m_mappingScrollTable, 10);
            this.m_mappingScrollTable.table().setModel(new DefaultTableModel());
            this.m_columnTable.setName("Mapping");
            this.m_index = this.m_columnTable.column_append("Index", DataType.Int);
            this.m_indexTime = this.m_columnTable.column_append("Time", DataType.Text);
            this.m_indexDepth = this.m_columnTable.column_append("Depth", DataType.Text);
            this.m_indexVel = this.m_columnTable.column_append("Velocity", DataType.Text);
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add(" ");
            for (String column : this.m_data.MasterColumnList) {
                if (column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing") || column.equalsIgnoreCase("Elevation")) continue;
                columnList.add(column);
            }
            for (int n = 0; n < 10; ++n) {
                int row = this.m_columnTable.row_increment();
                this.m_columnTable.putInt(row, this.m_index, row);
            }
            this.m_columnModel = new Table_CustomModel(this.m_columnTable);
            this.m_mappingScrollTable.table().setModel(this.m_columnModel);
            Table_CustomModel.ComboCellEditor editor = this.m_columnModel.getComboCellEditor(columnList);
            Table_CustomModel.ComboCellRenderer renderer = this.m_columnModel.getComboCellRenderer();
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexTime).setCellEditor(editor);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexTime).setCellRenderer(renderer);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexDepth).setCellEditor(editor);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexDepth).setCellRenderer(renderer);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexVel).setCellEditor(editor);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexVel).setCellRenderer(renderer);
            this.m_columnModel.setColumnEditable(this.m_index, false);
            this.m_columnModel.setColumnEditable(this.m_indexTime, true);
            this.m_columnModel.setColumnEditable(this.m_indexDepth, true);
            this.m_columnModel.setColumnEditable(this.m_indexVel, this.m_chkImportVel.isSelected());
            this.m_mappingScrollTable.setMininimumColumnWidth(this.m_index, 200);
            this.m_mappingScrollTable.setMininimumColumnWidth(this.m_indexTime, 200);
            this.m_mappingScrollTable.setMininimumColumnWidth(this.m_indexDepth, 200);
            this.m_mappingScrollTable.setMininimumColumnWidth(this.m_indexVel, 200);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String predictTime(int index) {
        try {
            String time = "time";
            for (String column : this.m_data.MasterColumnList) {
                if (!column.toLowerCase().contains(time.toLowerCase())) continue;
                String number = column.replaceAll("[^\\d]", "");
                if (!Integer.toString(index).equalsIgnoreCase(number)) continue;
                return column;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected String predictDepth(int index) {
        try {
            String depth = "depth";
            for (String column : this.m_data.MasterColumnList) {
                if (!column.toLowerCase().contains(depth.toLowerCase())) continue;
                String number = column.replaceAll("[^\\d]", "");
                if (!Integer.toString(index).equalsIgnoreCase(number)) continue;
                return column;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected String predictVel(int index) {
        try {
            String vel = "vel";
            for (String column : this.m_data.MasterColumnList) {
                if (!column.toLowerCase().contains(vel.toLowerCase())) continue;
                String number = column.replaceAll("[^\\d]", "");
                if (!Integer.toString(index).equalsIgnoreCase(number)) continue;
                return column;
            }
            return null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void updateRestOfColumns() {
        try {
            Table_Abstract table = this.m_columnModel.getTable();
            for (int row = 0; row < table.row_count(); ++row) {
                for (int col = 0; col < table.column_count(); ++col) {
                    String selectedColumn;
                    if (col == this.m_index || (selectedColumn = table.getString(row, col)) == null || selectedColumn.equalsIgnoreCase(" ")) continue;
                    for (String column : this.m_data.MasterColumnList) {
                        if (!column.equalsIgnoreCase(selectedColumn)) continue;
                        Object newColumnName = "";
                        if (col == this.m_indexTime) {
                            newColumnName = "Time" + Integer.toString(row);
                        } else if (col == this.m_indexDepth) {
                            newColumnName = "Depth" + Integer.toString(row);
                        } else if (col == this.m_indexVel) {
                            newColumnName = "Velocity" + Integer.toBinaryString(row);
                        }
                        if (((String)newColumnName).length() <= 0) continue;
                        this.m_data.MasterColumnList.set(this.m_data.MasterColumnList.indexOf(column), (String)newColumnName);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns() {
        try {
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add(" ");
            for (String column : this.m_data.MasterColumnList) {
                if (column.equalsIgnoreCase("Easting") || column.equalsIgnoreCase("Northing") || column.equalsIgnoreCase("Elevation")) continue;
                columnList.add(column);
            }
            this.m_columnModel = new Table_CustomModel(this.m_columnTable);
            this.m_mappingScrollTable.table().setModel(this.m_columnModel);
            Table_CustomModel.ComboCellEditor editor = this.m_columnModel.getComboCellEditor(columnList);
            Table_CustomModel.ComboCellRenderer renderer = this.m_columnModel.getComboCellRenderer();
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexTime).setCellEditor(editor);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexTime).setCellRenderer(renderer);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexDepth).setCellEditor(editor);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexDepth).setCellRenderer(renderer);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexVel).setCellEditor(editor);
            this.m_mappingScrollTable.table().getColumnModel().getColumn(this.m_indexVel).setCellRenderer(renderer);
            this.m_columnModel.setColumnEditable(this.m_index, false);
            this.m_columnModel.setColumnEditable(this.m_indexTime, true);
            this.m_columnModel.setColumnEditable(this.m_indexDepth, true);
            this.m_columnModel.setColumnEditable(this.m_indexVel, this.m_chkImportVel.isSelected());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void leavingPage() {
        try {
            this.updateRestOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_chkImportVel) {
                this.m_columnModel.setColumnEditable(this.m_indexVel, this.m_chkImportVel.isSelected());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void activatePage() {
        this.reloadColumns();
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return true;
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

