/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Tomography.VNS;

import com.PecosCore.Data.Column_Double;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Action_Thread;
import com.PecosLibrary.Action.Tomography.VNS.Action_TomoVNS_ExportSegy;
import com.PecosLibrary.Action.Tomography.VNS.Action_TomoVNS_NewThreadModel_Disk;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Math.Interpolator_EmptyGrid;
import com.PecosLibrary.Math.InversePowerInterpolator;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.TomoProfileV2_VNS;
import com.PecosLibrary.Refraction.Tomography.VNS.TomoVNS_PolygonEdit;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple_Location;
import com.PecosLibrary.Tools.Tools_Math;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintableDatabaseProfile;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_LineSegment;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseoverInfo;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.DefineGridThreeCornerDialog;
import com.PecosLibrary.Windows.Refraction.Tomography.VNS.NewTomoVNSDialog;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TomoVNSWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
ISaveableFrame,
ChangeListener {
    protected SelectedProfileInfo m_selectedProfileInfo;
    protected MapWidget m_smallMapWidget = new MapWidget(true, false);
    protected MapWidget m_bigMapWidget = new MapWidget(false, true);
    protected Java2D_VerticalStackWidget m_profileDisplayWidget;
    protected JComboBox m_cmbProfileLowerPlot = new JComboBox();
    protected JCheckBox m_chkShowDelayTimeModelOnProfile = new JCheckBox("Show DelayTime model on profile");
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEH = new Java2D_UserEventConsumer_MultiLineSegments();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickMainUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected JButton m_btnClearPolygon;
    protected JButton m_btnCutInside;
    protected JButton m_btnCutOutside;
    protected JButton m_btnSaveModel;
    protected JButton m_btnClone;
    protected JButton m_btnCreateNew;
    protected JButton m_btnReload;
    protected ComboStringListWrapper m_modelCombo = new ComboStringListWrapper();
    protected boolean m_ignoreModelCombo = true;
    protected JLabel m_lblSizeX = new JLabel("", 4);
    protected JLabel m_lblSizeZ = new JLabel("", 4);
    protected JLabel m_lblNumInline = new JLabel("", 4);
    protected JLabel m_lblNumCrossline = new JLabel("", 4);
    protected JLabel m_lblNumZ = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected JLabel m_lblAngle = new JLabel("", 4);
    protected JLabel m_lblVtiConstant = new JLabel("", 4);
    protected JLabel m_lblProfileStartX = new JLabel("", 4);
    protected JLabel m_lblProfileStartY = new JLabel("", 4);
    protected JLabel m_lblProfileEndX = new JLabel("", 4);
    protected JLabel m_lblProfileEndY = new JLabel("", 4);
    protected JButton m_btnSetProfile = new JButton("Set profile manually");
    protected JTextField m_txtVtiDelta = new JTextField("0.0");
    protected JTextField m_txtVtiEps = new JTextField("0.1");
    protected JCheckBox m_chkVtiApply = new JCheckBox("Apply constant VTI");
    protected JCheckBox m_chkApplyBlend = new JCheckBox("Apply constraint function");
    protected JTextField m_txtMinVel = new JTextField("800");
    protected JTextField m_txtMaxVel = new JTextField("21000");
    protected JCheckBox m_chkLimitVel = new JCheckBox("Limit velocity range");
    protected JTextField m_txtMinOffset = new JTextField("100");
    protected JTextField m_txtMaxOffset = new JTextField("16000");
    protected JTextField m_txtNumIter = new JTextField("13");
    protected JTextField m_txtSmoothRadiusH = new JTextField("1");
    protected JTextField m_txtSmoothDecay = new JTextField("0.2");
    protected JTextField m_txtSmoothRadiusZ = new JTextField("0");
    protected JTextField m_txtNumThreads = new JTextField("16");
    protected JButton m_btnUpdateMPI;
    protected JButton m_btnUpdateThreadsNC;
    protected JButton m_btnUpdateThreadsNC_Thread;
    protected ComboStringListWrapper m_pickVersionCombo;
    protected JTextField m_txtPickShift = new JTextField("0");
    protected JCheckBox m_chkAllowInversions = new JCheckBox("Allow velocity inversions");
    protected JCheckBox m_chkUseNewInterpolation = new JCheckBox("Use improved model update code");
    protected JTextField m_txtAzimuthCenter = new JTextField("45");
    protected JTextField m_txtAzimuthRadius = new JTextField("45");
    protected JCheckBox m_chkApplyAzimuth = new JCheckBox("Apply azimuth restrictions");
    protected JTextField m_txtHybridVel = new JTextField("5000");
    protected JTextField m_txtHybridTimeShift = new JTextField("200");
    protected JCheckBox m_chkHybridCompute = new JCheckBox("Compute hybrid time errors");
    protected JCheckBox m_chkPrediction = new JCheckBox("Save predicted travels times");
    protected ComboStringListWrapper m_predictedPickVersionCombo = new ComboStringListWrapper();
    protected JTextField m_txtDecimation = new JTextField("1");
    protected JCheckBox m_chkDecimatePick = new JCheckBox("Decimate picks ");
    protected JTextField m_txtSubSample = new JTextField("2");
    protected JTextField m_txtForceDepth = new JTextField("100");
    protected JTextField m_txtForceVelocity = new JTextField("3000");
    protected JCheckBox m_chkForceShallow = new JCheckBox("Lock shallow velocity");
    protected JCheckBox m_chkApplyUphole = new JCheckBox("Lock shallow velocity using simple uphole survey");
    protected ComboStringListWrapper m_comboUpholeTable = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeX = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeY = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeZ = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeV = new ComboStringListWrapper();
    protected JButton m_btnComboReloadTables = new JButton("Reload list of tables");
    protected JCheckBox m_chkApplyUpholeModel = new JCheckBox("Lock shallow velocity using uphole survey");
    protected ComboStringListWrapper m_comboUpholeSurvey = new ComboStringListWrapper();
    protected JButton m_btnComboReloadUpholeSurveys = new JButton("Reload list of uphole surveys");
    protected JRadioButton m_radRaypathOffsetWeight = new JRadioButton("Use standard offset weighting approach");
    protected JRadioButton m_radRaypathDepthWeight = new JRadioButton("Use maximum raypath depth weighting approach");
    protected JRadioButton m_radRaypathDepthWeightSq = new JRadioButton("Use squared depth weighting scheme");
    protected ComboStringListWrapper m_comboResidualTable = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboResidualX = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboResidualY = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboResidualT = new ComboStringListWrapper();
    protected JTextField m_txtResidualNewModelFileName = new JTextField("");
    protected JButton m_btnComboReloadResidualTables = new JButton("Reload list of tables");
    protected JButton m_btnNewResidualModel = new JButton("Create new model");
    protected JTextField m_txtResidualModDepth = new JTextField("50");
    protected DefaultListModel<String> m_historyListModel = new DefaultListModel();
    protected JList<String> m_historyList = new JList();
    protected JButton m_btnReloadHistory;
    protected JTextField m_txtWeatheringVelocityDepth = new JTextField("100");
    protected JButton m_btnSetWeatheringVelocity;
    protected JCheckBox m_chkComputeRefractorElevation = new JCheckBox("Use the new weathering velocity to update the first refractor elevation");
    protected JTextField m_txtLocationX = new JTextField("");
    protected JTextField m_txtLocationY = new JTextField("");
    protected JTextField m_txtLocationZ = new JTextField("");
    protected JTable m_tblLocation = new JTable();
    protected JButton m_btnSmoothModel = new JButton("Create smoothed model");
    protected JTextField m_txtSmoothHorz = new JTextField("3");
    protected JTextField m_txtSmoothVert = new JTextField("0");
    protected JTextField m_txtSmoothNewModelName = new JTextField("");
    protected JButton m_btnResample = new JButton("Create resampled model");
    protected JTextField m_txtResampleMaxDepth = new JTextField("400");
    protected JTextField m_txtResampleHorzSpacing = new JTextField("50");
    protected JTextField m_txtResampleVertSpacing = new JTextField("30");
    protected JTextField m_txtResampleNewModelName = new JTextField("");
    protected JButton m_btnStaticsReloadColumns;
    protected JButton m_btnStatics;
    protected ButtonGroup m_intGroup = new ButtonGroup();
    protected JRadioButton m_radIntElev = new JRadioButton("Fixed elevation");
    protected JRadioButton m_radIntDepth = new JRadioButton("Fixed depth");
    protected JRadioButton m_radIntVel = new JRadioButton("Fixed velocity");
    protected JRadioButton m_radIntCol = new JRadioButton("Database column");
    protected ComboStringListWrapper m_comboIntCol = new ComboStringListWrapper();
    protected JLabel m_lblStaticsResult = new JLabel(" ");
    protected JTextField m_txtStaticsName = new JTextField("TomoVNS");
    protected JTextField m_txtIntDatumDepth = new JTextField("400");
    protected JTextField m_txtIntDatumVelocity = new JTextField("5000");
    protected JTextField m_txtIntDatumElev = new JTextField("-200");
    protected JCheckBox m_chkApplyResidual = new JCheckBox("Apply residual correction");
    protected JTextField m_txtResidCorrMult = new JTextField("1");
    protected ButtonGroup m_finalGroup = new ButtonGroup();
    protected JRadioButton m_radFinalElev = new JRadioButton("Fixed elevation");
    protected JRadioButton m_radFinalCol = new JRadioButton("Database column");
    protected ComboStringListWrapper m_comboFinalCol = new ComboStringListWrapper();
    protected JTextField m_txtFinalDatumElev = new JTextField("2000");
    protected JTextField m_txtRepVel = new JTextField("10000");
    protected ButtonGroup m_shiftGroup = new ButtonGroup();
    protected JRadioButton m_radShiftNone = new JRadioButton("Do not modify the statics");
    protected JRadioButton m_radShiftZero = new JRadioButton("Convert the statics to zero mean");
    protected JRadioButton m_radShiftTie = new JRadioButton("Tie the statics to another column");
    protected ComboStringListWrapper m_comboShiftCol = new ComboStringListWrapper();
    protected JCheckBox m_chkHighlightIntermediate = new JCheckBox("Highlight intermediate datum");
    protected Action_Thread m_thread;
    protected Timer m_timer = new Timer(500, this);
    protected boolean m_thread_alive_during_prior_time = false;
    protected JLabel m_label_thread_status = new JLabel();
    protected JButton m_btn_thread_halt = new JButton("Stop");
    protected Action_TomoVNS_NewThreadModel_Disk m_update_action;
    protected JTabbedPane m_mainRightTabs = new JTabbedPane();
    protected JComboBox m_comboMouseAction = new JComboBox();
    protected JButton m_btnExportMPI;
    protected JTextField m_txtMPIPath = new JTextField("/Users/matt/Data/MPI");
    protected JLabel m_lblMaxElev = new JLabel("");
    protected JLabel m_lblMinElev = new JLabel("");
    protected JButton m_btnRefreshInfo = new JButton("Reload model info");
    protected JTextField m_txtMod_MaxElev = new JTextField("");
    protected JTextField m_txtMod_MaxVel = new JTextField("");
    protected JTextField m_txtMod_MinElev = new JTextField("");
    protected JTextField m_txtMod_MinVel = new JTextField("");
    protected JButton m_btnSetVel = new JButton("Set velocity");
    protected JCheckBox m_chkInsidePolygon = new JCheckBox("Only inside polygon");
    protected JButton m_btnSmooth;
    protected JButton m_btnCreateSynth;
    protected JProgressBar m_progress = new JProgressBar();
    protected FileWidget m_importSegyFileWidget;
    protected FileWidget m_importDictionaryFileWidget;
    protected JTextField m_txtImportSegyDatumTop = new JTextField("0");
    protected JTextField m_txtImportSegySampleSize = new JTextField("20");
    protected JButton m_btnImportSegyModel = new JButton("Import SEG-Y file");
    protected JCheckBox m_chkModSmooth_NewModel = new JCheckBox("Create new model");
    protected JTextField m_txtModSmooth_NewName = new JTextField("");
    protected JTextField m_txtModSmooth_RadH = new JTextField("3");
    protected JTextField m_txtModSmooth_RadZ = new JTextField("1");
    protected JButton m_btnModSmooth_Velocity = new JButton("Smooth velocity");
    protected JButton m_btnBlendReset = new JButton("Reset constraint function to 0 (no constraint)");
    protected ArrayList<JTextField> m_list_txt_dt_constraint = new ArrayList();
    protected JButton m_btnBlendDT = new JButton("Create constraint using delay time model");
    protected JComboBox m_combo_blend_layer1 = new JComboBox();
    protected JComboBox m_combo_blend_layer2 = new JComboBox();
    protected JButton m_btnBlendLayers = new JButton("Set selected layers to constraint value");
    protected JTextField m_txt_constraint_layer_value = new JTextField("0.5");
    protected JTextField m_txtModSmoothBlend_RadH = new JTextField("3");
    protected JTextField m_txtModSmoothBlend_RadZ = new JTextField("1");
    protected JButton m_btnModSmooth_Blend = new JButton("Smooth constraint");
    protected JTextField m_txtImportDT_NewModelName = new JTextField("");
    protected JButton m_btnImportDelayTime = new JButton("Import delay time model");
    protected JComboBox m_combo_import_uphole = new JComboBox();
    protected JButton m_btnImportUphole = new JButton("Import uphole model");
    protected JTextField m_txtImportUphole_NewModelName = new JTextField("");
    protected JTextField m_txtSegySampleSize = new JTextField("20");
    protected JTextField m_txtSegyDatumBottom = new JTextField("0");
    protected JTextField m_txtSegyDatumTop = new JTextField("2000");
    protected JButton m_btnSegyExport;
    protected JButton m_btnSegyExportCount;
    protected JButton m_btnSegyExport_Grid;
    protected JButton m_btnSegyExportCount_Grid;
    protected JButton m_btnSegyExport_UserGrid;
    protected JButton m_btnSegyExportCount_UserGrid;
    protected FileWidget m_segyFileWidget;
    protected JButton m_importTriconFile;
    protected NewTomoVNSDialog m_newDlg;
    protected String m_staticsColName;
    TomoProfileV2_VNS m_profile;
    protected Java2D_Polygon m_polygon = null;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Tomography.VNS.TomoVNSWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "TomoVNS";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "TomoVNS";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    void vti_update_label() {
        try {
            this.m_lblVtiConstant.setText("");
            Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
            if (model == null) {
                return;
            }
            if (!model.vti_constant_apply()) {
                this.m_lblVtiConstant.setText("Not used");
                return;
            }
            String s = "Delta = " + Tools_Strings.doubleToString(model.vti_constant_delta(), 2.0) + " epsilon = " + Tools_Strings.doubleToString(model.vti_constant_epsilon(), 2.0);
            this.m_lblVtiConstant.setText(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TomoVNSWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            Messenger.singleton().addListener(this);
            this.reloadModelCombo();
            this.loadModel();
            this.reloadListOfTable();
            this.reloadListOfUpholeSurveys();
            this.m_thread = new Action_Thread();
            this.m_timer.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected ComboStringListWrapper createPickCombo() {
        try {
            ComboStringListWrapper combo = new ComboStringListWrapper("FBP_User");
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> pickCols = traceTable.columns("FBP_");
            combo.setStringArray(pickCols);
            combo.listener().addListener(this);
            return combo;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadSmallMapUIH() {
        try {
            this.m_smallMapWidget.CompositeWidget.mainWidget().clearEventConsumerList();
            this.m_smallMapWidget.CompositeWidget.mainWidget().addZoomer();
            if (this.m_mainRightTabs.getSelectedIndex() == 1) {
                this.m_smallMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_profileLineUEC);
            }
            if (this.m_mainRightTabs.getSelectedIndex() == 2) {
                this.m_smallMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_leftClickUEC);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.m_mainRightTabs) {
                this.reloadSmallMapUIH();
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected JComponent createRight() {
        try {
            this.m_mainRightTabs = new JTabbedPane();
            this.m_mainRightTabs.addTab("Map view", this.m_bigMapWidget);
            this.m_bigMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_polygonUEH);
            this.m_polygonUEH.addListener(this);
            this.m_polygonUEH.DefiningPolygon = true;
            this.m_leftClickMainUEC.addListener(this);
            this.m_comboMouseAction.addItem("Define polygon");
            this.m_comboMouseAction.addItem("Select location");
            this.m_bigMapWidget.Bottom.addComponent(this.m_comboMouseAction, 0);
            this.m_comboMouseAction.addItemListener(this);
            this.m_btnClearPolygon = this.m_bigMapWidget.Bottom.createButton("Clear polygon", this, 0);
            this.m_btnCutInside = this.m_bigMapWidget.Bottom.createButton("Interpolate inside", this, 0);
            this.m_btnCutOutside = this.m_bigMapWidget.Bottom.createButton("Extrapolate outside", this, 0);
            this.m_btnSaveModel = this.m_bigMapWidget.Bottom.createButton("Save model", this, 0);
            LinearLayoutWidget main1 = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget top = LinearLayoutWidget.horz(0, null);
            top.addComponent(new JLabel("Select lower plot:"), 0);
            this.m_cmbProfileLowerPlot.addItem("Show inversion node counts");
            this.m_cmbProfileLowerPlot.addItem("Show inversion constraint function");
            top.addComponent(this.m_cmbProfileLowerPlot, 1);
            this.m_cmbProfileLowerPlot.addActionListener(this);
            top.addComponent(this.m_chkShowDelayTimeModelOnProfile, 1);
            this.m_chkShowDelayTimeModelOnProfile.addActionListener(this);
            top.addStretch(10);
            this.m_profileDisplayWidget = new Java2D_VerticalStackWidget(2);
            main1.addComponent(top, 0);
            main1.addComponent(this.m_profileDisplayWidget, 10);
            this.m_mainRightTabs.addTab("Profile", main1);
            this.m_mainRightTabs.addChangeListener(this);
            return this.m_mainRightTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Model", this.createModelTab());
            topTabs.addTab("Update", this.createUpdateTab());
            topTabs.addTab("Statics", this.createStaticsTab());
            topTabs.addTab("Export", this.createExtraTab());
            topTabs.addTab("Import", this.createImportTab());
            topTabs.addTab("Constraint", this.createBlendTab());
            topTabs.addTab("Mod", this.createModTab());
            topTabs.addTab("History", this.createHistoryTab());
            topTabs.addTab("Detail", this.createDetailTab());
            return topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void smoothVel() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS model = p.getTomo_VNS();
            model.save(model.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setSynthVel() {
    }

    protected void refreshModelInfo() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS tomo_VNS = p.getTomo_VNS();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createSynth() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS tomo_VNS = p.getTomo_VNS();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createSynthTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(5, "Model info", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Maximum elevation"), this.m_lblMaxElev);
            grid.addSimple(row++, new JLabel("Minimum elevation"), this.m_lblMinElev);
            grid.addSimple(row++, new JLabel(" "), this.m_btnRefreshInfo);
            this.m_btnRefreshInfo.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Model mod", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Top elevation"), this.m_txtMod_MaxElev);
            grid.addSimple(row++, new JLabel("Top velocity"), this.m_txtMod_MaxVel);
            grid.addSimple(row++, new JLabel("Bottom elevation"), this.m_txtMod_MinElev);
            grid.addSimple(row++, new JLabel("Bottom velocity"), this.m_txtMod_MinVel);
            grid.addSimple(row++, new JLabel(" "), this.m_chkInsidePolygon);
            grid.addSimple(row++, new JLabel(" "), this.m_btnSetVel);
            this.m_btnSetVel.addActionListener(this);
            this.m_btnSmooth = main.createButton("Smooth current velocity field", this, 0);
            this.m_btnCreateSynth = main.createButton("Create synthetics", this, 0);
            main.addComponent(this.m_progress, 0);
            main.addStretch(5);
            main.addHorzPair(new JLabel("MPI export path"), 0, this.m_txtMPIPath, 9);
            this.m_btnExportMPI = main.createButton("Export data for MPI test", this, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void importSegy() {
        try {
            double datum = Tools_Widget.extractDouble(this.m_txtImportSegyDatumTop, 100.0, -100000.0, 100000.0);
            double spacing = Tools_Widget.extractDouble(this.m_txtImportSegySampleSize, 10.0, 0.1, 10000.0);
            String segyFile = this.m_importSegyFileWidget.getText();
            String dictFile = this.m_importDictionaryFileWidget.getText();
            Segy_Dictionary dict = new Segy_Dictionary();
            dict.setOpenFileName(dictFile);
            Segy segy = new Segy();
            segy.setSegyDictionary(dict);
            segy.setFileName(segyFile);
            RefractionStaticsProject.singleton().getTomo_VNS().importSegy(segy, datum, spacing);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void smooth_velocity() {
        try {
            int radh = Tools_Widget.extractInteger(this.m_txtModSmooth_RadH, 1, 0, 50);
            int radz = Tools_Widget.extractInteger(this.m_txtModSmooth_RadZ, 0, 0, 50);
            this.smooth(true, radh, radz);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void smooth_blend() {
        try {
            int radh = Tools_Widget.extractInteger(this.m_txtModSmoothBlend_RadH, 1, 0, 50);
            int radz = Tools_Widget.extractInteger(this.m_txtModSmoothBlend_RadZ, 0, 0, 50);
            this.smooth(false, radh, radz);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void layers_blend() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS vns = p.getTomo_VNS();
            if (p.getTomo_VNS() == null) {
                JOptionPane.showMessageDialog(null, "Must define tomo model first", " ", 1);
                return;
            }
            float[][][] array = vns.blend();
            int layer1 = this.m_combo_blend_layer1.getSelectedIndex();
            int layer2 = this.m_combo_blend_layer2.getSelectedIndex();
            double con = Tools_Widget.extractDouble(this.m_txt_constraint_layer_value, 0.0, 0.0, 1.0);
            for (int x = 0; x < vns.numX(); ++x) {
                for (int y = 0; y < vns.numY(); ++y) {
                    for (int z = layer1; z <= layer2; ++z) {
                        array[x][y][z] = (float)con;
                    }
                }
            }
            p.getTomo_VNS().save(vns.name());
            this.loadMapProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reset_blend() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS vns = p.getTomo_VNS();
            if (p.getTomo_VNS() == null) {
                JOptionPane.showMessageDialog(null, "Must define tomo model first", " ", 1);
                return;
            }
            float[][][] array = vns.blend();
            for (int x = 0; x < vns.numX(); ++x) {
                for (int y = 0; y < vns.numY(); ++y) {
                    for (int z = 0; z < vns.numZ(); ++z) {
                        array[x][y][z] = 0.0f;
                    }
                }
            }
            p.getTomo_VNS().save(vns.name());
            this.loadMapProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void smooth(boolean vel, int radh, int radz) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS vns = p.getTomo_VNS();
            if (p.getTomo_VNS() == null) {
                JOptionPane.showMessageDialog(null, "Must define tomo model first", " ", 1);
                return;
            }
            String name = vns.name();
            if (this.m_chkModSmooth_NewModel.isSelected()) {
                name = this.m_txtModSmooth_NewName.getText();
                if (name.length() < 2) {
                    JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                    return;
                }
                String path = RefractionStaticsProject.singleton().tomoVNSProjectsPath() + "/" + name;
                if (Tools_FileSystem.exists_path(path)) {
                    JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                    return;
                }
            }
            float[][][] array = vns.getSlowness();
            if (!vel) {
                array = vns.blend();
            }
            Tools_Math.smooth_3d(array, radh, radz);
            p.getTomo_VNS().save(name);
            if (this.m_chkModSmooth_NewModel.isSelected()) {
                this.reloadModelCombo();
                this.m_ignoreModelCombo = true;
                this.m_modelCombo.setPreferredSelected(name);
                this.m_ignoreModelCombo = false;
                this.handleNewModel();
            }
            this.loadMapProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createModTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Smoothing options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkModSmooth_NewModel);
            grid.addSimple(row++, new JLabel("New model name"), this.m_txtModSmooth_NewName);
            grid.addSimple(row++, new JLabel("Horizontal smoothing radius, nodes"), this.m_txtModSmooth_RadH);
            grid.addSimple(row++, new JLabel("Vertical smoothing radius, nodes"), this.m_txtModSmooth_RadZ);
            grid.addSimple(row++, new JLabel(" "), this.m_btnModSmooth_Velocity);
            this.m_btnModSmooth_Velocity.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Modify node spacing", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Import table name"), this.m_comboResidualTable);
            grid.addSimple(row++, new JLabel("Easting column"), this.m_comboResidualX);
            grid.addSimple(row++, new JLabel("Northing column"), this.m_comboResidualY);
            grid.addSimple(row++, new JLabel("Residual column"), this.m_comboResidualT);
            grid.addSimple(row++, new JLabel("New model name"), this.m_txtResidualNewModelFileName);
            grid.addSimple(row++, new JLabel("Modification depth"), this.m_txtResidualModDepth);
            grid.addSimple(row++, new JLabel(" "), this.m_btnComboReloadResidualTables);
            grid.addSimple(row++, new JLabel(" "), this.m_btnNewResidualModel);
            this.m_comboUpholeTable.listener().addListener(this);
            this.m_btnComboReloadResidualTables.addActionListener(this);
            this.m_btnNewResidualModel.addActionListener(this);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createDetailTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(6, null);
            main.createLabel("Type the location then press Enter", 0, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Easting"), this.m_txtLocationX);
            grid.addSimple(row++, new JLabel("Northing"), this.m_txtLocationY);
            grid.addSimple(row++, new JLabel("Elevation"), this.m_txtLocationZ);
            this.m_txtLocationX.addActionListener(this);
            this.m_txtLocationY.addActionListener(this);
            this.m_txtLocationZ.setEnabled(false);
            main.addComponent(new JScrollPane(this.m_tblLocation), 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void loadLocationDetails() {
        try {
            this.m_tblLocation.setModel(new Table_SimpleModel(new Table_Memory()));
            Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
            if (model == null) {
                return;
            }
            double x = Tools_Widget.extractDouble(this.m_txtLocationX, 0.0, -1.0E20, 1.0E20);
            double y = Tools_Widget.extractDouble(this.m_txtLocationY, 0.0, -1.0E20, 1.0E20);
            model.setLowerIndices(x, y);
            int ix = model.LowerIndexX;
            int iy = model.LowerIndexY;
            if (ix >= 0 && iy >= 0 && ix < model.numX() && iy < model.numY()) {
                double z = (int)model.surfaceElevation()[ix][iy];
                this.m_txtLocationZ.setText(Double.toString(z));
                float[] d = model.nodeDepth();
                float[] s = model.slowness()[ix][iy];
                Table_Memory table = new Table_Memory();
                int colD = table.column_append("Depth", DataType.Double);
                int colZ = table.column_append("Elevation", DataType.Double);
                int colV = table.column_append("Velocity", DataType.Double);
                for (int n = 0; n < model.numZ(); ++n) {
                    int r = table.row_increment();
                    table.putDouble(r, colD, d[n]);
                    table.putDouble(r, colZ, z - (double)d[n]);
                    table.putDouble(r, colV, 1000.0 / (double)s[n]);
                }
                this.m_tblLocation.setModel(new Table_SimpleModel(table));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createHistoryTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnReloadHistory = main.createButton("Reload history", this, 0);
            main.addComponent(new JScrollPane(this.m_historyList), 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadHistory() {
        try {
            this.m_historyListModel.clear();
            Tomo_VNS tomo = RefractionStaticsProject.singleton().getTomo_VNS();
            if (tomo != null) {
                History h = tomo.getHistory();
                h.fillDefaultListModel(this.m_historyListModel);
            }
            this.m_historyList.setModel(this.m_historyListModel);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createStaticsTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnStaticsReloadColumns = main.createButton("Reload list of database columns", this, 0);
            this.m_intGroup.add(this.m_radIntElev);
            this.m_intGroup.add(this.m_radIntDepth);
            this.m_intGroup.add(this.m_radIntVel);
            this.m_intGroup.add(this.m_radIntCol);
            this.m_radIntElev.setSelected(true);
            this.m_radIntElev.addActionListener(this);
            this.m_radIntDepth.addActionListener(this);
            this.m_radIntVel.addActionListener(this);
            this.m_radIntCol.addActionListener(this);
            this.m_txtIntDatumElev.addActionListener(this);
            this.m_txtIntDatumDepth.addActionListener(this);
            this.m_txtIntDatumVelocity.addActionListener(this);
            this.m_comboIntCol.addActionListener(this);
            this.m_chkHighlightIntermediate.addActionListener(this);
            this.m_chkHighlightIntermediate.setSelected(false);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Intermediate datum options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkHighlightIntermediate, new JLabel(" "));
            grid.addSimple(row++, this.m_radIntElev, this.m_txtIntDatumElev);
            grid.addSimple(row++, this.m_radIntDepth, this.m_txtIntDatumDepth);
            grid.addSimple(row++, this.m_radIntVel, this.m_txtIntDatumVelocity);
            grid.addSimple(row++, this.m_radIntCol, this.m_comboIntCol);
            this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
            this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
            this.m_txtIntDatumVelocity.setEnabled(this.m_radIntVel.isSelected());
            this.m_comboIntCol.setEnabled(this.m_radIntCol.isSelected());
            this.m_finalGroup.add(this.m_radFinalElev);
            this.m_finalGroup.add(this.m_radFinalCol);
            this.m_radFinalElev.setSelected(true);
            this.m_radFinalElev.addActionListener(this);
            this.m_radFinalCol.addActionListener(this);
            this.m_txtFinalDatumElev.setEnabled(this.m_radFinalElev.isSelected());
            this.m_comboFinalCol.setEnabled(this.m_radFinalCol.isSelected());
            grid = main.createGridLayoutWidget(0, "Final datum options", 0);
            row = 0;
            grid.addSimple(row++, this.m_radFinalElev, this.m_txtFinalDatumElev);
            grid.addSimple(row++, this.m_radFinalCol, this.m_comboFinalCol);
            grid.addSimple(row++, new JLabel("Replacement velocity"), this.m_txtRepVel);
            String s = "<HTML><font color=\"blue\">Residual terms are computed during batch update </font></HTML>";
            LinearLayoutWidget res = main.createVertical(0, "Residual correction options", 0);
            res.addComponent(new JLabel(s, 0), 0);
            res.addComponent(this.m_chkApplyResidual, 0);
            this.m_chkApplyResidual.setSelected(true);
            res.addHorzPair(new JLabel("Residual multiplier"), 0, this.m_txtResidCorrMult, 10);
            s = "<HTML><font color=\"blue\">Stack picks are made in the tomo stacks display</font></HTML>";
            this.m_shiftGroup.add(this.m_radShiftNone);
            this.m_shiftGroup.add(this.m_radShiftZero);
            this.m_shiftGroup.add(this.m_radShiftTie);
            this.m_radShiftNone.setSelected(true);
            this.m_radShiftNone.addActionListener(this);
            this.m_radShiftZero.addActionListener(this);
            this.m_radShiftTie.addActionListener(this);
            LinearLayoutWidget shift = main.createVertical(0, "Bulk shift options", 0);
            shift.addComponent(this.m_radShiftNone, 0);
            shift.addComponent(this.m_radShiftZero, 0);
            shift.addComponent(this.m_radShiftTie, 0);
            shift.addComponent(this.m_comboShiftCol, 0);
            this.m_comboShiftCol.setEnabled(this.m_radShiftTie.isSelected());
            main.addHorzPair(new JLabel("Statics name"), 0, this.m_txtStaticsName, 10);
            this.m_btnStatics = main.createButton("Compute statics", this, 0);
            main.addComponent(this.m_lblStaticsResult, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
            this.m_comboIntCol.setStringArray(cols);
            this.m_comboFinalCol.setStringArray(cols);
            this.m_comboShiftCol.setStringArray(cols);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createUpdateTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_pickVersionCombo = this.createPickCombo();
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Batch update options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_txtMinOffset);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_txtMaxOffset);
            grid.addSimple(row++, new JLabel("Number of iterations"), this.m_txtNumIter);
            grid.addSimple(row++, new JLabel("Horizontal smooth radius (nodes)"), this.m_txtSmoothRadiusH);
            grid.addSimple(row++, new JLabel("Weight at max radius ( <= 1 )"), this.m_txtSmoothDecay);
            grid.addSimple(row++, new JLabel("Vertical smooth radius (nodes)"), this.m_txtSmoothRadiusZ);
            grid.addSimple(row++, new JLabel("Pick version"), this.m_pickVersionCombo);
            grid.addSimple(row++, new JLabel("Pick shift (ms)"), this.m_txtPickShift);
            grid.addSimple(row++, new JLabel(" "), new JLabel(" "));
            grid.addSimple(row++, new JLabel("Accuracy (2 - 5)"), this.m_txtSubSample);
            grid.addSimple(row++, new JLabel("Number of threads"), this.m_txtNumThreads);
            grid.addSimple(row++, new JLabel(" "), this.m_chkAllowInversions);
            grid.addSimple(row++, new JLabel(" "), this.m_chkUseNewInterpolation);
            grid.addSimple(row++, new JLabel(" "), this.m_chkLimitVel);
            grid.addSimple(row++, new JLabel("Minimum allowed velocity"), this.m_txtMinVel);
            grid.addSimple(row++, new JLabel("Maximum allowed velocity"), this.m_txtMaxVel);
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyBlend);
            this.m_chkAllowInversions.setSelected(false);
            this.m_chkUseNewInterpolation.setSelected(true);
            this.m_chkLimitVel.setSelected(true);
            JTabbedPane tabs = new JTabbedPane();
            LinearLayoutWidget sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkVtiApply);
            grid.addSimple(row++, new JLabel("Thomsen parameter - delta"), this.m_txtVtiDelta);
            grid.addSimple(row++, new JLabel("Thomsen parameter - epsilon"), this.m_txtVtiEps);
            sub.addStretch(10);
            tabs.addTab("VTI", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyAzimuth);
            grid.addSimple(row++, new JLabel("Center azimuth"), this.m_txtAzimuthCenter);
            grid.addSimple(row++, new JLabel("Azimuth radius"), this.m_txtAzimuthRadius);
            sub.addStretch(10);
            tabs.addTab("Azimuth", sub);
            String s = "<html>The hybrid picks time will be stored in FBP_Back3.<br><html>FBP_Back3 = Error + (Time shift) + Offset / Velocity<br><html>You must run the multithreaded update routine</html>";
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addComponent(new JLabel(s), row++, 0, 1.0, 1.0, 1, 2);
            grid.addSimple(row++, new JLabel(" "), this.m_chkHybridCompute);
            grid.addSimple(row++, new JLabel("LMO velocity"), this.m_txtHybridVel);
            grid.addSimple(row++, new JLabel("Time shift"), this.m_txtHybridTimeShift);
            sub.addStretch(10);
            tabs.addTab("Hybrid", sub);
            s = "<html>The predicted travel times will be stored in the selected column<br> Residual error terms NOT included</html>";
            sub = LinearLayoutWidget.vert(0, null);
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> pickCols = traceTable.columns("FBP_");
            this.m_predictedPickVersionCombo.setStringArray(pickCols);
            boolean haspredcol = false;
            for (String col : pickCols) {
                haspredcol = haspredcol || col.equalsIgnoreCase("FBP_PickPredVNS");
            }
            if (haspredcol) {
                this.m_predictedPickVersionCombo.setPreferredSelected("FBP_PickPredVNS");
            } else {
                this.m_predictedPickVersionCombo.setPreferredSelected("FBP_Back2");
            }
            sub.addComponent(new JLabel(s), 0);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Predicted pick version"), this.m_predictedPickVersionCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_chkPrediction);
            this.m_chkPrediction.setSelected(haspredcol);
            sub.addStretch(10);
            tabs.addTab("Predicted", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkDecimatePick);
            grid.addSimple(row++, new JLabel("Decimation ( >= 1 ) "), this.m_txtDecimation);
            sub.addStretch(10);
            tabs.addTab("Decimation", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkForceShallow);
            grid.addSimple(row++, new JLabel("Depth"), this.m_txtForceDepth);
            grid.addSimple(row++, new JLabel("Velocity"), this.m_txtForceVelocity);
            sub.addStretch(10);
            tabs.addTab("Shallow velocity lock", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyUphole);
            grid.addSimple(row++, new JLabel("Database table"), this.m_comboUpholeTable);
            grid.addSimple(row++, new JLabel(" "), this.m_btnComboReloadTables);
            grid.addSimple(row++, new JLabel("Easting"), this.m_comboUpholeX);
            grid.addSimple(row++, new JLabel("Northing"), this.m_comboUpholeY);
            grid.addSimple(row++, new JLabel("Elevation"), this.m_comboUpholeZ);
            grid.addSimple(row++, new JLabel("Velocity"), this.m_comboUpholeV);
            this.m_btnComboReloadTables.addActionListener(this);
            this.m_comboUpholeTable.listener().addListener(this);
            sub.addStretch(10);
            tabs.addTab("Simple Uphole survey", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyUpholeModel);
            grid.addSimple(row++, new JLabel("Uphole Survey"), this.m_comboUpholeSurvey);
            grid.addSimple(row++, new JLabel(" "), this.m_btnComboReloadUpholeSurveys);
            this.m_btnComboReloadUpholeSurveys.addActionListener(this);
            this.m_comboUpholeSurvey.listener().addListener(this);
            sub.addStretch(10);
            tabs.addTab("Uphole survey", sub);
            sub = LinearLayoutWidget.vert(0, null);
            sub.addComponent(this.m_radRaypathOffsetWeight, 0);
            sub.addComponent(this.m_radRaypathDepthWeight, 0);
            sub.addComponent(this.m_radRaypathDepthWeightSq, 0);
            ButtonGroup btg = new ButtonGroup();
            btg.add(this.m_radRaypathOffsetWeight);
            btg.add(this.m_radRaypathDepthWeight);
            btg.add(this.m_radRaypathDepthWeightSq);
            this.m_radRaypathOffsetWeight.setSelected(true);
            sub.addStretch(10);
            tabs.addTab("Raypath depth weighting", sub);
            main.addComponent(tabs, 0);
            this.m_btnUpdateThreadsNC = main.createButton("Start batch update - standard, locks screen", this, 0);
            this.m_btnUpdateMPI = main.createButton("Start batch update - run on cluster using MPI", this, 0);
            LinearLayoutWidget sub4 = main.createHorizontal(0, null, 0);
            this.m_btnUpdateThreadsNC_Thread = sub4.createButton("Start batch update - run in independent thread", this, 10);
            this.m_btn_thread_halt = sub4.createButton("Halt", this, 0);
            main.createGapLabel(12);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void importUphole() {
        try {
            String name = this.m_txtImportUphole_NewModelName.getText();
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return;
            }
            String path = RefractionStaticsProject.singleton().tomoVNSProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS vns = p.getTomo_VNS();
            if (p.getTomo_VNS() == null) {
                JOptionPane.showMessageDialog(null, "Must define tomo model first", " ", 1);
                return;
            }
            UpholeSimple uphole = p.uphole_simple_get();
            if (uphole.List.size() < 1) {
                JOptionPane.showMessageDialog(null, "Must import an uphole survey first", " ", 1);
                return;
            }
            int max_depth = this.m_combo_import_uphole.getSelectedIndex();
            int nx = vns.numX();
            int ny = vns.numY();
            Interpolator_EmptyGrid interp = new Interpolator_EmptyGrid(nx, ny, vns.binSizeHorz());
            float[][][] slowness = vns.getSlowness();
            float[] nodeDepth = vns.nodeDepth();
            for (int n = 0; n <= max_depth; ++n) {
                interp.clear();
                for (UpholeSimple_Location loc : uphole.List) {
                    vns.setLowerIndices(loc.Easting, loc.Northing);
                    double v = loc.velocity_at_depth_using_array(nodeDepth[n]);
                    interp.add(vns.LowerIndexX, vns.LowerIndexY, v, 1.0);
                }
                interp.finish(20);
                for (int x = 0; x < nx; ++x) {
                    for (int y = 0; y < ny; ++y) {
                        slowness[x][y][n] = 1000.0f / (float)interp.value[x][y];
                    }
                }
            }
            p.getTomo_VNS().save(name);
            this.reloadModelCombo();
            this.m_ignoreModelCombo = true;
            this.m_modelCombo.setPreferredSelected(name);
            this.m_ignoreModelCombo = false;
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void blendDelayTime() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS vns = p.getTomo_VNS();
            if (p.getTomo_VNS() == null) {
                JOptionPane.showMessageDialog(null, "Must define tomo model first", " ", 1);
                return;
            }
            if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                JOptionPane.showMessageDialog(null, "Must define the weathering velocity field first", " ", 1);
                return;
            }
            ArrayList<Interpolator_EmptyGrid> listz = new ArrayList<Interpolator_EmptyGrid>();
            double[] array_v = new double[30];
            double[] array_z = new double[30];
            double bin_size = vns.binSizeHorz();
            listz.add(Tools_RefractionStaticsProject.getInterpolator_EmptyGrid("Elevation", bin_size));
            int max_branch = 1;
            boolean has_z = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameElev(max_branch), true, true);
            while (has_z) {
                listz.add(Tools_RefractionStaticsProject.getInterpolator_EmptyGrid(Pecos.getColNameElev(max_branch), bin_size));
                has_z = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameElev(++max_branch), true, true);
            }
            if (--max_branch < 1) {
                return;
            }
            int nc = this.m_list_txt_dt_constraint.size();
            float[] con = new float[nc];
            for (int n = 0; n < nc; ++n) {
                con[n] = (float)Tools_Widget.extractDouble(this.m_list_txt_dt_constraint.get(n), 0.0, 0.0, 1.0);
            }
            float[][] elev = vns.surfaceElevation();
            float[] depth = vns.nodeDepth();
            float[][][] blend = vns.blend();
            for (int x = 0; x < vns.numX(); ++x) {
                for (int y = 0; y < vns.numY(); ++y) {
                    vns.setGridLocation(x, y);
                    for (int b = 0; b <= max_branch; ++b) {
                        array_z[b] = ((Interpolator_EmptyGrid)listz.get(b)).get_world(vns.WorldX, vns.WorldY);
                    }
                    for (int n = 0; n < depth.length; ++n) {
                        double z = elev[x][y] - depth[n];
                        boolean ok = false;
                        for (int b = 1; b <= max_branch && !ok; ++b) {
                            if (!(z >= array_z[b])) continue;
                            blend[x][y][n] = con[b - 1];
                            ok = true;
                        }
                        if (ok) continue;
                        blend[x][y][n] = con[max_branch];
                    }
                }
            }
            p.getTomo_VNS().save(vns.name());
            this.loadMapProfile();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importDelayTime() {
        try {
            String name = this.m_txtImportDT_NewModelName.getText();
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return;
            }
            String path = RefractionStaticsProject.singleton().tomoVNSProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS vns = p.getTomo_VNS();
            if (p.getTomo_VNS() == null) {
                JOptionPane.showMessageDialog(null, "Must define tomo model first", " ", 1);
                return;
            }
            if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                JOptionPane.showMessageDialog(null, "Must define the weathering velocity field first", " ", 1);
                return;
            }
            ArrayList<Interpolator_EmptyGrid> listz = new ArrayList<Interpolator_EmptyGrid>();
            ArrayList<Interpolator_EmptyGrid> listv = new ArrayList<Interpolator_EmptyGrid>();
            double[] array_v = new double[30];
            double[] array_z = new double[30];
            double bin_size = vns.binSizeHorz();
            listz.add(Tools_RefractionStaticsProject.getInterpolator_EmptyGrid("Elevation", bin_size));
            listv.add(Tools_RefractionStaticsProject.getInterpolator_EmptyGrid(Pecos.getColNameVel(0), bin_size));
            int max_branch = 1;
            boolean has_vel = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(max_branch), true, true);
            boolean has_z = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameElev(max_branch), true, true);
            while (has_vel && has_z) {
                listz.add(Tools_RefractionStaticsProject.getInterpolator_EmptyGrid(Pecos.getColNameElev(max_branch), bin_size));
                listv.add(Tools_RefractionStaticsProject.getInterpolator_EmptyGrid(Pecos.getColNameVel(max_branch), bin_size));
                has_vel = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(++max_branch), true, true);
                has_z = Tools_RefractionStaticsProject.columnExists(Pecos.getColNameElev(max_branch), true, true);
            }
            if (--max_branch < 1) {
                return;
            }
            float[][] elev = vns.surfaceElevation();
            float[] depth = vns.nodeDepth();
            float[][][] slow = vns.getSlowness();
            for (int x = 0; x < vns.numX(); ++x) {
                for (int y = 0; y < vns.numY(); ++y) {
                    vns.setGridLocation(x, y);
                    for (int b = 0; b <= max_branch; ++b) {
                        array_v[b] = ((Interpolator_EmptyGrid)listv.get(b)).get_world(vns.WorldX, vns.WorldY);
                        array_z[b] = ((Interpolator_EmptyGrid)listz.get(b)).get_world(vns.WorldX, vns.WorldY);
                    }
                    for (int n = 0; n < depth.length; ++n) {
                        double z = elev[x][y] - depth[n];
                        boolean ok = false;
                        for (int b = 1; b <= max_branch && !ok; ++b) {
                            if (!(z >= array_z[b])) continue;
                            slow[x][y][n] = 1000.0f / (float)array_v[b - 1];
                            ok = true;
                        }
                        if (ok) continue;
                        slow[x][y][n] = 1000.0f / (float)array_v[max_branch];
                    }
                }
            }
            p.getTomo_VNS().save(name);
            this.reloadModelCombo();
            this.m_ignoreModelCombo = true;
            this.m_modelCombo.setPreferredSelected(name);
            this.m_ignoreModelCombo = false;
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createBlendTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            main.addComponent(this.m_btnBlendReset, 0);
            this.m_btnBlendReset.addActionListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Define constraint using layers", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("First layer"), this.m_combo_blend_layer1);
            grid.addSimple(row++, new JLabel("Second layer"), this.m_combo_blend_layer2);
            grid.addSimple(row++, new JLabel("Constraint value (between 0 and 1)"), this.m_txt_constraint_layer_value);
            grid.addComponent(this.m_btnBlendLayers, row++, 1);
            this.m_btnBlendLayers.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Define constraint using delay time model", 0);
            row = 0;
            JTextField txt = new JTextField("0");
            grid.addSimple(row++, new JLabel("Weathering layer constraint"), txt);
            this.m_list_txt_dt_constraint.add(txt);
            for (int b = 1; b <= 5; ++b) {
                txt = new JTextField("0.2");
                String s = "Refractor " + Integer.toString(b) + " constraint";
                grid.addSimple(row++, new JLabel(s), txt);
                this.m_list_txt_dt_constraint.add(txt);
            }
            grid.addSimple(row++, new JLabel(""), this.m_btnBlendDT);
            this.m_btnBlendDT.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Smoothing options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Horizontal smoothing radius, nodes"), this.m_txtModSmoothBlend_RadH);
            grid.addSimple(row++, new JLabel("Vertical smoothing radius, nodes"), this.m_txtModSmoothBlend_RadZ);
            grid.addSimple(row++, new JLabel(" "), this.m_btnModSmooth_Blend);
            this.m_btnModSmooth_Blend.addActionListener(this);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createImportTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Delay time model import options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("New model name"), this.m_txtImportDT_NewModelName);
            grid.addComponent(this.m_btnImportDelayTime, row++, 1);
            this.m_btnImportDelayTime.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Uphole survey import options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("New model name"), this.m_txtImportUphole_NewModelName);
            grid.addSimple(row++, new JLabel("Maximum depth to modify"), this.m_combo_import_uphole);
            grid.addComponent(this.m_btnImportUphole, row++, 1);
            this.m_btnImportUphole.addActionListener(this);
            main.addStretch(2);
            grid = main.createGridLayoutWidget(0, "SEG-Y model import options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Top datum (ft/m)"), this.m_txtImportSegyDatumTop);
            grid.addSimple(row++, new JLabel("Sample size (ft/m)"), this.m_txtImportSegySampleSize);
            this.m_importSegyFileWidget = new FileWidget(false, 0, "Select input SEG-Y file", null);
            main.addComponent(this.m_importSegyFileWidget, 0);
            this.m_importDictionaryFileWidget = new FileWidget(false, 0, "Select input SEG-Y dictionary", null);
            main.addComponent(this.m_importDictionaryFileWidget, 0);
            main.addComponent(this.m_btnImportSegyModel, 0);
            this.m_btnImportSegyModel.addActionListener(this);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createExtraTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            if (SharedApplicationData.singleton().isTricon()) {
                LinearLayoutWidget subt = main.createVertical(0, "Tricon-specific code for CU project", 0);
                this.m_importTriconFile = subt.createButton("Import text file", this, 0);
            }
            LinearLayoutWidget sub = main.createVertical(0, "Weathering velocity for delay time model", 0);
            JLabel lbl = new JLabel("You must assign branches first!", 0);
            lbl.setForeground(Color.red);
            sub.addComponent(lbl, 0);
            sub.addHorzPair(new JLabel("Depth at which to compute weathering velocity"), 0, this.m_txtWeatheringVelocityDepth, 10);
            sub.addComponent(this.m_chkComputeRefractorElevation, 0);
            this.m_chkComputeRefractorElevation.setSelected(true);
            this.m_btnSetWeatheringVelocity = sub.createButton("Set weathering velocity", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "SEG-Y model export options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Top datum (ft/m)"), this.m_txtSegyDatumTop);
            grid.addSimple(row++, new JLabel("Bottom datum (ft/m)"), this.m_txtSegyDatumBottom);
            grid.addSimple(row++, new JLabel("Sample size (ft/m)"), this.m_txtSegySampleSize);
            this.m_segyFileWidget = new FileWidget(false, 0, "Select output SEG-Y file", null);
            main.addComponent(this.m_segyFileWidget, 0);
            LinearLayoutWidget sub1 = main.createVertical(0, "These export options use the tomography grid", 0);
            this.m_btnSegyExport = sub1.createButton("Export velocity field to SEG-Y", this, 0);
            this.m_btnSegyExportCount = sub1.createButton("Export node counts to SEG-Y", this, 0);
            sub1 = main.createVertical(0, "These export options use the project grid", 0);
            this.m_btnSegyExport_Grid = sub1.createButton("Export velocity field to SEG-Y", this, 0);
            this.m_btnSegyExportCount_Grid = sub1.createButton("Export node counts to SEG-Y", this, 0);
            sub1 = main.createVertical(0, "These export options use a user-defined grid", 0);
            this.m_btnSegyExport_UserGrid = sub1.createButton("Export velocity field to SEG-Y", this, 0);
            this.m_btnSegyExportCount_UserGrid = sub1.createButton("Export node counts to SEG-Y", this, 0);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = main.createHorizontal(0, "Select model", 0);
            sub.addComponent(this.m_modelCombo, 10);
            this.m_modelCombo.listener().addListener(this);
            this.m_btnReload = sub.createButton("Reload", this, 0);
            this.m_btnCreateNew = sub.createButton("New", this, 0);
            this.m_btnClone = sub.createButton("Clone", this, 0);
            GridLayoutWidget gridvti = main.createGridLayoutWidget(0, "VTI options", 0);
            int row = 0;
            gridvti.addSimple(row++, new JLabel("Constant VTI"), this.m_lblVtiConstant);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Model description", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Grid angle"), this.m_lblAngle);
            grid.addSimple(row++, new JLabel("Horizontal node spacing"), this.m_lblSizeX);
            grid.addSimple(row++, new JLabel("Inline node count"), this.m_lblNumInline);
            grid.addSimple(row++, new JLabel("Crossline node count"), this.m_lblNumCrossline);
            grid.addSimple(row++, new JLabel("Vertical node count"), this.m_lblNumZ);
            grid.addSimple(row++, new JLabel("Total model memory (MB)"), this.m_lblMemory);
            JLabel lbl = new JLabel("Left-click and drag to display profiles", 0);
            lbl.setForeground(Color.blue);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            GridLayoutWidget profileGrid = main.createGridLayoutWidget(0, "Profile info", 0);
            int profileRow = 0;
            profileGrid.addSimple(profileRow++, new JLabel("Start: "), this.m_lblProfileStartX, this.m_lblProfileStartY);
            profileGrid.addSimple(profileRow++, new JLabel("End: "), this.m_lblProfileEndX, this.m_lblProfileEndY);
            this.m_btnSetProfile.addActionListener(this);
            profileGrid.addComponent(this.m_btnSetProfile, profileRow++, 0);
            main.addComponent(this.m_smallMapWidget, 11);
            this.m_profileLineUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.reloadSmallMapUIH();
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadListOfTable() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            this.m_comboUpholeTable.setStringArray(tables);
            this.m_comboResidualTable.setStringArray(tables);
            this.reloadListOfColumns();
            this.reloadListOfResidualColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfUpholeSurveys() {
        try {
            ArrayList<String> upholeSurveyList = RefractionStaticsProject.singleton().getListOfUpholeSurveys();
            this.m_comboUpholeSurvey.setStringArray(upholeSurveyList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfResidualColumns() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            if (tables.size() < 1) {
                this.m_comboUpholeX.setStringArray(new ArrayList<String>());
                this.m_comboUpholeY.setStringArray(new ArrayList<String>());
                this.m_comboUpholeZ.setStringArray(new ArrayList<String>());
                this.m_comboUpholeV.setStringArray(new ArrayList<String>());
                return;
            }
            String tableName = this.m_comboResidualTable.getSelectedString();
            ArrayList<String> cols = database.listOfColumnNames(tableName);
            this.m_comboResidualX.setStringArray(cols);
            this.m_comboResidualY.setStringArray(cols);
            this.m_comboResidualT.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfColumns() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            if (tables.size() < 1) {
                this.m_comboUpholeX.setStringArray(new ArrayList<String>());
                this.m_comboUpholeY.setStringArray(new ArrayList<String>());
                this.m_comboUpholeZ.setStringArray(new ArrayList<String>());
                this.m_comboUpholeV.setStringArray(new ArrayList<String>());
                return;
            }
            String tableName = this.m_comboUpholeTable.getSelectedString();
            ArrayList<String> cols = database.listOfColumnNames(tableName);
            this.m_comboUpholeX.setStringArray(cols);
            this.m_comboUpholeY.setStringArray(cols);
            this.m_comboUpholeZ.setStringArray(cols);
            this.m_comboUpholeV.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadModelCombo() {
        try {
            this.m_ignoreModelCombo = true;
            String tomoPath = RefractionStaticsProject.singleton().tomoVNSProjectsPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(tomoPath, false);
            ArrayList<String> models = new ArrayList<String>();
            for (String s : subdirs) {
                if (s.equalsIgnoreCase("ShotRecStacks")) continue;
                models.add(s);
            }
            this.m_modelCombo.setStringArray(models);
            this.m_ignoreModelCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewModel() {
        try {
            this.m_profile = null;
            this.m_combo_import_uphole.removeAllItems();
            this.m_combo_blend_layer1.removeAllItems();
            this.m_combo_blend_layer2.removeAllItems();
            Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
            this.m_smallMapWidget.handleNewModel();
            this.m_bigMapWidget.handleNewModel();
            this.reloadHistory();
            this.vti_update_label();
            if (model == null) {
                this.m_lblAngle.setText("");
                this.m_lblSizeX.setText("");
                this.m_lblSizeZ.setText("");
                this.m_lblNumInline.setText("");
                this.m_lblNumCrossline.setText("");
                this.m_lblNumZ.setText("");
                this.m_lblMemory.setText("");
                return;
            }
            if (this.m_selectedProfileInfo == null) {
                this.m_lblProfileStartX.setText("");
                this.m_lblProfileStartY.setText("");
                this.m_lblProfileEndX.setText("");
                this.m_lblProfileEndY.setText("");
            }
            float[] nodeDepth = model.nodeDepth();
            for (int n = 0; n < nodeDepth.length; ++n) {
                String s = Tools_Strings.getString(nodeDepth[n], 1);
                this.m_combo_import_uphole.addItem(s);
                this.m_combo_blend_layer1.addItem(s);
                this.m_combo_blend_layer2.addItem(s);
            }
            double angleDegrees = model.inlineAngle() * 180.0 / Math.PI;
            this.m_lblAngle.setText(Double.toString(angleDegrees));
            this.m_lblSizeX.setText(Double.toString(model.binSizeHorz()));
            this.m_lblNumInline.setText(Integer.toString(model.numX()));
            this.m_lblNumCrossline.setText(Integer.toString(model.numY()));
            this.m_lblNumZ.setText(Integer.toString(model.numZ()));
            double numNodes = (double)model.numX() * (double)model.numY() * (double)model.numZ();
            double mem = 8.0 * numNodes;
            int mb = 1 + (int)(mem *= 1.0E-6);
            this.m_lblMemory.setText(Integer.toString(mb));
            this.m_smallMapWidget.reloadPlot();
            this.m_bigMapWidget.reloadPlot();
            if (this.m_selectedProfileInfo != null) {
                if (this.m_selectedProfileInfo.StartWorldX != 0.0 && this.m_selectedProfileInfo.StartWorldY != 0.0 && this.m_selectedProfileInfo.EndWorldX != 0.0 && this.m_selectedProfileInfo.EndWorldY != 0.0) {
                    this.m_profileLineUEC.StartPixelX = this.m_selectedProfileInfo.StartPixelX;
                    this.m_profileLineUEC.StartPixelY = this.m_selectedProfileInfo.StartPixelY;
                    this.m_profileLineUEC.EndPixelX = this.m_selectedProfileInfo.EndPixelX;
                    this.m_profileLineUEC.EndPixelY = this.m_selectedProfileInfo.EndPixelY;
                    this.m_profileLineUEC.StartWorldX = this.m_selectedProfileInfo.StartWorldX;
                    this.m_profileLineUEC.StartWorldY = this.m_selectedProfileInfo.StartWorldY;
                    this.m_profileLineUEC.EndWorldX = this.m_selectedProfileInfo.EndWorldX;
                    this.m_profileLineUEC.EndWorldY = this.m_selectedProfileInfo.EndWorldY;
                    this.m_lblProfileStartX.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldX));
                    this.m_lblProfileStartY.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldY));
                    this.m_lblProfileEndX.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldX));
                    this.m_lblProfileEndY.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldY));
                }
                this.loadMapProfile();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadModel() {
        try {
            if (this.m_selectedProfileInfo == null) {
                this.m_selectedProfileInfo = new SelectedProfileInfo();
            }
            this.m_selectedProfileInfo.StartPixelX = this.m_profileLineUEC.StartPixelX;
            this.m_selectedProfileInfo.StartPixelY = this.m_profileLineUEC.StartPixelY;
            this.m_selectedProfileInfo.EndPixelX = this.m_profileLineUEC.EndPixelX;
            this.m_selectedProfileInfo.EndPixelY = this.m_profileLineUEC.EndPixelY;
            this.m_selectedProfileInfo.StartWorldX = this.m_profileLineUEC.StartWorldX;
            this.m_selectedProfileInfo.StartWorldY = this.m_profileLineUEC.StartWorldY;
            this.m_selectedProfileInfo.EndWorldX = this.m_profileLineUEC.EndWorldX;
            this.m_selectedProfileInfo.EndWorldY = this.m_profileLineUEC.EndWorldY;
            this.m_profile = null;
            String name = this.m_modelCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            Tomo_VNS model = new Tomo_VNS(name);
            RefractionStaticsProject.singleton().setTomo_VNS(model);
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String newFileName(JTextField txt) {
        try {
            String name = txt.getText();
            if (name == null) {
                JOptionPane.showMessageDialog(null, "Please enter a name", "Cannot create model", 0);
                return null;
            }
            name = Tools_Strings.removeCrap(name, true);
            txt.setText(name);
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return null;
            }
            String path = RefractionStaticsProject.singleton().eikonal3DProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return null;
            }
            if (name.equalsIgnoreCase("ShotRecStacks")) {
                JOptionPane.showMessageDialog(null, "Invalid name", "Cannot create model", 0);
                return null;
            }
            return name;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void smoothModel() {
    }

    protected void resampleModel() {
    }

    protected void cloneModel() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (p.getTomo_VNS() == null) {
                return;
            }
            String name = JOptionPane.showInputDialog(null, "Name of the new model", "VNS name ", -1);
            if (name == null) {
                return;
            }
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return;
            }
            String path = RefractionStaticsProject.singleton().tomoVNSProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return;
            }
            p.getTomo_VNS().save(name);
            this.reloadModelCombo();
            this.m_ignoreModelCombo = true;
            this.m_modelCombo.setPreferredSelected(name);
            this.m_ignoreModelCombo = false;
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createNewModel() {
        try {
            if (this.m_newDlg == null) {
                this.m_newDlg = new NewTomoVNSDialog(NewTomoVNSDialog.InitialVelocitySource.Linear);
            }
            this.m_newDlg.showDialog();
            if (this.m_newDlg.OK) {
                this.reloadModelCombo();
                Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
                if (model != null) {
                    this.m_ignoreModelCombo = true;
                    this.m_modelCombo.setPreferredSelected(model.name());
                    this.m_ignoreModelCombo = false;
                }
                this.handleNewModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeV0() {
        try {
            Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (model == null) {
                JOptionPane.showMessageDialog(null, "Tomo model not valid", "Cannot compute V0", 0);
                return;
            }
            int maxBranch = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
            if (maxBranch < 1) {
                JOptionPane.showMessageDialog(null, "Must assign branches first", "Cannot compute V0", 0);
                return;
            }
            double depth = Tools_Widget.extractDouble(this.m_txtWeatheringVelocityDepth, 100.0, 1.0, 1000.0);
            boolean updateZ = this.m_chkComputeRefractorElevation.isSelected();
            model.computeWeatheringVelocity((float)depth, updateZ);
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics() {
        try {
            Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (model == null) {
                return;
            }
            this.m_staticsColName = this.m_txtStaticsName.getText();
            this.m_staticsColName = Tools_Strings.removeCrap(this.m_staticsColName, true);
            if (this.m_staticsColName.length() < 2) {
                return;
            }
            String statColName = this.m_staticsColName;
            this.m_staticsColName = "STATICS_" + statColName;
            String datumIntColName = "DatumInt_" + statColName;
            String datumFinalColName = "DatumFinal_" + statColName;
            p.shotTable().column_append(this.m_staticsColName, DataType.Double);
            p.shotTable().column_append(datumIntColName, DataType.Double);
            p.shotTable().column_append(datumFinalColName, DataType.Double);
            p.receiverTable().column_append(this.m_staticsColName, DataType.Double);
            p.receiverTable().column_append(datumIntColName, DataType.Double);
            p.receiverTable().column_append(datumFinalColName, DataType.Double);
            if (this.m_radIntVel.isSelected()) {
                int indexKilled;
                int indexY;
                int indexX;
                Table_Abstract table;
                int iter;
                double datumVelocity = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
                int total = model.numX() * model.numY();
                InversePowerInterpolator interp = new InversePowerInterpolator(400.0, total);
                for (iter = 0; iter <= 1; ++iter) {
                    table = p.shotTable();
                    if (iter == 1) {
                        table = p.receiverTable();
                    }
                    indexX = table.column_indexOfColumn("Easting");
                    indexY = table.column_indexOfColumn("Northing");
                    indexKilled = table.column_indexOfColumn("Killed");
                    for (int n = 0; n < table.row_count(); ++n) {
                        if (table.getBool(n, indexKilled)) continue;
                        double x = table.getDouble(n, indexX);
                        double y = table.getDouble(n, indexY);
                        double z = model.getElevationAtVelocity(x, y, datumVelocity);
                        interp.add(x, y, z, 1.0);
                    }
                }
                for (iter = 0; iter <= 1; ++iter) {
                    table = p.shotTable();
                    if (iter == 1) {
                        table = p.receiverTable();
                    }
                    indexX = table.column_indexOfColumn("Easting");
                    indexY = table.column_indexOfColumn("Northing");
                    indexKilled = table.column_indexOfColumn("Killed");
                    int indexColIntDatum = table.column_indexOfColumn(datumIntColName);
                    for (int n = 0; n < table.row_count(); ++n) {
                        if (table.getBool(n, indexKilled)) continue;
                        double x = table.getDouble(n, indexX);
                        double y = table.getDouble(n, indexY);
                        double z = interp.getInverseSquare(x, y);
                        table.putDouble(n, indexColIntDatum, z);
                    }
                }
            }
            this.computeStatics(model.SourceHash, p.shotTable(), "ShotID", false);
            this.computeStatics(model.ReceiverHash, p.receiverTable(), "ReceiverID", true);
            if (this.m_radShiftZero.isSelected()) {
                Tools_RefractionStaticsProject.convertToZeroMean(this.m_staticsColName);
            }
            if (this.m_radShiftTie.isSelected()) {
                String column = this.m_comboShiftCol.getSelectedString();
                Tools_RefractionStaticsProject.tieColumnAverage(column, this.m_staticsColName, -9900.0, 9900.0);
            }
            RefractionStaticsProject.singleton().reloadAllData();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics(HashMap_Integers<Tomo_VNS.Element> hash, Table_Abstract table, String idname, boolean updateHistory) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
            if (model == null) {
                return;
            }
            this.m_staticsColName = this.m_txtStaticsName.getText();
            this.m_staticsColName = Tools_Strings.removeCrap(this.m_staticsColName, true);
            if (this.m_staticsColName.length() < 2) {
                return;
            }
            String statColName = this.m_staticsColName;
            this.m_staticsColName = "STATICS_" + statColName;
            String datumIntColName = "DatumInt_" + statColName;
            String datumFinalColName = "DatumFinal_" + statColName;
            int colIntDatum = table.column_indexOfColumn(datumIntColName);
            double residualScalar = Tools_Widget.extractDouble(this.m_txtResidCorrMult, 1.0, -10.0, 10.0);
            boolean includeResidual = this.m_chkApplyResidual.isSelected();
            FinalDatumEnum finalDatum = FinalDatumEnum.Elevation;
            IntDatumEnum intDatum = IntDatumEnum.Elevation;
            if (this.m_radFinalCol.isSelected()) {
                finalDatum = FinalDatumEnum.Column;
            }
            if (this.m_radIntDepth.isSelected()) {
                intDatum = IntDatumEnum.Depth;
            }
            if (this.m_radIntVel.isSelected()) {
                intDatum = IntDatumEnum.Velocity;
            }
            if (this.m_radIntCol.isSelected()) {
                intDatum = IntDatumEnum.Column;
            }
            double datumVelocity = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
            String columnIntDatumName = this.m_comboIntCol.getSelectedString();
            String columnFinalDatumName = this.m_comboFinalCol.getSelectedString();
            double fixedIntElev = Tools_Widget.extractDouble(this.m_txtIntDatumElev, 0.0, -30000.0, 30000.0);
            double depth = Tools_Widget.extractDouble(this.m_txtIntDatumDepth, 100.0, 1.0, 30000.0);
            double finalDatumElevation = Tools_Widget.extractDouble(this.m_txtFinalDatumElev, 0.0, -30000.0, 30000.0);
            double repVel = Tools_Widget.extractDouble(this.m_txtRepVel, 1000.0, 100.0, 30000.0);
            int indexStatics = table.column_indexOfColumn(this.m_staticsColName);
            int indexDatInt = table.column_indexOfColumn(datumIntColName);
            int indexDatFin = table.column_indexOfColumn(datumFinalColName);
            int indexID = table.column_indexOfColumn(idname);
            int indexStackPick = table.column_indexOfColumn("TomoVNS_StackPickTime");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int indexD = -9999;
            if (table.column_exists("PointDepth")) {
                indexD = table.column_indexOfColumn("PointDepth");
            }
            int indexColIntDatum = table.column_indexOfColumn(columnIntDatumName);
            int indexColFinalDatum = table.column_indexOfColumn(columnFinalDatumName);
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double z = table.getDouble(n, indexZ);
                double d = 0.0;
                if (indexD >= 0) {
                    d = table.getDouble(n, indexD);
                }
                int id = table.getInt(n, indexID);
                double intDatumZ = z - 10.0;
                if (intDatum == IntDatumEnum.Elevation) {
                    intDatumZ = Math.min(z - 1.0, fixedIntElev);
                }
                if (intDatum == IntDatumEnum.Depth) {
                    intDatumZ = z - depth;
                }
                if (intDatum == IntDatumEnum.Column) {
                    double colDatum = table.getDouble(n, indexColIntDatum);
                    intDatumZ = Math.min(z - 1.0, colDatum);
                }
                if (finalDatum == FinalDatumEnum.Column) {
                    finalDatumElevation = table.getDouble(n, indexColFinalDatum);
                }
                if (intDatum == IntDatumEnum.Velocity) {
                    intDatumZ = table.getDouble(n, colIntDatum);
                }
                model.computeStaticsV2(x, y, z - d, intDatumZ, finalDatumElevation, repVel);
                double statics = model.Statics;
                if (includeResidual && hash.containsKey(id)) {
                    Tomo_VNS.Element e = hash.get(id);
                    statics += residualScalar * e.Residual;
                }
                table.putDouble(n, indexStatics, statics);
                table.putDouble(n, indexDatInt, model.IntermediateDatum);
                table.putDouble(n, indexDatFin, model.FinalDatum);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(table, this.m_staticsColName);
            p.geometryDatabase().writeColumnContentsToDatabase(table, datumFinalColName);
            p.geometryDatabase().writeColumnContentsToDatabase(table, datumIntColName);
            if (updateHistory) {
                try {
                    model.getHistory().addWithTime("Compute statics:");
                    model.getHistory().add("Column name = " + this.m_staticsColName);
                    if (includeResidual) {
                        model.getHistory().add("Residual term included, scalar = " + Double.toString(residualScalar));
                    }
                    if (this.m_radShiftZero.isSelected()) {
                        model.getHistory().add("Converted to zero mean");
                    }
                    if (this.m_radShiftTie.isSelected()) {
                        model.getHistory().add("Statics tied to column " + this.m_comboShiftCol.getSelectedString());
                    }
                    if (intDatum == IntDatumEnum.Velocity) {
                        model.getHistory().add("Intermediate at velocity = " + Double.toString(datumVelocity));
                    }
                    if (intDatum == IntDatumEnum.Elevation) {
                        model.getHistory().add("Flat intermediate datum, elevation = " + Double.toString(fixedIntElev));
                    }
                    if (intDatum == IntDatumEnum.Depth) {
                        model.getHistory().add("Intermediate datum at depth = " + Double.toString(depth));
                    }
                    if (intDatum == IntDatumEnum.Column) {
                        model.getHistory().add("Intermediate datum at column = " + columnIntDatumName);
                    }
                    if (finalDatum == FinalDatumEnum.Elevation) {
                        model.getHistory().add("Final datum = " + Double.toString(finalDatumElevation));
                    }
                    if (finalDatum == FinalDatumEnum.Column) {
                        model.getHistory().add("Final datum set using column " + columnFinalDatumName);
                    }
                    model.getHistory().add("Replacment velocity = " + Double.toString(repVel));
                    model.getHistory().save();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void cutInside() {
        try {
            if (this.m_polygon == null) {
                JOptionPane.showMessageDialog(null, "Define a polygon first");
                return;
            }
            int res = JOptionPane.showConfirmDialog(null, "Okay to cut inside polygon and interpolate new velocities?", "Confirm delete", 2, 2, null);
            if (res != 0) {
                return;
            }
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS tomo = p.getTomo_VNS();
            TomoVNS_PolygonEdit editor = new TomoVNS_PolygonEdit();
            editor.prepare(this.m_polygon, tomo);
            editor.interpolate_inside(tomo.slowness());
            JOptionPane.showMessageDialog(null, "You must select \"Save model\" to save changes", " ", 1);
            this.m_smallMapWidget.reloadPlot();
            this.m_bigMapWidget.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void cutOutside() {
        try {
            if (this.m_polygon == null) {
                JOptionPane.showMessageDialog(null, "Define a polygon first");
                return;
            }
            int res = JOptionPane.showConfirmDialog(null, "Okay to cut outside polygon and extrapolate new velocities?", "Confirm delete", 2, 2, null);
            if (res != 0) {
                return;
            }
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS tomo = p.getTomo_VNS();
            TomoVNS_PolygonEdit editor = new TomoVNS_PolygonEdit();
            editor.prepare(this.m_polygon, tomo);
            editor.extrapolate_outside(tomo.slowness());
            JOptionPane.showMessageDialog(null, "You must select \"Save model\" to save changes", " ", 1);
            this.m_smallMapWidget.reloadPlot();
            this.m_bigMapWidget.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void importTriconFile() {
        try {
            String fileName = Tools_Chooser.getFileName();
            if (fileName == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            Column_Double colX = new Column_Double("W", 100);
            Column_Double colD = new Column_Double("W", 100);
            Column_Double colV = new Column_Double("W", 100);
            int num = 0;
            double minV = 1.0E8;
            int numInner = 0;
            while (line != null) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_space(line, false);
                if (tokens.size() == 3) {
                    double x = 1000.0 * Double.parseDouble(tokens.get(0));
                    double depth = 1000.0 * Double.parseDouble(tokens.get(1));
                    double v = 1000.0 * Double.parseDouble(tokens.get(2));
                    if (v > 500.0) {
                        minV = Math.min(minV, v);
                    }
                    if (v > 500.0 && v < 2500.0) {
                        System.out.println("x = " + x + " v = " + v);
                        ++numInner;
                    }
                    colX.putDouble(num, x);
                    colD.putDouble(num, depth);
                    colV.putDouble(num, v);
                    ++num;
                }
                line = br.readLine();
            }
            for (int n = 0; n < num; ++n) {
                double v = colV.getDouble(n);
                if (!(v < minV)) continue;
                colV.putDouble(n, minV);
            }
            if (num < 10) {
                return;
            }
            System.out.println("numInner = " + numInner);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.getTomo_VNS().importTricon(num, colX, colD, colV);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Action_TomoVNS_ExportSegy action;
            JDialog dlg;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (!p.valid()) {
                return;
            }
            if (e.getSource() == this.m_btn_thread_halt && this.m_thread.isAlive()) {
                this.m_thread.stopAllActions();
            }
            if (e.getSource() == this.m_timer) {
                boolean is_alive = this.m_thread.isAlive();
                this.m_btn_thread_halt.setEnabled(is_alive);
                this.m_btnUpdateMPI.setEnabled(!is_alive);
                this.m_btnUpdateThreadsNC.setEnabled(!is_alive);
                this.m_btnUpdateThreadsNC_Thread.setEnabled(!is_alive);
                this.m_btnClone.setEnabled(!is_alive);
                this.m_btnCreateNew.setEnabled(!is_alive);
                this.m_btnReload.setEnabled(!is_alive);
                this.m_modelCombo.setEnabled(!is_alive);
                if (is_alive && this.m_thread_alive_during_prior_time) {
                    String s = String.format("UPDATE %d of %d   Error = %f", this.m_update_action.Iter, this.m_update_action.NumIter, this.m_update_action.AverageError);
                    this.m_bigMapWidget.ThreadStatusLabel.setText(s);
                }
                if (is_alive && !this.m_thread_alive_during_prior_time) {
                    this.m_bigMapWidget.ThreadStatusLabel.setForeground(Color.red);
                    this.m_bigMapWidget.ThreadStatusLabel.setText("Update running");
                }
                if (!is_alive && this.m_thread_alive_during_prior_time) {
                    Messenger.broadcastReloadAllGathers(this);
                    this.m_bigMapWidget.ThreadStatusLabel.setText(" ");
                    this.m_bigMapWidget.reloadPlot();
                    this.reloadHistory();
                }
                this.m_thread_alive_during_prior_time = is_alive;
            }
            this.m_comboShiftCol.setEnabled(this.m_radShiftTie.isSelected());
            this.m_txtFinalDatumElev.setEnabled(this.m_radFinalElev.isSelected());
            this.m_comboFinalCol.setEnabled(this.m_radFinalCol.isSelected());
            this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
            this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
            this.m_txtIntDatumVelocity.setEnabled(this.m_radIntVel.isSelected());
            this.m_comboIntCol.setEnabled(this.m_radIntCol.isSelected());
            if (e.getSource() == this.m_txtLocationX || e.getSource() == this.m_txtLocationY) {
                this.loadLocationDetails();
                return;
            }
            if (e.getSource() == this.m_cmbProfileLowerPlot || e.getSource() == this.m_chkShowDelayTimeModelOnProfile) {
                this.loadMapProfile();
                return;
            }
            if (e.getSource() == this.m_btnModSmooth_Velocity) {
                this.smooth_velocity();
                return;
            }
            if (e.getSource() == this.m_btnBlendLayers) {
                this.layers_blend();
                return;
            }
            if (e.getSource() == this.m_btnBlendReset) {
                this.reset_blend();
                return;
            }
            if (e.getSource() == this.m_btnModSmooth_Blend) {
                this.smooth_blend();
                return;
            }
            if (e.getSource() == this.m_btnImportUphole) {
                this.importUphole();
                return;
            }
            if (e.getSource() == this.m_btnBlendDT) {
                this.blendDelayTime();
                return;
            }
            if (e.getSource() == this.m_btnImportDelayTime) {
                this.importDelayTime();
                return;
            }
            if (e.getSource() == this.m_btnImportSegyModel) {
                this.importSegy();
                return;
            }
            if (e.getSource() == this.m_importTriconFile) {
                this.importTriconFile();
                return;
            }
            if (e.getSource() == this.m_btnSmoothModel) {
                this.smoothModel();
                return;
            }
            if (e.getSource() == this.m_btnResample) {
                this.resampleModel();
                return;
            }
            if (e.getSource() == this.m_btnSaveModel) {
                p.getTomo_VNS().save(p.getTomo_VNS().name());
                return;
            }
            if (e.getSource() == this.m_btnCutInside) {
                this.cutInside();
                return;
            }
            if (e.getSource() == this.m_btnCutOutside) {
                this.cutOutside();
                return;
            }
            if (e.getSource() == this.m_btnClearPolygon) {
                this.m_smallMapWidget.Polygon = this.m_polygon = null;
                this.m_smallMapWidget.reloadPlot();
                this.m_bigMapWidget.Polygon = this.m_polygon;
                this.m_bigMapWidget.reloadPlot();
            }
            if (e.getSource() == this.m_btnSmooth) {
                this.smoothVel();
                return;
            }
            if (e.getSource() == this.m_btnCreateSynth) {
                this.createSynth();
                return;
            }
            if (e.getSource() == this.m_btnSetVel) {
                this.setSynthVel();
                return;
            }
            if (e.getSource() == this.m_btnRefreshInfo) {
                this.refreshModelInfo();
                return;
            }
            if (e.getSource() == this.m_btnStaticsReloadColumns) {
                ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
                this.m_comboIntCol.setStringArray(cols);
                this.m_comboFinalCol.setStringArray(cols);
                this.m_comboShiftCol.setStringArray(cols);
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (this.m_btnSegyExportCount_UserGrid == e.getSource()) {
                if (this.m_thread.isAlive()) {
                    JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                    return;
                }
                if (p.getTomo_VNS() == null) {
                    return;
                }
                dlg = new DefineGridThreeCornerDialog(project.getEmptyGrid3D(), false);
                if (!((DefineGridThreeCornerDialog)dlg).OK) {
                    return;
                }
                Action_TomoVNS_ExportSegy action2 = new Action_TomoVNS_ExportSegy();
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).X, 0, action2.X, 0, 3);
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).Y, 0, action2.Y, 0, 3);
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).Inline, 0, action2.Inline, 0, 3);
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).Crossline, 0, action2.Crossline, 0, 3);
                action2.ExportCounts = true;
                action2.ExportVelocity = false;
                action2.UseProjectGrid = false;
                action2.UseUserGrid = true;
                action2.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action2.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action2.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action2.TopDatum - 1000.0, action2.TopDatum - 50000.0, action2.TopDatum - 10.0);
                action2.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action2);
                return;
            }
            if (this.m_btnSegyExport_UserGrid == e.getSource()) {
                if (this.m_thread.isAlive()) {
                    JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                    return;
                }
                if (p.getTomo_VNS() == null) {
                    return;
                }
                dlg = new DefineGridThreeCornerDialog(project.getEmptyGrid3D(), false);
                if (!((DefineGridThreeCornerDialog)dlg).OK) {
                    return;
                }
                Action_TomoVNS_ExportSegy action3 = new Action_TomoVNS_ExportSegy();
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).X, 0, action3.X, 0, 3);
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).Y, 0, action3.Y, 0, 3);
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).Inline, 0, action3.Inline, 0, 3);
                System.arraycopy(((DefineGridThreeCornerDialog)dlg).Crossline, 0, action3.Crossline, 0, 3);
                action3.ExportVelocity = true;
                action3.UseProjectGrid = false;
                action3.UseUserGrid = true;
                action3.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action3.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action3.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action3.TopDatum - 1000.0, action3.TopDatum - 50000.0, action3.TopDatum - 10.0);
                action3.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action3);
                return;
            }
            if (this.m_btnSegyExport_Grid == e.getSource()) {
                if (this.m_thread.isAlive()) {
                    JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                    return;
                }
                if (p.getTomo_VNS() == null) {
                    return;
                }
                action = new Action_TomoVNS_ExportSegy();
                action.ExportVelocity = true;
                action.UseProjectGrid = true;
                action.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action.TopDatum - 1000.0, action.TopDatum - 50000.0, action.TopDatum - 10.0);
                action.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (this.m_btnSegyExport == e.getSource()) {
                if (this.m_thread.isAlive()) {
                    JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                    return;
                }
                if (p.getTomo_VNS() == null) {
                    return;
                }
                action = new Action_TomoVNS_ExportSegy();
                action.ExportVelocity = true;
                action.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action.TopDatum - 1000.0, action.TopDatum - 50000.0, action.TopDatum - 10.0);
                action.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (this.m_btnSegyExportCount_Grid == e.getSource()) {
                if (this.m_thread.isAlive()) {
                    JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                    return;
                }
                if (p.getTomo_VNS() == null) {
                    return;
                }
                action = new Action_TomoVNS_ExportSegy();
                action.ExportCounts = true;
                action.UseProjectGrid = true;
                action.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action.TopDatum - 1000.0, action.TopDatum - 50000.0, action.TopDatum - 10.0);
                action.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (this.m_btnSegyExportCount == e.getSource()) {
                if (this.m_thread.isAlive()) {
                    JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                    return;
                }
                if (p.getTomo_VNS() == null) {
                    return;
                }
                action = new Action_TomoVNS_ExportSegy();
                action.ExportCounts = true;
                action.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action.TopDatum - 1000.0, action.TopDatum - 50000.0, action.TopDatum - 10.0);
                action.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (e.getSource() == this.m_btnComboReloadTables) {
                this.reloadListOfTable();
                return;
            }
            if (e.getSource() == this.m_btnComboReloadUpholeSurveys) {
                this.reloadListOfUpholeSurveys();
                return;
            }
            if (e.getSource() == this.m_btnComboReloadResidualTables) {
                this.reloadListOfTable();
                return;
            }
            if (e.getSource() == this.m_btnReloadHistory) {
                this.reloadHistory();
                return;
            }
            if (e.getSource() == this.m_btnSetWeatheringVelocity) {
                this.computeV0();
                return;
            }
            if (e.getSource() == this.m_btnStatics) {
                this.computeStatics();
                return;
            }
            if (e.getSource() == this.m_btnReload) {
                this.reloadModelCombo();
            }
            if (e.getSource() == this.m_btnClone) {
                this.cloneModel();
            }
            if (e.getSource() == this.m_btnCreateNew) {
                this.createNewModel();
            }
            if (e.getSource() == this.m_btnExportMPI) {
                return;
            }
            if (e.getSource() == this.m_btnUpdateMPI) {
                this.start_job_mpi(false);
            }
            if (e.getSource() == this.m_btnUpdateThreadsNC_Thread) {
                this.start_job(false);
            }
            if (e.getSource() == this.m_btnUpdateThreadsNC) {
                this.start_job(true);
            }
            if (e.getSource() == this.m_btnSetProfile) {
                dlg = new MultiTextDialog(null, "Manually set profile", "Start X: ", "Start Y: ", "End X: ", "End Y: ");
                ((MultiTextDialog)dlg).showDialog("Set profile");
                if (!((MultiTextDialog)dlg).OK) {
                    return;
                }
                this.m_profileLineUEC.StartWorldX = ((MultiTextDialog)dlg).getDouble(0, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.StartWorldY = ((MultiTextDialog)dlg).getDouble(1, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.EndWorldX = ((MultiTextDialog)dlg).getDouble(2, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.EndWorldY = ((MultiTextDialog)dlg).getDouble(3, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.StartPixelX = this.m_smallMapWidget.CompositeWidget.getPixelX(this.m_profileLineUEC.StartWorldX);
                this.m_profileLineUEC.StartPixelY = this.m_smallMapWidget.CompositeWidget.getPixelY(this.m_profileLineUEC.StartWorldY);
                this.m_profileLineUEC.EndPixelX = this.m_smallMapWidget.CompositeWidget.getPixelX(this.m_profileLineUEC.EndWorldX);
                this.m_profileLineUEC.EndPixelY = this.m_smallMapWidget.CompositeWidget.getPixelY(this.m_profileLineUEC.EndWorldY);
                this.m_lblProfileStartX.setText(Double.toString(this.m_profileLineUEC.StartWorldX));
                this.m_lblProfileStartY.setText(Double.toString(this.m_profileLineUEC.StartWorldY));
                this.m_lblProfileEndX.setText(Double.toString(this.m_profileLineUEC.EndWorldX));
                this.m_lblProfileEndY.setText(Double.toString(this.m_profileLineUEC.EndWorldY));
                this.loadMapProfile();
                this.m_smallMapWidget.CompositeWidget.mainWidget().mooz();
            }
            if (this.m_profile != null) {
                if (e.getSource() == this.m_chkHighlightIntermediate) {
                    this.m_profile.PaintDatum = this.m_chkHighlightIntermediate.isSelected();
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_radIntElev) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeElevation;
                    this.m_profile.IntDatumElev = Tools_Widget.extractDouble(this.m_txtIntDatumElev, 0.0, -30000.0, 30000.0);
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_radIntVel) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeVelocity;
                    this.m_profile.IntDatumVel = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_radIntDepth) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeDepth;
                    this.m_profile.IntDatumDepth = Tools_Widget.extractDouble(this.m_txtIntDatumDepth, 100.0, 1.0, 30000.0);
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_radIntCol) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeColumn;
                    this.m_profile.IntDatumColumn = this.m_comboIntCol.getSelectedString();
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_txtIntDatumElev) {
                    this.m_profile.IntDatumElev = Tools_Widget.extractDouble(this.m_txtIntDatumElev, 0.0, -30000.0, 30000.0);
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_txtIntDatumVelocity) {
                    this.m_profile.IntDatumVel = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_txtIntDatumDepth) {
                    this.m_profile.IntDatumDepth = Tools_Widget.extractDouble(this.m_txtIntDatumDepth, 100.0, 1.0, 30000.0);
                    this.loadMapProfile();
                }
                if (e.getSource() == this.m_comboIntCol) {
                    this.m_profile.IntDatumColumn = this.m_comboIntCol.getSelectedString();
                    this.loadMapProfile();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void start_job_mpi(boolean standard) {
        try {
            String file_mpi = "";
            ParameterTree tree = SharedApplicationData.singleton().getParameterTree();
            if (tree.string_exists("FileFlatironsTomography")) {
                file_mpi = tree.string_get("FileFlatironsTomography");
            }
            JFileChooser chooser = new JFileChooser();
            if (Tools_FileSystem.exists_file(file_mpi)) {
                File f = new File(file_mpi);
                String p = f.getCanonicalPath();
                chooser.setCurrentDirectory(new File(p));
            }
            chooser.setDialogTitle("Select \"FlatironsTomography.sh\" shell script");
            chooser.setFileSelectionMode(0);
            if (chooser.showOpenDialog(null) != 0) {
                return;
            }
            file_mpi = chooser.getSelectedFile().getAbsolutePath();
            if (!Tools_FileSystem.exists_file(file_mpi)) {
                JOptionPane.showMessageDialog(null, "Must select FlatironsTomography.sh shell script", "Cannot run MPI", 0);
                return;
            }
            tree.string_put("FileFlatironsTomography", file_mpi);
            SharedApplicationData.singleton().saveParameterTree();
            String vns = RefractionStaticsProject.singleton().getTomo_VNS().name();
            String project = RefractionStaticsProject.singleton().projectName();
            String version = RefractionStaticsProject.singleton().versionName();
            String canon = SharedApplicationData.singleton().homeDirectory();
            ArrayList<String> list = new ArrayList<String>();
            list.add(canon);
            list.add(project);
            list.add(version);
            list.add(vns);
            File fm = new File(file_mpi);
            String path_mpi = fm.getParent();
            String file_start = path_mpi + "/ft.txt";
            Tools_FileSystem.saveAscii(file_start, list);
            ProcessBuilder pb = new ProcessBuilder(file_mpi);
            pb.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void start_job(boolean standard) {
        try {
            if (this.m_thread.isAlive()) {
                JOptionPane.showMessageDialog(null, "Cannot perform action", "Update currently running", 0);
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (p.getTomo_VNS() == null) {
                return;
            }
            Action_TomoVNS_NewThreadModel_Disk action = new Action_TomoVNS_NewThreadModel_Disk();
            action.Uphole_LockShallow = this.m_chkApplyUphole.isSelected();
            if (action.Uphole_LockShallow) {
                action.Uphole_Table = this.m_comboUpholeTable.getSelectedString();
                if (p.importDatabase().tableExists(action.Uphole_Table)) {
                    action.Uphole_X = this.m_comboUpholeX.getSelectedString();
                    action.Uphole_Y = this.m_comboUpholeY.getSelectedString();
                    action.Uphole_Z = this.m_comboUpholeZ.getSelectedString();
                    action.Uphole_V = this.m_comboUpholeV.getSelectedString();
                } else {
                    action.Uphole_LockShallow = false;
                }
            }
            action.UpholeModel_LockShallow = this.m_chkApplyUpholeModel.isSelected();
            if (action.UpholeModel_LockShallow) {
                action.Uphole_ModelName = this.m_comboUpholeSurvey.getSelectedString();
            }
            if (this.m_chkVtiApply.isSelected()) {
                double vti_e = Tools_Widget.extractDouble(this.m_txtVtiEps, 0.1, -0.3, 0.4);
                double vti_d = Tools_Widget.extractDouble(this.m_txtVtiDelta, 0.0, -0.3, 0.4);
                p.getTomo_VNS().vti_constant_select(vti_d, vti_e);
            } else {
                p.getTomo_VNS().vti_constant_off();
            }
            action.ApplyConstraint = this.m_chkApplyBlend.isSelected();
            action.RaypathDepthWeight = this.m_radRaypathDepthWeight.isSelected();
            action.RaypathDepthWeightSq = this.m_radRaypathDepthWeightSq.isSelected();
            action.AllowInversions = this.m_chkAllowInversions.isSelected();
            action.UseNewInterpolation = this.m_chkUseNewInterpolation.isSelected();
            action.LimitVel = this.m_chkLimitVel.isSelected();
            action.LockShallowVelocity = this.m_chkForceShallow.isSelected();
            action.LockDepth = Tools_Widget.extractDouble(this.m_txtForceDepth, 0.0, 0.0, 5000.0);
            action.LockVelocity = Tools_Widget.extractDouble(this.m_txtForceVelocity, 3000.0, 10.0, 50000.0);
            action.SubSample = Tools_Widget.extractInteger(this.m_txtSubSample, 2, 2, 5);
            action.Decimation = Tools_Widget.extractInteger(this.m_txtDecimation, 1, 1, 20);
            action.ApplyDecimation = this.m_chkDecimatePick.isSelected();
            action.PickShift = Tools_Widget.extractDouble(this.m_txtPickShift, 0.0, -500.0, 500.0);
            action.PredictTravelTimes = this.m_chkPrediction.isSelected();
            action.PredictedPickColumn = this.m_predictedPickVersionCombo.getSelectedString();
            action.ComputeHybridTimeShifts = this.m_chkHybridCompute.isSelected();
            action.HybridLMOVelocity = Tools_Widget.extractDouble(this.m_txtHybridVel, 2000.0, 500.0, 20000.0);
            action.HybridTimeShifts = Tools_Widget.extractDouble(this.m_txtHybridTimeShift, 200.0, 100.0, 20000.0);
            action.ApplyAzimuthLimits = this.m_chkApplyAzimuth.isSelected();
            action.AzimuthCenter = Tools_Widget.extractDouble(this.m_txtAzimuthCenter, 0.0, -180.0, 180.0) * Math.PI / 180.0;
            action.AzimuthRadius = Tools_Widget.extractDouble(this.m_txtAzimuthRadius, 0.0, 0.0, 90.0) * Math.PI / 180.0;
            action.Model = p.getTomo_VNS();
            action.NumIter = Tools_Widget.extractInteger(this.m_txtNumIter, 10, 1, 100);
            action.SmoothRadiusZ = Tools_Widget.extractInteger(this.m_txtSmoothRadiusZ, 0, 0, 5);
            action.SmoothRadiusH = Tools_Widget.extractInteger(this.m_txtSmoothRadiusH, 3, 0, 100);
            action.SmoothDecay = Tools_Widget.extractDouble(this.m_txtSmoothDecay, 0.2, 0.01, 1.0);
            action.OffsetCorner = 25.0;
            action.MinOffset = Tools_Widget.extractDouble(this.m_txtMinOffset, 0.0, 0.0, 10000.0);
            action.MaxOffset = Tools_Widget.extractDouble(this.m_txtMaxOffset, action.MinOffset + 1000.0, action.MinOffset + 10.0, 100000.0);
            action.MinAllowedVel = Tools_Widget.extractDouble(this.m_txtMinVel, 2000.0, 10.0, 40000.0);
            action.MaxAllowedVel = Tools_Widget.extractDouble(this.m_txtMaxVel, 20000.0, 10.0, 40000.0);
            action.PickVersion = this.m_pickVersionCombo.getSelectedString();
            int np = Runtime.getRuntime().availableProcessors();
            action.NumThreads = Tools_Widget.extractInteger(this.m_txtNumThreads, 2, 2, np);
            if (standard) {
                p.executeSingleAction(action);
                this.vti_update_label();
            } else {
                this.m_thread = new Action_Thread();
                this.m_update_action = action;
                Action_Sequence seq = new Action_Sequence();
                seq.addAction(action);
                this.m_thread.setSequence(seq);
                this.m_thread.startThread();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportMPI() {
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_comboMouseAction) {
                this.m_bigMapWidget.CompositeWidget.mainWidget().clearEventConsumerList();
                if (this.m_comboMouseAction.getSelectedIndex() == 0) {
                    this.m_bigMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_polygonUEH);
                } else {
                    this.m_bigMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_leftClickMainUEC);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.TomoVNSModelChanged) {
                this.reloadModelCombo();
                this.m_modelCombo.setSelectedItem(data);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadMapProfile() {
        try {
            this.m_profileDisplayWidget.clear();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tomo_VNS model = p.getTomo_VNS();
            if (model == null) {
                return;
            }
            double x1 = this.m_profileLineUEC.StartWorldX;
            double y1 = this.m_profileLineUEC.StartWorldY;
            double x2 = this.m_profileLineUEC.EndWorldX;
            double y2 = this.m_profileLineUEC.EndWorldY;
            if (this.m_profileLineUEC.StartWorldX != 0.0 && this.m_profileLineUEC.StartWorldY != 0.0 && this.m_profileLineUEC.EndWorldX != 0.0 && this.m_profileLineUEC.EndWorldY != 0.0) {
                this.m_smallMapWidget.LineSegment.Valid = true;
                this.m_smallMapWidget.LineSegment.DrawSymbols = false;
                this.m_smallMapWidget.LineSegment.X1 = x1;
                this.m_smallMapWidget.LineSegment.Y1 = y1;
                this.m_smallMapWidget.LineSegment.X2 = x2;
                this.m_smallMapWidget.LineSegment.Y2 = y2;
                this.m_smallMapWidget.LineSegment.LineColor = Color.WHITE;
            }
            model.setWorldLocation(x1, y1, true, true, true, true);
            double z1 = model.InterpolatedElevation;
            model.setWorldLocation(x2, y2, true, true, true, true);
            double z2 = model.InterpolatedElevation;
            if (this.m_profile == null) {
                System.out.println("Recreate profile object");
                this.m_profile = model.createNewProfileV2(5);
                if (this.m_radIntElev.isSelected()) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeElevation;
                    this.m_profile.IntDatumElev = Tools_Widget.extractDouble(this.m_txtIntDatumElev, 0.0, -30000.0, 30000.0);
                } else if (this.m_radIntVel.isSelected()) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeVelocity;
                    this.m_profile.IntDatumVel = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
                } else if (this.m_radIntDepth.isSelected()) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeDepth;
                    this.m_profile.IntDatumDepth = Tools_Widget.extractDouble(this.m_txtIntDatumDepth, 100.0, 1.0, 30000.0);
                } else if (this.m_radIntCol.isSelected()) {
                    this.m_profile.IntDatumEnum = TomoProfileV2_VNS.ProfileIntDatumEnum.IntDatumTypeColumn;
                    this.m_profile.IntDatumColumn = this.m_comboIntCol.getSelectedString();
                }
            }
            model.populateProfileV2(this.m_profile, x1, y1, x2, y2, true);
            this.m_profile.fireShot((float)z1);
            this.m_profile.setReceiver((float)z2, 1000.0f);
            this.m_profile.PaintDatum = this.m_chkHighlightIntermediate.isSelected();
            this.m_profileDisplayWidget.mainWidget(0).addPaintable(this.m_profile, 1000);
            if (this.m_cmbProfileLowerPlot.getSelectedIndex() == 0) {
                this.m_profileDisplayWidget.mainWidget(1).addPaintable(this.m_profile, 1003);
                this.m_profileDisplayWidget.setColorLabel(1, "Node sampling");
            }
            if (this.m_cmbProfileLowerPlot.getSelectedIndex() == 1) {
                this.m_profileDisplayWidget.mainWidget(1).addPaintable(this.m_profile, 1004);
                this.m_profileDisplayWidget.setColorLabel(1, "Constraint");
            }
            this.m_profileDisplayWidget.setColorLabel(0, "Velocity");
            if (this.m_chkShowDelayTimeModelOnProfile.isSelected()) {
                for (int b = 1; b < 5; ++b) {
                    String col = Pecos.getColNameElev(b);
                    if (!p.shotTable().column_exists(col)) continue;
                    Java2D_PaintableDatabaseProfile pr = new Java2D_PaintableDatabaseProfile(col, x1, y1, x2, y2, 100);
                    this.m_profileDisplayWidget.mainWidget(0).addPaintable(pr, 1000);
                    this.m_profileDisplayWidget.mainWidget(1).addPaintable(pr, 1000);
                }
            }
            this.m_profileDisplayWidget.setTransform(Java2D_Transform.Technique.Normal);
            this.m_profileDisplayWidget.unzoom();
            this.m_profileDisplayWidget.initializeMouseoverPanel(this.m_profile, Java2D_UserEventConsumer_MouseoverInfo.ModelType.TomoVNS);
            this.m_smallMapWidget.CompositeWidget.mainWidget().repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_leftClickMainUEC) {
                this.m_txtLocationX.setText(Double.toString(this.m_leftClickMainUEC.WorldX));
                this.m_txtLocationY.setText(Double.toString(this.m_leftClickMainUEC.WorldY));
                this.loadLocationDetails();
                return;
            }
            if (sender == this.m_polygonUEH) {
                if (this.m_polygonUEH.Dragging) {
                    return;
                }
                if (!this.m_polygonUEH.Finished) {
                    return;
                }
                int num = this.m_polygonUEH.numPoints();
                if (this.m_polygonUEH.numPoints() < 3) {
                    return;
                }
                this.m_polygon = new Java2D_Polygon();
                this.m_polygon.FillColor = new Color(192, 192, 192, 192);
                this.m_polygon.X = new double[num];
                this.m_polygon.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    this.m_polygon.X[n] = this.m_polygonUEH.getX(n);
                    this.m_polygon.Y[n] = this.m_polygonUEH.getY(n);
                }
                this.m_smallMapWidget.Polygon = this.m_polygon;
                this.m_smallMapWidget.reloadPlot();
                this.m_bigMapWidget.Polygon = this.m_polygon;
                this.m_bigMapWidget.reloadPlot();
            }
            if (sender == this.m_leftClickUEC) {
                // empty if block
            }
            if (sender == this.m_comboResidualTable) {
                this.reloadListOfResidualColumns();
            }
            if (sender == this.m_comboUpholeTable) {
                this.reloadListOfColumns();
            }
            if (sender == this.m_profileLineUEC) {
                if (this.m_profileLineUEC.Dragging) {
                    this.loadMapProfile();
                } else {
                    System.out.println("handleGenericObjectListener m_profileLineUEC.Dragging == false");
                    this.m_smallMapWidget.CompositeWidget.mainWidget().mooz();
                    this.m_lblProfileStartX.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldX));
                    this.m_lblProfileStartY.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldY));
                    this.m_lblProfileEndX.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldX));
                    this.m_lblProfileEndY.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldY));
                }
            }
            if (sender == this.m_modelCombo) {
                if (this.m_ignoreModelCombo) {
                    return;
                }
                this.loadModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class MapWidget
    extends LinearLayoutWidget
    implements ActionListener,
    ItemListener {
        public Java2D_SimpleComposite CompositeWidget;
        public JComboBox<String> ComboAttribute;
        public JComboBox<String> ComboDepth;
        public JTextField m_txtZ;
        public JCheckBox m_chkShowShots;
        public JCheckBox m_chkShowReceivers;
        public JButton m_btnReload;
        public boolean m_ignoreCombo;
        public JCheckBox m_chkShowWholeGrid;
        public Java2D_Paintable_LineSegment LineSegment;
        public Java2D_Polygon Polygon;
        protected Java2D_Paintable_Table m_shotPaintable;
        public JLabel ThreadStatusLabel;
        protected boolean m_usePolygon;
        public LinearLayoutWidget Bottom;

        public Java2D_Paintable_Table shotPaintable() {
            return this.m_shotPaintable;
        }

        public MapWidget(boolean tinyWidth, boolean usePolygon) {
            super(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.ComboAttribute = new JComboBox();
            this.ComboDepth = new JComboBox();
            this.m_txtZ = new JTextField("0");
            this.m_chkShowShots = new JCheckBox("Show shots");
            this.m_chkShowReceivers = new JCheckBox("Show receivers");
            this.m_ignoreCombo = false;
            this.m_chkShowWholeGrid = new JCheckBox("Show entire grid");
            this.LineSegment = new Java2D_Paintable_LineSegment();
            this.m_shotPaintable = null;
            this.ThreadStatusLabel = new JLabel();
            this.m_usePolygon = false;
            try {
                this.m_usePolygon = usePolygon;
                LinearLayoutWidget top = this.createHorizontal(0, null, 0);
                top.addComponent(this.ComboAttribute, 2);
                top.addComponent(new JLabel("Depth:"), 0);
                top.addComponent(this.ComboDepth, 2);
                top.addComponent(new JLabel("Elevation:"), 0);
                top.addComponent(this.m_txtZ, 2);
                this.m_txtZ.addActionListener(this);
                top.addComponent(this.ThreadStatusLabel, 5);
                this.ComboAttribute.addItem("Surface elevation");
                this.ComboAttribute.addItem("Velocity at fixed depth");
                this.ComboAttribute.addItem("Node hit count at depth");
                this.ComboAttribute.addItem("Maximum valid depth");
                this.ComboAttribute.addItem("Statistical error at depth");
                this.ComboAttribute.addItem("Velocity at fixed elevation");
                this.ComboAttribute.setSelectedIndex(0);
                this.ComboAttribute.addItemListener(this);
                this.ComboDepth.addItemListener(this);
                int index = this.ComboAttribute.getSelectedIndex();
                this.ComboDepth.setEnabled(index == 1 || index == 2);
                this.m_txtZ.setEnabled(index == 5);
                this.Bottom = this.createHorizontal(0, null, 0);
                this.Bottom.addComponent(this.m_chkShowReceivers, 0);
                this.m_chkShowReceivers.addActionListener(this);
                this.Bottom.addComponent(this.m_chkShowShots, 0);
                this.m_chkShowShots.addActionListener(this);
                this.Bottom.addComponent(this.m_chkShowWholeGrid, 0);
                this.m_chkShowWholeGrid.addActionListener(this);
                this.m_btnReload = this.Bottom.createButton("Reload plot", this, 0);
                this.Bottom.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(top, -1, null, true);
                Tools_FontChanger.changeSizeOfFont(this.Bottom, -1, null, true);
                Tools_FontChanger.changeSizeOfFont(this.ThreadStatusLabel, 3, null, false);
                this.CompositeWidget = new Java2D_SimpleComposite(true);
                this.CompositeWidget.setAxesVisible(true, true);
                this.CompositeWidget.setScrollVisible(true, true);
                this.CompositeWidget.mainWidget().addZoomer();
                this.addComponent(this.CompositeWidget, 10);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void handleNewModel() {
            try {
                Tomo_VNS model = RefractionStaticsProject.singleton().getTomo_VNS();
                this.LineSegment.Valid = false;
                if (model == null) {
                    return;
                }
                this.ComboDepth.removeAllItems();
                float[] nodeDepth = model.nodeDepth();
                for (int n = 0; n < nodeDepth.length; ++n) {
                    String s = Tools_Strings.getString(nodeDepth[n], 1);
                    this.ComboDepth.addItem(s);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void reloadPlot() {
            try {
                int index;
                this.m_shotPaintable = null;
                Tomo_VNS tomo = RefractionStaticsProject.singleton().getTomo_VNS();
                Java2D_Widget w = this.CompositeWidget.mainWidget();
                w.clearPaintableList();
                if (tomo == null) {
                    w.mooz();
                    return;
                }
                Grid3D grid = null;
                if (this.ComboAttribute.getSelectedIndex() == 0) {
                    grid = tomo.getSurfaceGrid3D();
                }
                if ((index = this.ComboDepth.getSelectedIndex()) < 0) {
                    return;
                }
                float depth = tomo.nodeDepth()[index];
                if (this.ComboAttribute.getSelectedIndex() == 1) {
                    grid = tomo.getVelocityAtDepthGrid3D(depth);
                }
                if (this.ComboAttribute.getSelectedIndex() == 2) {
                    grid = tomo.getCountAtDepthGrid3D(depth);
                }
                if (this.ComboAttribute.getSelectedIndex() == 3) {
                    grid = tomo.getValidDepthGrid3D();
                    RefractionStaticsProject p = RefractionStaticsProject.singleton();
                    this.saveGridToTable(grid, p.shotTable(), "TOMOVNS_MAXDEPTH");
                    this.saveGridToTable(grid, p.receiverTable(), "TOMOVNS_MAXDEPTH");
                }
                if (this.ComboAttribute.getSelectedIndex() == 4) {
                    grid = tomo.getErrorAtDepthGrid3D(depth);
                }
                if (this.ComboAttribute.getSelectedIndex() == 5) {
                    double z = Tools_Widget.extractDouble(this.m_txtZ, 0.0, -100000.0, 100000.0);
                    grid = tomo.getVelocityAtElevationGrid3D(z);
                }
                if (grid != null) {
                    if (!this.m_chkShowWholeGrid.isSelected()) {
                        grid.DataValid = tomo.ray_coverage();
                    }
                    grid.ArrayDirty = true;
                    w.addPaintable(grid, 0);
                }
                if (this.m_chkShowShots.isSelected()) {
                    try {
                        this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                        w.addPaintable(this.m_shotPaintable, 0);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                if (this.m_chkShowReceivers.isSelected()) {
                    try {
                        w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), 0);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                if (this.Polygon != null) {
                    w.addPaintable(this.Polygon, 0);
                }
                if (!this.m_usePolygon) {
                    w.addPaintable(this.LineSegment, 0);
                }
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                w.mooz();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void saveGridToTable(Grid3D grid, Table_Abstract table, String name) {
            try {
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                int col = table.column_append(name, DataType.Double);
                int colx = table.column_indexOfColumn("Easting");
                int coly = table.column_indexOfColumn("Northing");
                for (int r = 0; r < table.row_count(); ++r) {
                    double x = table.getDouble(r, colx);
                    double y = table.getDouble(r, coly);
                    float v = grid.getNearestValue(x, y);
                    table.putDouble(r, col, v);
                }
                p.geometryDatabase().writeColumnContentsToDatabase(table, name);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (this.m_ignoreCombo) {
                    return;
                }
                int index = this.ComboAttribute.getSelectedIndex();
                this.m_txtZ.setEnabled(index == 5);
                this.ComboDepth.setEnabled(index == 1 || index == 2 || index == 4);
                if (e.getSource() == this.ComboDepth) {
                    this.reloadPlot();
                }
                if (e.getSource() == this.ComboAttribute) {
                    this.reloadPlot();
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.reloadPlot();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public class SelectedProfileInfo {
        protected int StartPixelX;
        protected int StartPixelY;
        protected int EndPixelX;
        protected int EndPixelY;
        protected double StartWorldX;
        protected double StartWorldY;
        protected double EndWorldX;
        protected double EndWorldY;
    }

    protected static enum FinalDatumEnum {
        Elevation,
        Column;

    }

    protected static enum IntDatumEnum {
        Depth,
        Elevation,
        Column,
        Velocity;

    }
}

