/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Tomography.VNS;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Refraction.DelayTime.SolutionStacksWidget;

public class SolutionStacksWidget_TomoVNS
extends SolutionStacksWidget
implements ISaveableFrame {
    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Tomography.SolutionStacksWidget_TomoVNS";
    }

    @Override
    public String TAB_LABEL() {
        return "VNS Shot/rec stacks";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "VNS residuals picker";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public SolutionStacksWidget_TomoVNS() {
        super(4000);
    }

    @Override
    public void handleShotPicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Tomo_VNS tomo = project.getTomo_VNS();
            if (tomo == null) {
                return;
            }
            HashMap_Integers<Tomo_VNS.Element> tomoHash = tomo.SourceHash;
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            HashMap_Integer map = project.shotMap();
            Table_Abstract table = project.shotTable();
            int columnStackPick = table.column_indexOfColumn("TomoVNS_StackPickTime");
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int row = map.get(trace.StackTraceID);
                double pick = trace.header().getDouble(indexPick);
                if (!(pick > -3000.0) || !(pick < 3000.0)) continue;
                table.putDouble(row, columnStackPick, pick);
                this.database().updateSingleRow_Double("Shot", "TomoVNS_StackPickTime", trace.StackTraceID, pick);
            }
            tomo.saveSourceHash();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleReceiverPicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Tomo_VNS tomo = project.getTomo_VNS();
            if (tomo == null) {
                return;
            }
            HashMap_Integers<Tomo_VNS.Element> tomoHash = tomo.ReceiverHash;
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            HashMap_Integer map = project.receiverMap();
            Table_Abstract table = project.receiverTable();
            int columnStackPick = table.column_indexOfColumn("TomoVNS_StackPickTime");
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int row = map.get(trace.StackTraceID);
                double pick = trace.header().getDouble(indexPick);
                if (!(pick > -3000.0) || !(pick < 3000.0)) continue;
                table.putDouble(row, columnStackPick, pick);
                this.database().updateSingleRow_Double("Receiver", "TomoVNS_StackPickTime", trace.StackTraceID, pick);
            }
            tomo.saveReceiverHash();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

