/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Tomography;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.FWI.FwiModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D_Tools;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class TomoLayerNewModelDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ItemListener {
    protected InitialVelocitySource m_initialVelocitySource;
    protected ModelType m_modelType;
    public boolean OK = false;
    protected Java2D_SimpleComposite m_widget;
    protected JTextField m_txtAngle = new JTextField("0");
    protected JTextField m_txtSize = new JTextField("300");
    protected JTextField m_txtName = new JTextField("aaa");
    protected JTextField m_txtDepth = new JTextField("400");
    protected JTextField m_txtSizeVert = new JTextField("40");
    protected JTextField m_txtSizeHorz = new JTextField("100");
    protected JComboBox m_comboInitialVel = new JComboBox();
    protected ComboStringListWrapper m_comboVersion = new ComboStringListWrapper();
    protected JTextField m_txtVelTop = new JTextField("3000");
    protected JTextField m_txtVelBottom = new JTextField("6000");
    protected JCheckBox m_chkMarine = new JCheckBox("Marine survey - keep water velocity fixed");
    protected JTextField m_txtWaterVelocity = new JTextField("1500");
    protected RadioPanel m_radioMethod;
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected JLabel m_lblStatusVersion = new JLabel("okay");
    protected JLabel m_lblStatus = new JLabel("");
    protected JLabel m_lblNumInline = new JLabel("", 4);
    protected JLabel m_lblNumCrossline = new JLabel("", 4);
    protected JLabel m_lblNumZ = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected JButton m_btnCreate;
    protected JButton m_btnCancel;
    protected Java2D_UserEventConsumer_Line m_lineUEC = new Java2D_UserEventConsumer_Line();
    protected TomoEikonal3D m_tomo3D;
    protected FwiModel m_fwi3D;
    protected boolean m_versionOkay = false;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_recPaintable = null;

    public TomoLayerNewModelDialog(ModelType modelType, InitialVelocitySource initialVelocitySource) {
        try {
            this.m_initialVelocitySource = initialVelocitySource;
            this.m_modelType = modelType;
            this.getContentPane().setLayout(new BorderLayout());
            JSplitPane splitter = new JSplitPane(1);
            LinearLayoutWidget right = LinearLayoutWidget.vert(0, null);
            this.m_widget = new Java2D_SimpleComposite(true);
            this.m_widget.setAxesVisible(true, true);
            this.m_widget.setScrollVisible(true, true);
            right.addComponent(new JLabel("Left click and drag to define grid angle"), 0);
            right.addComponent(this.m_widget, 10);
            splitter.setRightComponent(right);
            this.m_lineUEC.addListener(this);
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            int row = 0;
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Model parameters", 0);
            grid.addSimple(row++, new JLabel("Grid angle (degrees)"), this.m_txtAngle);
            if (this.m_modelType == ModelType.Layered) {
                grid.addSimple(row++, new JLabel("Node spacing (ft/m)"), this.m_txtSize);
            } else {
                grid.addSimple(row++, new JLabel("Horizontal node spacing (ft/m)"), this.m_txtSizeHorz);
                grid.addSimple(row++, new JLabel("Vertical node spacing (ft/m)"), this.m_txtSizeVert);
                grid.addSimple(row++, new JLabel("Model depth (ft/m)"), this.m_txtDepth);
                if (this.m_initialVelocitySource == InitialVelocitySource.Linear) {
                    this.m_comboInitialVel.addItem("Use linear velocity gradient");
                    this.m_comboInitialVel.addItem("Use current delay time model");
                    this.m_comboInitialVel.setSelectedIndex(0);
                    this.m_comboInitialVel.addItemListener(this);
                    this.m_comboVersion.setStringArray(RefractionStaticsProject.singleton().versionList());
                    grid.addSimple(row++, new JLabel("Initial velocity model"), this.m_comboInitialVel);
                    grid.addSimple(row++, new JLabel("Velocity at surface"), this.m_txtVelTop);
                    grid.addSimple(row++, new JLabel("Velocity at max depth"), this.m_txtVelBottom);
                    this.m_txtVelTop.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 0);
                    this.m_txtVelBottom.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 0);
                    this.m_comboVersion.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 1);
                }
            }
            grid.addSimple(row++, new JLabel("Name"), this.m_txtName);
            if (this.m_modelType == ModelType.Eikonal3D || this.m_modelType == ModelType.FWI3D) {
                JLabel lbl = new JLabel("<html><font color=\"red\">1) Both Shot and Receiver tables must have valid WaterDepth column<br>2) The surface elevation will be forced to zero<br> 3) The shot/receiver depths should be in PointDepth columns</font><br> </html>");
                LinearLayoutWidget sub = main.createVertical(0, "Marine survey options", 0);
                sub.addComponent(lbl, 0);
                sub.addComponent(this.m_chkMarine, 0);
                sub.addHorzPair(new JLabel("Water velocity"), 0, this.m_txtWaterVelocity, 4);
            }
            if (this.m_modelType == ModelType.Eikonal3D && this.m_initialVelocitySource == InitialVelocitySource.InteractivePicks) {
                this.m_radioMethod = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Velocity interpolation method", "Use curve depth", "Use curve elevation");
                main.addComponent(this.m_radioMethod, 0);
            }
            main.createGapLabel(12);
            if (this.m_modelType == ModelType.Eikonal3D || this.m_modelType == ModelType.FWI3D) {
                grid = main.createGridLayoutWidget(0, "Model size", 0);
                row = 0;
                grid.addSimple(row++, new JLabel("Inline node count"), this.m_lblNumInline);
                grid.addSimple(row++, new JLabel("Crossline node count"), this.m_lblNumCrossline);
                grid.addSimple(row++, new JLabel("Depth node count"), this.m_lblNumZ);
                grid.addSimple(row++, new JLabel("Total model memory (MB)"), this.m_lblMemory);
            }
            if (this.m_modelType == ModelType.Layered) {
                LinearLayoutWidget sub = main.createVertical(0, "Select delay time version", 0);
                JLabel lbl = new JLabel("<html>The initial model, including refractor velocities, <br>will be generated from the delay time branch assignment <br>of the following version:</html>");
                sub.addComponent(lbl, 0);
                sub.addHorzPair(new JLabel("Version:"), 0, this.m_versionCombo, 5);
                sub.addComponent(this.m_lblStatusVersion, 0);
                this.m_versionCombo.listener().addListener(this);
            }
            main.addStretch(10);
            this.m_txtAngle.addActionListener(this);
            this.m_txtSize.addActionListener(this);
            this.m_txtSizeHorz.addActionListener(this);
            this.m_txtSizeVert.addActionListener(this);
            this.m_txtDepth.addActionListener(this);
            splitter.setLeftComponent(main);
            this.getContentPane().add((Component)splitter, "Center");
            LinearLayoutWidget bottom = LinearLayoutWidget.horz(0, null);
            this.m_btnCreate = bottom.createButton("Create new model", this, 0);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            bottom.addComponent(this.m_lblStatus, 33);
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(950, 750);
            if (this.m_modelType == ModelType.Layered) {
                this.setTitle("Create new layer tomography model");
            } else if (this.m_modelType == ModelType.Eikonal3D) {
                this.setTitle("Create new 3D tomography model");
            } else {
                this.setTitle("Create new 3D FWI model");
            }
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.m_txtVelTop.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 0);
            this.m_txtVelBottom.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 0);
            this.m_comboVersion.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 1);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadVersions() {
        try {
            if (this.m_modelType != ModelType.Layered) {
                return;
            }
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_comboVersion.setStringArray(RefractionStaticsProject.singleton().versionList());
            this.m_versionCombo.setStringArray(versionList);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            int maxBranch = project.getDelayTimeData().branchAssignment().maxBranch();
            if (maxBranch < 1) {
                this.m_comboInitialVel.setSelectedIndex(0);
                this.m_comboInitialVel.setEnabled(false);
            } else {
                this.m_comboInitialVel.setEnabled(true);
            }
            this.m_txtVelTop.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 0);
            this.m_txtVelBottom.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 0);
            this.m_comboVersion.setEnabled(this.m_comboInitialVel.getSelectedIndex() == 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.reloadVersions();
            this.checkVersion();
            this.reload();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected BranchAssignment checkVersion() {
        try {
            if (this.m_modelType != ModelType.Layered) {
                return new BranchAssignment();
            }
            this.m_btnCreate.setEnabled(false);
            this.m_versionOkay = false;
            String version = this.m_versionCombo.getSelectedString();
            String path = RefractionStaticsProject.singleton().versionContainerPath() + "/" + version;
            if (!Tools_FileSystem.exists_path(path)) {
                this.m_lblStatusVersion.setText("Version path error");
                this.m_lblStatusVersion.setForeground(Color.red);
                return null;
            }
            String file = path + "/DelayTime/Branch.xml";
            if (!Tools_FileSystem.exists_file(file)) {
                this.m_lblStatusVersion.setText("Version branch file not found");
                this.m_lblStatusVersion.setForeground(Color.red);
                return null;
            }
            BranchAssignment ba = new BranchAssignment();
            ba.read(file);
            int maxBranch = ba.maxBranch();
            if (maxBranch < 1) {
                this.m_lblStatusVersion.setText("Version branch not assigned");
                this.m_lblStatusVersion.setForeground(Color.red);
                return null;
            }
            this.m_lblStatusVersion.setText("Number of refractors: " + maxBranch);
            this.m_lblStatusVersion.setForeground(Color.blue);
            this.m_btnCreate.setEnabled(true);
            return ba;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected Java2D_Paintable_Table createPT(String tableName, String colX, String colY) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            String colID = tableName + "ID";
            String query = String.format("SELECT  %s, %s, %s FROM %s WHERE KILLED = FALSE", colX, colY, colID, tableName);
            Table_Abstract table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
            painter.setTable(table);
            painter.UseColorScale = false;
            painter.FixedColor = Color.BLACK;
            painter.Symbol = Java2D_PointSymbol.Plus;
            painter.DrawMoveVectors = false;
            painter.Size_UsePixel = true;
            painter.Size_Pixel = 3;
            painter.setAxisX(colX);
            painter.setAxisY(colY);
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected boolean nameOkay() {
        try {
            String name = this.m_txtName.getText();
            if (name == null) {
                JOptionPane.showMessageDialog(null, "Please enter a name", "Cannot create model", 0);
                return false;
            }
            name = Tools_Strings.removeCrap(name, true);
            this.m_txtName.setText(name);
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return false;
            }
            Object path = "";
            if (this.m_modelType == ModelType.Layered) {
                // empty if block
            }
            if (this.m_modelType == ModelType.Eikonal3D) {
                path = RefractionStaticsProject.singleton().eikonal3DProjectsPath() + "/" + name;
            }
            if (this.m_modelType == ModelType.FWI3D) {
                path = RefractionStaticsProject.singleton().fwi3DProjectsPath() + "/" + name;
            }
            if (Tools_FileSystem.exists_path((String)path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return false;
            }
            if (name.equalsIgnoreCase("ShotRecStacks")) {
                JOptionPane.showMessageDialog(null, "Invalid name", "Cannot create model", 0);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void createNew() {
        try {
            double v2;
            int res;
            int mb;
            if (!this.nameOkay()) {
                return;
            }
            String name = this.m_txtName.getText();
            if (this.m_modelType == ModelType.FWI3D) {
                mb = this.createFwi3D(false);
                if (mb > 500 && (res = JOptionPane.showConfirmDialog(null, "This model will require " + Integer.toString(mb) + " MB of memory. \nDo you still want to create the model?", "", 0)) != 0) {
                    return;
                }
                mb = this.createFwi3D(true);
                if (this.m_initialVelocitySource == InitialVelocitySource.Linear) {
                    double v1 = Tools_Widget.extractDouble(this.m_txtVelTop, 3000.0, 700.0, 6000.0);
                    v2 = Tools_Widget.extractDouble(this.m_txtVelBottom, 2.0 * v1, 1.1 * v1, 8.0 * v1);
                    this.m_fwi3D.setVelocityGradient(v1, v2);
                }
                this.m_fwi3D.save(name);
                RefractionStaticsProject.singleton().setFwi3D(this.m_fwi3D);
                this.OK = true;
                this.dispose();
            }
            if (this.m_modelType == ModelType.Eikonal3D) {
                mb = this.createTomo3D(false);
                if (mb > 500 && (res = JOptionPane.showConfirmDialog(null, "This model will require " + Integer.toString(mb) + " MB of memory. \nDo you still want to create the model?", "", 0)) != 0) {
                    return;
                }
                mb = this.createTomo3D(true);
                if (this.m_initialVelocitySource == InitialVelocitySource.Linear) {
                    if (this.m_comboInitialVel.getSelectedIndex() == 0) {
                        double v1 = Tools_Widget.extractDouble(this.m_txtVelTop, 3000.0, 700.0, 6000.0);
                        v2 = Tools_Widget.extractDouble(this.m_txtVelBottom, 2.0 * v1, 1.1 * v1, 8.0 * v1);
                        this.m_tomo3D.setVelocityGradient(v1, v2);
                        this.m_tomo3D.prepWaterVelocity();
                    } else if (this.m_comboInitialVel.getSelectedIndex() == 1) {
                        TomoEikonal3D_Tools.initializeWithDelayTimeModel(this.m_tomo3D);
                        this.m_tomo3D.prepWaterVelocity();
                    }
                }
                if (this.m_initialVelocitySource == InitialVelocitySource.InteractivePicks) {
                    int method = this.m_radioMethod.getSelectedIndex();
                    this.m_tomo3D.computeVelocityUsingPicks(method);
                    this.m_tomo3D.prepWaterVelocity();
                }
                this.m_tomo3D.save(name);
                RefractionStaticsProject.singleton().setEikonal3D(this.m_tomo3D);
                this.OK = true;
                this.dispose();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean marineTableOkay(Table_Abstract tbl) {
        try {
            if (!tbl.column_exists("WaterDepth")) {
                return false;
            }
            return tbl.column_exists("PointDepth");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean checkMarineOkay() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Table_Abstract shotTable = project.shotTable();
            Table_Abstract recTable = project.receiverTable();
            return this.marineTableOkay(shotTable) && this.marineTableOkay(recTable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected int createTomo3D(boolean allocateMemory) {
        try {
            double angle = Math.PI * Tools_Widget.extractDouble(this.m_txtAngle, 0.0, -360.0, 360.0) / 180.0;
            double sizeX = Tools_Widget.extractDouble(this.m_txtSizeHorz, 50.0, 1.0, 1000.0);
            double sizeZ = Tools_Widget.extractDouble(this.m_txtSizeVert, 50.0, 1.0, 1000.0);
            double maxDepth = Tools_Widget.extractDouble(this.m_txtDepth, 5.0 * sizeZ, 3.0 * sizeZ, 500.0 * sizeZ);
            boolean forceMarine = this.m_chkMarine.isSelected();
            double waterVelocity = Tools_Widget.extractDouble(this.m_txtWaterVelocity, 1500.0, 1400.0, 6000.0);
            if (forceMarine && !this.checkMarineOkay()) {
                forceMarine = false;
                JOptionPane.showMessageDialog(null, "Cannot treat as marine survey, required columns not valid", "", 0);
            }
            this.m_tomo3D = new TomoEikonal3D(angle, maxDepth, sizeX, sizeZ, allocateMemory, forceMarine, waterVelocity);
            this.m_lblNumInline.setText(Integer.toString(this.m_tomo3D.numX()));
            this.m_lblNumCrossline.setText(Integer.toString(this.m_tomo3D.numY()));
            this.m_lblNumZ.setText(Integer.toString(this.m_tomo3D.numZ()));
            double numNodes = (double)this.m_tomo3D.numX() * (double)this.m_tomo3D.numY() * (double)this.m_tomo3D.numZ();
            double mem = 13.2 * numNodes;
            int mb = 1 + (int)(mem *= 1.0E-6);
            this.m_lblMemory.setText(Integer.toString(mb));
            if (mb > 500) {
                this.m_lblMemory.setForeground(Color.red);
            } else {
                this.m_lblMemory.setForeground(Color.black);
            }
            return mb;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected int createFwi3D(boolean allocateMemory) {
        try {
            double angle = Math.PI * Tools_Widget.extractDouble(this.m_txtAngle, 0.0, -360.0, 360.0) / 180.0;
            double sizeX = Tools_Widget.extractDouble(this.m_txtSizeHorz, 50.0, 5.0, 1000.0);
            double sizeZ = Tools_Widget.extractDouble(this.m_txtSizeVert, 50.0, 1.0, 1000.0);
            double maxDepth = Tools_Widget.extractDouble(this.m_txtDepth, 5.0 * sizeZ, 3.0 * sizeZ, 100.0 * sizeZ);
            boolean forceMarine = this.m_chkMarine.isSelected();
            double waterVelocity = Tools_Widget.extractDouble(this.m_txtWaterVelocity, 1500.0, 1400.0, 6000.0);
            if (forceMarine && !this.checkMarineOkay()) {
                forceMarine = false;
                JOptionPane.showMessageDialog(null, "Cannot treat as marine survey, required columns not valid", "", 0);
            }
            this.m_fwi3D = new FwiModel(angle, maxDepth, sizeX, sizeZ, allocateMemory, forceMarine, waterVelocity);
            this.m_lblNumInline.setText(Integer.toString(this.m_fwi3D.numX()));
            this.m_lblNumCrossline.setText(Integer.toString(this.m_fwi3D.numY()));
            this.m_lblNumZ.setText(Integer.toString(this.m_fwi3D.numZ()));
            double numNodes = (double)this.m_fwi3D.numX() * (double)this.m_fwi3D.numY() * (double)this.m_fwi3D.numZ();
            double mem = 13.2 * numNodes;
            int mb = 1 + (int)(mem *= 1.0E-6);
            this.m_lblMemory.setText(Integer.toString(mb));
            if (mb > 500) {
                this.m_lblMemory.setForeground(Color.red);
            } else {
                this.m_lblMemory.setForeground(Color.black);
            }
            return mb;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected void reload() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearPaintableList();
            if (this.m_shotPaintable == null) {
                this.m_shotPaintable = this.createPT("Shot", "Easting", "Northing");
                this.m_recPaintable = this.createPT("Receiver", "Easting", "Northing");
            }
            if (this.m_modelType == ModelType.Layered) {
                // empty if block
            }
            if (this.m_modelType == ModelType.FWI3D) {
                this.createFwi3D(false);
                w.addPaintable(this.m_fwi3D.createPointArray(), -9999);
            }
            if (this.m_modelType == ModelType.Eikonal3D) {
                this.createTomo3D(false);
                w.addPaintable(this.m_tomo3D.createPointArray(), -9999);
            }
            w.addPaintable(this.m_shotPaintable, -9999);
            w.addPaintable(this.m_recPaintable, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            this.m_lineUEC.BroadcastWhenDragging = false;
            w.addEventConsumer(this.m_lineUEC);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_versionCombo) {
                this.checkVersion();
                return;
            }
            if (sender == this.m_lineUEC) {
                double angle = 180.0 * this.m_lineUEC.Azimuth / Math.PI;
                this.m_txtAngle.setText(Double.toString(angle));
                this.reload();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_txtAngle) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_txtSize) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_txtDepth) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_txtSizeVert) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_txtSizeHorz) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCreate) {
                this.createNew();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String name() {
        try {
            return this.m_txtName.getText();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static enum InitialVelocitySource {
        Linear,
        InteractivePicks;

    }

    public static enum ModelType {
        Layered,
        Eikonal3D,
        FWI3D;

    }
}

