/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class RefractionStaticsProjectManagerWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected ScrollTable m_scrollTable;
    protected String m_addAram = "Based on Aram project file";
    protected String m_addGli = "Based on GLI files";
    protected String m_addSegyWiz = "Based on SEG-Y files";
    protected String m_addGroups = "Based on existing projects";
    protected Table_Abstract m_projectTable = new Table_Memory();
    protected Table_SimpleModel m_tableModel;
    protected int m_indexName;
    protected int m_indexOrigin;
    protected int m_indexTraceCount;
    protected int m_indexDate;
    protected int m_indexDateLast;
    protected int m_indexVersion;
    protected int m_indexDim;
    protected int m_indexUnits;
    protected int m_indexShotCount;
    protected int m_indexReceiverCount;
    protected int m_indexArea;
    protected int m_indexMinOffset;
    protected int m_indexMaxOffset;
    protected int m_indexCompressed;

    public RefractionStaticsProjectManagerWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_scrollTable = new ScrollTable();
            this.addComponent(this.m_scrollTable, 10);
            this.m_projectTable.setName("Projects");
            this.m_indexName = this.m_projectTable.column_append("Name", DataType.Text);
            this.m_indexOrigin = this.m_projectTable.column_append("Origin", DataType.Text);
            this.m_indexCompressed = this.m_projectTable.column_append("Compressed", DataType.Text);
            this.m_indexDate = this.m_projectTable.column_append("Date", DataType.Text);
            this.m_indexDateLast = this.m_projectTable.column_append("Date last opened", DataType.Text);
            this.m_indexVersion = this.m_projectTable.column_append("Version created in", DataType.Text);
            this.m_indexDim = this.m_projectTable.column_append("Dimension", DataType.Text);
            this.m_indexUnits = this.m_projectTable.column_append("Units", DataType.Text);
            this.m_indexShotCount = this.m_projectTable.column_append("Shot count", DataType.Text);
            this.m_indexReceiverCount = this.m_projectTable.column_append("Receiver count", DataType.Text);
            this.m_indexTraceCount = this.m_projectTable.column_append("Trace count", DataType.Text);
            this.m_indexArea = this.m_projectTable.column_append("Survey area", DataType.Text);
            this.m_indexMinOffset = this.m_projectTable.column_append("Min offset", DataType.Text);
            this.m_indexMaxOffset = this.m_projectTable.column_append("Max offset", DataType.Text);
            this.m_tableModel = new Table_SimpleModel(this.m_projectTable);
            this.m_scrollTable.table().setModel(this.m_tableModel);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexName).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexCompressed).setMinWidth(100);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexDate).setMinWidth(210);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexDateLast).setMinWidth(210);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexVersion).setMinWidth(100);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexDim).setMinWidth(80);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexUnits).setMinWidth(80);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexShotCount).setMinWidth(100);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexReceiverCount).setMinWidth(100);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexTraceCount).setMinWidth(100);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexArea).setMinWidth(100);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexMinOffset).setMinWidth(90);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexMaxOffset).setMinWidth(90);
            this.reloadTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadTable() {
        try {
            this.m_projectTable.row_clear(true);
            String parentPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(parentPath, false);
            for (String subdir : subdirs) {
                String subdirName;
                String fullProjectPath = parentPath + "/" + subdir;
                if (!Tools_FileSystem.exists_path(fullProjectPath)) continue;
                if (subdir.endsWith(".xtref")) {
                    int endChar = subdir.length() - ".xtref".length();
                    subdirName = subdir.substring(0, endChar);
                } else {
                    subdirName = subdir;
                }
                String descFileName = fullProjectPath + "/ProjectDescription.xml";
                ParameterTree pt = new ParameterTree();
                pt.read(descFileName);
                int row = this.m_projectTable.row_increment();
                this.m_projectTable.putString(row, this.m_indexName, subdirName);
                this.m_projectTable.putString(row, this.m_indexCompressed, pt.string_get("HasCompressed", "Error"));
                this.m_projectTable.putString(row, this.m_indexDate, pt.string_get("DateCreated", "Error"));
                this.m_projectTable.putString(row, this.m_indexDateLast, pt.string_get("DateLastOpened", "Unknown"));
                this.m_projectTable.putString(row, this.m_indexVersion, pt.string_get("VersionCreated", "Unknown"));
                this.m_projectTable.putString(row, this.m_indexDim, pt.string_get("Dimension", "Error"));
                this.m_projectTable.putString(row, this.m_indexUnits, pt.string_get("Units", "Error"));
                this.m_projectTable.putString(row, this.m_indexShotCount, pt.string_get("ShotCount", "Error"));
                this.m_projectTable.putString(row, this.m_indexReceiverCount, pt.string_get("ReceiverCount", "Error"));
                this.m_projectTable.putString(row, this.m_indexOrigin, pt.string_get("Origin", "Error"));
                this.m_projectTable.putString(row, this.m_indexTraceCount, pt.string_get("TraceCount", "Error"));
                this.m_projectTable.putString(row, this.m_indexArea, pt.string_get("SurveyArea", "Rebin req."));
                this.m_projectTable.putString(row, this.m_indexMinOffset, pt.string_get("MinOffset", "Rebin req."));
                this.m_projectTable.putString(row, this.m_indexMaxOffset, pt.string_get("MaxOffset", "Rebin req."));
            }
            this.m_tableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean isProjectSelected() {
        try {
            int row = this.m_scrollTable.table().getSelectedRow();
            return row >= 0 && row < this.m_projectTable.row_count();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public ArrayList<String> getProjectNames() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            int[] rows = this.m_scrollTable.table().getSelectedRows();
            if (rows != null) {
                for (int n = 0; n < rows.length; ++n) {
                    String name = this.m_projectTable.getString(rows[n], this.m_indexName);
                    list.add(name);
                    System.out.println("getProjectNames " + name);
                }
            }
            return list;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return new ArrayList<String>();
        }
    }

    public String getProjectName() {
        try {
            if (!this.isProjectSelected()) {
                return "";
            }
            int row = this.m_scrollTable.table().getSelectedRow();
            String name = this.m_projectTable.getString(row, this.m_indexName);
            return name;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

