/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;

public class TraceTableScannerDialog
extends JDialog
implements ActionListener,
ITraceTableScannerMonitor {
    protected JProgressBar m_progress = new JProgressBar();
    protected JTextField m_text = new JTextField("");
    protected TraceTable_ScannerBase m_scanner;
    protected boolean m_started = false;
    protected Timer m_timer = new Timer(100, this);
    protected int m_timerCount = 0;

    public TraceTableScannerDialog(TraceTable_ScannerBase scanner, String title) {
        try {
            this.m_scanner = scanner;
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            middle.addComponent(this.m_text, 0);
            middle.addComponent(this.m_progress, 0);
            this.m_progress.setMinimum(0);
            this.m_progress.setMaximum(1000);
            this.getContentPane().add((Component)middle, "Center");
            this.m_timer.start();
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 300, this.getSize().height);
            this.setTitle(title);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
        try {
            this.m_text.setText(message);
            this.m_text.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                System.out.println("e.getSource() == m_timer, m_timerCount = " + this.m_timerCount);
                ++this.m_timerCount;
                if (this.m_timerCount < 3) {
                    return;
                }
                this.m_timer.stop();
                this.m_timer = null;
                if (!this.m_started) {
                    this.m_started = true;
                    this.m_scanner.scan(RefractionStaticsProject.singleton().traceTableWrapper().traceTable(), this);
                    System.out.println("scanner completed?");
                    this.dispose();
                } else {
                    System.out.println("scanner done?");
                    this.dispose();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

