/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleSnapshots;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableObjectData;
import com.PecosLibrary.Windows.Java2D.Java2D_XAxisImage;
import com.PecosLibrary.Windows.Java2D.Java2D_YAxisImage;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Ensemble_Wiggles;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleAxisSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleGroupControllerWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleVisibleTraceSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickDisplayWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickPlaneCombo;
import com.PecosLibrary.Windows.Refraction.Picking.TraceBackgroundWidget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class SnapshotWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected JLabel m_errorLabel = new JLabel(" ");
    protected JButton m_button;
    protected JTextField m_nameText = new JTextField("Version1");
    protected JTextField m_widthText = new JTextField("600");
    protected JTextField m_heightText = new JTextField("400");
    protected JProgressBar m_progress = new JProgressBar();
    public Java2D_AxisLocker AxisLockerOffset;
    public Java2D_AxisLocker AxisLockerTime;
    public EnsembleWorker_Sequence Sequence;
    public TraceBackgroundWidget BackgroundWidget;
    public Java2D_EnsembleDisplayOptionsWidget WiggleOptionsWidget;
    public PickDisplayWidget PickDisplayWidget;
    public EnsembleVisibleTraceSelectionWidget VisibleWidget;
    public EnsembleGroupControllerWidget GroupControllerWidget;
    public EnsembleAxisSelectionWidget AxisWidget;
    public PickPlaneCombo PlaneCombo;

    public SnapshotWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.createGapLabel(12);
            String dir = "<HTML>A snapshot of each shot is saved on disk. These snapshots may be viewed very rapidly in the \"Snapshot QC\" window.  \"Grouping\" must be off. Must be in shot plane.</HTML>";
            this.addComponent(new JLabel(dir), 0);
            this.createGapLabel(12);
            GridLayoutWidget w = this.createGridLayoutWidget(0, 0);
            w.addSimple(0, new JLabel("Name"), this.m_nameText);
            w.addSimple(1, new JLabel("Pixel width"), this.m_widthText);
            w.addSimple(2, new JLabel("Pixel height"), this.m_heightText);
            this.createGapLabel(12);
            this.addComponent(this.m_errorLabel, 0);
            this.createGapLabel(12);
            this.m_button = this.createButton("Create snapshots", this, 0);
            this.addComponent(this.m_progress, 0);
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setStatus() {
        try {
            this.m_errorLabel.setText(" ");
            this.m_button.setEnabled(false);
            if (this.PlaneCombo.getPickPlane() != PickPlaneEnum.Shot) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Currently only works for shots");
                return;
            }
            if (!this.GroupControllerWidget.isGroupingOff()) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Grouping must be turned off");
                return;
            }
            this.m_errorLabel.setForeground(Color.blue);
            this.m_errorLabel.setText("Okay to start...");
            this.m_button.setEnabled(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setListeners() {
        try {
            this.GroupControllerWidget.listener().addListener(this);
            this.PlaneCombo.getListenerController().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeImages() {
        try {
            String version = this.m_nameText.getText();
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String projectPath = project.projectPath();
            String snapPathRoot = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "SnapshotVersions");
            String snapPath = Tools_FileSystem.confirmSubDirectoryExists(snapPathRoot, version);
            Tools_FileSystem.deletePathIfExists(snapPath);
            snapPath = Tools_FileSystem.confirmSubDirectoryExists(snapPathRoot, version);
            Table_Abstract table = project.shotTable();
            int colID = table.column_indexOfColumn("ShotID");
            int colKilled = table.column_indexOfColumn("Killed");
            int max = table.row_count();
            this.m_progress.setMaximum(max);
            this.m_progress.setValue(0);
            this.m_progress.paintImmediately(0, 0, 400, 24);
            int width = Tools_Widget.extractInteger(this.m_widthText, 500, 300, 2000);
            int height = Tools_Widget.extractInteger(this.m_heightText, 500, 300, 2000);
            int axisWidth = 60;
            int axisHeight = 40;
            Java2D_XAxisImage imageX = new Java2D_XAxisImage();
            Java2D_YAxisImage imageY = new Java2D_YAxisImage();
            BufferedImage compositeImage = new BufferedImage(width + axisWidth, height + axisHeight, 2);
            Java2D_EnsembleSnapshots snapshots = new Java2D_EnsembleSnapshots(width, height);
            snapshots.Transform.setAxisLockedX(this.AxisLockerOffset.locked(), this.AxisLockerOffset.min(), this.AxisLockerOffset.max());
            snapshots.Transform.setAxisLockedY(this.AxisLockerTime.locked(), this.AxisLockerTime.min(), this.AxisLockerTime.max());
            Java2D_Paintable_Ensemble_Wiggles wigglePainter = new Java2D_Paintable_Ensemble_Wiggles();
            if (this.AxisWidget.isUniformSpacing()) {
                wigglePainter.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            } else {
                wigglePainter.setAxisTableColumn(this.AxisWidget.getAxisTable(), this.AxisWidget.getAxisColumn());
                wigglePainter.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            }
            Java2D_PaintableObjectData pod = new Java2D_PaintableObjectData();
            pod.Paintable = wigglePainter;
            pod.Supplemental = -9999;
            snapshots.BufferedImageWrapper.displayList().add(pod);
            this.WiggleOptionsWidget.prepPainter(wigglePainter);
            Ensemble ensemble = new Ensemble();
            Ensemble ensembleCopy = new Ensemble();
            for (int n = 0; n < max; ++n) {
                this.m_progress.setValue(n);
                this.m_progress.paintImmediately(0, 0, 400, 24);
                ensemble.clearTraces(false);
                int id = table.getInt(n, colID);
                boolean killed = table.getBool(n, colKilled);
                if (killed) continue;
                project.ensemble_Shot(ensemble, id, true);
                ensemble.resetAllKillFlags();
                ensemble.copyToOtherEnsemble(ensembleCopy);
                ensembleCopy.pickPlotData().clearRequiredList();
                Ensemble processedEnsemble = this.Sequence.work(ensembleCopy);
                this.AxisWidget.setEnsembleHeaderDictionary(processedEnsemble.dictionary());
                this.VisibleWidget.setEnsembleHeaderDictionary(processedEnsemble.dictionary());
                this.PickDisplayWidget.prepEnsemble(processedEnsemble);
                this.VisibleWidget.setVisibleTraces(processedEnsemble);
                this.BackgroundWidget.setBackground(processedEnsemble);
                if (this.AxisWidget.isUniformSpacing()) {
                    this.AxisWidget.sortEnsemble(processedEnsemble);
                }
                wigglePainter.setEnsemble(processedEnsemble);
                snapshots.forcePaint();
                BufferedImage image = snapshots.BufferedImageWrapper.image();
                BufferedImage axisX = imageX.image(width, axisHeight, snapshots.Transform.actualLeft(), snapshots.Transform.actualRight());
                BufferedImage axisY = imageY.image(axisWidth, height, snapshots.Transform.actualTop(), snapshots.Transform.actualBottom());
                Graphics2D g2d = compositeImage.createGraphics();
                g2d.drawImage((Image)axisX, axisWidth, 0, null);
                g2d.drawImage((Image)axisY, 0, axisHeight, null);
                g2d.drawImage((Image)image, axisWidth, axisHeight, null);
                g2d = null;
                String fileName = String.format("%s/Shot_%d.png", snapPath, id);
                File file = new File(fileName);
                ImageIO.write((RenderedImage)compositeImage, "png", file);
            }
            this.m_progress.setValue(0);
            this.m_progress.paintImmediately(0, 0, 400, 24);
            System.gc();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_button) {
                this.makeImages();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

