/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableObjectData;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_EnsembleOverlay;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_DragFixedLine;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Selector;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class PickerBasemapWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener {
    protected JButton m_reloadButton;
    protected ArrayList<WeakReference<Listener>> m_listeners = new ArrayList();
    protected Java2D_SimpleComposite m_widget;
    protected PickPlaneEnum m_pickPlane = PickPlaneEnum.Shot;
    protected JButton m_reloadComboButton;
    protected ComboStringListWrapper m_cCombo = new ComboStringListWrapper("Elevation");
    protected ArrayList<String> m_colList = null;
    protected JCheckBox m_chkDrawOverlay = new JCheckBox("Overlay");
    protected JCheckBox m_chkDrawOther = new JCheckBox("Rec");
    protected JCheckBox m_chkDrawMove = new JCheckBox("Moved");
    protected JCheckBox m_chkDrawErr = new JCheckBox("Error");
    protected JCheckBox m_chkMultiSelect = new JCheckBox("Show popup list of nearby shots/receivers");
    protected JComboBox<String> m_mouseModeCombo = new JComboBox();
    protected boolean m_ignoreCombo = true;
    protected JButton m_killPolygonButton;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected boolean m_mapView = false;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_Selector m_selectorUEC;
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEC;
    protected Java2D_UserEventConsumer_DragFixedLine m_dragUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = null;
    protected Java2D_Paintable_EnsembleOverlay m_overlay = new Java2D_Paintable_EnsembleOverlay();
    protected Ensemble m_sparseEnsemble = new Ensemble();
    protected ArrayList<Java2D_PaintableObjectData> m_underlayList = new ArrayList();

    public Ensemble sparseEnsemble() {
        return this.m_sparseEnsemble;
    }

    public PickerBasemapWidget(Listener listener) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_listeners.add(new WeakReference<Listener>(listener));
            LinearLayoutWidget chks = LinearLayoutWidget.horz(0, null);
            chks.addComponent(this.m_chkDrawOverlay, 0);
            chks.addComponent(this.m_chkDrawOther, 0);
            chks.addComponent(this.m_chkDrawErr, 0);
            chks.addComponent(this.m_chkDrawMove, 10);
            this.m_chkDrawErr.setSelected(true);
            this.m_chkDrawErr.addActionListener(this);
            this.m_chkDrawOverlay.setSelected(true);
            this.m_chkDrawOverlay.addActionListener(this);
            this.m_chkDrawOther.setSelected(true);
            this.m_chkDrawOther.addActionListener(this);
            this.m_chkDrawMove.setSelected(true);
            this.m_chkDrawMove.addActionListener(this);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, 0);
            int row = 0;
            this.m_reloadButton = grid.createButton("Reload plot", this, row, 0);
            grid.addComponent(chks, row, 1, 0.0, 0.0);
            this.m_reloadComboButton = grid.createButton("Reload", this, ++row, 0);
            grid.addComponent(this.m_cCombo, row, 1, 0.0, 10.0, 1, 2);
            this.m_cCombo.listener().addListener(this);
            this.m_killPolygonButton = grid.createButton("Clear polygon", this, ++row, 0);
            grid.addComponent(this.m_mouseModeCombo, row, 1, 0.0, 10.0, 1, 2);
            ++row;
            this.m_mouseModeCombo.addItem("Select");
            this.m_mouseModeCombo.addItem("Define the polygon");
            this.m_mouseModeCombo.setSelectedIndex(0);
            this.m_mouseModeCombo.addItemListener(this);
            this.m_widget = new Java2D_SimpleComposite(true);
            this.m_widget.setAxesVisible(false, false);
            this.m_widget.setScrollVisible(true, true);
            this.m_chkMultiSelect.setSelected(false);
            this.m_chkMultiSelect.addActionListener(this);
            this.addComponent(this.m_chkMultiSelect, 0);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.addComponent(this.m_widget, 10);
            this.reloadCombo();
            this.reloadPlot(true);
            this.reloadMouse();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setKeyPressedUEC(Java2D_UserEventConsumer_KeyPressed uec) {
        try {
            this.m_keyUEC = uec;
            this.reloadMouse();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void drawBFD(boolean draw) {
        try {
            this.m_overlay.DrawMassiveDot = draw;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            boolean needReloadPlot;
            boolean bl = needReloadPlot = message == Messenger.Message.ProjectPolygonModified || message == Messenger.Message.ProjectVersionChanged || message == Messenger.Message.ReceiverGeometryChanged || message == Messenger.Message.ShotGeometryChanged || message == Messenger.Message.ShotKilled || message == Messenger.Message.ReceiverKilled;
            if (needReloadPlot) {
                this.reloadPlot(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void lockCurrentViewport() {
        try {
            this.widget().lockCurrentViewport();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unlockCurrentViewport() {
        try {
            this.widget().unlockCurrentViewport();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addListener(Listener listener) {
        try {
            if (listener != null) {
                this.m_listeners.add(new WeakReference<Listener>(listener));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Java2D_Paintable_Table createPT(String tableName, String colX, String colY, String colC) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            String colID = tableName + "ID";
            painter.setDefaultWorldSize();
            painter.DrawErrorVectors = false;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            boolean hasError = false;
            if (tableName.equalsIgnoreCase("Shot")) {
                hasError = p.shotTable().column_exists("GeomErr_Dist");
            }
            if (tableName.equalsIgnoreCase("Receiver")) {
                hasError = p.receiverTable().column_exists("GeomErr_Dist");
            }
            if (colC != null) {
                painter.DrawErrorVectors = hasError && this.m_chkDrawErr.isSelected();
                String query = "";
                query = painter.DrawErrorVectors ? String.format("SELECT  %s, %s, %s, %s, %s, %s, %s, %s FROM %s WHERE KILLED = FALSE", "InitialEasting", "InitialNorthing", "GeomErr_Dist", "GeomErr_Az", colX, colY, colC, colID, tableName) : String.format("SELECT  %s, %s, %s, %s, %s, %s FROM %s WHERE KILLED = FALSE", "InitialEasting", "InitialNorthing", colX, colY, colC, colID, tableName);
                Table_Abstract table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.setAxisC(colC);
                painter.UseColorScale = true;
                painter.Symbol = Java2D_PointSymbol.FilledSquare;
                painter.DrawMoveVectors = this.m_chkDrawMove.isSelected();
            } else {
                String query = String.format("SELECT  %s, %s, %s FROM %s WHERE KILLED = FALSE", colX, colY, colID, tableName);
                Table_Abstract table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.UseColorScale = false;
                painter.FixedColor = Color.LIGHT_GRAY;
                painter.Symbol = Java2D_PointSymbol.Plus;
                painter.DrawMoveVectors = false;
            }
            painter.setAxisX(colX);
            painter.setAxisY(colY);
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void setMouseID(int shotID, int recID) {
        try {
            this.m_overlay.MouseReceiverID = recID;
            this.m_overlay.MouseShotID = shotID;
            this.m_widget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void associatedEnsembleWidgetJustPainted(Ensemble ensemble) {
        try {
            if (this.m_dragUEC != null && this.m_dragUEC.Valid && this.m_dragUEC.Dragging) {
                return;
            }
            this.m_overlay.m_ensemble = ensemble;
            this.m_widget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_SimpleComposite widget() {
        return this.m_widget;
    }

    public void reloadDelayTimePlot() {
        try {
            boolean ok;
            if (this.m_colList == null) {
                return;
            }
            String col = this.m_cCombo.getSelectedString();
            boolean bl = ok = col.equalsIgnoreCase("GeomErr_Dist") || col.equalsIgnoreCase("GeomErr_Az") || col.startsWith("DTA_DelayTime_") || col.startsWith("DTA_");
            if (ok) {
                this.reloadPlot(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearUnderlayList() {
        this.m_underlayList.clear();
    }

    public void addUnderlay(Java2D_PaintableInterface p, int supplemental) {
        try {
            if (p == null) {
                return;
            }
            Java2D_PaintableObjectData pod = new Java2D_PaintableObjectData();
            pod.Paintable = p;
            pod.Supplemental = supplemental;
            this.m_underlayList.add(pod);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setForceDrawLines(boolean forceDrawLines) {
        try {
            this.m_overlay.ForceDrawLines = forceDrawLines;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadPlot(boolean unzoom) {
        try {
            Java2D_Polygon poly;
            this.m_overlay.MouseReceiverID = -9999;
            this.m_overlay.MouseShotID = -9999;
            if (!unzoom) {
                this.widget().lockCurrentViewport();
            }
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearPaintableList();
            for (Java2D_PaintableObjectData pod : this.m_underlayList) {
                w.addPaintable(pod.Paintable, pod.Supplemental);
            }
            String colNameX = "Easting";
            String colNameY = "Northing";
            String colNameC = "Elevation";
            if (this.m_colList != null) {
                colNameC = this.m_cCombo.getSelectedString();
            }
            this.m_overlay.ColumnX = colNameX;
            this.m_overlay.ColumnY = colNameY;
            boolean bl = this.m_mapView = colNameX.equalsIgnoreCase("Easting") && colNameY.equalsIgnoreCase("Northing");
            if (this.m_mapView && (poly = RefractionStaticsProject.singleton().polygon()).valid()) {
                w.addPaintable(poly, -9999);
            }
            this.m_receiverPaintable = null;
            this.m_shotPaintable = null;
            if (this.m_pickPlane == PickPlaneEnum.Sparse) {
                this.m_shotPaintable = this.createPT("Shot", colNameX, colNameY, null);
                w.addPaintable(this.m_shotPaintable, -9999);
                this.m_receiverPaintable = this.createPT("Receiver", colNameX, colNameY, null);
                w.addPaintable(this.m_receiverPaintable, -9999);
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                if (sparse.size() > 0) {
                    Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray(sparse);
                    w.addPaintable(pa, -9999);
                }
            }
            if (this.m_pickPlane == PickPlaneEnum.Bin) {
                this.m_shotPaintable = this.createPT("Shot", colNameX, colNameY, colNameC);
                w.addPaintable(this.m_shotPaintable, -9999);
                this.m_receiverPaintable = this.createPT("Receiver", colNameX, colNameY, colNameC);
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            if (this.m_pickPlane == PickPlaneEnum.Shot) {
                if (this.m_mapView && this.m_chkDrawOther.isSelected()) {
                    this.m_receiverPaintable = this.createPT("Receiver", colNameX, colNameY, null);
                    w.addPaintable(this.m_receiverPaintable, -9999);
                }
                this.m_shotPaintable = this.createPT("Shot", colNameX, colNameY, colNameC);
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                if (this.m_mapView && this.m_chkDrawOther.isSelected()) {
                    this.m_shotPaintable = this.createPT("Shot", colNameX, colNameY, null);
                    w.addPaintable(this.m_shotPaintable, -9999);
                }
                this.m_receiverPaintable = this.createPT("Receiver", colNameX, colNameY, colNameC);
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            if (this.m_pickPlane == PickPlaneEnum.Offset) {
                this.m_shotPaintable = this.createPT("Shot", colNameX, colNameY, colNameC);
                w.addPaintable(this.m_shotPaintable, -9999);
                this.m_receiverPaintable = this.createPT("Receiver", colNameX, colNameY, colNameC);
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            this.m_overlay.PickPlane = this.m_pickPlane;
            w.addPaintable(this.m_overlay, -9999);
            if (this.m_mapView) {
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            } else {
                w.transform().setTechnique(Java2D_Transform.Technique.Normal);
            }
            this.m_widget.setHorizontalTitle(colNameX);
            this.m_widget.setVerticalTitle(colNameY);
            this.m_widget.setColorTitle(colNameC);
            w.mooz();
            this.reloadMouse();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.widget().unlockCurrentViewport();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMouse() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearEventConsumerList();
            w.addZoomer();
            if (this.m_keyUEC != null) {
                w.addEventConsumer(this.m_keyUEC);
            }
            if (this.m_dragUEC == null) {
                this.m_dragUEC = new Java2D_UserEventConsumer_DragFixedLine();
                this.m_dragUEC.addListener(this);
            }
            if (this.m_selectorUEC == null) {
                this.m_selectorUEC = new Java2D_UserEventConsumer_Selector(w);
                this.m_selectorUEC.addListener(this);
            }
            this.m_selectorUEC.MultiSelect = this.m_chkMultiSelect.isSelected();
            if (this.m_leftClickUEC == null) {
                this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
                this.m_leftClickUEC.addListener(this);
            }
            if (this.m_mouseModeCombo.getSelectedIndex() == 2) {
                this.m_dragUEC.Valid = false;
                if (this.m_pickPlane == PickPlaneEnum.Shot) {
                    this.m_dragUEC.setEnsemble(this.m_overlay.m_ensemble, "Shot");
                }
                if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                    this.m_dragUEC.setEnsemble(this.m_overlay.m_ensemble, "Receiver");
                }
                if (this.m_dragUEC.Valid) {
                    w.addEventConsumer(this.m_dragUEC);
                } else {
                    System.err.println("reloadMouse: m_dragUEC.Valid = false;");
                }
                return;
            }
            if (this.m_mouseModeCombo.getSelectedIndex() == 0) {
                if (this.m_pickPlane == PickPlaneEnum.Bin || this.m_pickPlane == PickPlaneEnum.Sparse) {
                    w.addEventConsumer(this.m_leftClickUEC);
                    return;
                }
                if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                    w.addEventConsumer(this.m_selectorUEC);
                    this.m_selectorUEC.PaintableTable = this.m_receiverPaintable;
                    return;
                }
                if (this.m_pickPlane == PickPlaneEnum.Shot) {
                    w.addEventConsumer(this.m_selectorUEC);
                    this.m_selectorUEC.PaintableTable = this.m_shotPaintable;
                    return;
                }
            }
            if (this.m_mouseModeCombo.getSelectedIndex() == 1) {
                if (this.m_polygonUEC == null) {
                    this.m_polygonUEC = new Java2D_UserEventConsumer_MultiLineSegments();
                    this.m_polygonUEC.addListener(this);
                    this.m_polygonUEC.DefiningPolygon = true;
                }
                w.addEventConsumer(this.m_polygonUEC);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadCombo() {
        try {
            this.m_colList = null;
            if (this.m_pickPlane == PickPlaneEnum.Shot) {
                this.m_colList = this.database().listOfColumnNames("Shot");
            }
            if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                this.m_colList = this.database().listOfColumnNames("Receiver");
            }
            if (this.m_pickPlane == PickPlaneEnum.Bin) {
                this.m_colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            if (this.m_pickPlane == PickPlaneEnum.Sparse) {
                this.m_colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            if (this.m_pickPlane == PickPlaneEnum.Offset) {
                this.m_colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            this.m_cCombo.removeAllItems();
            this.m_cCombo.setEnabled(this.m_colList != null);
            if (this.m_colList != null) {
                this.m_cCombo.setStringArray(this.m_colList);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        try {
            this.m_pickPlane = pickPlane;
            this.m_ignoreCombo = true;
            int index = this.m_mouseModeCombo.getSelectedIndex();
            this.m_mouseModeCombo.removeAllItems();
            if (this.m_pickPlane == PickPlaneEnum.Shot) {
                this.m_mouseModeCombo.addItem("Select a shot");
            }
            if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                this.m_mouseModeCombo.addItem("Select a receiver");
            }
            if (this.m_pickPlane == PickPlaneEnum.Bin) {
                this.m_mouseModeCombo.addItem("Select a CMP");
            }
            if (this.m_pickPlane == PickPlaneEnum.Sparse) {
                this.m_mouseModeCombo.addItem("Select a Sparse CMP");
            }
            if (this.m_pickPlane == PickPlaneEnum.Shot) {
                this.m_chkDrawOther.setText("Rec");
            }
            if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                this.m_chkDrawOther.setText("Src");
            }
            this.m_chkDrawOther.setVisible(this.m_pickPlane != PickPlaneEnum.Bin);
            this.m_mouseModeCombo.addItem("Define the polygon");
            this.m_mouseModeCombo.setSelectedIndex(index);
            if (this.m_pickPlane == PickPlaneEnum.Shot) {
                this.m_mouseModeCombo.addItem("Drag the shot");
            }
            if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                this.m_mouseModeCombo.addItem("Drag the receiver");
            }
            this.m_ignoreCombo = false;
            this.reloadCombo();
            this.reloadPlot(true);
            this.reloadMouse();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createTop() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_mouseModeCombo) {
                if (this.m_ignoreCombo) {
                    return;
                }
                this.reloadMouse();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_chkDrawOther || e.getSource() == this.m_chkDrawMove || e.getSource() == this.m_chkDrawErr) {
                this.reloadPlot(false);
                return;
            }
            if (e.getSource() == this.m_chkMultiSelect) {
                this.reloadMouse();
                return;
            }
            if (e.getSource() == this.m_chkDrawOverlay) {
                this.m_overlay.Draw = this.m_chkDrawOverlay.isSelected();
                this.m_widget.repaint();
                return;
            }
            if (e.getSource() == this.m_reloadComboButton) {
                this.reloadCombo();
                return;
            }
            if (e.getSource() == this.m_reloadButton) {
                this.reloadPlot(false);
                return;
            }
            if (this.m_killPolygonButton == e.getSource()) {
                project.polygon().clear();
                project.savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getClickPixelX() {
        return this.m_leftClickUEC.PixelX;
    }

    public int getClickPixelY() {
        return this.m_leftClickUEC.PixelY;
    }

    public double getClickWorldX() {
        return this.m_leftClickUEC.WorldX;
    }

    public double getClickWorldY() {
        return this.m_leftClickUEC.WorldY;
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_cCombo) {
                this.reloadPlot(false);
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (sender == this.m_dragUEC) {
                if (this.m_dragUEC.Dragging) {
                    for (WeakReference<Listener> weak : this.m_listeners) {
                        Listener l = (Listener)weak.get();
                        if (l == null) continue;
                        if (this.m_pickPlane == PickPlaneEnum.Shot) {
                            l.handleBasemap_ShotDrag(this.m_dragUEC.EndWorldX, this.m_dragUEC.EndWorldY);
                        }
                        if (this.m_pickPlane != PickPlaneEnum.Receiver) continue;
                        l.handleBasemap_ReceiverDrag(this.m_dragUEC.EndWorldX, this.m_dragUEC.EndWorldY);
                    }
                    return;
                }
                if (this.m_dragUEC.JustReleased) {
                    this.m_mouseModeCombo.setSelectedIndex(0);
                    for (WeakReference<Listener> weak : this.m_listeners) {
                        Listener l = (Listener)weak.get();
                        if (l == null) continue;
                        if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                            l.handleBasemap_ReceiverDragFinish(this.m_dragUEC.EndWorldX, this.m_dragUEC.EndWorldY);
                        }
                        if (this.m_pickPlane != PickPlaneEnum.Shot) continue;
                        l.handleBasemap_ShotDragFinish(this.m_dragUEC.EndWorldX, this.m_dragUEC.EndWorldY);
                    }
                    return;
                }
            }
            if (sender == this.m_polygonUEC) {
                if (this.m_polygonUEC.Dragging) {
                    return;
                }
                if (!this.m_polygonUEC.Finished) {
                    return;
                }
                int num = this.m_polygonUEC.numPoints();
                if (this.m_polygonUEC.numPoints() < 3) {
                    return;
                }
                Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
                p.X = new double[num];
                p.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    p.X[n] = this.m_polygonUEC.getX(n);
                    p.Y[n] = this.m_polygonUEC.getY(n);
                }
                RefractionStaticsProject.singleton().savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, sender, null);
                return;
            }
            if (sender == this.m_selectorUEC) {
                int id;
                if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                    id = this.m_selectorUEC.SelectedID;
                    if (id < 0) {
                        return;
                    }
                    for (WeakReference<Listener> weak : this.m_listeners) {
                        Listener listener = (Listener)weak.get();
                        if (listener == null || this.m_selectorUEC.PlotIndex >= 0) continue;
                        listener.handleBasemap_ReceiverSelected(id);
                    }
                }
                if (this.m_pickPlane == PickPlaneEnum.Shot) {
                    id = this.m_selectorUEC.SelectedID;
                    if (id < 0) {
                        return;
                    }
                    for (WeakReference<Listener> weak : this.m_listeners) {
                        Listener listener = (Listener)weak.get();
                        if (listener == null) continue;
                        if (this.m_selectorUEC.PlotIndex >= 0) {
                            listener.handleBasemap_ShotSelected(id, this.m_selectorUEC.PlotIndex);
                            continue;
                        }
                        listener.handleBasemap_ShotSelected(id);
                    }
                }
                return;
            }
            if (sender == this.m_leftClickUEC) {
                Listener l;
                if (this.m_pickPlane == PickPlaneEnum.Bin && this.m_mapView && project.dim2D()) {
                    int bin = project.getGrid2D_Conversion().getBin(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    if (this.m_leftClickUEC.ControlDown) {
                        Messenger.broadcastBin2DSelected(this, bin);
                    } else {
                        for (WeakReference<Listener> weak : this.m_listeners) {
                            Listener listener = (Listener)weak.get();
                            if (listener == null) continue;
                            listener.handleBasemap_Bin2DSelected(bin);
                        }
                    }
                }
                if (this.m_pickPlane == PickPlaneEnum.Sparse && this.m_mapView && project.dim3D()) {
                    RefractionStaticsProject p = RefractionStaticsProject.singleton();
                    SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                    sparse.selectNearestCMP(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, this.m_sparseEnsemble);
                    p.traceTableWrapper().traceTable().fillEnsembleHeaders(this.m_sparseEnsemble);
                    p.prepGeometryHeaders(this.m_sparseEnsemble, true, true);
                    p.inputDataProcessor_Run(this.m_sparseEnsemble);
                    for (WeakReference weakReference : this.m_listeners) {
                        l = (Listener)weakReference.get();
                        if (l == null) continue;
                        l.handleBasemap_SparseCMPSelected(this.m_sparseEnsemble);
                    }
                }
                if (this.m_pickPlane == PickPlaneEnum.Bin && this.m_mapView && project.dim3D()) {
                    project.getGrid3D_Conversion().setWorldLocation(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    int inline = project.getGrid3D_Conversion().Inline;
                    int crossline = project.getGrid3D_Conversion().Crossline;
                    if (this.m_leftClickUEC.ControlDown) {
                        Messenger.broadcastBin3DSelected(this, inline, crossline);
                    } else {
                        for (WeakReference weakReference : this.m_listeners) {
                            l = (Listener)weakReference.get();
                            if (l == null) continue;
                            l.handleBasemap_Bin3DSelected(inline, crossline);
                        }
                    }
                }
                if (this.m_pickPlane == PickPlaneEnum.Shot) {
                    int id = this.m_shotPaintable.getNearestID(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY);
                    if (id < 0) {
                        return;
                    }
                    if (this.m_leftClickUEC.ControlDown) {
                        Messenger.broadcastShotSelected(this, id);
                    } else {
                        for (WeakReference<Listener> weak : this.m_listeners) {
                            Listener listener = (Listener)weak.get();
                            if (listener == null) continue;
                            listener.handleBasemap_ShotSelected(id);
                        }
                    }
                }
                if (this.m_pickPlane == PickPlaneEnum.Receiver) {
                    int id = this.m_receiverPaintable.getNearestID(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY);
                    if (id < 0) {
                        return;
                    }
                    if (this.m_leftClickUEC.ControlDown) {
                        Messenger.broadcastReceiverSelected(this, id);
                    } else {
                        for (WeakReference<Listener> weak : this.m_listeners) {
                            Listener listener = (Listener)weak.get();
                            if (listener == null) continue;
                            listener.handleBasemap_ReceiverSelected(id);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static interface Listener {
        public void handleBasemap_SparseCMPSelected(Ensemble var1);

        public void handleBasemap_Bin2DSelected(int var1);

        public void handleBasemap_Bin3DSelected(int var1, int var2);

        public void handleBasemap_ShotSelected(int var1);

        public void handleBasemap_ShotSelected(int var1, int var2);

        public void handleBasemap_ShotDrag(double var1, double var3);

        public void handleBasemap_ShotDragFinish(double var1, double var3);

        public void handleBasemap_ReceiverSelected(int var1);

        public void handleBasemap_ReceiverDrag(double var1, double var3);

        public void handleBasemap_ReceiverDragFinish(double var1, double var3);
    }
}

