/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Export.Action_ExportBinaryGLI;
import com.PecosLibrary.Action.Export.Action_ExportBinaryGLI_All;
import com.PecosLibrary.Action.Export.Action_ExportGLI;
import com.PecosLibrary.Action.Export.Action_ExportGLI_LPI;
import com.PecosLibrary.Action.Export.Action_ExportNumPy;
import com.PecosLibrary.Action.Export.Action_ExportSeisupMatrix;
import com.PecosLibrary.Action.Export.Action_ExportSyntheticBinaryGLI;
import com.PecosLibrary.Action.Import.Action_ImportSeisupMatrix;
import com.PecosLibrary.Action.QC.Action_UnkillTraces;
import com.PecosLibrary.Action.TraceTable.Action_InteractiveTrend;
import com.PecosLibrary.Action.TraceTable.Action_PickCount;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_LayerSyn;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_V0PlusKZ;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.LinearMoveoutTrendDialog_Picks;
import com.PecosLibrary.Windows.Refraction.LinearMoveoutTrendDialog_Traces;
import com.PecosLibrary.Windows.Refraction.Picking.AddPickVersionDialog;
import com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_MultiplePanel;
import com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_MultipleProfilePanel;
import com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_V2;
import com.PecosLibrary.Windows.Refraction.Picking.EnergyWindowDialog;
import com.PecosLibrary.Windows.Refraction.Picking.NoiseComputationDialog;
import com.PecosLibrary.Windows.Refraction.Picking.Offset2DPickWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickCopyDialog;
import com.PecosLibrary.Windows.Refraction.Picking.PickImportWithCoordsDialog;
import com.PecosLibrary.Windows.Refraction.Picking.PickKillDialog;
import com.PecosLibrary.Windows.Refraction.Picking.PickSimpleMathDialog;
import com.PecosLibrary.Windows.Refraction.Picking.SolutionsStackWidget_General;
import com.PecosLibrary.Windows.Refraction.Picking.TraceColumnExportDialog;
import com.PecosLibrary.Windows.Segy.ExportSegyNumPyDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Synthetic.ExportSyntheticBinaryGLIDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Menu_Picking
implements ActionListener {
    protected JMenu m_menu = new JMenu("Picking");
    protected JMenuItem m_menuItem_SelectOffsetBinSize;
    protected JMenuItem m_menuItem_SimplePickerV2_Standard;
    protected JMenuItem m_menuItem_SimplePickerV2_Offset;
    protected JMenuItem m_menuItem_SimplePickerV2_OffsetProfile;
    protected JMenuItem m_menuItem_SimplePickerV2_OffsetInlineCrossline;
    protected JMenuItem m_menuItem_MultiPanelPicker;
    protected JMenuItem m_menuItem_MultiProfilePanelPicker;
    protected JMenuItem m_menuItem_Offset2DPicker;
    protected JMenuItem m_menuItem_GeneralStacks;
    protected JMenuItem m_menuItem_Trend;
    protected JMenuItem m_menuItem_Trend_Picks;
    protected JMenuItem m_menuItem_InitialEnergy;
    protected JMenuItem m_menuItem_NoiseLevel;
    protected JMenuItem m_menuItem_UnkillTraces;
    protected JMenuItem m_menuItem_PrepInteractiveTrend;
    protected JMenuItem m_menuItem_PickCount;
    protected JMenuItem m_menuItem_ExportGLI;
    protected JMenuItem m_menuItem_ExportGLI_LPI;
    protected JMenuItem m_menuItem_ExportGLI_Binary;
    protected JMenuItem m_menuItem_ExportGLI_Binary_All;
    protected JMenuItem m_menuItem_ExportGLI_Binary_Synthetic;
    protected JMenuItem m_menuItem_ExportShotToNumPy;
    protected JMenuItem m_menuItem_ExportSeisUP;
    protected JMenuItem m_menuItem_ImportSeisUP;
    protected JMenu m_menuPickIO = new JMenu("Pick import/export");
    protected JMenuItem m_menuItem_ImportCoords;
    protected JMenuItem m_menuItem_ExportCoords_ASCII;
    protected JMenuItem m_menuItem_ExportCoords_Binary;
    protected JMenuItem m_menuItem_ImportFFIDCHAN;
    protected JMenuItem m_menuItem_ExportFFIDCHAN;
    protected JMenuItem m_menuItem_ImportFFIDPOINT;
    protected JMenuItem m_menuItem_ExportFFIDPOINT;
    protected JMenuItem m_menuItem_ImportCombined;
    protected JMenuItem m_menuItem_ExportCombined;
    protected JMenuItem m_menuItem_ImportSeparate;
    protected JMenuItem m_menuItem_ExportSeparate;
    protected JMenu m_menuPickManipulation = new JMenu("Pick manipulation");
    protected JMenuItem m_menuItem_AddPick;
    protected JMenuItem m_menuItem_CopyPick;
    protected JMenuItem m_menuItem_PickMath;
    protected JMenuItem m_menuItem_ExportPick;
    protected JMenuItem m_menuItem_KillPick;
    protected JMenuItem m_menuItem_KillPickInsideOffset;
    protected JMenuItem m_menuItem_PickMultiply;
    protected JMenuItem m_menuItem_SynV0KZ;
    protected JMenuItem m_menuItem_SynLayers;
    protected AddPickVersionDialog m_pickAddDialog = new AddPickVersionDialog();
    protected TraceColumnExportDialog m_exportDialog = new TraceColumnExportDialog();
    protected PickKillDialog m_killDialog = new PickKillDialog(false);
    protected PickKillDialog m_killOffsetDialog = new PickKillDialog(true);
    protected ExportSyntheticBinaryGLIDialog m_syntheticGLIDialog;
    protected ExportSegyNumPyDialog m_exportSegyNumPyDialog;
    protected EnergyWindowDialog m_energyDialog;
    MultiTextDialog m_dlg;
    MultiTextDialog m_dlg2;
    protected NoiseComputationDialog m_noiseDialog;

    public Menu_Picking(JMenuBar menuBar) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String origin = project.information().string_get("Origin", "Error");
            boolean isSegy = origin.equalsIgnoreCase("SEGY");
            boolean is3D = project.dim3D();
            menuBar.add(this.m_menu);
            this.m_menuItem_SelectOffsetBinSize = this.addMenuItem(this.m_menu, "Select offset bin size for all offset-plane picker windows");
            this.m_menu.addSeparator();
            this.m_menuItem_SimplePickerV2_Standard = this.addMenuItem(this.m_menu, "New picker window - shot/receiver/bin plane");
            this.m_menuItem_SimplePickerV2_Offset = this.addMenuItem(this.m_menu, "New picker window - offset plane (works best with 2D)");
            if (is3D) {
                this.m_menuItem_SimplePickerV2_OffsetProfile = this.addMenuItem(this.m_menu, "New picker window - offset plane using 2D profiles");
                this.m_menuItem_SimplePickerV2_OffsetInlineCrossline = this.addMenuItem(this.m_menu, "New picker window - offset plane using inlines/crosslines");
            }
            this.m_menu.addSeparator();
            this.m_menuItem_MultiPanelPicker = this.addMenuItem(this.m_menu, "New picker window - Multi-panel display (shot plane only!)");
            this.m_menuItem_MultiProfilePanelPicker = this.addMenuItem(this.m_menu, "New picker window - Multi-panel profile display (offset plane) ");
            this.m_menu.addSeparator();
            this.m_menuItem_PrepInteractiveTrend = this.addMenuItem(this.m_menu, "Prepare interactive moveout trend data");
            this.m_menu.addSeparator();
            this.m_menuItem_Trend = this.addMenuItem(this.m_menu, "Define linear moveout trend using traces");
            this.m_menuItem_Trend_Picks = this.addMenuItem(this.m_menu, "Define linear moveout trend using picks");
            this.m_menu.addSeparator();
            this.m_menuItem_GeneralStacks = this.addMenuItem(this.m_menu, "General shot/receiver stacks");
            this.m_menu.addSeparator();
            this.m_menu.add(this.m_menuPickIO);
            this.m_menuItem_ImportCoords = this.addMenuItem(this.m_menuPickIO, "Import picks using coordinates - ASCII format");
            this.m_menuItem_ExportCoords_ASCII = this.addMenuItem(this.m_menuPickIO, "Export picks using coordinates - ASCII format");
            this.m_menuItem_ExportCoords_Binary = this.addMenuItem(this.m_menuPickIO, "Export picks using coordinates - Binary format");
            this.m_menuPickIO.addSeparator();
            this.m_menuItem_ImportFFIDCHAN = this.addMenuItem(this.m_menuPickIO, "Import picks using FFID/Channel");
            this.m_menuItem_ExportFFIDCHAN = this.addMenuItem(this.m_menuPickIO, "Export picks using FFID/Channel");
            this.m_menuPickIO.addSeparator();
            this.m_menuItem_ImportFFIDPOINT = this.addMenuItem(this.m_menuPickIO, "Import picks using FFID/Receiver PointNumber");
            this.m_menuItem_ExportFFIDPOINT = this.addMenuItem(this.m_menuPickIO, "Export picks using FFID/Receiver PointNumber");
            this.m_menuPickIO.addSeparator();
            this.m_menuItem_ImportCombined = this.addMenuItem(this.m_menuPickIO, "Import picks using combined LineNumber/PointNumber");
            this.m_menuPickIO.addSeparator();
            this.m_menuItem_ImportSeparate = this.addMenuItem(this.m_menuPickIO, "Import picks using separate LineNumber/PointNumber");
            this.m_menuItem_ExportSeparate = this.addMenuItem(this.m_menuPickIO, "Export picks using separate LineNumber/PointNumber");
            this.m_menu.add(this.m_menuPickManipulation);
            this.m_menuItem_AddPick = this.addMenuItem(this.m_menuPickManipulation, "Add first break pick version");
            this.m_menuItem_CopyPick = this.addMenuItem(this.m_menuPickManipulation, "Copy first break picks");
            this.m_menuItem_PickMath = this.addMenuItem(this.m_menuPickManipulation, "Simple first break pick math");
            this.m_menuItem_ExportPick = this.addMenuItem(this.m_menuPickManipulation, "Export first break picks");
            this.m_menuItem_KillPick = this.addMenuItem(this.m_menuPickManipulation, "Kill first break picks");
            this.m_menuItem_KillPickInsideOffset = this.addMenuItem(this.m_menuPickManipulation, "Kill first break picks inside offset range");
            this.m_menuPickManipulation.addSeparator();
            this.m_menuItem_SynV0KZ = this.addMenuItem(this.m_menuPickManipulation, "Synthetic first break picks - V0 + K Z");
            this.m_menuItem_SynLayers = this.addMenuItem(this.m_menuPickManipulation, "Synthetic first break picks - Flat refractors");
            this.m_menu.addSeparator();
            this.m_menuItem_PickCount = this.addMenuItem(this.m_menu, "Compute fold, pick counts, offset ranges for the shots and receivers");
            this.m_menuItem_NoiseLevel = this.addMenuItem(this.m_menu, "Compute shot/receiver noise levels, kill noisy traces");
            this.m_menuItem_UnkillTraces = this.addMenuItem(this.m_menu, "Un-kill all traces");
            this.m_menuItem_ExportGLI = this.addMenuItem(this.m_menu, "Export GLI");
            this.m_menuItem_ExportGLI_LPI = this.addMenuItem(this.m_menu, "Export GLI - use Line/Point/Index");
            this.m_menuItem_ExportGLI_Binary = this.addMenuItem(this.m_menu, "Export GLI - use custom binary format");
            this.m_menuItem_ExportGLI_Binary_All = this.addMenuItem(this.m_menu, "Export GLI - use custom binary format - ALL PROJECTS");
            this.m_menuItem_ExportGLI_Binary_Synthetic = this.addMenuItem(this.m_menu, "Export synthetic GLI - use custom binary format");
            this.m_menu.addSeparator();
            this.m_menuItem_ExportShotToNumPy = this.addMenuItem(this.m_menu, "Export shot w/ picks/trace data to numPy array");
            if (isSegy) {
                this.m_menu.addSeparator();
                this.m_menuItem_ExportSeisUP = this.addMenuItem(this.m_menu, "Export SeisUP pick file");
                this.m_menuItem_ImportSeisUP = this.addMenuItem(this.m_menu, "Import SeisUP pick file");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void multiplyByFactor() {
        try {
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            if (!traceTable.column_exists("FBP_User")) {
                return;
            }
            int index = traceTable.column_indexOfColumn("FBP_User");
            for (long n = 0L; n < traceTable.rowCount(); ++n) {
                float pick = traceTable.getFloat(n, index);
                if ((double)pick >= 0.0) {
                    traceTable.putFloat(n, index, 2.0f * pick);
                }
                if (n % 200000L != 0L) continue;
                System.out.println("n = " + n);
            }
            traceTable.saveCurrentSection();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void v0kz() {
        try {
            int res = JOptionPane.showConfirmDialog(null, "This will overwrite user picks with synthetics!!!", "Confirm overwrite", 2, 2, null);
            if (res != 0) {
                return;
            }
            if (this.m_dlg == null) {
                this.m_dlg = new MultiTextDialog(null, "V0 + kz", "V0", "Depth", "Vel at depth");
            }
            this.m_dlg.showDialog();
            if (!this.m_dlg.OK) {
                return;
            }
            double v0 = this.m_dlg.getDouble(0, 3000.0, 500.0, 10000.0);
            double depth = this.m_dlg.getDouble(1, 500.0, 100.0, 2000.0);
            double v1 = this.m_dlg.getDouble(2, v0 + 100.0, v0 + 50.0, 30000.0);
            double k = (v1 - v0) / depth;
            TraceTable_Scanner_V0PlusKZ scanner = new TraceTable_Scanner_V0PlusKZ();
            scanner.K = k;
            scanner.V0 = v0;
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, null);
            JOptionPane.showMessageDialog(null, "Finished", "Finished", 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void layers() {
        try {
            int res = JOptionPane.showConfirmDialog(null, "This will overwrite user picks with synthetics!!!", "Confirm overwrite", 2, 2, null);
            if (res != 0) {
                return;
            }
            if (this.m_dlg2 == null) {
                this.m_dlg2 = new MultiTextDialog(null, "Flat layers", "V0", "Z1", "V1", "Z2", "V2");
            }
            this.m_dlg2.setText(0, "3000");
            this.m_dlg2.setText(1, "600");
            this.m_dlg2.setText(2, "6000");
            this.m_dlg2.setText(3, "0");
            this.m_dlg2.setText(4, "9000");
            this.m_dlg2.showDialog();
            if (!this.m_dlg2.OK) {
                return;
            }
            double v0 = this.m_dlg2.getDouble(0, 3000.0, 500.0, 10000.0);
            double z1 = this.m_dlg2.getDouble(1, 100.0, -100.0, 100000.0);
            double v1 = this.m_dlg2.getDouble(2, v0 + 100.0, v0 + 50.0, 30000.0);
            double z2 = this.m_dlg2.getDouble(3, z1 - 400.0, z1 - 5000.0, z1 - 50.0);
            double v2 = this.m_dlg2.getDouble(4, v1 + 100.0, v1 + 50.0, 30000.0);
            TraceTable_Scanner_LayerSyn scanner = new TraceTable_Scanner_LayerSyn();
            scanner.V[0] = v0;
            scanner.V[1] = v1;
            scanner.V[2] = v2;
            scanner.Z[1] = z1;
            scanner.Z[2] = z2;
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, null);
            JOptionPane.showMessageDialog(null, "Finished", "Finished", 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Action_Base action;
            int res;
            Action_Base action2;
            String fileName;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String origin = project.information().string_get("Origin", "Error");
            boolean isSegy = origin.equalsIgnoreCase("SEGY");
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_PrepInteractiveTrend) {
                MultiTextDialog dlg = new MultiTextDialog(null, "Interactive trend parameters", "Spatial binning size (ft/m)", "Offset binning size (ft/m)", "Maximum allowed offset");
                dlg.setText(0, "5000");
                dlg.setText(1, "1000");
                dlg.setText(2, "30000");
                dlg.showDialog("Apply");
                if (!dlg.OK) {
                    return;
                }
                double grid = dlg.getDouble(0, 5000.0, 500.0, 20000.0);
                double offbin = dlg.getDouble(1, 1000.0, 100.0, 10000.0);
                double maxoff = dlg.getDouble(2, 30000.0, 2000.0, 100000.0);
                project.prepInteractiveMoveoutTrend(grid, maxoff, offbin);
                project.executeSingleAction(new Action_InteractiveTrend());
                return;
            }
            if (e.getSource() == this.m_menuItem_SynLayers) {
                this.layers();
                return;
            }
            if (e.getSource() == this.m_menuItem_SynV0KZ) {
                this.v0kz();
                return;
            }
            if (e.getSource() == this.m_menuItem_SelectOffsetBinSize) {
                project.selectOffsetBinSize();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportFFIDPOINT) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(false, PickImportWithCoordsDialog.MethodIO.FFIDPointNumber, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportFFIDCHAN) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(false, PickImportWithCoordsDialog.MethodIO.FFID, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportCoords) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(false, PickImportWithCoordsDialog.MethodIO.Coords, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportCombined) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(false, PickImportWithCoordsDialog.MethodIO.CombinedLinePoint, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportSeparate) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(false, PickImportWithCoordsDialog.MethodIO.LinePoint, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportSeisUP) {
                if (!project.shotTable().column_exists("SSPN")) {
                    JOptionPane.showMessageDialog(null, "Shot table must have SSPN column", "Cannot import picks", 0);
                    return;
                }
                if (!project.traceTableWrapper().traceTable().column_exists("Channel")) {
                    JOptionPane.showMessageDialog(null, "Trace table must have Channel column", "Cannot import picks", 0);
                    return;
                }
                String fileName2 = Tools_Chooser.getFileName();
                if (fileName2 == null) {
                    return;
                }
                MultiTextDialog dlg = new MultiTextDialog(null, "Pick shift", "Pick shift in milliseconds");
                dlg.setText(0, "0");
                dlg.showDialog("OK");
                if (!dlg.OK) {
                    return;
                }
                Action_ImportSeisupMatrix action3 = new Action_ImportSeisupMatrix();
                action3.FileName = fileName2;
                action3.Shift = dlg.getDouble(0, 0.0, -10000.0, 10000.0);
                project.executeSingleAction(action3);
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportSeisUP) {
                if (!project.shotTable().column_exists("SSPN")) {
                    JOptionPane.showMessageDialog(null, "Shot table must have SSPN column", "Cannot export picks", 0);
                    return;
                }
                String fileName3 = Tools_Chooser.getSaveFileName("txt");
                if (fileName3 == null) {
                    return;
                }
                Action_ExportSeisupMatrix action4 = new Action_ExportSeisupMatrix();
                action4.FileName = fileName3;
                action4.TraceColumnName = "FBP_User";
                project.executeSingleAction(action4);
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportCoords_Binary) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(true, PickImportWithCoordsDialog.MethodIO.Coords, false);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportCoords_ASCII) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(true, PickImportWithCoordsDialog.MethodIO.Coords, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportFFIDPOINT) {
                if (!project.shotTable().column_exists("FFID")) {
                    JOptionPane.showMessageDialog(null, "Shot table must have FFID column", "Cannot export picks", 0);
                    return;
                }
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(true, PickImportWithCoordsDialog.MethodIO.FFIDPointNumber, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportFFIDCHAN) {
                if (!project.shotTable().column_exists("FFID")) {
                    JOptionPane.showMessageDialog(null, "Shot table must have FFID column", "Cannot export picks", 0);
                    return;
                }
                if (!project.traceTableWrapper().traceTable().column_exists("Channel")) {
                    JOptionPane.showMessageDialog(null, "Trace table must have Channel column", "Cannot export picks", 0);
                    return;
                }
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(true, PickImportWithCoordsDialog.MethodIO.FFID, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportCombined) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(true, PickImportWithCoordsDialog.MethodIO.CombinedLinePoint, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportSeparate) {
                PickImportWithCoordsDialog dlg = new PickImportWithCoordsDialog(true, PickImportWithCoordsDialog.MethodIO.LinePoint, true);
                dlg.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_PickMultiply) {
                this.multiplyByFactor();
                return;
            }
            if (e.getSource() == this.m_menuItem_InitialEnergy) {
                if (this.m_energyDialog == null) {
                    this.m_energyDialog = new EnergyWindowDialog();
                }
                this.m_energyDialog.showDialog();
                if (this.m_energyDialog.OK) {
                    this.m_energyDialog.launchJob();
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_Trend_Picks) {
                LinearMoveoutTrendDialog_Picks dlg = new LinearMoveoutTrendDialog_Picks();
                return;
            }
            if (e.getSource() == this.m_menuItem_Trend) {
                LinearMoveoutTrendDialog_Traces dlg = new LinearMoveoutTrendDialog_Traces(false);
                return;
            }
            if (e.getSource() == this.m_menuItem_GeneralStacks) {
                cm.showComponent(SolutionsStackWidget_General.class.getName(), "General shot/receiver stacks", "General shot/receiver stacks", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Offset2DPicker) {
                cm.showComponent(Offset2DPickWidget.class.getName(), "2D Offset Picker", "2D Offset Picker", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_SimplePickerV2_OffsetInlineCrossline) {
                SharedApplicationData.singleton().SharedString = "OffsetInlineCrossline";
                cm.showComponent(BasicPickWidget_V2.class.getName(), "I/C Picker", "Offset plane picker using inlines/crosslines", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_SimplePickerV2_OffsetProfile) {
                SharedApplicationData.singleton().SharedString = "OffsetProfile";
                cm.showComponent(BasicPickWidget_V2.class.getName(), "Profile Picker", "Offset plane picker using 2D profiles", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_SimplePickerV2_Offset) {
                SharedApplicationData.singleton().SharedString = "Offset";
                cm.showComponent(BasicPickWidget_V2.class.getName(), "Offset Picker", "Offset Picker", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_SimplePickerV2_Standard) {
                SharedApplicationData.singleton().SharedString = "Standard";
                cm.showComponent(BasicPickWidget_V2.class.getName(), "Picker", "Picker", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_MultiPanelPicker) {
                cm.showComponent(BasicPickWidget_MultiplePanel.class.getName(), "MultiPicker", "MultiPicker", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_MultiProfilePanelPicker) {
                cm.showComponent(BasicPickWidget_MultipleProfilePanel.class.getName(), "MultiProfilePicker", "MultiProfilePicker", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_AddPick) {
                if (project.traceTableWrapper().traceTable().needToExpandTableMemory(DataType.Float)) {
                    JOptionPane.showMessageDialog(null, "Unable to add column to trace table", "Cannot add pick version", 0);
                    return;
                }
                this.m_pickAddDialog.showDialog();
                if (this.m_pickAddDialog.OK) {
                    Messenger.broadcast(Messenger.Message.PickColumnAdded, null, null);
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_KillPickInsideOffset) {
                this.m_killOffsetDialog.showDialog();
                if (this.m_killOffsetDialog.OK) {
                    Messenger.broadcast(Messenger.Message.PicksChanged, null, null);
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_KillPick) {
                this.m_killDialog.showDialog();
                if (this.m_killDialog.OK) {
                    Messenger.broadcast(Messenger.Message.PicksChanged, null, null);
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_CopyPick) {
                PickCopyDialog.singleton().showDialog(null);
                if (PickCopyDialog.singleton().OK) {
                    Messenger.broadcast(Messenger.Message.PicksChanged, null, null);
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_PickMath) {
                PickSimpleMathDialog.singleton().showDialog(null);
                if (PickSimpleMathDialog.singleton().OK) {
                    Messenger.broadcast(Messenger.Message.PicksChanged, null, null);
                }
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportPick) {
                if (!isSegy) {
                    JOptionPane.showMessageDialog(null, "Only works for SEG-Y projects", "Cannot export", 2);
                    return;
                }
                this.m_exportDialog.showDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_PickCount) {
                project.executeSingleAction(new Action_PickCount());
                return;
            }
            if (e.getSource() == this.m_menuItem_UnkillTraces) {
                project.executeSingleAction(new Action_UnkillTraces());
                return;
            }
            if (e.getSource() == this.m_menuItem_NoiseLevel) {
                if (this.m_noiseDialog == null) {
                    this.m_noiseDialog = new NoiseComputationDialog();
                }
                this.m_noiseDialog.showDialog();
                if (this.m_noiseDialog.OK) {
                    this.m_noiseDialog.launchJob();
                }
            }
            if (e.getSource() == this.m_menuItem_ExportGLI_Binary_All) {
                fileName = Tools_Chooser.getDirectory("Top level directory for export");
                if (fileName == null) {
                    return;
                }
                action2 = new Action_ExportBinaryGLI_All();
                action2.OutputPath = fileName;
                project.executeSingleAction(action2);
            }
            if (e.getSource() == this.m_menuItem_ExportGLI_Binary) {
                fileName = Tools_Chooser.getDirectory("Binary pick files  export");
                if (fileName == null) {
                    return;
                }
                action2 = new Action_ExportBinaryGLI();
                if (project.polygon() != null) {
                    res = JOptionPane.showConfirmDialog(null, "Apply polygon limit", "", 0);
                    ((Action_ExportBinaryGLI)action2).ApplyPolygon = res == 0;
                    ((Action_ExportBinaryGLI)action2).Polygon = project.polygon();
                }
                ((Action_ExportBinaryGLI)action2).OutputPath = fileName;
                project.executeSingleAction(action2);
            }
            if (e.getSource() == this.m_menuItem_ExportGLI_Binary_Synthetic) {
                if (this.m_syntheticGLIDialog == null) {
                    this.m_syntheticGLIDialog = new ExportSyntheticBinaryGLIDialog();
                }
                this.m_syntheticGLIDialog.showDialog();
                if (!this.m_syntheticGLIDialog.OK) {
                    return;
                }
                action = new Action_ExportSyntheticBinaryGLI();
                action.OutputPath = this.m_syntheticGLIDialog.outputPath();
                action.ParamTree = this.m_syntheticGLIDialog.paramTree();
                project.executeSingleAction(action);
            }
            if (e.getSource() == this.m_menuItem_ExportShotToNumPy) {
                if (this.m_exportSegyNumPyDialog == null) {
                    this.m_exportSegyNumPyDialog = new ExportSegyNumPyDialog();
                }
                this.m_exportSegyNumPyDialog.showDialog();
                if (!this.m_exportSegyNumPyDialog.OK) {
                    return;
                }
                action = new Action_ExportNumPy();
                ((Action_ExportNumPy)action).OutputPath = this.m_exportSegyNumPyDialog.OutputPath;
                project.executeSingleAction(action);
            }
            if (e.getSource() == this.m_menuItem_ExportGLI_LPI) {
                fileName = Tools_Chooser.getSaveFileName("txt");
                if (fileName == null) {
                    return;
                }
                action2 = new Action_ExportGLI_LPI();
                if (project.polygon() != null) {
                    res = JOptionPane.showConfirmDialog(null, "Apply polygon limit", "", 0);
                    ((Action_ExportGLI_LPI)action2).ApplyPolygon = res == 0;
                    ((Action_ExportGLI_LPI)action2).Polygon = project.polygon();
                }
                ((Action_ExportGLI_LPI)action2).FileName = fileName;
                project.executeSingleAction(action2);
            }
            if (e.getSource() == this.m_menuItem_ExportGLI) {
                fileName = Tools_Chooser.getSaveFileName("gli");
                if (fileName == null) {
                    return;
                }
                action2 = new Action_ExportGLI();
                if (project.polygon() != null) {
                    res = JOptionPane.showConfirmDialog(null, "Apply polygon limit", "", 0);
                    ((Action_ExportGLI)action2).ApplyPolygon = res == 0;
                    ((Action_ExportGLI)action2).Polygon = project.polygon();
                }
                ((Action_ExportGLI)action2).FileName = fileName;
                project.executeSingleAction(action2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

