/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.HybridGLI.HybridGliData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Ensemble.EnsembleHeaderSelectorWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class EnsembleVisibleTraceSelectionWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
MouseListener {
    protected JRadioButton m_allRad = new JRadioButton("Display all traces");
    protected JRadioButton m_headerRad = new JRadioButton("Limit traces by header value");
    protected JRadioButton m_branchDelayTimeRad = new JRadioButton("Limit traces by branch - delay time analysis");
    protected JRadioButton m_branchHybridGLIRad = new JRadioButton("Limit traces by branch - hybrid GLI analysis");
    protected ButtonGroup m_group = new ButtonGroup();
    protected PickPlaneEnum m_pickPlane = PickPlaneEnum.Shot;
    protected LinearLayoutWidget m_branchDelayTimeWidget;
    protected JComboBox<String> m_branchDelayTimeCombo = new JComboBox();
    protected LinearLayoutWidget m_branchHybridGLIWidget;
    protected JComboBox<String> m_branchHybridGLICombo = new JComboBox();
    protected LinearLayoutWidget m_subWidget;
    protected EnsembleHeaderSelectorWidget m_headerWidget;
    protected JTextField m_minText = new JTextField("0");
    protected JTextField m_maxText = new JTextField("10000");
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected boolean m_ignoreEvents = false;

    public EnsembleVisibleTraceSelectionWidget(String label) {
        super(LinearLayoutWidget.Direction.Vertical, 3, label);
        try {
            int n;
            this.m_headerWidget = new EnsembleHeaderSelectorWidget(3, "Select header");
            this.m_headerWidget.listener().addListener(this);
            this.m_group.add(this.m_allRad);
            this.m_group.add(this.m_headerRad);
            this.m_group.add(this.m_branchDelayTimeRad);
            this.m_group.add(this.m_branchHybridGLIRad);
            this.m_minText.addActionListener(this);
            this.m_maxText.addActionListener(this);
            this.m_allRad.addActionListener(this);
            this.m_headerRad.addActionListener(this);
            this.m_branchDelayTimeRad.addActionListener(this);
            this.m_branchHybridGLIRad.addActionListener(this);
            this.addComponent(this.m_allRad, 0);
            this.m_allRad.setSelected(true);
            this.createGapLabel(20);
            this.addComponent(this.m_branchDelayTimeRad, 0);
            this.m_branchDelayTimeWidget = this.createHorizontal(0, null, 0);
            this.m_branchDelayTimeWidget.addComponent(new JLabel("Select visible branch"), 0);
            this.m_branchDelayTimeWidget.addComponent(this.m_branchDelayTimeCombo, 10);
            this.m_branchDelayTimeCombo.addItem("Show all branches");
            for (n = 1; n < 10; ++n) {
                this.m_branchDelayTimeCombo.addItem(String.format("Branch %d", n));
            }
            this.m_branchDelayTimeCombo.setSelectedIndex(0);
            this.m_branchDelayTimeCombo.addItemListener(this);
            this.createGapLabel(20);
            this.addComponent(this.m_branchHybridGLIRad, 0);
            this.m_branchHybridGLIWidget = this.createHorizontal(0, null, 0);
            this.m_branchHybridGLIWidget.addComponent(new JLabel("Select visible branch"), 0);
            this.m_branchHybridGLIWidget.addComponent(this.m_branchHybridGLICombo, 10);
            this.m_branchHybridGLICombo.addItem("Show all branches");
            for (n = 1; n < 10; ++n) {
                this.m_branchHybridGLICombo.addItem(String.format("Branch %d", n));
            }
            this.m_branchHybridGLICombo.setSelectedIndex(0);
            this.m_branchHybridGLICombo.addItemListener(this);
            this.createGapLabel(20);
            this.addComponent(this.m_headerRad, 0);
            this.m_subWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null, 0);
            this.m_subWidget.addComponent(this.m_headerWidget, 0);
            LinearLayoutWidget sub = this.m_subWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            sub.addComponent(new JLabel("Min"), 0);
            sub.addComponent(this.m_minText, 10);
            sub.addComponent(new JLabel("Max"), 0);
            sub.addComponent(this.m_maxText, 10);
            this.m_subWidget.setEnabled(this.m_headerRad.isSelected());
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_paramManager.addComboBoxConnector("VisibleDelayTimeBranches", this.m_branchDelayTimeCombo, 0);
            this.m_paramManager.addComboBoxConnector("VisibleHybridGLIBranches", this.m_branchHybridGLICombo, 0);
            this.m_paramManager.addRadioArray("Method", 0);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_allRad);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_branchDelayTimeRad);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_branchHybridGLIRad);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_headerRad);
            this.m_paramManager.addHeaderWidget("Header", this.m_headerWidget, "Trace", "Offset");
            this.m_paramManager.addTextFieldConnector("HeaderMin", this.m_minText, "0");
            this.m_paramManager.addTextFieldConnector("HeaderMax", this.m_maxText, "2000");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean isBranchRadSelected() {
        return this.m_branchDelayTimeRad.isSelected();
    }

    public void setParentParameterTree(ParameterTree parentTree) {
        try {
            this.m_paramManager.setTree(parentTree.ParameterTree_get("VisibleTraces"));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int visibleTraceCount(Ensemble ensemble) {
        try {
            if (ensemble == null) {
                return 0;
            }
            if (this.m_allRad.isSelected()) {
                return ensemble.traceCount();
            }
            if (this.m_branchHybridGLIRad.isSelected()) {
                HybridGliData hybrid = RefractionStaticsProject.singleton().hybridGliData();
                if (hybrid.branchAssignment().maxBranch() < 1) {
                    return 0;
                }
                hybrid.branchAssignment().assignBranch(ensemble, "Branch_HybridGLI");
                if (!ensemble.dictionary().containsEntry("Trace", "Branch_HybridGLI")) {
                    return 0;
                }
                int whichBranch = this.m_branchHybridGLICombo.getSelectedIndex();
                int index = ensemble.dictionary().getEntryIndex("Trace", "Branch_HybridGLI");
                int count = 0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int branch = trace.header().getInt(index);
                    trace.PlotData.ShowTrace = false;
                    if (branch < 1 || branch != whichBranch && whichBranch != 0) continue;
                    ++count;
                }
                return count;
            }
            if (this.m_branchDelayTimeRad.isSelected()) {
                DelayTimeData dtd = RefractionStaticsProject.delayTimeData();
                if (dtd.branchAssignment().maxBranch() < 1) {
                    return 0;
                }
                if (!ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                    return 0;
                }
                int whichBranch = this.m_branchDelayTimeCombo.getSelectedIndex();
                int index = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
                int count = 0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int branch = trace.header().getInt(index);
                    trace.PlotData.ShowTrace = false;
                    trace.PlotData.IsInBranch = false;
                    if (branch < 1 || branch != whichBranch && whichBranch != 0) continue;
                    ++count;
                    trace.PlotData.IsInBranch = true;
                }
                return count;
            }
            if (this.m_headerRad.isSelected()) {
                String table = this.m_headerWidget.getTable();
                String column = this.m_headerWidget.getColumn();
                if (!ensemble.dictionary().containsEntry(table, column)) {
                    return 0;
                }
                int index = ensemble.dictionary().getEntryIndex(table, column);
                double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
                double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
                int count = 0;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    double v = trace.header().getDouble(index);
                    if (!(v >= min) || !(v <= max)) continue;
                    ++count;
                }
                return count;
            }
            return 0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public void setVisibleTraces(Ensemble ensemble) {
        try {
            if (ensemble == null) {
                return;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.PlotData.ShowTrace = true;
                trace.PlotData.IsInBranch = true;
            }
            if (this.m_branchHybridGLIRad.isSelected()) {
                HybridGliData hybrid = RefractionStaticsProject.singleton().hybridGliData();
                if (hybrid.branchAssignment().maxBranch() < 1) {
                    this.m_allRad.setSelected(true);
                    return;
                }
                hybrid.branchAssignment().assignBranch(ensemble, "Branch_HybridGLI");
                if (!ensemble.dictionary().containsEntry("Trace", "Branch_HybridGLI")) {
                    return;
                }
                int whichBranch = this.m_branchHybridGLICombo.getSelectedIndex();
                int index = ensemble.dictionary().getEntryIndex("Trace", "Branch_HybridGLI");
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int branch = trace.header().getInt(index);
                    trace.PlotData.ShowTrace = false;
                    if (branch < 1 || branch != whichBranch && whichBranch != 0) continue;
                    trace.PlotData.ShowTrace = true;
                }
                return;
            }
            if (this.m_branchDelayTimeRad.isSelected()) {
                DelayTimeData dtd = RefractionStaticsProject.delayTimeData();
                if (dtd.branchAssignment().maxBranch() < 1) {
                    this.m_allRad.setSelected(true);
                    return;
                }
                if (!ensemble.dictionary().containsEntry("Trace", "Branch_DelayTime")) {
                    return;
                }
                int whichBranch = this.m_branchDelayTimeCombo.getSelectedIndex();
                int index = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int branch = trace.header().getInt(index);
                    trace.PlotData.ShowTrace = false;
                    trace.PlotData.IsInBranch = false;
                    if (branch < 1 || branch != whichBranch && whichBranch != 0) continue;
                    trace.PlotData.ShowTrace = true;
                    trace.PlotData.IsInBranch = true;
                }
                return;
            }
            if (this.m_headerRad.isSelected()) {
                String table = this.m_headerWidget.getTable();
                String column = this.m_headerWidget.getColumn();
                if (!ensemble.dictionary().containsEntry(table, column)) {
                    return;
                }
                int index = ensemble.dictionary().getEntryIndex(table, column);
                double min = Tools_Widget.extractDouble(this.m_minText, 0.0, -1.0E30, 1.0E30);
                double max = Tools_Widget.extractDouble(this.m_maxText, 0.0, -1.0E30, 1.0E30);
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    double v = trace.header().getDouble(index);
                    trace.PlotData.ShowTrace = v >= min && v <= max;
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public void setEnsembleHeaderDictionary(EnsembleHeaderDictionary dict) {
        try {
            this.m_headerWidget.setEnsembleHeaderDictionary(dict);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public void handleKeyboard(int index) {
        try {
            if (index < 0 || index >= this.m_branchDelayTimeCombo.getItemCount()) {
                return;
            }
            this.m_branchDelayTimeCombo.setSelectedIndex(index);
            this.m_branchHybridGLICombo.setSelectedIndex(index);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        try {
            this.m_pickPlane = pickPlane;
            this.m_headerWidget.setPickPlane(pickPlane);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectHeaderVisible(String table, String column, double min, double max, boolean broadcast) {
        try {
            this.m_ignoreEvents = true;
            this.m_headerWidget.setPreferredTableAndColumn(table, column);
            this.m_minText.setText(Double.toString(min));
            this.m_maxText.setText(Double.toString(max));
            this.m_headerRad.setSelected(true);
            if (broadcast) {
                this.m_listener.broadcast(this, null);
            }
            this.m_ignoreEvents = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_ignoreEvents = false;
        }
    }

    public void selectAllVisible(boolean broadcast) {
        try {
            this.m_ignoreEvents = true;
            this.m_allRad.setSelected(true);
            if (broadcast) {
                this.m_listener.broadcast(this, null);
            }
            this.m_ignoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvents = false;
    }

    public void selectDelayTimeVisible(boolean broadcast) {
        try {
            this.m_ignoreEvents = true;
            this.m_branchDelayTimeRad.setSelected(true);
            this.m_branchDelayTimeCombo.setSelectedIndex(0);
            if (broadcast) {
                this.m_listener.broadcast(this, null);
            }
            this.m_ignoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvents = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_subWidget.setEnabled(this.m_headerRad.isSelected());
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreEvents) {
                return;
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

