/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EnsembleGroupSelectorWidget
extends LinearLayoutWidget
implements ListSelectionListener {
    protected JLabel m_label = new JLabel("lbl", 0);
    protected JList<String> m_list = new JList();
    protected boolean m_ignore = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected EnsembleGroupManager m_egm;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public EnsembleGroupSelectorWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, "Groups");
        try {
            this.addComponent(this.m_label, 0);
            this.addComponent(new JScrollPane(this.m_list), 100);
            this.m_list.addListSelectionListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSelectedIndex(int index) {
        try {
            if (index < 0 || index >= this.m_list.getModel().getSize()) {
                return;
            }
            this.m_ignore = true;
            this.m_list.setSelectedIndex(index);
            this.m_ignore = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getSelectedIndex() {
        try {
            if (this.m_list.getModel().getSize() < 1) {
                return 0;
            }
            return this.m_list.getSelectedIndex();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.m_ignore) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectGroupWithShot(int id) {
        try {
            for (int n = 0; n < this.m_egm.GroupList.size(); ++n) {
                EnsembleGroupManager.GroupInfo info = this.m_egm.GroupList.get(n);
                if (!Tools_Ensemble.hasShotID(info.GroupEnsemble, id)) continue;
                this.setSelectedIndex(n);
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectGroupWithReceiver(int id) {
        try {
            for (int n = 0; n < this.m_egm.GroupList.size(); ++n) {
                EnsembleGroupManager.GroupInfo info = this.m_egm.GroupList.get(n);
                if (!Tools_Ensemble.hasReceiverID(info.GroupEnsemble, id)) continue;
                this.setSelectedIndex(n);
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prep(EnsembleGroupManager egm, boolean preserveSelectedGroup) {
        try {
            this.m_egm = egm;
            this.m_ignore = true;
            int currIndex = -9999;
            if (preserveSelectedGroup && this.m_list.getModel().getSize() >= 1) {
                currIndex = this.m_list.getSelectedIndex();
            }
            this.m_label.setText(egm.Label);
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int n = 0; n < egm.GroupList.size(); ++n) {
                model.addElement(egm.description(n));
            }
            this.m_list.setModel(model);
            if (currIndex >= 0 && currIndex < this.m_list.getModel().getSize()) {
                this.m_list.setSelectedIndex(currIndex);
            }
            this.m_ignore = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

