/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Ensemble.EnsembleHeaderSelectorWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class EnsembleGroupControllerWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected PickPlaneEnum m_pickPlane = PickPlaneEnum.Shot;
    protected String m_tableKey;
    protected String m_columnKey;
    protected EnsembleHeaderDictionary m_dictionary = new EnsembleHeaderDictionary();
    protected Ensemble m_parentEnsemble = null;
    protected EnsembleGroupManager m_groupManager = new EnsembleGroupManager();
    protected boolean m_ignoreCombo = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JRadioButton m_offRad = new JRadioButton("Grouping off");
    protected JRadioButton m_headerRad = new JRadioButton("Group using header value");
    protected JRadioButton m_countRad = new JRadioButton("Group by trace count");
    protected ButtonGroup m_group = new ButtonGroup();
    protected EnsembleHeaderSelectorWidget m_header;
    protected JTextField m_countText = new JTextField("100");
    protected boolean m_ignoreEvents = false;

    public EnsembleGroupManager groupManager() {
        return this.m_groupManager;
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public EnsembleGroupControllerWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 4, null);
        try {
            this.m_offRad.addActionListener(this);
            this.m_headerRad.addActionListener(this);
            this.m_countRad.addActionListener(this);
            this.m_countText.addActionListener(this);
            this.m_header = new EnsembleHeaderSelectorWidget(0, "Select group header");
            this.m_header.listener().addListener(this);
            this.m_header.setPickPlanePrefs(PickPlaneEnum.Shot, "Receiver", "LineNumber");
            this.m_header.setPickPlanePrefs(PickPlaneEnum.Receiver, "Shot", "LineNumber");
            this.m_header.setPickPlanePrefs(PickPlaneEnum.Bin, "Receiver", "LineNumber");
            this.m_group.add(this.m_offRad);
            this.m_group.add(this.m_headerRad);
            this.m_group.add(this.m_countRad);
            this.addComponent(this.m_offRad, 0);
            this.createGapLabel(12);
            this.addComponent(this.m_headerRad, 0);
            this.addComponent(this.m_header, 0);
            this.createGapLabel(12);
            this.addComponent(this.m_countRad, 0);
            GridLayoutWidget grid = this.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Count:"), this.m_countText);
            this.createGapLabel(12);
            this.addStretch(10);
            this.m_headerRad.setSelected(true);
            this.m_header.setEnabled(true);
            this.m_countText.setEnabled(false);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_paramManager.addTextFieldConnector("Count", this.m_countText, "100");
            this.m_paramManager.addRadioArray("Method", 1);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_offRad);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_headerRad);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_countRad);
            this.m_paramManager.addHeaderWidget("Header", this.m_header, "Receiver", "LineNumber");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setGroupingOff() {
        try {
            this.m_offRad.setSelected(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean isGroupingOff() {
        return this.m_offRad.isSelected();
    }

    public void prepareGroup(Ensemble ensemble) {
        try {
            if (ensemble == null) {
                return;
            }
            this.m_parentEnsemble = ensemble;
            this.m_header.setEnsembleHeaderDictionary(ensemble.dictionary());
            this.prepareGroupInfo();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setParentParameterTree(ParameterTree parentTree) {
        try {
            this.m_paramManager.setTree(parentTree.ParameterTree_get("GroupOptions"));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        try {
            this.m_pickPlane = pickPlane;
            this.m_header.setPickPlane(pickPlane);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepareGroupInfo() {
        try {
            this.m_groupManager.setParentEnsemble(this.m_parentEnsemble);
            if (this.m_offRad.isSelected()) {
                this.m_groupManager.prepareNoGrouping();
                return;
            }
            if (this.m_countRad.isSelected()) {
                int count = Tools_Widget.extractInteger(this.m_countText, 100, 10, 1000);
                this.m_groupManager.prepareGroupsBasedOnCount(count);
                return;
            }
            String table = this.m_header.getTable();
            String column = this.m_header.getColumn();
            this.m_groupManager.prepareGroupsBasedOnInteger(table, column);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectGroupingOff() {
        try {
            this.m_ignoreEvents = true;
            this.m_offRad.setSelected(true);
            this.m_ignoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvents = false;
    }

    public void selectHeaderGrouping() {
        try {
            this.m_ignoreEvents = true;
            this.m_headerRad.setSelected(true);
            this.m_ignoreEvents = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        this.m_ignoreEvents = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_header.setEnabled(this.m_headerRad.isSelected());
            this.m_countText.setEnabled(this.m_countRad.isSelected());
            this.prepareGroupInfo();
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_header) {
                this.m_listener.broadcast(this, null);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

