/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Ensemble.EnsembleHeaderSelectorWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class EnsembleAxisSelectionWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected PickPlaneEnum m_pickPlane = PickPlaneEnum.Shot;
    protected EnsembleGroupManager m_groupManager = new EnsembleGroupManager();
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JRadioButton m_sortRad;
    protected JRadioButton m_headerValueRad;
    protected ButtonGroup m_group = new ButtonGroup();
    protected EnsembleHeaderSelectorWidget m_sort1Widget;
    protected EnsembleHeaderSelectorWidget m_sort2Widget;
    protected EnsembleHeaderSelectorWidget m_axisWidget;

    public EnsembleGroupManager groupManager() {
        return this.m_groupManager;
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public EnsembleAxisSelectionWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 4, null);
        try {
            this.m_sortRad = new JRadioButton("Sort, then space traces evenly");
            this.m_headerValueRad = new JRadioButton("Use trace header for axis");
            this.m_sortRad.addActionListener(this);
            this.m_headerValueRad.addActionListener(this);
            this.m_group.add(this.m_sortRad);
            this.m_group.add(this.m_headerValueRad);
            this.m_sortRad.setSelected(true);
            this.m_axisWidget = new EnsembleHeaderSelectorWidget(3, "Axis header");
            this.m_sort1Widget = new EnsembleHeaderSelectorWidget(3, "Primary sort header");
            this.m_sort1Widget.setPickPlanePrefs(PickPlaneEnum.Shot, "Receiver", "LineNumber");
            this.m_sort1Widget.setPickPlanePrefs(PickPlaneEnum.Receiver, "Shot", "LineNumber");
            this.m_sort2Widget = new EnsembleHeaderSelectorWidget(3, "Secondary sort header");
            this.m_sort2Widget.setPickPlanePrefs(PickPlaneEnum.Shot, "Receiver", "PointNumber");
            this.m_sort2Widget.setPickPlanePrefs(PickPlaneEnum.Receiver, "Shot", "PointNumber");
            this.m_sort1Widget.listener().addListener(this);
            this.m_sort2Widget.listener().addListener(this);
            this.m_axisWidget.listener().addListener(this);
            this.addComponent(this.m_sortRad, 0);
            this.addComponent(this.m_sort1Widget, 0);
            this.addComponent(this.m_sort2Widget, 0);
            this.createGapLabel(15);
            this.addComponent(this.m_headerValueRad, 0);
            this.addComponent(this.m_axisWidget, 0);
            this.createGapLabel(15);
            this.addStretch(12);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_paramManager.addRadioArray("Method", 0);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_sortRad);
            this.m_paramManager.addRadioButtonToArray("Method", this.m_headerValueRad);
            this.m_paramManager.addHeaderWidget("Axis", this.m_axisWidget, "Trace", "Offset");
            this.m_paramManager.addHeaderWidget("Sort1", this.m_sort1Widget, "Receiver", "LineNumber");
            this.m_paramManager.addHeaderWidget("Sort2", this.m_sort2Widget, "Receiver", "PointNumber");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setAxis(String table, String column) {
        try {
            this.m_axisWidget.setPreferredTableAndColumn(table, column);
            this.m_headerValueRad.setSelected(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String getAxisTable() {
        return this.m_axisWidget.getTable();
    }

    public String getAxisColumn() {
        return this.m_axisWidget.getColumn();
    }

    public boolean isUniformSpacing() {
        return this.m_sortRad.isSelected();
    }

    public void sortEnsemble(Ensemble ensemble) {
        try {
            boolean sortInt;
            if (ensemble == null) {
                return;
            }
            String col1 = this.m_sort1Widget.getColumn();
            boolean bl = sortInt = col1.equalsIgnoreCase("LineNumber") || col1.equalsIgnoreCase("PointNumber") || col1.equalsIgnoreCase("PointIndex");
            if (sortInt) {
                ensemble.sortInt(0, this.m_sort1Widget.getTable(), this.m_sort1Widget.getColumn(), this.m_sort2Widget.getTable(), this.m_sort2Widget.getColumn());
            } else {
                ensemble.sortDouble(0, this.m_sort1Widget.getTable(), this.m_sort1Widget.getColumn());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setEnsembleHeaderDictionary(EnsembleHeaderDictionary dict) {
        try {
            this.m_sort1Widget.setEnsembleHeaderDictionary(dict);
            this.m_sort2Widget.setEnsembleHeaderDictionary(dict);
            this.m_axisWidget.setEnsembleHeaderDictionary(dict);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setParentParameterTree(ParameterTree parentTree) {
        try {
            this.m_paramManager.setTree(parentTree.ParameterTree_get("AxisOptions"));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        try {
            this.m_pickPlane = pickPlane;
            this.m_sort1Widget.setPickPlane(pickPlane);
            this.m_sort2Widget.setPickPlane(pickPlane);
            this.m_axisWidget.setPickPlane(pickPlane);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

