/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Column_Bool;
import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Long;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Sequence.Action_RunSequence;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Ensemble.Worker.DelayTime.EnsembleWorker_DelayTimeShifts;
import com.PecosLibrary.Ensemble.Worker.Filter.EnsembleWorker_ButterworthLowPass;
import com.PecosLibrary.Ensemble.Worker.Import.EnsembleWorker_ScanProjectTraces;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_Eikonal3D;
import com.PecosLibrary.Ensemble.Worker.ModelTimeShifts.EnsembleWorker_TomoVNS;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyMoveoutTrend;
import com.PecosLibrary.Ensemble.Worker.Output.EnsembleWorker_MergeTraceHeader;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_AmpOnsetPicker;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_AmpOnsetPicker_Snap;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_EnergyInWindow;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_NearestTimePicker;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_ShiftUserPicks;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_ThresholdPicker;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime_Geometry;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_Ensemble_RefractionProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Tools.Tools_Bitmap;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_PenMode;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Wheel;
import com.PecosLibrary.Windows.Refraction.Database.UniqueColumnCombo;
import com.PecosLibrary.Windows.Refraction.DelayTime.GeometryCorrectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleAxisSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleGroupControllerWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleGroupSelectorWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleVisibleTraceSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.NavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.OffsetBinInlineCrosslineNavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.OffsetBinNavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.OffsetBinProfileNavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickDisplayWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickPlaneCombo;
import com.PecosLibrary.Windows.Refraction.Picking.PickPolygonDialog;
import com.PecosLibrary.Windows.Refraction.Picking.PickerBasemapWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PreviousPicksWidget;
import com.PecosLibrary.Windows.Refraction.Picking.SnapshotWidget;
import com.PecosLibrary.Windows.Refraction.Picking.TraceBackgroundWidget;
import com.PecosLibrary.Windows.Refraction.Picking.TraceFrequencyWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import com.PecosLibrary.Windows.Stack.ProfileSelectorWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class BasicPickWidget_V2
extends JSplitPane
implements INumberedWidget,
ActionListener,
GenericObjectListener.Listener,
ItemListener,
PickerBasemapWidget.Listener,
Java2D_VertStackedEnsembleDisplayWidget.Listener,
Messenger.Listener,
PopupMenuButton.Listener,
Action_Sequence.Listener {
    protected Timer m_timer = new Timer(5000, this);
    protected JComboBox<String> m_comboNumHeaders;
    protected JComboBox<String> m_comboNumHeaderPlot;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected PickerBasemapWidget m_basemapWidget;
    protected EnsembleGroupControllerWidget m_groupControllerWidget;
    protected EnsembleGroupSelectorWidget m_groupSelectorWidget;
    protected Sequence_MainWidget m_sequenceWorkerWidget;
    protected LinearLayoutWidget m_sequenceWrapperWidget = LinearLayoutWidget.vert(0, null);
    protected JButton m_sequenceLocationButton;
    protected boolean m_sequenceOnLeft = true;
    protected EnsembleAxisSelectionWidget m_axisWidget;
    protected PickDisplayWidget m_pickDisplayWidget;
    protected EnsembleVisibleTraceSelectionWidget m_visibleWidget;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected PreviousPicksWidget m_previousPicksWidget;
    protected JTable m_traceHeaderTable = new JTable();
    protected JTable m_traceSampleTable = new JTable();
    protected TraceFrequencyWidget m_traceFrequencyWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected TraceBackgroundWidget m_traceBackgroundWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected RadioPanel m_radioPlotType;
    protected PickPlaneCombo m_pickPlaneCombo = new PickPlaneCombo(this, true);
    protected UniqueColumnCombo m_selectorCombo = new UniqueColumnCombo();
    protected JTabbedPane m_navTabs = new JTabbedPane();
    protected NavigationWidget m_shotNavigationWidget;
    protected NavigationWidget m_recNavigationWidget;
    protected SnapshotWidget m_snapshotWidget;
    protected GeometryCorrectionWidget m_geomCorrWidget;
    protected JLabel m_timeLabel = new JLabel("", 0);
    protected String m_operationFlipPolarity = "Flip polarity";
    protected String m_unkillTraces = "Unkill traces for current shot or receiver";
    protected String m_operationKill = "Kill current shot or receiver";
    protected String m_operationUndoGeometryCorrection = "Undo geometry correction";
    protected String m_operationExportTraceHeaders = "Export trace headers to ASCII";
    protected PopupMenuButton m_operationButton;
    protected PopupMenuButton m_defaultsButton;
    protected String m_defaultsAutoPicker = "Prepare options for autopicking";
    protected String m_defaultsDelayTime = "Prepare options for delay time analysis";
    protected String m_defaultsTomo3D = "Prepare options for 3D tomographic analysis";
    protected String m_defaultsTomoVNS = "Prepare options for TomoVNS analysis";
    protected JButton m_lockButton;
    protected ImageIcon m_lockedIcon = Tools_Bitmap.makeIcon("Lock.png");
    protected ImageIcon m_unlockedIcon = Tools_Bitmap.makeIcon("Open lock.png");
    protected boolean m_isRangeLocked = false;
    protected OffsetBinNavigationWidget m_offsetBinNav;
    protected JButton m_btnNextOffsetBin;
    protected JButton m_btnPrevOffsetBin;
    protected ProfileSelectorWidget m_profileSelectorWidget;
    protected OffsetBinProfileNavigationWidget m_offsetBinProfileNav;
    protected OffsetBinInlineCrosslineNavigationWidget m_offsetBinInlineCrosslineNav;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected BitmapCardWidget m_rightBitmapCardWidget = new BitmapCardWidget();
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_groupEnsemble;
    protected Ensemble m_groupEnsemble_Copy = new Ensemble();
    protected Ensemble m_processedEnsemble;
    public int m_shotID;
    public int m_recID;
    public int m_selectedCrossline;
    public int m_selectedInline;
    public int m_selectedBin2D;
    protected Java2D_UserEventConsumer_MultiLineSegments m_lineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
    protected Java2D_UserEventConsumer_MultiLineSegments m_rubberBandUEC = new Java2D_UserEventConsumer_MultiLineSegments(true);
    protected Java2D_UserEventConsumer_KeyPressed m_keyUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected Java2D_UserEventConsumer_KeyPressed m_keyBasemapUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
    protected Java2D_UserEventConsumer_ButtonPressed m_middleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);
    protected Java2D_UserEventConsumer_Wheel m_wheelUEC = new Java2D_UserEventConsumer_Wheel();
    protected Java2D_UserEventConsumer_PenMode m_penUEC = new Java2D_UserEventConsumer_PenMode();
    protected ParameterTree m_parameters = new ParameterTree();
    protected String m_paramFileName;
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected int m_widgetNumber = 1;
    protected LayoutMethod m_layoutMethod = LayoutMethod.Standard;
    protected boolean m_bJustLoadedNewEnsembleForPriorPickWidget = true;
    protected HashMap_Long m_traceKilledHash = new HashMap_Long();
    protected PickPolygonDialog m_PickPolygonDialog;
    protected String m_autoPickColumnName = "";

    protected void finalize() {
        try {
            System.err.println("BasicPickWidget finalize");
            this.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public PickerBasemapWidget basemapWidget() {
        return this.m_basemapWidget;
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
        try {
            Object launchData;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String pickerType = "Picker";
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                pickerType = "OffsetPicker";
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile) {
                pickerType = "OffsetProfilePicker";
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                pickerType = "OffsetInlineCrosslinePicker";
            }
            String root = p.guiOptionsPath() + "/" + pickerType + Integer.toString(this.m_widgetNumber);
            this.m_paramFileName = root + "Options.xml";
            this.m_parameters.read(this.m_paramFileName);
            this.m_paramManager.addComboBoxConnector("PickPlane", this.m_pickPlaneCombo, 0);
            this.m_paramManager.addComboBoxConnector("NumHeaders", this.m_comboNumHeaders, 2);
            this.m_paramManager.addComboBoxConnector("NumHeaderPlots", this.m_comboNumHeaderPlot, 1);
            this.m_paramManager.setTree(this.m_parameters.ParameterTree_get("MainWindowOptions"));
            this.m_groupControllerWidget.setParentParameterTree(this.m_parameters);
            this.m_axisWidget.setParentParameterTree(this.m_parameters);
            this.m_wiggleOptionsWidget.setParentParameterTree(this.m_parameters);
            this.m_visibleWidget.setParentParameterTree(this.m_parameters);
            this.m_traceBackgroundWidget.setParentParameterTree(this.m_parameters);
            this.m_axisLockerOffset.setParentParameterTree(this.m_parameters, "OffsetLocker");
            this.m_axisLockerTime.setParentParameterTree(this.m_parameters, "TimeLocker");
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                this.m_groupControllerWidget.setGroupingOff();
                this.m_visibleWidget.selectAllVisible(false);
            }
            String sfn = root + ".SequenceXML";
            this.m_sequenceWorkerWidget.setFileName(sfn);
            this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.m_widget.setParameterTree(this.m_parameters.ParameterTree_get("Display"));
            if (this.m_axisWidget.isUniformSpacing()) {
                this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            } else {
                this.m_widget.setAxisTableColumn(this.m_axisWidget.getAxisTable(), this.m_axisWidget.getAxisColumn());
                this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            }
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.setPickPlane(false);
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                    this.m_selectorCombo.setTable(RefractionStaticsProject.singleton().receiverTable());
                    this.m_recNavigationWidget.setSelected(1000);
                    this.loadRec();
                }
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                    this.m_selectorCombo.setTable(RefractionStaticsProject.singleton().shotTable());
                    this.m_shotNavigationWidget.setSelected(1000);
                    this.loadShot();
                }
            }
            if ((launchData = SharedApplicationData.singleton().LaunchData) == null) {
                return;
            }
            if (!(launchData instanceof LaunchOptions)) {
                return;
            }
            LaunchOptions options = (LaunchOptions)launchData;
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                if (options.PrepForAutoPicks) {
                    this.prepDefaults_AutoPicker();
                    return;
                }
                if (options.PrepForDelayTimeAnalysis) {
                    this.prepDefaults_DelayTime();
                    return;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
            this.m_groupControllerWidget.saveParameters();
            this.m_axisWidget.saveParameters();
            this.m_wiggleOptionsWidget.saveParameters();
            this.m_axisLockerOffset.saveParameters();
            this.m_axisLockerTime.saveParameters();
            this.m_visibleWidget.saveParameters();
            this.m_traceBackgroundWidget.saveParameters();
            if (this.m_paramFileName != null) {
                this.m_parameters.save(this.m_paramFileName);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public LayoutMethod layoutMethod() {
        return this.m_layoutMethod;
    }

    public BasicPickWidget_V2() {
        super(1);
        try {
            this.m_layoutMethod = LayoutMethod.Standard;
            String sharedString = SharedApplicationData.singleton().SharedString;
            if (sharedString != null) {
                if (sharedString.equalsIgnoreCase("Offset")) {
                    this.m_layoutMethod = LayoutMethod.OffsetBins;
                }
                if (sharedString.equalsIgnoreCase("OffsetProfile")) {
                    this.m_layoutMethod = LayoutMethod.OffsetBinUsingProfile;
                }
                if (sharedString.equalsIgnoreCase("OffsetInlineCrossline")) {
                    this.m_layoutMethod = LayoutMethod.OffsetBinUsingInlineCrossline;
                }
            }
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.setOneTouchExpandable(true);
            this.m_rubberBandUEC.LineColor = Color.GREEN;
            this.m_rubberBandUEC.LineStroke = new BasicStroke(3.0f);
            this.m_rubberBandUEC.addListener(this);
            this.m_lineSegmentUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            this.m_mouseMoveUEC.addListener(this);
            this.m_middleClickUEC.addListener(this);
            this.m_keyUEC.addListener(this);
            this.m_keyBasemapUEC.addListener(this);
            this.m_penUEC.addListener(this);
            this.m_wheelUEC.addListener(this);
            this.loadUEC();
            Messenger.singleton().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile || this.m_layoutMethod == LayoutMethod.OffsetBins) {
                this.setPickPlane(false);
            }
            if (this.m_layoutMethod == LayoutMethod.Standard && this.m_snapshotWidget != null) {
                this.m_snapshotWidget.AxisLockerOffset = this.m_axisLockerOffset;
                this.m_snapshotWidget.AxisLockerTime = this.m_axisLockerTime;
                this.m_snapshotWidget.Sequence = this.m_sequence;
                this.m_snapshotWidget.BackgroundWidget = this.m_traceBackgroundWidget;
                this.m_snapshotWidget.WiggleOptionsWidget = this.m_wiggleOptionsWidget;
                this.m_snapshotWidget.PickDisplayWidget = this.m_pickDisplayWidget;
                this.m_snapshotWidget.VisibleWidget = this.m_visibleWidget;
                this.m_snapshotWidget.GroupControllerWidget = this.m_groupControllerWidget;
                this.m_snapshotWidget.AxisWidget = this.m_axisWidget;
                this.m_snapshotWidget.PlaneCombo = this.m_pickPlaneCombo;
                this.m_snapshotWidget.setListeners();
                this.m_snapshotWidget.setStatus();
            }
            this.m_timer.start();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget sub;
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_pickPlaneCombo = RefractionStaticsProject.singleton().dim2D() ? new PickPlaneCombo(this, false) : new PickPlaneCombo(this, true);
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                sub = main.createHorizontal(0, null, 0);
                sub.addComponent(new JLabel("Pick plane"), 0);
                sub.addComponent(this.m_pickPlaneCombo, 0);
                sub.addComponent(this.m_selectorCombo, 0);
                this.m_selectorCombo.setTable(RefractionStaticsProject.singleton().shotTable());
                this.m_selectorCombo.setPreferredSize(new Dimension(300, this.m_pickPlaneCombo.getSize().height));
                this.m_selectorCombo.listener().addListener(this);
                sub.addComponent(this.m_timeLabel, 10);
                sub.addStretch(10);
                this.m_defaultsButton = new PopupMenuButton(null, "Defaults", this);
                this.m_defaultsButton.addOption(this.m_defaultsAutoPicker);
                this.m_defaultsButton.addOption(this.m_defaultsDelayTime);
                this.m_defaultsButton.addOption(this.m_defaultsTomo3D);
                this.m_defaultsButton.addOption(this.m_defaultsTomoVNS);
                sub.addComponent(this.m_defaultsButton, 0);
                this.m_operationButton = new PopupMenuButton(null, "Operations", this);
                this.m_operationButton.addOption(this.m_operationFlipPolarity);
                this.m_operationButton.addOption(this.m_operationKill);
                this.m_operationButton.addOption(this.m_operationUndoGeometryCorrection);
                this.m_operationButton.addOption(this.m_unkillTraces);
                this.m_operationButton.addOption(this.m_operationExportTraceHeaders);
                sub.addComponent(this.m_operationButton, 0);
                this.m_lockButton = new JButton();
                this.m_lockButton.setIcon(this.m_unlockedIcon);
                this.m_lockButton.setVisible(true);
                sub.addComponent(this.m_lockButton, 0);
                this.m_lockButton.addActionListener(this);
                Tools_FontChanger.changeSizeOfFont(sub, -2, null, true);
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                sub = main.createHorizontal(0, null, 0);
                this.m_btnPrevOffsetBin = sub.createButton("Previous offset bin", this, 0);
                this.m_btnNextOffsetBin = sub.createButton("Next offset bin", this, 0);
                sub.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(sub, -2, null, true);
            }
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            this.m_widget.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            Table_Abstract mergeTable;
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                if (this.m_offsetBinInlineCrosslineNav == null) {
                    this.m_offsetBinInlineCrosslineNav = new OffsetBinInlineCrosslineNavigationWidget();
                }
                this.m_offsetBinInlineCrosslineNav.listener().addListener(this);
                this.m_offsetBinInlineCrosslineNav.azimuthSelectorWidget().listener().addListener(this);
                this.m_rightBitmapCardWidget.addComponent(BitmapEnum.Navigation, this.m_offsetBinInlineCrosslineNav, "Offset bin selection");
            }
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Horizontal lock", "Lock axis ");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(-400.0, 500.0);
            this.m_groupSelectorWidget = new EnsembleGroupSelectorWidget();
            this.m_groupSelectorWidget.listener().addListener(this);
            main.addComponent(this.m_axisLockerOffset, 0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addComponent(this.m_groupSelectorWidget, 10);
            Tools_FontChanger.changeSizeOfFont(main, -1, null, true);
            this.m_snapshotWidget = new SnapshotWidget();
            Object h = "<HTML>";
            h = (String)h + "You can view trace header data in this window.  First select ";
            h = (String)h + "a hot-key for the ViewTraceHeaders option";
            h = (String)h + "</HTML>";
            this.m_traceHeaderTable.setGridColor(Color.LIGHT_GRAY);
            this.m_traceHeaderTable.setShowGrid(true);
            JScrollPane headerScroll = new JScrollPane(this.m_traceHeaderTable);
            LinearLayoutWidget headers = LinearLayoutWidget.vert(0, null);
            headers.addComponent(new JLabel((String)h), 0);
            headers.addComponent(headerScroll, 10);
            Object s = "<HTML>";
            s = (String)s + "You can view the trace sample values in this window. First select ";
            s = (String)s + "a hot-key for the ViewTraceData option";
            s = (String)s + "</HTML>";
            this.m_traceSampleTable.setGridColor(Color.LIGHT_GRAY);
            this.m_traceSampleTable.setShowGrid(true);
            JScrollPane scroller = new JScrollPane(this.m_traceSampleTable);
            LinearLayoutWidget samples = LinearLayoutWidget.vert(0, null);
            samples.addComponent(new JLabel((String)s), 0);
            samples.addComponent(scroller, 10);
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Picker controls");
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.TaskList, main, "Axis locks, group info");
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.ImportedTable, headers, "View trace headers");
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.TraceSamples, samples, "View trace samples");
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_rightBitmapCardWidget.addComponent(BitmapEnum.Snapshot, this.m_snapshotWidget, "Snapshot creation");
            }
            if ((mergeTable = RefractionStaticsProject.singleton().mergeProjectTable()) != null) {
                JTable tbl = new JTable();
                tbl.setGridColor(Color.LIGHT_GRAY);
                tbl.setShowGrid(true);
                tbl.setModel(new Table_SimpleModel(mergeTable));
                JScrollPane scroller2 = new JScrollPane(tbl);
                this.m_rightBitmapCardWidget.addComponent(BitmapEnum.Bricks, scroller2, "View merged projects");
            }
            this.m_rightBitmapCardWidget.setPreferredSize(new Dimension(240, 500));
            this.m_rightBitmapCardWidget.setMinimumSize(new Dimension(240, 500));
            return this.m_rightBitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            int n;
            this.m_basemapWidget = new PickerBasemapWidget(this);
            this.m_basemapWidget.setKeyPressedUEC(this.m_keyBasemapUEC);
            JComponent basemapComponent = this.m_basemapWidget;
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_geomCorrWidget = new GeometryCorrectionWidget();
                this.m_geomCorrWidget.listener().addListener(this);
                JSplitPane splitter = new JSplitPane(0);
                splitter.setTopComponent(this.m_geomCorrWidget);
                splitter.setBottomComponent(this.m_basemapWidget);
                splitter.setOneTouchExpandable(true);
                basemapComponent = splitter;
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBins || this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile || this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_basemapWidget.drawBFD(false);
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile || this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_basemapWidget.setForceDrawLines(true);
            }
            this.m_groupControllerWidget = new EnsembleGroupControllerWidget();
            this.m_groupControllerWidget.listener().addListener(this);
            this.m_axisWidget = new EnsembleAxisSelectionWidget();
            this.m_axisWidget.listener().addListener(this);
            this.m_sequenceWorkerWidget = new Sequence_MainWidget("Picker", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_sequenceWorkerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_sequence.setRefractionStaticsProject(RefractionStaticsProject.singleton());
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_pickDisplayWidget = new PickDisplayWidget();
            this.m_pickDisplayWidget.getListenerController().addListener(this);
            this.m_traceBackgroundWidget = new TraceBackgroundWidget("Trace color");
            this.m_traceBackgroundWidget.listener().addListener(this);
            this.m_comboNumHeaders = new JComboBox();
            for (n = 1; n < 10; ++n) {
                this.m_comboNumHeaders.addItem(Integer.toString(n));
            }
            this.m_comboNumHeaders.setSelectedIndex(1);
            this.m_comboNumHeaders.addItemListener(this);
            this.m_comboNumHeaderPlot = new JComboBox();
            this.m_comboNumHeaderPlot.addItem("None");
            for (n = 1; n <= 4; ++n) {
                this.m_comboNumHeaderPlot.addItem(String.format("%d", n));
            }
            this.m_comboNumHeaderPlot.setSelectedIndex(1);
            this.m_comboNumHeaderPlot.addItemListener(this);
            GridLayoutWidget headerGrid = new GridLayoutWidget(0, "Text and plot headers");
            headerGrid.addSimple(0, new JLabel("Number of text headers"), this.m_comboNumHeaders);
            headerGrid.addSimple(1, new JLabel("Number of plot headers"), this.m_comboNumHeaderPlot);
            this.m_radioPlotType = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Display type", "Wiggles", "Gray scale");
            this.m_radioPlotType.listener().addListener(this);
            LinearLayoutWidget dispWiggle = LinearLayoutWidget.vert(0, null);
            dispWiggle.addComponent(this.m_radioPlotType, 0);
            String s = "<html>Gray scale display only available if horizontal<br> axis is Sort, then space traces evenly</html>";
            JLabel lbl = dispWiggle.createLabel(s, 0, 0);
            lbl.setForeground(Color.red);
            dispWiggle.addComponent(this.m_wiggleOptionsWidget, 0);
            dispWiggle.addStretch(11);
            LinearLayoutWidget dispPlot = LinearLayoutWidget.vert(0, null);
            dispPlot.addComponent(this.m_traceBackgroundWidget, 0);
            dispPlot.addComponent(headerGrid, 0);
            dispPlot.addComponent(this.m_pickDisplayWidget, 10);
            this.m_visibleWidget = new EnsembleVisibleTraceSelectionWidget(null);
            this.m_visibleWidget.listener().addListener(this);
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_shotNavigationWidget = new NavigationWidget("Shot");
                this.m_recNavigationWidget = new NavigationWidget("Receiver");
                this.m_navTabs.addTab("Shot", this.m_shotNavigationWidget);
                this.m_navTabs.addTab("Receiver", this.m_recNavigationWidget);
                this.m_navTabs.setSelectedIndex(0);
                this.m_shotNavigationWidget.listener().addListener(this);
                this.m_recNavigationWidget.listener().addListener(this);
            }
            this.m_previousPicksWidget = new PreviousPicksWidget();
            this.m_previousPicksWidget.setSequence(this.m_sequence);
            this.m_traceFrequencyWidget = new TraceFrequencyWidget();
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, basemapComponent, "Basemap");
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Navigation, this.m_navTabs, "Ensemble navigation");
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                this.m_offsetBinNav = new OffsetBinNavigationWidget(false, true);
                this.m_offsetBinNav.listener().addListener(this);
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Navigation, this.m_offsetBinNav, "Offset bin selection");
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, basemapComponent, "Basemap");
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile) {
                this.m_offsetBinProfileNav = new OffsetBinProfileNavigationWidget();
                this.m_offsetBinProfileNav.listener().addListener(this);
                this.m_offsetBinProfileNav.azimuthSelectorWidget().listener().addListener(this);
                this.m_profileSelectorWidget = new ProfileSelectorWidget(false, this.m_offsetBinProfileNav, 0);
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Profile, this.m_profileSelectorWidget, "Profile selection");
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Navigation, this.m_offsetBinProfileNav, "Offset bin selection");
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, basemapComponent, "Basemap");
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_basemapWidget.setPickPlane(PickPlaneEnum.Bin);
                this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, basemapComponent, "Basemap");
            }
            this.m_sequenceLocationButton = this.m_sequenceWrapperWidget.createButton("Move this processing sequence display to the right", this, 0);
            this.m_sequenceWrapperWidget.addComponent(this.m_sequenceWorkerWidget, 10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_sequenceWrapperWidget, "Ensemble processing sequence");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Groups, this.m_groupControllerWidget, "Ensemble grouping options");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Axis, this.m_axisWidget, "Horizontal axis selection");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, dispWiggle, "Wiggle display options");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.PickerPlotExtra, dispPlot, "Visible picks, header plots");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.VisibleTraces, this.m_visibleWidget, "Select visible traces");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.PreviousPicks, this.m_previousPicksWidget, "Prior pick usage");
            this.m_bitmapCardWidget.setPreferredSize(new Dimension(300, 500));
            return this.m_bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            int reloadID;
            boolean polarityFlipped;
            if (message == Messenger.Message.ReloadAllGathers) {
                if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                    this.loadOffset();
                }
                if (this.m_layoutMethod == LayoutMethod.Standard) {
                    this.load(false);
                }
                return;
            }
            if (message == Messenger.Message.TracePolarityFlipped) {
                boolean change = false;
                int numSelected = Messenger.selectedTraceCount();
                Column_Long colSelected = Messenger.selectedTraces();
                Column_Bool colPol = Messenger.selectedTracePolarity();
                for (int n = 0; n < numSelected; ++n) {
                    long traceIndex = colSelected.getLong(n);
                    boolean tracePol = colPol.getBool(n);
                    boolean mod = Tools_Ensemble.setTracePolarity(this.m_inputEnsemble, traceIndex, tracePol);
                    change = change || mod;
                }
                if (change) {
                    Tools_Ensemble_RefractionProject.setTracePolarity(this.m_inputEnsemble, true);
                    this.processGroupEnsemble(false);
                }
                return;
            }
            boolean bl = polarityFlipped = message == Messenger.Message.ReceiverPolarityFlipped || message == Messenger.Message.ShotPolarityFlipped;
            if (polarityFlipped) {
                Tools_Ensemble_RefractionProject.setTracePolarity(this.m_inputEnsemble, true);
                this.processGroupEnsemble(false);
                return;
            }
            if (message == Messenger.Message.PicksChanged) {
                if (sender == this) {
                    return;
                }
                Ensemble ensemble = (Ensemble)data;
                if (Tools_Ensemble.copyHeaderValue(ensemble, this.m_inputEnsemble, "Trace", "FBP_User") < 1) {
                    return;
                }
                this.processGroupEnsemble(false);
                this.handlePicksModified(false, false);
                return;
            }
            boolean reloadData = false;
            boolean updateID = false;
            if (message == Messenger.Message.ReceiverGeometryChanged) {
                reloadID = (Integer)data;
                boolean bl2 = reloadData = reloadData || Tools_Ensemble.hasReceiverID(this.m_inputEnsemble, reloadID);
            }
            if (message == Messenger.Message.ShotGeometryChanged) {
                reloadID = (Integer)data;
                boolean bl3 = reloadData = reloadData || Tools_Ensemble.hasShotID(this.m_inputEnsemble, reloadID);
            }
            if (message == Messenger.Message.ProjectVersionChanged) {
                reloadData = true;
            }
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                    if (reloadData) {
                        this.loadShot();
                        return;
                    }
                    if (message == Messenger.Message.ShotSelected) {
                        if (this.m_shotID != Messenger.shotID()) {
                            this.m_shotNavigationWidget.setSelected(Messenger.shotID());
                            this.loadShot();
                        }
                        return;
                    }
                    if (message == Messenger.Message.TraceSelected) {
                        if (this.m_shotID != Messenger.shotID()) {
                            this.m_shotNavigationWidget.setSelected(Messenger.shotID());
                            this.loadShot();
                        }
                        this.m_groupSelectorWidget.selectGroupWithReceiver(Messenger.receiverID());
                        return;
                    }
                    if (message == Messenger.Message.ReceiverSelected) {
                        this.m_groupSelectorWidget.selectGroupWithReceiver(Messenger.receiverID());
                        return;
                    }
                }
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                    if (reloadData) {
                        this.loadRec();
                        return;
                    }
                    if (message == Messenger.Message.ReceiverSelected) {
                        if (this.m_recID != Messenger.receiverID()) {
                            this.m_recNavigationWidget.setSelected(Messenger.receiverID());
                            this.loadRec();
                        }
                        return;
                    }
                    if (message == Messenger.Message.TraceSelected) {
                        if (this.m_recID != Messenger.receiverID()) {
                            this.m_recNavigationWidget.setSelected(Messenger.receiverID());
                            this.loadRec();
                        }
                        this.m_groupSelectorWidget.selectGroupWithShot(Messenger.shotID());
                        return;
                    }
                    if (message == Messenger.Message.ShotSelected) {
                        this.m_groupSelectorWidget.selectGroupWithShot(Messenger.shotID());
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            if (imagePainted && widgetIndex == 0) {
                this.m_basemapWidget.associatedEnsembleWidgetJustPainted(this.m_processedEnsemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadUEC() {
        try {
            boolean needControlPoint;
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            boolean bl = needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointSelect;
            if (needControlPoint) {
                this.m_widget.addEventConsumer(0, this.m_lineSegmentUEC);
            } else {
                this.m_widget.addEventConsumer(0, this.m_leftClickUEC);
            }
            this.m_widget.addEventConsumer(0, this.m_rubberBandUEC);
            this.m_widget.addEventConsumer(0, this.m_middleClickUEC);
            this.m_widget.addEventConsumer(0, this.m_wheelUEC);
            this.m_widget.addEventConsumer(0, this.m_mouseMoveUEC);
            this.m_widget.addEventConsumer(0, this.m_keyUEC);
            this.m_widget.addEventConsumer(0, this.m_penUEC);
            this.m_widget.addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void setPickPlane(boolean selectGroup) {
        try {
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_groupControllerWidget.groupManager().GroupList.clear();
                this.m_groupControllerWidget.groupManager().Label = " ";
                this.m_basemapWidget.setPickPlane(this.m_pickPlaneCombo.getPickPlane());
                this.m_groupControllerWidget.setPickPlane(this.m_pickPlaneCombo.getPickPlane());
                this.m_axisWidget.setPickPlane(this.m_pickPlaneCombo.getPickPlane());
                this.m_visibleWidget.setPickPlane(this.m_pickPlaneCombo.getPickPlane());
                this.m_geomCorrWidget.setPickPlane(this.m_pickPlaneCombo.getPickPlane());
                this.m_sequence.setPickPlane(this.m_pickPlaneCombo.getPickPlane());
                if (PickPlaneEnum.Shot == this.m_pickPlaneCombo.getPickPlane()) {
                    this.m_selectorCombo.setTable(RefractionStaticsProject.singleton().shotTable());
                    this.m_navTabs.setSelectedIndex(0);
                } else if (PickPlaneEnum.Receiver == this.m_pickPlaneCombo.getPickPlane()) {
                    this.m_selectorCombo.setTable(RefractionStaticsProject.singleton().receiverTable());
                    this.m_navTabs.setSelectedIndex(1);
                } else {
                    this.m_selectorCombo.setTable(null);
                }
                if (selectGroup) {
                    this.tryToSelectGroupIndex(0);
                }
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile) {
                this.m_basemapWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_groupControllerWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_axisWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_visibleWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_sequence.setPickPlane(PickPlaneEnum.Offset);
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                this.m_groupControllerWidget.groupManager().GroupList.clear();
                this.m_groupControllerWidget.groupManager().Label = " ";
                this.m_basemapWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_groupControllerWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_axisWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_visibleWidget.setPickPlane(PickPlaneEnum.Offset);
                this.m_sequence.setPickPlane(PickPlaneEnum.Offset);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepareWidget(boolean unzoom) {
        try {
            if (SharedApplicationData.JobRunning) {
                return;
            }
            boolean hasBack3 = false;
            if (this.m_processedEnsemble != null && this.m_processedEnsemble.dictionary().containsEntry("Trace", "FPB_Back3")) {
                hasBack3 = true;
            }
            if (this.m_processedEnsemble != null) {
                this.m_pickDisplayWidget.prepEnsemble(this.m_processedEnsemble);
            }
            this.m_widget.setEnsemble(0, this.m_processedEnsemble);
            this.m_visibleWidget.setVisibleTraces(this.m_processedEnsemble);
            if (this.m_offsetBinProfileNav != null) {
                this.m_offsetBinProfileNav.azimuthSelectorWidget().prepEnsemble(this.m_processedEnsemble, true);
            }
            if (this.m_offsetBinInlineCrosslineNav != null) {
                this.m_offsetBinInlineCrosslineNav.azimuthSelectorWidget().prepEnsemble(this.m_processedEnsemble, true);
            }
            this.m_traceBackgroundWidget.setBackground(this.m_processedEnsemble);
            if (this.m_axisWidget.isUniformSpacing()) {
                this.m_axisWidget.sortEnsemble(this.m_processedEnsemble);
            }
            if (unzoom) {
                this.m_widget.DrawWiggles = true;
                this.m_widget.DrawColor = false;
                if (this.m_axisWidget.isUniformSpacing() && this.m_radioPlotType.getSelectedIndex() == 1) {
                    this.m_widget.DrawColor = true;
                    this.m_widget.DrawWiggles = false;
                    this.m_widget.setUseGrayScale(true);
                }
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
            } else {
                this.m_widget.forcePaintAll();
            }
            if (this.m_geomCorrWidget != null) {
                this.m_geomCorrWidget.setEnsemble(this.m_inputEnsemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void processGroupEnsemble(boolean unzoom) {
        try {
            long total;
            long start;
            if (SharedApplicationData.JobRunning) {
                return;
            }
            if (this.m_groupEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_groupEnsemble.resetAllKillFlags();
                start = System.currentTimeMillis();
                this.m_groupEnsemble.copyToOtherEnsemble(this.m_groupEnsemble_Copy);
                total = System.currentTimeMillis() - start;
                this.m_groupEnsemble_Copy.pickPlotData().clearRequiredList();
                start = System.currentTimeMillis();
                String sUnits = "unknown";
                try {
                    sUnits = RefractionStaticsProject.singleton().units_feet() ? "Feet" : "Meters";
                }
                catch (Exception ex) {
                    ExceptionMonitor.add(ex);
                }
                this.m_sequence.setDistanceUnits(sUnits);
                this.m_sequence.setInteractiveMode(true);
                this.m_sequence.setRefractionStaticsProject(RefractionStaticsProject.singleton());
                this.m_processedEnsemble = this.m_sequence.work(this.m_groupEnsemble_Copy);
                total = System.currentTimeMillis() - start;
                Tools_Ensemble.computeMaximumAmplitude_Buffer(this.m_processedEnsemble, "MAXAMP", 40);
                this.m_axisWidget.setEnsembleHeaderDictionary(this.m_processedEnsemble.dictionary());
                this.m_visibleWidget.setEnsembleHeaderDictionary(this.m_processedEnsemble.dictionary());
            }
            start = System.currentTimeMillis();
            this.prepareWidget(unzoom);
            total = System.currentTimeMillis() - start;
            if (this.m_geomCorrWidget != null) {
                this.m_geomCorrWidget.setEnsemble(this.m_inputEnsemble);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void tryToSelectGroupIndex(int groupIndex) {
        try {
            EnsembleGroupManager egm = this.m_groupControllerWidget.groupManager();
            if (egm.GroupList.size() < 1) {
                System.out.println("(egm.GroupList.size() < 1)");
                this.m_processedEnsemble = null;
                this.m_widget.setEnsemble(0, null);
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                return;
            }
            groupIndex = Math.max(0, groupIndex);
            groupIndex = Math.min(egm.GroupList.size() - 1, groupIndex);
            this.m_groupSelectorWidget.setSelectedIndex(groupIndex);
            this.m_groupEnsemble = egm.GroupList.get((int)groupIndex).GroupEnsemble;
            int numVisible = this.m_visibleWidget.visibleTraceCount(this.m_groupEnsemble);
            while (numVisible < 1 && groupIndex < egm.GroupList.size() - 1) {
                this.m_groupSelectorWidget.setSelectedIndex(++groupIndex);
                this.m_groupEnsemble = egm.GroupList.get((int)groupIndex).GroupEnsemble;
                numVisible = this.m_visibleWidget.visibleTraceCount(this.m_groupEnsemble);
            }
            this.processGroupEnsemble(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewInputEnsemble(boolean preserveCurrentGroup) {
        try {
            this.handleNewInputEnsemble(preserveCurrentGroup, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewInputEnsemble(boolean preserveCurrentGroup, boolean fromDragger) {
        try {
            this.m_traceKilledHash = new HashMap_Long();
            Tools_Ensemble.prepKilledHash(this.m_inputEnsemble, this.m_traceKilledHash);
            Tools_Ensemble.copyHeaderValue(this.m_inputEnsemble, "Trace", "Killed", "Trace", "KilledTemp");
            Tools_DelayTime_Geometry.singleton().computeGeometryCorrection(true, this.m_inputEnsemble, "FBP_User");
            if (this.m_bJustLoadedNewEnsembleForPriorPickWidget) {
                this.m_previousPicksWidget.setCurrentEnsemble(this.m_inputEnsemble);
            }
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = false;
            this.m_groupControllerWidget.prepareGroup(this.m_inputEnsemble);
            this.m_groupSelectorWidget.prep(this.m_groupControllerWidget.groupManager(), preserveCurrentGroup);
            if (!fromDragger) {
                if (!preserveCurrentGroup) {
                    this.tryToSelectGroupIndex(0);
                } else {
                    this.tryToSelectGroupIndex(this.m_groupSelectorWidget.getSelectedIndex());
                }
            } else {
                this.tryToSelectGroupIndex(this.m_groupSelectorWidget.getSelectedIndex());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadShot() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            if (this.m_inputEnsemble != null) {
                RefractionStaticsProject.singleton().getInteractiveMoveoutTrend().addPicks(this.m_inputEnsemble, true);
            }
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
            this.m_shotID = this.m_shotNavigationWidget.selected();
            long start = System.currentTimeMillis();
            if (this.getIsUsingOmegaShotCorrelationPicker()) {
                int nNumberOfShotsToMix = this.getOmegaShotCorrelationPickerNumberOfShotsToMix();
                RefractionStaticsProject.singleton().ensemble_Shots(this.m_inputEnsemble, this.m_shotID, true, nNumberOfShotsToMix);
            } else {
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_inputEnsemble, this.m_shotID, true);
            }
            long end = System.currentTimeMillis();
            System.out.println("loadShot " + Long.toString(end - start));
            this.m_inputEnsemble.parameterTree().setString("ShotID", Integer.toString(this.m_shotID));
            this.handleNewInputEnsemble(false);
            this.m_selectorCombo.setSelectedID(this.m_shotID);
            this.m_snapshotWidget.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean getIsUsingOmegaShotCorrelationPicker() {
        try {
            if (this.m_sequence != null) {
                int nWorkers = this.m_sequence.size();
                for (int iWorker = 0; iWorker < nWorkers; ++iWorker) {
                    EnsembleWorker_Base worker = this.m_sequence.worker(iWorker);
                    String sWorkerID = worker.uniqueID();
                    if (!sWorkerID.equals("EnsembleWorker_shot_correl_fb_pick") || !worker.WorkerTurnedOn) continue;
                    return true;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return false;
    }

    protected int getOmegaShotCorrelationPickerNumberOfShotsToMix() {
        try {
            if (this.m_sequence != null) {
                int nWorkers = this.m_sequence.size();
                for (int iWorker = 0; iWorker < nWorkers; ++iWorker) {
                    ParameterTree parameterTree;
                    EnsembleWorker_Base worker = this.m_sequence.worker(iWorker);
                    String sWorkerID = worker.uniqueID();
                    if (!sWorkerID.equals("EnsembleWorker_shot_correl_fb_pick") || !worker.WorkerTurnedOn || !(parameterTree = worker.parameterTree()).int_exists("NumberOfShotsToMix")) continue;
                    int nShotsToMix = parameterTree.int_get("NumberOfShotsToMix");
                    return nShotsToMix;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return 0;
    }

    protected void loadRec() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            if (this.m_inputEnsemble != null) {
                RefractionStaticsProject.singleton().getInteractiveMoveoutTrend().addPicks(this.m_inputEnsemble, true);
            }
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
            this.m_recID = this.m_recNavigationWidget.selected();
            RefractionStaticsProject.singleton().ensemble_Receiver(this.m_inputEnsemble, this.m_recID, true);
            this.handleNewInputEnsemble(false);
            this.m_selectorCombo.setSelectedID(this.m_recID);
            this.m_snapshotWidget.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleAzimuthWidget() {
        try {
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile) {
                this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
                this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
                this.handleNewInputEnsemble(false);
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
                this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
                this.handleNewInputEnsemble(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadOffsetInlineCrossline() {
        try {
            if (this.m_layoutMethod != LayoutMethod.OffsetBinUsingInlineCrossline) {
                return;
            }
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
            this.m_offsetBinInlineCrosslineNav.populateEnsemble(this.m_inputEnsemble, false);
            this.handleAzimuthWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadOffsetProfile() {
        try {
            if (this.m_layoutMethod != LayoutMethod.OffsetBinUsingProfile) {
                return;
            }
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
            this.m_offsetBinProfileNav.populateEnsemble(this.m_inputEnsemble, false);
            this.handleAzimuthWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadOffset() {
        try {
            if (this.m_layoutMethod != LayoutMethod.OffsetBins) {
                return;
            }
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            this.m_previousPicksWidget.setPriorEnsemble(this.m_inputEnsemble);
            this.m_offsetBinNav.populateEnsemble(this.m_inputEnsemble, false);
            this.handleNewInputEnsemble(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepDefaults_AutoPicker() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_sequence.clear();
            this.m_sequence.add(new EnsembleWorker_ApplyMoveoutTrend(), false);
            this.m_sequence.add(new EnsembleWorker_ButterworthLowPass(), false);
            this.m_sequence.add(new EnsembleWorker_ThresholdPicker(), false);
            this.m_groupControllerWidget.selectHeaderGrouping();
            this.m_visibleWidget.selectAllVisible(true);
            this.m_axisLockerTime.setLockedRange(-500.0, 500.0);
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.load(true);
            this.m_snapshotWidget.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepDefaults_DelayTime() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_sequence.clear();
            this.m_sequence.add(new EnsembleWorker_DelayTimeShifts(), false);
            this.m_sequence.add(new EnsembleWorker_ButterworthLowPass(), false);
            this.m_sequence.add(new EnsembleWorker_NearestTimePicker(), false);
            this.m_groupControllerWidget.selectGroupingOff();
            this.m_visibleWidget.selectDelayTimeVisible(true);
            this.m_axisLockerTime.setLockedRange(-300.0, 300.0);
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.load(true);
            this.m_snapshotWidget.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepDefaults_Tomo3D() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_sequence.clear();
            this.m_sequence.add(new EnsembleWorker_Eikonal3D(), false);
            this.m_sequence.add(new EnsembleWorker_ButterworthLowPass(), false);
            this.m_axisWidget.setAxis("Trace", "Offset");
            this.m_visibleWidget.selectAllVisible(false);
            this.m_groupControllerWidget.selectGroupingOff();
            this.m_visibleWidget.selectHeaderVisible("Trace", "Offset", 0.0, 6000.0, false);
            this.m_axisLockerTime.setLockedRange(-300.0, 300.0);
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.load(true);
            this.m_snapshotWidget.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepDefaults_TomoVNS() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_sequence.clear();
            this.m_sequence.add(new EnsembleWorker_TomoVNS(), false);
            this.m_sequence.add(new EnsembleWorker_ButterworthLowPass(), false);
            this.m_axisWidget.setAxis("Trace", "Offset");
            this.m_visibleWidget.selectAllVisible(false);
            this.m_groupControllerWidget.selectGroupingOff();
            this.m_visibleWidget.selectHeaderVisible("Trace", "Offset", 0.0, 6000.0, false);
            this.m_axisLockerTime.setLockedRange(-300.0, 300.0);
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.load(true);
            this.m_snapshotWidget.setStatus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
        try {
            if (text.equalsIgnoreCase(this.m_defaultsAutoPicker)) {
                this.prepDefaults_AutoPicker();
                return;
            }
            if (text.equalsIgnoreCase(this.m_defaultsDelayTime)) {
                this.prepDefaults_DelayTime();
                return;
            }
            if (text.equalsIgnoreCase(this.m_defaultsTomo3D)) {
                this.prepDefaults_Tomo3D();
                return;
            }
            if (text.equalsIgnoreCase(this.m_defaultsTomoVNS)) {
                this.prepDefaults_TomoVNS();
                return;
            }
            if (text.equalsIgnoreCase(this.m_operationExportTraceHeaders)) {
                String dir = RefractionStaticsProject.singleton().projectPath();
                String filename = dir + "/headers.csv";
                Ensemble e1 = this.m_inputEnsemble;
                Tools_Ensemble.writeHeaderstoAscii(e1, filename);
            }
            if (text.equalsIgnoreCase(this.m_operationUndoGeometryCorrection)) {
                this.undoGeomCorrection();
                return;
            }
            if (text.equalsIgnoreCase(this.m_unkillTraces)) {
                this.unkillTraces();
                return;
            }
            if (text.equalsIgnoreCase(this.m_operationKill)) {
                this.killCurrent();
                return;
            }
            if (text.equalsIgnoreCase(this.m_operationFlipPolarity)) {
                this.flipCurrent();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_SparseCMPSelected(Ensemble ensemble) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_inputEnsemble = ensemble;
            if (this.m_inputEnsemble == null) {
                this.m_inputEnsemble = new Ensemble();
            }
            double cmpX = RefractionStaticsProject.singleton().sparseCmpGathers().SelectedX;
            double cmpY = RefractionStaticsProject.singleton().sparseCmpGathers().SelectedY;
            this.m_sequence.setSparseCmpX(cmpX);
            this.m_sequence.setSparseCmpY(cmpY);
            this.handleNewInputEnsemble(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_Bin2DSelected(int bin) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_selectedBin2D = bin;
            RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, this.m_selectedBin2D, 0, true);
            this.handleNewInputEnsemble(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void binNavigation(int inlineChange, int crosslineChange) {
        try {
            if (this.m_pickPlaneCombo.getPickPlane() != PickPlaneEnum.Bin) {
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                if (RefractionStaticsProject.singleton().dim3D()) {
                    this.m_selectedInline += inlineChange;
                    this.m_selectedCrossline += crosslineChange;
                    RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, this.m_selectedInline, this.m_selectedCrossline, 0, true);
                } else {
                    this.m_selectedBin2D += inlineChange;
                    RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, this.m_selectedBin2D, 0, true);
                }
                this.handleNewInputEnsemble(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_Bin3DSelected(int inline, int crossline) {
        try {
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_offsetBinInlineCrosslineNav.setInlineCrossline(inline, crossline, false);
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_selectedInline = inline;
                this.m_selectedCrossline = crossline;
                RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, this.m_selectedInline, this.m_selectedCrossline, 0, true);
                this.handleNewInputEnsemble(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ShotSelected(int id, int plotIndex) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_shotNavigationWidget.setSelected(id);
            this.loadShot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ShotDrag(double x, double y) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            if (this.m_pickPlaneCombo.getPickPlane() != PickPlaneEnum.Shot) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tools_Ensemble.setShotCoords(this.m_inputEnsemble, x, y);
            Tools_Ensemble.computeAzimuthAndOffset(this.m_inputEnsemble);
            Tools_Ensemble_RefractionProject.computeCdpCoords(this.m_inputEnsemble);
            Tools_Ensemble.killTraces(this.m_inputEnsemble);
            p.getDelayTimeData().branchAssignment().assignBranch(this.m_inputEnsemble, "Branch_DelayTime");
            p.getDelayTimeData().computeRefractorTravelTimes(this.m_inputEnsemble);
            this.handleNewInputEnsemble(true, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ReceiverDrag(double x, double y) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            if (this.m_pickPlaneCombo.getPickPlane() != PickPlaneEnum.Receiver) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Tools_Ensemble.setReceiverCoords(this.m_inputEnsemble, x, y);
            Tools_Ensemble.computeAzimuthAndOffset(this.m_inputEnsemble);
            Tools_Ensemble_RefractionProject.computeCdpCoords(this.m_inputEnsemble);
            Tools_Ensemble.killTraces(this.m_inputEnsemble);
            p.getDelayTimeData().branchAssignment().assignBranch(this.m_inputEnsemble, "Branch_DelayTime");
            p.getDelayTimeData().computeRefractorTravelTimes(this.m_inputEnsemble);
            this.handleNewInputEnsemble(true, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ReceiverDragFinish(double x, double y) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            if (this.m_pickPlaneCombo.getPickPlane() != PickPlaneEnum.Receiver) {
                return;
            }
            RefractionStaticsProject.singleton().moveReceiver(this.m_recID, x, y);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ShotDragFinish(double x, double y) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            if (this.m_pickPlaneCombo.getPickPlane() != PickPlaneEnum.Shot) {
                return;
            }
            RefractionStaticsProject.singleton().moveShot(this.m_shotID, x, y);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ReceiverSelected(int id) {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            this.m_recNavigationWidget.setSelected(id);
            this.loadRec();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_comboNumHeaders) {
                this.m_widget.HeaderTextRowCount = 1 + this.m_comboNumHeaders.getSelectedIndex();
                this.m_widget.placeWidgets();
                return;
            }
            if (e.getSource() == this.m_comboNumHeaderPlot) {
                int count = this.m_comboNumHeaderPlot.getSelectedIndex();
                this.m_widget.setHeaderPlotVisibleCount(0, count);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void unkillTraces() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                p.unkillTraces_Shot(this.m_shotID);
            }
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                p.unkillTraces_Rec(this.m_recID);
            }
            this.load(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void killCurrent() {
        try {
            int id;
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                id = this.m_shotID;
                p.setShotKilled(id, true);
            }
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                id = this.m_recID;
                p.setReceiverKilled(id, true);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void undoGeomCorrection() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                p.resetShotCoords(this.m_shotID);
            }
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                p.resetReceiverCoords(this.m_recID);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void flipCurrent() {
        try {
            if (this.m_layoutMethod != LayoutMethod.Standard) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                p.flipShotPolarity(this.m_shotID);
            }
            if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                p.flipReceiverPolarity(this.m_recID);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void moveSequenceWidget() {
        try {
            BitmapCardWidget left = this.m_bitmapCardWidget;
            BitmapCardWidget right = this.m_rightBitmapCardWidget;
            if (this.m_sequenceOnLeft) {
                this.m_sequenceLocationButton.setText("Move the processing sequence widget to the left");
                left.removeComponent(this.m_sequenceWrapperWidget);
                right.addComponent(BitmapEnum.Sequence, this.m_sequenceWrapperWidget, "Ensemble processing sequence");
                right.showComponent(this.m_sequenceWrapperWidget);
            } else {
                this.m_sequenceLocationButton.setText("Move the processing sequence widget to the right");
                right.removeComponent(this.m_sequenceWrapperWidget);
                left.addComponent(BitmapEnum.Sequence, this.m_sequenceWrapperWidget, "Ensemble processing sequence");
                left.showComponent(this.m_sequenceWrapperWidget);
            }
            this.m_sequenceOnLeft = !this.m_sequenceOnLeft;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_sequenceLocationButton) {
                this.moveSequenceWidget();
                return;
            }
            if (e.getSource() == this.m_btnNextOffsetBin) {
                this.m_offsetBinNav.goToNext(false);
                this.loadOffset();
                return;
            }
            if (e.getSource() == this.m_btnPrevOffsetBin) {
                this.m_offsetBinNav.goToPrev(false);
                this.loadOffset();
                return;
            }
            if (e.getSource() == this.m_timer) {
                return;
            }
            if (e.getSource() == this.m_lockButton) {
                if (this.m_isRangeLocked) {
                    this.m_isRangeLocked = false;
                    this.m_lockButton.setIcon(this.m_unlockedIcon);
                    this.m_widget.unlockViewports();
                    this.m_widget.unzoom();
                } else {
                    this.m_isRangeLocked = true;
                    this.m_lockButton.setIcon(this.m_lockedIcon);
                    this.m_widget.lockViewports();
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void load(boolean loadIfReceiverPlane) {
        try {
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                if (loadIfReceiverPlane && this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver) {
                    int id = this.m_selectorCombo.getSelectedID();
                    this.m_recNavigationWidget.setSelected(id);
                    this.loadRec();
                    return;
                }
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot) {
                    int id = this.m_selectorCombo.getSelectedID();
                    this.m_shotNavigationWidget.setSelected(id);
                    this.loadShot();
                    return;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void tryToLaunchBatchPicker(Object data) {
        try {
            Object p;
            EnsembleWorker_Base worker;
            EnsembleWorker_Base tp;
            boolean isEnergy;
            boolean acceptable;
            System.out.println("BasicPickWidget_V2 tryToLaunchBatchPicker");
            Object md = this.m_sequence.MessageData.ExtraData;
            if (md == null) {
                return;
            }
            EnsembleWorker_Base sourceWorker = (EnsembleWorker_Base)md;
            if (sourceWorker == null) {
                return;
            }
            sourceWorker.getParametersFromWidget();
            if (md instanceof EnsembleWorker_ThresholdPicker) {
                EnsembleWorker_ThresholdPicker ensembleWorker_ThresholdPicker = (EnsembleWorker_ThresholdPicker)md;
            }
            boolean bl = acceptable = (isEnergy = md instanceof EnsembleWorker_EnergyInWindow) || sourceWorker.FirstBreakAutoPicker;
            if (!acceptable) {
                return;
            }
            EnsembleWorker_Base picker = sourceWorker;
            ParameterTree pt = picker.parameterTree();
            PickPlaneEnum pp = this.m_pickPlaneCombo.getPickPlane();
            boolean threaded = false;
            this.m_autoPickColumnName = "";
            boolean needShotEnsembles = false;
            boolean applyOffsetLimits = false;
            double minOffset = 0.0;
            double maxOffset = 1.0E10;
            if (md instanceof EnsembleWorker_AmpOnsetPicker) {
                needShotEnsembles = pp == PickPlaneEnum.Shot;
                tp = (EnsembleWorker_AmpOnsetPicker)md;
                ((EnsembleWorker_AmpOnsetPicker)tp).setOverwritePicks();
                ((EnsembleWorker_AmpOnsetPicker)tp).getParametersFromWidget();
                boolean bl2 = applyOffsetLimits = applyOffsetLimits || ((EnsembleWorker_AmpOnsetPicker)tp).ApplyOffsetLimits;
                if (((EnsembleWorker_AmpOnsetPicker)tp).ApplyOffsetLimits) {
                    minOffset = ((EnsembleWorker_AmpOnsetPicker)tp).BatchMinOffset;
                    maxOffset = ((EnsembleWorker_AmpOnsetPicker)tp).BatchMaxOffset;
                }
                this.m_autoPickColumnName = ((EnsembleWorker_AmpOnsetPicker)tp).getColumnName();
            }
            if (md instanceof EnsembleWorker_AmpOnsetPicker_Snap) {
                needShotEnsembles = pp == PickPlaneEnum.Shot;
                tp = (EnsembleWorker_AmpOnsetPicker_Snap)md;
                ((EnsembleWorker_AmpOnsetPicker_Snap)tp).setOverwritePicks();
                ((EnsembleWorker_AmpOnsetPicker_Snap)tp).getParametersFromWidget();
                this.m_autoPickColumnName = ((EnsembleWorker_AmpOnsetPicker_Snap)tp).getColumnName();
            } else if (md instanceof EnsembleWorker_ThresholdPicker) {
                tp = (EnsembleWorker_ThresholdPicker)md;
                ((EnsembleWorker_ThresholdPicker)tp).setOverwritePicks();
                this.m_autoPickColumnName = ((EnsembleWorker_ThresholdPicker)tp).getColumnName();
            } else if (md instanceof EnsembleWorker_NearestTimePicker) {
                tp = (EnsembleWorker_NearestTimePicker)md;
                ((EnsembleWorker_NearestTimePicker)tp).setOverwritePicks();
                this.m_autoPickColumnName = ((EnsembleWorker_NearestTimePicker)tp).getColumnName();
            } else if (sourceWorker.FirstBreakAutoPicker) {
                this.m_autoPickColumnName = sourceWorker.getColumnName();
            }
            for (int n = 0; n < this.m_sequence.size(); ++n) {
                EnsembleWorker_Base worker2 = this.m_sequence.worker(n);
                worker2.getParametersFromWidget();
                boolean bl3 = needShotEnsembles = needShotEnsembles || worker2.RequiresShotOrderedData;
                if (worker2 != picker) continue;
                n = 1000000;
            }
            EnsembleWorker_Sequence runSequence = new EnsembleWorker_Sequence(EnsembleWorker_Sequence.SequenceType.Processing);
            EnsembleWorker_ScanProjectTraces scanner = new EnsembleWorker_ScanProjectTraces();
            if (needShotEnsembles) {
                scanner.setScanPlane(EnsembleWorker_ScanProjectTraces.ScanPlaneEnum.Shot);
            } else {
                scanner.setScanPlane(EnsembleWorker_ScanProjectTraces.ScanPlaneEnum.Sequential);
            }
            if (applyOffsetLimits) {
                scanner.setOffsetFilter(true, minOffset, maxOffset);
            }
            runSequence.add(scanner, false, false);
            for (int n = 0; n < this.m_sequence.size(); ++n) {
                worker = this.m_sequence.worker(n);
                worker.getParametersFromWidget();
                if (worker.WorkerTurnedOn) {
                    runSequence.add(worker.cloneWithParameterTree(), false, false);
                }
                if (worker != picker) continue;
                n = 1000000;
            }
            String column = "";
            if (md instanceof EnsembleWorker_ThresholdPicker) {
                p = (EnsembleWorker_ThresholdPicker)md;
                column = ((EnsembleWorker_ThresholdPicker)p).getColumnName();
            } else if (md instanceof EnsembleWorker_NearestTimePicker) {
                p = (EnsembleWorker_NearestTimePicker)md;
                column = ((EnsembleWorker_NearestTimePicker)p).getColumnName();
            } else if (md instanceof EnsembleWorker_AmpOnsetPicker) {
                p = (EnsembleWorker_AmpOnsetPicker)md;
                column = ((EnsembleWorker_AmpOnsetPicker)p).getColumnName();
            } else if (md instanceof EnsembleWorker_AmpOnsetPicker_Snap) {
                p = (EnsembleWorker_AmpOnsetPicker_Snap)md;
                column = ((EnsembleWorker_AmpOnsetPicker_Snap)p).getColumnName();
            } else if (md instanceof EnsembleWorker_EnergyInWindow) {
                p = (EnsembleWorker_EnergyInWindow)md;
                column = ((EnsembleWorker_EnergyInWindow)p).getColumnName();
            } else if (md instanceof EnsembleWorker_ShiftUserPicks) {
                column = "FBP_User";
            } else if (md instanceof EnsembleWorker_Base) {
                worker = (EnsembleWorker_Base)md;
                if (worker.FirstBreakAutoPicker) {
                    column = worker.getColumnName();
                }
            }
            if (!column.isEmpty()) {
                p = RefractionStaticsProject.singleton();
                if (((RefractionStaticsProject)p).traceTableWrapper().traceTable().needToExpandTableMemory(DataType.Float)) {
                    ((RefractionStaticsProject)p).traceTable_SaveandRead_MainThread();
                }
                ((RefractionStaticsProject)p).traceTableWrapper().traceTable().column_append(column, DataType.Float);
                EnsembleWorker_MergeTraceHeader writer = new EnsembleWorker_MergeTraceHeader();
                writer.setColumnName(column);
                runSequence.add(writer, false, false);
            }
            if (RefractionStaticsProject.singleton().polygon() != null) {
                scanner.Polygon = RefractionStaticsProject.singleton().polygon();
                try {
                    if (this.m_PickPolygonDialog == null) {
                        this.m_PickPolygonDialog = new PickPolygonDialog(false);
                    }
                    this.m_PickPolygonDialog.showDialog();
                    scanner.RequireShotInsidePolygon = this.m_PickPolygonDialog.CheckRequireSource.isSelected();
                    scanner.RequireReceiverInsidePolygon = this.m_PickPolygonDialog.CheckRequireRec.isSelected();
                    scanner.RequireCdpInsidePolygon = this.m_PickPolygonDialog.CheckRequireCdp.isSelected();
                }
                catch (Exception p2) {
                    // empty catch block
                }
            }
            Action_RunSequence action = new Action_RunSequence();
            action.Sequence = runSequence;
            action.Hasher.string_put("Description", "Batch auto picker");
            action.Hasher.bool_put("RequiresDelayTimeData", false);
            action.Hasher.bool_put("RequiresRefractionStaticsProject", sourceWorker.FirstBreakAutoPicker);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String sUnits = "Meters";
            if (project.units_feet()) {
                sUnits = "Feet";
            }
            action.Sequence.setDistanceUnits(sUnits);
            action.Sequence.setRefractionStaticsProject(project);
            if (!this.m_autoPickColumnName.isEmpty()) {
                project.executeSingleAction(action, this);
            } else {
                project.executeSingleAction(action);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleActionSequenceFinished(Action_Sequence sender) {
        try {
            if (this.m_autoPickColumnName == null) {
                return;
            }
            if (this.m_autoPickColumnName.isEmpty()) {
                return;
            }
            RefractionProjectSuggestions.singleton().autopickSuggestion(this.m_autoPickColumnName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void nextEnsemble() {
        try {
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_offsetBinInlineCrosslineNav.goToNextOffsets();
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile) {
                this.m_offsetBinProfileNav.goToNext();
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                this.m_offsetBinNav.goToNext(false);
                this.loadOffset();
                return;
            }
            if (this.m_layoutMethod != LayoutMethod.Standard) return;
            PickPlaneEnum pp = this.m_pickPlaneCombo.getPickPlane();
            if (pp == PickPlaneEnum.Shot) {
                this.m_shotNavigationWidget.goToNext();
                this.loadShot();
                return;
            }
            if (pp == PickPlaneEnum.Receiver) {
                this.m_recNavigationWidget.goToNext();
                this.loadRec();
                return;
            }
            if (pp == PickPlaneEnum.Sparse) {
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                sparse.next(this.m_inputEnsemble);
                p.traceTableWrapper().traceTable().fillEnsembleHeaders(this.m_inputEnsemble);
                RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_inputEnsemble, true, true);
                RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
                this.handleBasemap_SparseCMPSelected(this.m_inputEnsemble);
                return;
            }
            if (pp != PickPlaneEnum.Bin) return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void priorEnsemble() {
        try {
            this.m_bJustLoadedNewEnsembleForPriorPickWidget = true;
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingInlineCrossline) {
                this.m_offsetBinInlineCrosslineNav.goToPriorOffsets();
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBinUsingProfile) {
                this.m_offsetBinProfileNav.goToPrev();
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.OffsetBins) {
                this.m_offsetBinNav.goToPrev(false);
                this.loadOffset();
                return;
            }
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                PickPlaneEnum pp = this.m_pickPlaneCombo.getPickPlane();
                if (pp == PickPlaneEnum.Shot) {
                    this.m_shotNavigationWidget.goToPrevious();
                    this.loadShot();
                    return;
                }
                if (pp == PickPlaneEnum.Receiver) {
                    this.m_recNavigationWidget.goToPrevious();
                    this.loadRec();
                    return;
                }
                if (pp == PickPlaneEnum.Sparse) {
                    RefractionStaticsProject p = RefractionStaticsProject.singleton();
                    SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                    sparse.prior(this.m_inputEnsemble);
                    p.traceTableWrapper().traceTable().fillEnsembleHeaders(this.m_inputEnsemble);
                    RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_inputEnsemble, true, true);
                    RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
                    this.handleBasemap_SparseCMPSelected(this.m_inputEnsemble);
                    return;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKeyUEC(Java2D_UserEventConsumer_KeyPressed keyUEC) {
        try {
            boolean plotUEC;
            PickerGizmo pg = PickerGizmo.singleton();
            EnsembleGroupManager egm = this.m_groupControllerWidget.groupManager();
            int groupIndex = this.m_groupSelectorWidget.getSelectedIndex();
            boolean mapUEC = keyUEC == this.m_keyBasemapUEC;
            boolean bl = plotUEC = keyUEC == this.m_keyUEC;
            if (keyUEC.KeyCode >= 48 && keyUEC.KeyCode <= 57) {
                int index = keyUEC.KeyCode - 48;
                this.m_visibleWidget.handleKeyboard(index);
                return;
            }
            if (keyUEC.EscapePressed) {
                if (plotUEC) {
                    PickerGizmo.broadcastControlClick(this, this.m_processedEnsemble, keyUEC.PixelX);
                }
                return;
            }
            if (pg.zoomIn(keyUEC)) {
                this.m_widget.horz_zoom(keyUEC.WorldX, 0.8);
                return;
            }
            if (pg.zoomOut(keyUEC)) {
                this.m_widget.horz_zoom(keyUEC.WorldX, 1.2);
                return;
            }
            if (pg.scrollLeft(keyUEC)) {
                this.m_widget.horz_shift_left(0.2);
                return;
            }
            if (pg.scrollRight(keyUEC)) {
                this.m_widget.horz_shift_right(0.2);
                return;
            }
            if (pg.keyOff(keyUEC)) {
                return;
            }
            if (pg.keyViewTraceSamples(keyUEC)) {
                if (plotUEC) {
                    EnsembleTrace trace = this.m_processedEnsemble.getNearestTrace_Pixel(keyUEC.PixelX);
                    if (trace != null) {
                        this.m_traceSampleTable.setModel(trace.data().createExactCopy());
                    } else {
                        this.m_traceSampleTable.setModel(new DefaultTableModel());
                    }
                }
                return;
            }
            if (pg.keyViewTraceHeaders(keyUEC)) {
                if (plotUEC) {
                    EnsembleTrace trace = this.m_processedEnsemble.getNearestTrace_Pixel(keyUEC.PixelX);
                    if (trace != null) {
                        this.m_traceHeaderTable.setModel(this.fillTraceHeaderTable(trace));
                    } else {
                        this.m_traceHeaderTable.setModel(new DefaultTableModel());
                    }
                }
                return;
            }
            if (pg.killPicksUsingDelayTimeSolution(keyUEC)) {
                if (this.m_geomCorrWidget != null) {
                    this.m_geomCorrWidget.killPicks();
                }
                return;
            }
            if (pg.isShiftPatternUp(keyUEC)) {
                this.shiftPatternUp();
                return;
            }
            if (pg.isShiftPatternDown(keyUEC)) {
                this.shiftPatternDown();
                return;
            }
            if (pg.keyPriorCrossline(keyUEC)) {
                this.binNavigation(0, -1);
                return;
            }
            if (pg.keyToggleUnlockedProcesses(keyUEC)) {
                this.m_sequenceWorkerWidget.toggle_unlocked_processes();
                return;
            }
            if (pg.keyToggleActiveProcess(keyUEC)) {
                this.toggle_active_process();
                return;
            }
            if (pg.keyNextCrossline(keyUEC)) {
                this.binNavigation(0, 1);
                return;
            }
            if (pg.keyPriorInline(keyUEC)) {
                this.binNavigation(-1, 0);
                return;
            }
            if (pg.keyNextInline(keyUEC)) {
                this.binNavigation(1, 0);
                return;
            }
            if (pg.keyPriorEnsemble(keyUEC)) {
                this.priorEnsemble();
                return;
            }
            if (pg.keyNextEnsemble(keyUEC)) {
                this.nextEnsemble();
                return;
            }
            if (pg.keyKillCurrentShotOrReceiver(keyUEC)) {
                this.killCurrent();
                return;
            }
            if (pg.keyNextGroup(keyUEC)) {
                if (groupIndex >= egm.GroupList.size() - 1) {
                    this.nextEnsemble();
                } else {
                    this.tryToSelectGroupIndex(groupIndex + 1);
                }
                return;
            }
            if (pg.keyPriorGroup(keyUEC)) {
                if (groupIndex <= 0) {
                    this.priorEnsemble();
                } else {
                    this.tryToSelectGroupIndex(groupIndex - 1);
                }
                return;
            }
            boolean lockedViewport = false;
            if (pg.keyGeomCorrection(keyUEC)) {
                this.basemapWidget().lockCurrentViewport();
                lockedViewport = true;
            }
            pg.PolarityFlipped = false;
            if (pg.handleKey(keyUEC, this.m_processedEnsemble, this.m_inputEnsemble, this.m_sequence, plotUEC, this.m_widget.transform(0), false)) {
                long start = System.currentTimeMillis();
                this.handlePicksModified(true, false);
                long total = System.currentTimeMillis() - start;
                this.m_timeLabel.setText("Total time to make picks = " + total + " ms ");
            } else if (pg.PolarityFlipped) {
                pg.PolarityFlipped = false;
                if (pg.PolarityRecID >= 1) {
                    this.loadShot();
                }
                if (pg.PolarityShotID >= 1) {
                    this.loadRec();
                }
            }
            if (lockedViewport) {
                this.basemapWidget().unlockCurrentViewport();
                this.basemapWidget().widget().mainWidget().repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void toggle_active_process() {
        try {
            this.m_sequenceWorkerWidget.toggle_active_process();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void shiftPatternUp() {
        try {
            boolean okay;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean bl = okay = this.m_layoutMethod == LayoutMethod.Standard;
            if (okay) {
                boolean bl2 = okay = okay && this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot && project.dim2D();
            }
            if (!okay) {
                JOptionPane.showMessageDialog(null, "Only works for 2D shot gathers", "Cannot shift pattern", 0);
                return;
            }
            project.shiftPatternUp2D(this.m_shotID);
            this.loadShot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void shiftPatternDown() {
        try {
            boolean okay;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            boolean bl = okay = this.m_layoutMethod == LayoutMethod.Standard;
            if (okay) {
                boolean bl2 = okay = okay && this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot && project.dim2D();
            }
            if (!okay) {
                JOptionPane.showMessageDialog(null, "Only works for 2D shot gathers", "Cannot shift pattern", 0);
                return;
            }
            project.shiftPatternDown2D(this.m_shotID);
            this.loadShot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handlePicksModified(boolean emitMessage, boolean forceBranchModified) {
        try {
            long total;
            long start;
            PickerGizmo pg = PickerGizmo.singleton();
            boolean repaintBasemap = false;
            boolean delayTimesModified = false;
            if (pg.BranchPicksModified || forceBranchModified) {
                int id;
                start = System.currentTimeMillis();
                Tools_DelayTime_Geometry.singleton().computeGeometryCorrection(true, this.m_inputEnsemble, "FBP_User");
                total = System.currentTimeMillis() - start;
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Shot && (delayTimesModified = Tools_DelayTime.singleton().updateDelayTime_Shot(this.m_inputEnsemble, true))) {
                    id = Tools_Ensemble.isShotEnsemble(this.m_inputEnsemble);
                    assert (id == this.m_shotID);
                    Messenger.broadcastShotDelayTimeChanged(this, id);
                }
                if (this.m_pickPlaneCombo.getPickPlane() == PickPlaneEnum.Receiver && (delayTimesModified = Tools_DelayTime.singleton().updateDelayTime_Rec(this.m_inputEnsemble, true))) {
                    id = Tools_Ensemble.isReceiverEnsemble(this.m_inputEnsemble);
                    assert (id == this.m_recID);
                    Messenger.broadcastReceiverDelayTimeChanged(this, id);
                }
                pg.BranchPicksModified = false;
                repaintBasemap = true;
            }
            if (this.m_layoutMethod == LayoutMethod.Standard) {
                this.m_geomCorrWidget.setEnsemble(this.m_inputEnsemble);
            }
            if (delayTimesModified && this.m_sequence.wasDelayTimeModelApplied()) {
                this.m_widget.ApplyTemporaryLock = true;
                start = System.currentTimeMillis();
                this.handleNewInputEnsemble(true);
                total = System.currentTimeMillis() - start;
            } else {
                this.m_widget.forcePaintAll();
            }
            if (repaintBasemap) {
                this.m_basemapWidget.reloadDelayTimePlot();
            }
            if (emitMessage) {
                Messenger.broadcast(Messenger.Message.PicksChanged, this, this.m_inputEnsemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            PickPlaneEnum pp = this.m_pickPlaneCombo.getPickPlane();
            if (sender == this.m_radioPlotType) {
                this.prepareWidget(true);
                return;
            }
            if (sender == this.m_selectorCombo) {
                this.load(true);
                return;
            }
            if (sender == this.m_offsetBinProfileNav) {
                this.loadOffsetProfile();
                return;
            }
            if (sender == this.m_offsetBinInlineCrosslineNav) {
                this.loadOffsetInlineCrossline();
                return;
            }
            if (this.m_offsetBinProfileNav != null && sender == this.m_offsetBinProfileNav.azimuthSelectorWidget()) {
                this.handleAzimuthWidget();
                return;
            }
            if (this.m_offsetBinInlineCrosslineNav != null && sender == this.m_offsetBinInlineCrosslineNav.azimuthSelectorWidget()) {
                this.handleAzimuthWidget();
                return;
            }
            if (sender == this.m_offsetBinNav) {
                this.loadOffset();
                return;
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            if (sender == this.m_traceBackgroundWidget) {
                this.prepareWidget(true);
                return;
            }
            if (sender == this.m_visibleWidget) {
                this.saveParameters();
                this.prepareWidget(true);
                return;
            }
            if (this.m_recNavigationWidget == sender && pp == PickPlaneEnum.Receiver) {
                this.loadRec();
                return;
            }
            if (this.m_shotNavigationWidget == sender && pp == PickPlaneEnum.Shot) {
                this.loadShot();
                return;
            }
            if (sender == this.m_keyBasemapUEC) {
                this.handleKeyUEC(this.m_keyBasemapUEC);
                return;
            }
            if (sender == this.m_keyUEC) {
                this.handleKeyUEC(this.m_keyUEC);
                return;
            }
            if (sender == this.m_lineSegmentUEC) {
                if (this.m_lineSegmentUEC.Dragging) {
                    return;
                }
                if (!this.m_lineSegmentUEC.Finished) {
                    return;
                }
                if (pg.handleControlPoint(this.m_lineSegmentUEC, this.m_processedEnsemble, this.m_inputEnsemble)) {
                    this.handlePicksModified(true, false);
                }
                return;
            }
            if (sender == this.m_rubberBandUEC) {
                if (this.m_rubberBandUEC.Dragging) {
                    return;
                }
                if (!this.m_rubberBandUEC.Finished) {
                    return;
                }
                if (pg.handleRubberBand(this.m_rubberBandUEC, this.m_processedEnsemble, this.m_inputEnsemble)) {
                    this.handlePicksModified(true, false);
                }
                return;
            }
            if (sender == this.m_mouseMoveUEC) {
                if (this.m_processedEnsemble == null || this.m_mouseMoveUEC == null) {
                    return;
                }
                EnsembleTrace trace = this.m_processedEnsemble.getNearestTrace_Pixel(this.m_mouseMoveUEC.PixelX);
                this.m_basemapWidget.setMouseID(this.m_processedEnsemble.NearestShotID, this.m_processedEnsemble.NearestReceiverID);
                if (this.m_traceFrequencyWidget.mouseMoves()) {
                    this.m_traceFrequencyWidget.setTrace(trace);
                }
                return;
            }
            if (sender == this.m_wheelUEC && this.m_pickerGizmoWidget.wheel_scroll()) {
                if (this.m_wheelUEC.WheelRotation > 0) {
                    this.m_widget.horz_shift_right(0.1);
                }
                if (this.m_wheelUEC.WheelRotation < 0) {
                    this.m_widget.horz_shift_left(0.1);
                }
                return;
            }
            if (sender == this.m_wheelUEC && this.m_pickerGizmoWidget.wheel_zoom()) {
                if (this.m_wheelUEC.WheelRotation < 0) {
                    this.m_widget.horz_zoom(this.m_wheelUEC.MouseX, 0.8);
                }
                if (this.m_wheelUEC.WheelRotation > 0) {
                    this.m_widget.horz_zoom(this.m_wheelUEC.MouseX, 1.2);
                }
                return;
            }
            if (sender == this.m_middleClickUEC) {
                return;
            }
            if (sender == this.m_leftClickUEC) {
                if (this.m_traceFrequencyWidget.mouseMoves()) {
                    EnsembleTrace trace = this.m_processedEnsemble.getNearestTrace_Pixel(this.m_mouseMoveUEC.PixelX);
                    this.m_traceFrequencyWidget.setTrace(trace);
                }
                if (this.m_leftClickUEC.ControlDown) {
                    PickerGizmo.broadcastControlClick(this, this.m_processedEnsemble, this.m_leftClickUEC.PixelX);
                    return;
                }
                if (pg.handleButtonPressed(this.m_leftClickUEC, this.m_processedEnsemble, this.m_inputEnsemble, false)) {
                    this.handlePicksModified(true, false);
                }
                return;
            }
            if (sender == this.m_geomCorrWidget) {
                this.handlePicksModified(true, true);
                return;
            }
            if (sender == this.m_penUEC) {
                if (!this.m_penUEC.Dragging) {
                    return;
                }
                if (pg.handlePenMode(this.m_penUEC, this.m_processedEnsemble, this.m_inputEnsemble)) {
                    this.handlePicksModified(true, true);
                }
                return;
            }
            if (sender == this.m_wiggleOptionsWidget) {
                this.saveParameters();
                return;
            }
            if (sender == this.m_pickDisplayWidget) {
                this.saveParameters();
                this.prepareWidget(false);
                return;
            }
            if (sender == this.m_axisWidget) {
                this.saveParameters();
                this.m_widget.DrawWiggles = true;
                this.m_widget.DrawColor = false;
                if (this.m_axisWidget.isUniformSpacing()) {
                    if (this.m_radioPlotType.getSelectedIndex() == 0) {
                        this.m_widget.DrawWiggles = false;
                        this.m_widget.DrawColor = true;
                    }
                    this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
                } else {
                    this.m_widget.setAxisTableColumn(this.m_axisWidget.getAxisTable(), this.m_axisWidget.getAxisColumn());
                    this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
                }
                this.prepareWidget(true);
                return;
            }
            if (sender == this.m_axisLockerOffset) {
                this.saveParameters();
                this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.saveParameters();
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    boolean bShotCorrPickerTurnedOnOrOff = false;
                    if (this.m_sequence.MessageData.ExtraData != null && this.m_sequence.MessageData.ExtraData.equals("EnsembleWorker_shot_correl_fb_pick")) {
                        bShotCorrPickerTurnedOnOrOff = true;
                    }
                    if (bShotCorrPickerTurnedOnOrOff) {
                        this.loadShot();
                    } else {
                        this.processGroupEnsemble(false);
                    }
                }
                if (this.m_sequence.MessageData.MessageFromWorker) {
                    this.tryToLaunchBatchPicker(data);
                }
                return;
            }
            if (sender == this.m_groupControllerWidget) {
                this.saveParameters();
                this.m_groupSelectorWidget.prep(this.m_groupControllerWidget.groupManager(), false);
                this.tryToSelectGroupIndex(0);
                return;
            }
            if (sender == this.m_groupSelectorWidget) {
                this.saveParameters();
                this.tryToSelectGroupIndex(this.m_groupSelectorWidget.getSelectedIndex());
                return;
            }
            if (sender == this.m_pickPlaneCombo) {
                this.setPickPlane(true);
                this.load(true);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected AbstractTableModel fillTraceHeaderTable(EnsembleTrace trace) {
        try {
            EnsembleHeaderDictionary dict = this.m_processedEnsemble.dictionary();
            Table_Memory table = new Table_Memory();
            table.setName("Header");
            int indexTableName = table.column_append("Table", DataType.Text);
            int indexTableColumn = table.column_append("Column", DataType.Text);
            int indexTableValue = table.column_append("Value", DataType.Double);
            for (int n = 0; n < dict.size(); ++n) {
                String tableName = dict.getEntry((int)n).Table;
                String columnName = dict.getEntry((int)n).Column;
                table.row_increment();
                table.putString(n, indexTableName, tableName);
                table.putString(n, indexTableColumn, columnName);
                double value = trace.header().getDouble(n);
                table.putDouble(n, indexTableValue, value);
            }
            Table_SimpleModel model = new Table_SimpleModel(table);
            return model;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static enum LayoutMethod {
        Standard,
        OffsetBins,
        OffsetBinUsingProfile,
        OffsetBinUsingInlineCrossline;

    }

    public static class LaunchOptions {
        public boolean ShotPlane = true;
        public boolean PrepForAutoPicks = false;
        public boolean PrepForDelayTimeAnalysis = false;
    }

    public static enum LaunchEnum {
        Standard,
        DelayTimeAnalysisShot,
        DelayTimeAnalysisRec;

    }
}

