/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Page_SegyWiz_Compression
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    protected SegyWizardSharedData m_data;
    protected JCheckBox m_chkCreateCompressedData = new JCheckBox("Create compressed seismic file");
    protected JTextField m_txtMaxTime = new JTextField("2000");
    protected JTextField m_txtSampleInterval = new JTextField("4");
    protected JCheckBox m_chkCreateLimitOffset = new JCheckBox("Limit trace offset range");
    protected JTextField m_txtMinOffset = new JTextField("0");
    protected JTextField m_txtMaxOffset = new JTextField("50000");
    protected JCheckBox m_chkCreateLimitSensor = new JCheckBox("Limit (Receiver,Sensor) range, if defined");
    protected JTextField m_txtMinSensor = new JTextField("6");
    protected JTextField m_txtMaxSensor = new JTextField("6");
    protected JCheckBox m_chkTraceDecimation = new JCheckBox("Decimate input traces");
    protected JCheckBox m_chkTraceDecimation_ReceiverFold = new JCheckBox("Decimate using receiver fold counts");
    protected JTextField m_txtDecimation = new JTextField("5");
    protected JCheckBox m_chkCreateSparseCMP = new JCheckBox("Create CMP gathers");
    protected JTextField m_txtSparseSpacing = new JTextField("5280");
    protected JTextField m_txtSparseRadius = new JTextField("400");
    protected JCheckBox m_chkKillNoisyTraces = new JCheckBox("Kill noisy traces");
    protected JTextField m_txtNoiseWindowLength = new JTextField("100");
    protected JTextField m_txtNoiseCutoff = new JTextField("10");
    protected JCheckBox[] m_chkLimitTracesUsingHeader;
    protected JComboBox[] m_comboHeaderType;
    protected JTextField[] m_txtHeaderOffset;
    protected JTextField[] m_txtHeaderMinValue;
    protected JTextField[] m_txtHeaderMaxValue;
    protected GridLayoutWidget m_limitGrid;
    protected int m_numLimits = 3;

    public Page_SegyWiz_Compression(SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.addComponent(this.createCompressed(), 0);
            this.addComponent(this.createSparse(), 0);
            this.addComponent(this.createKillNoisy(), 0);
            this.addStretch(10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.prep();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prep() {
        try {
            boolean is3D = this.m_data.Dimension.equalsIgnoreCase("3D");
            boolean isCompressed = this.m_chkCreateCompressedData.isSelected();
            for (int n = 0; n < this.m_numLimits; ++n) {
                this.m_chkLimitTracesUsingHeader[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_comboHeaderType[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_txtHeaderOffset[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_txtHeaderMinValue[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_txtHeaderMaxValue[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
            }
            this.m_txtMaxTime.setEnabled(this.m_chkCreateCompressedData.isSelected());
            this.m_txtSampleInterval.setEnabled(this.m_chkCreateCompressedData.isSelected());
            this.m_txtDecimation.setEnabled(this.m_chkTraceDecimation.isSelected());
            this.m_chkTraceDecimation_ReceiverFold.setEnabled(this.m_chkTraceDecimation.isSelected());
            this.m_txtMinSensor.setEnabled(this.m_chkCreateLimitSensor.isSelected() && this.m_chkCreateCompressedData.isSelected());
            this.m_txtMaxSensor.setEnabled(this.m_chkCreateLimitSensor.isSelected() && this.m_chkCreateCompressedData.isSelected());
            this.m_txtMinOffset.setEnabled(this.m_chkCreateLimitOffset.isSelected() && this.m_chkCreateCompressedData.isSelected());
            this.m_txtMaxOffset.setEnabled(this.m_chkCreateLimitOffset.isSelected() && this.m_chkCreateCompressedData.isSelected());
            if (!is3D || !isCompressed) {
                this.m_chkCreateSparseCMP.setSelected(false);
                this.m_chkCreateSparseCMP.setEnabled(false);
            } else {
                this.m_chkCreateSparseCMP.setEnabled(true);
            }
            this.m_txtSparseSpacing.setEnabled(is3D && this.m_chkCreateSparseCMP.isSelected());
            this.m_txtSparseRadius.setEnabled(is3D && this.m_chkCreateSparseCMP.isSelected());
            this.m_chkKillNoisyTraces.setEnabled(isCompressed);
            if (!isCompressed) {
                this.m_chkKillNoisyTraces.setSelected(false);
            }
            this.m_txtNoiseCutoff.setEnabled(this.m_chkKillNoisyTraces.isSelected());
            this.m_txtNoiseWindowLength.setEnabled(this.m_chkKillNoisyTraces.isSelected());
            ArrayList arrays = new ArrayList();
            for (int n = 0; n < arrays.size(); ++n) {
                float[] fArray = (float[])arrays.get(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.handleGenericObjectListener(null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createKillNoisy() {
        try {
            JLabel label = new JLabel("Compression must be used. Traces may be un-killed after the project is opened");
            label.setForeground(Color.red);
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, "Kill noisy traces");
            main.addComponent(label, 0);
            main.addComponent(this.m_chkKillNoisyTraces, 0);
            main.addHorzPair(new JLabel("Noise computation window length (ms)"), 0, this.m_txtNoiseWindowLength, 10);
            main.addHorzPair(new JLabel("Cutoff threshhold (between 1 and 99)"), 0, this.m_txtNoiseCutoff, 10);
            this.m_txtNoiseWindowLength.setEnabled(false);
            this.m_txtNoiseCutoff.setEnabled(false);
            this.m_chkKillNoisyTraces.addActionListener(this);
            this.m_chkKillNoisyTraces.setEnabled(false);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createSparse() {
        try {
            JLabel label = new JLabel("Only works for 3D surveys. Compression must be used");
            label.setForeground(Color.red);
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, "Sparse CMP gather options");
            String lbl = "<html>Note - sparse CMP gathers can speed up a number of processes, including moveout trend definition and branch assignment using traces</html>";
            main.addComponent(label, 0);
            main.addComponent(new JLabel(lbl), 0);
            main.addComponent(this.m_chkCreateSparseCMP, 0);
            main.addHorzPair(new JLabel("CMP midpoint spacing (ft/m)"), 0, this.m_txtSparseSpacing, 10);
            main.addHorzPair(new JLabel("CMP diameter (ft/m)"), 0, this.m_txtSparseRadius, 10);
            this.m_txtSparseSpacing.setEnabled(false);
            this.m_txtSparseRadius.setEnabled(false);
            this.m_chkCreateSparseCMP.addActionListener(this);
            this.m_chkCreateSparseCMP.setEnabled(false);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createCompressed() {
        try {
            int n;
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, "Compressed option");
            main.addComponent(new JLabel("Note - compression ratio is approximately a factor of 3"), 0);
            main.addComponent(this.m_chkCreateCompressedData, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Maximum output time"), this.m_txtMaxTime);
            grid.addSimple(row++, new JLabel("Sample interval"), this.m_txtSampleInterval);
            grid.addSimple(row++, new JLabel(" "), this.m_chkCreateLimitOffset);
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_txtMinOffset);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_txtMaxOffset);
            grid.addSimple(row++, new JLabel(" "), this.m_chkCreateLimitSensor);
            grid.addSimple(row++, new JLabel("Minimum sensor"), this.m_txtMinSensor);
            grid.addSimple(row++, new JLabel("Maximum sensor"), this.m_txtMaxSensor);
            grid.addSimple(row++, new JLabel(" "), this.m_chkTraceDecimation);
            grid.addSimple(row++, new JLabel("Decimation ( >= 2)"), this.m_txtDecimation);
            grid.addSimple(row++, new JLabel(" "), this.m_chkTraceDecimation_ReceiverFold);
            this.m_chkTraceDecimation_ReceiverFold.setSelected(true);
            this.m_txtDecimation.setEnabled(this.m_chkTraceDecimation.isSelected());
            this.m_chkTraceDecimation_ReceiverFold.setEnabled(this.m_chkTraceDecimation.isSelected());
            this.m_txtMaxTime.setEnabled(false);
            this.m_txtSampleInterval.setEnabled(false);
            this.m_txtMinOffset.setEnabled(false);
            this.m_txtMaxOffset.setEnabled(false);
            this.m_chkTraceDecimation.addActionListener(this);
            this.m_chkCreateCompressedData.addActionListener(this);
            this.m_chkCreateLimitOffset.addActionListener(this);
            this.m_chkCreateLimitSensor.addActionListener(this);
            this.m_chkLimitTracesUsingHeader = new JCheckBox[this.m_numLimits];
            this.m_comboHeaderType = new JComboBox[this.m_numLimits];
            this.m_txtHeaderOffset = new JTextField[this.m_numLimits];
            this.m_txtHeaderMinValue = new JTextField[this.m_numLimits];
            this.m_txtHeaderMaxValue = new JTextField[this.m_numLimits];
            this.m_limitGrid = main.createGridLayoutWidget(0, "Options to limit imported traces ", 0);
            row = 0;
            this.m_limitGrid.addSimple(row++, new JLabel(""), new JLabel("Byte offset"), new JLabel("Header type"), new JLabel("Minimum"), new JLabel("Maximum"), 0, 1, 2, 2, 2);
            for (n = 0; n < this.m_numLimits; ++n) {
                this.m_chkLimitTracesUsingHeader[n] = new JCheckBox("Apply limit");
                this.m_comboHeaderType[n] = new JComboBox();
                this.m_comboHeaderType[n].addItem("4-byte int");
                this.m_comboHeaderType[n].addItem("2-byte int");
                this.m_txtHeaderOffset[n] = new JTextField("1");
                this.m_txtHeaderMinValue[n] = new JTextField("1");
                this.m_txtHeaderMaxValue[n] = new JTextField("1");
                this.m_limitGrid.addSimple(row++, this.m_chkLimitTracesUsingHeader[n], this.m_txtHeaderOffset[n], this.m_comboHeaderType[n], this.m_txtHeaderMinValue[n], this.m_txtHeaderMaxValue[n], 0, 1, 2, 2, 2);
            }
            for (n = 0; n < this.m_numLimits; ++n) {
                this.m_chkLimitTracesUsingHeader[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_comboHeaderType[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_txtHeaderOffset[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_txtHeaderMinValue[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
                this.m_txtHeaderMaxValue[n].setEnabled(this.m_chkCreateCompressedData.isSelected());
            }
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
        try {
            try {
                this.m_data.ImportLimitList.clear();
                if (this.m_chkCreateCompressedData.isSelected()) {
                    for (int n = 0; n < this.m_numLimits; ++n) {
                        if (!this.m_chkLimitTracesUsingHeader[n].isSelected()) continue;
                        SegyWizardSharedData.CompressedImportLimit lim = new SegyWizardSharedData.CompressedImportLimit();
                        lim.Type = this.m_comboHeaderType[n].getSelectedIndex();
                        lim.Header = Tools_Widget.extractInteger(this.m_txtHeaderOffset[n], 1, 1, 237);
                        lim.Min = Tools_Widget.extractInteger(this.m_txtHeaderMinValue[n], 1, -999999999, 999999999);
                        lim.Max = Tools_Widget.extractInteger(this.m_txtHeaderMaxValue[n], 1, -999999999, 999999999);
                        this.m_data.ImportLimitList.add(lim);
                    }
                }
            }
            catch (Exception limex) {
                limex.printStackTrace();
            }
            this.m_data.DecimateInput = this.m_chkTraceDecimation.isSelected();
            this.m_data.DecimateInput_ReceiverFold = this.m_chkTraceDecimation_ReceiverFold.isSelected();
            this.m_data.Decimation = Tools_Widget.extractInteger(this.m_txtDecimation, 2, 2, 50);
            this.m_data.CreateCompressed = this.m_chkCreateCompressedData.isSelected();
            this.m_data.MaxTime = (float)Tools_Widget.extractDouble(this.m_txtMaxTime, 2000.0, 200.0, 10000.0);
            this.m_data.OutputSampleInterval = (float)Tools_Widget.extractDouble(this.m_txtSampleInterval, 4.0, 2.0, 8.0);
            this.m_data.KillSensor = this.m_chkCreateLimitSensor.isSelected();
            this.m_data.MinSensor = Tools_Widget.extractInteger(this.m_txtMinSensor, 0, 0, 50000);
            this.m_data.MaxSensor = Tools_Widget.extractInteger(this.m_txtMaxSensor, 0, 0, 510000);
            this.m_data.KillOffsets = this.m_chkCreateLimitOffset.isSelected();
            this.m_data.MinOffset = (float)Tools_Widget.extractDouble(this.m_txtMinOffset, 0.0, 0.0, 50000.0);
            this.m_data.MaxOffset = (float)Tools_Widget.extractDouble(this.m_txtMaxOffset, 20000.0, 0.0, 510000.0);
            this.m_data.CreateSparse = this.m_chkCreateSparseCMP.isSelected();
            this.m_data.SparseRadius = 0.5f * (float)Tools_Widget.extractDouble(this.m_txtSparseRadius, 200.0, 40.0, 1000.0);
            this.m_data.SparseSpacing = (float)Tools_Widget.extractDouble(this.m_txtSparseSpacing, 5000.0, 800.0, 10000.0);
            this.m_data.KillNoisy = this.m_chkKillNoisyTraces.isSelected();
            this.m_data.NoiseWindow = (float)Tools_Widget.extractDouble(this.m_txtNoiseWindowLength, 100.0, 40.0, 1000.0);
            this.m_data.NoiseCutoff = (float)Tools_Widget.extractDouble(this.m_txtNoiseCutoff, 10.0, 1.0, 99.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.prep();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

