/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardEchos;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtParadigmEposUser;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Windows.Echos.EchosSurveysWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.EchosWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

public class Page_EchosWiz_Survey
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    protected EchosSurveysWidget m_echosSurveyWidget;
    protected EchosWizardSharedData m_data;
    protected JLabel m_labelError;

    public Page_EchosWiz_Survey(EchosWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.m_echosSurveyWidget = new EchosSurveysWidget();
            this.m_labelError = new JLabel();
            this.addComponent(this.m_echosSurveyWidget, 0);
            this.addComponent(this.m_labelError, 0);
            this.m_labelError.setForeground(Color.red);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void leavingPage() {
        try {
            boolean bCreateNewSurvey = false;
            if (!this.m_data.EchosSurveyName.equals(this.m_echosSurveyWidget.getSelectedName())) {
                bCreateNewSurvey = true;
            }
            if (!this.m_data.EchosSurveyHost.equals(this.m_echosSurveyWidget.getSelectedHost())) {
                bCreateNewSurvey = true;
            }
            if (this.m_data.EchosSurveyType != this.m_echosSurveyWidget.getSelectedSurveyType()) {
                bCreateNewSurvey = true;
            }
            if (this.m_data.EchosSurvey == null) {
                bCreateNewSurvey = true;
            }
            if (bCreateNewSurvey) {
                this.m_data.EchosSurveyName = this.m_echosSurveyWidget.getSelectedName();
                this.m_data.EchosSurveyHost = this.m_echosSurveyWidget.getSelectedHost();
                this.m_data.EchosSurveyType = this.m_echosSurveyWidget.getSelectedSurveyType();
                this.m_data.EchosSurvey = XtEchos.getParadigmSurvey(this.m_data.EchosSurveyName, this.m_data.EchosSurveyHost, this.m_data.EchosSurveyType);
                this.m_data.SelectedFileIndices = null;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        this.m_labelError.setText("");
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            this.m_labelError.setText("");
            String sName = this.m_echosSurveyWidget.getSelectedName();
            String sHost = this.m_echosSurveyWidget.getSelectedHost();
            if (sName.length() == 0 || sHost.length() == 0) {
                this.m_labelError.setText("Please select a survey");
                return false;
            }
            String sUser = XtParadigmEposUser.getCurrentEposUser();
            String sNameAtHost = sName + "@" + sHost;
            boolean bIsReadable = XtParadigmSurvey.IsReadable(sNameAtHost, sUser);
            if (!bIsReadable) {
                this.m_labelError.setText("Survey '" + sNameAtHost + "' is not readable by user '" + sUser + "'");
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.handleGenericObjectListener(null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

