/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardEchos;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.EchosWizardSharedData;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import com.PecosLibrary.Windows.Shared.DimensionSelectionWidget;
import com.PecosLibrary.Windows.Shared.UnitsSelectionWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Page_EchosWiz_Name
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    protected EchosWizardSharedData m_data;
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Statics);
    protected DimensionSelectionWidget m_dimWidget = new DimensionSelectionWidget(3, "Project dimension");
    protected UnitsSelectionWidget m_unitsWidget = new UnitsSelectionWidget(3);
    protected JCheckBox m_chkMarineSurvey = new JCheckBox("This is a marine survey");
    protected JTextField m_txtRecBinSize = new JTextField("25");
    protected JComboBox<String> m_cmbMarineDecimation = new JComboBox();
    protected JTextField m_txtMarineShotLineIncrement = new JTextField("1000");
    boolean _bFirstActivation = true;
    String _sActivationSurvey = "";
    String _sActivationHost = "";
    int _iActivationSurveyType = -1;

    public Page_EchosWiz_Name(EchosWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.addComponent(this.m_nameWidget, 0);
            this.addComponent(this.m_dimWidget, 0);
            this.addComponent(this.m_unitsWidget, 0);
            this.m_chkMarineSurvey.setSelected(false);
            GridLayoutWidget grid = this.createGridLayoutWidget(0, "Marine survey options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkMarineSurvey, new JLabel(" "));
            grid.addSimple(row++, new JLabel("Receiver bin size"), this.m_txtRecBinSize, new JLabel(" "));
            grid.addSimple(row++, new JLabel("Receiver decimation"), this.m_cmbMarineDecimation, new JLabel("Only used if the data is being compressed"));
            grid.addSimple(row++, new JLabel("Shot LineNumber increment per file"), this.m_txtMarineShotLineIncrement, new JLabel("Ignored if zero", 2));
            this.m_cmbMarineDecimation.addItem("None (includes all traces!)");
            this.m_cmbMarineDecimation.addItem("2 by 2 (includes 1/4 traces!)");
            this.m_cmbMarineDecimation.addItem("3 by 3 (includes 1/9 traces!)");
            this.m_cmbMarineDecimation.addItem("4 by 4 (includes 1/16 traces!)");
            this.m_cmbMarineDecimation.addItem("5 by 5 (includes 1/25 traces!)");
            this.m_cmbMarineDecimation.addItem("6 by 6 (includes 1/36 traces!)");
            this.addStretch(10);
            this.m_dimWidget.listener().addListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.handleGenericObjectListener(null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            return this.m_nameWidget.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
        try {
            this.m_data.Dimension = this.m_dimWidget.dimension();
            this.m_data.ProjectName = this.m_nameWidget.name();
            this.m_data.Units = this.m_unitsWidget.units();
            this.m_data.RecBinSize = (float)Tools_Widget.extractDouble(this.m_txtRecBinSize, 25.0, 10.0, 200.0);
            this.m_data.IsMarine = this.m_chkMarineSurvey.isSelected();
            this.m_data.MarineDecimation = 1 + this.m_cmbMarineDecimation.getSelectedIndex();
            this.m_data.MarineShotLineIncrement = Tools_Widget.extractInteger(this.m_txtMarineShotLineIncrement, 0, 0, 100000);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            boolean bSurveyTypeChanged;
            boolean bHostChanged = !this._sActivationHost.equals(this.m_data.EchosSurveyHost);
            boolean bSurveyChanged = !this._sActivationSurvey.equals(this.m_data.EchosSurveyName);
            boolean bl = bSurveyTypeChanged = this._iActivationSurveyType != this.m_data.EchosSurveyType;
            if (bHostChanged || bSurveyChanged || bSurveyTypeChanged) {
                this.m_nameWidget.setProjectName(this.m_data.EchosSurveyName);
                if (this.m_data.EchosSurveyType == 1) {
                    this.m_dimWidget.setDimension("2D");
                } else if (this.m_data.EchosSurveyType == 2) {
                    this.m_dimWidget.setDimension("3D");
                }
                this._sActivationHost = this.m_data.EchosSurveyHost;
                this._sActivationSurvey = this.m_data.EchosSurveyName;
                this._iActivationSurveyType = this.m_data.EchosSurveyType;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

