/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardEchos;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Geometry.TableParser;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Windows.Echos.Echos_DictionaryEditorWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Refraction.Import.WizardEchos.EchosWizardSharedData;
import com.PecosLibrary.Windows.Segy.Segy_DataDisplayWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class Page_EchosWiz_DictFileName
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener,
ItemListener,
PropertyChangeListener {
    protected EchosWizardSharedData m_data;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected Echos_DictionaryEditorWidget m_dictEditor;
    protected JLabel m_launchLabel = new JLabel(" ", 0);
    protected JLabel m_label = new JLabel(" ");
    protected JButton m_scanButton;
    protected JProgressBar m_progress = new JProgressBar();
    protected JLabel m_scanLabel = new JLabel("", 0);
    protected JRadioButton m_radScanAll = new JRadioButton("Scan all traces");
    protected JRadioButton m_radScanSome = new JRadioButton("Scan max traces per file:");
    protected ButtonGroup m_scanGroup = new ButtonGroup();
    protected JTextField m_txtScanCount = new JTextField("100000");
    protected JTable m_shotTable = new JTable();
    protected JTable m_recTable = new JTable();
    protected Table_Abstract m_shotDataTable;
    protected TableParser m_shotParser;
    protected Table_Abstract m_recDataTable;
    protected TableParser m_recParser;
    protected long m_numRead = 0L;
    protected long m_totalTraces = 0L;
    protected JTable m_shotConflictTable = new JTable();
    protected JTable m_recConflictTable = new JTable();
    protected Java2D_SimpleComposite m_widget;
    protected Segy_DataDisplayWidget m_segyDisplayWidget;
    protected JButton m_btnReloadSegyList;
    protected JComboBox<String> m_segyCombo = new JComboBox();
    protected int m_maxTracesPerFile = 1000000000;

    public Page_EchosWiz_DictFileName(EchosWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.m_data.Dictionary.ShowTestColumnsInTable = false;
            this.m_data.Dictionary.getListenerController().addListener(this);
            this.m_dictEditor = new Echos_DictionaryEditorWidget(this.m_data.EchosDictionary, true, "Flatirons");
            this.m_dictEditor.addPropertyChangeListener(this);
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Dictionary selection", this.m_dictEditor);
            this.addComponent(tabs, 10);
            LinearLayoutWidget sub = this.createHorizontal(0, null, 0);
            sub.addComponent(this.m_launchLabel, 10);
            Tools_FontChanger.changeSizeOfFont(this.m_launchLabel, 3);
            this.m_launchLabel.setForeground(Color.red);
            this.m_launchLabel.setText("Select header dictionary");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createScanWidget() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget top = main.createHorizontal(3, null, 0);
            this.m_scanGroup.add(this.m_radScanAll);
            this.m_scanGroup.add(this.m_radScanSome);
            top.addComponent(this.m_radScanAll, 0);
            top.addComponent(this.m_radScanSome, 0);
            top.addComponent(this.m_txtScanCount, 2);
            this.m_radScanSome.setSelected(true);
            this.m_scanButton = top.createButton("Begin scan (cannot interrupt!)", this, 0);
            top.addComponent(this.m_progress, 4);
            top.addComponent(this.m_scanLabel, 12);
            this.m_progress.setMaximum(1000);
            this.m_progress.setMinimum(0);
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("Shot table", new JScrollPane(this.m_shotTable));
            this.m_shotTable.setGridColor(Color.black);
            this.m_shotTable.setShowGrid(true);
            tabs.addTab("Receiver table", new JScrollPane(this.m_recTable));
            this.m_recTable.setGridColor(Color.black);
            this.m_recTable.setShowGrid(true);
            tabs.addTab("Shot conflicts table", new JScrollPane(this.m_shotConflictTable));
            this.m_shotConflictTable.setGridColor(Color.black);
            this.m_shotConflictTable.setShowGrid(true);
            tabs.addTab("Receiver conflicts table", new JScrollPane(this.m_recConflictTable));
            this.m_recConflictTable.setGridColor(Color.black);
            this.m_recConflictTable.setShowGrid(true);
            this.m_widget = new Java2D_SimpleComposite(false);
            this.m_widget.setScrollVisible(true, true);
            tabs.addTab("Basemap", this.m_widget);
            main.addComponent(tabs, 10);
            return main;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void reloadSegyCombo() {
        try {
            this.m_segyCombo.removeAllItems();
            if (this.m_data.Files.size() < 1) {
                this.m_segyDisplayWidget.setSegy(new Segy());
                return;
            }
            for (String s : this.m_data.Files) {
                this.m_segyCombo.addItem(s);
            }
            this.m_segyCombo.setSelectedIndex(0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void scan() {
        try {
            this.m_shotTable.setModel(new DefaultTableModel());
            this.m_recTable.setModel(new DefaultTableModel());
            this.m_shotConflictTable.setModel(new DefaultTableModel());
            this.m_recConflictTable.setModel(new DefaultTableModel());
            this.m_progress.setValue(0);
            this.m_shotDataTable = new Table_Memory();
            this.m_shotDataTable.setName("Shot");
            this.m_shotParser = new TableParser(this.m_shotDataTable);
            this.m_recDataTable = new Table_Memory();
            this.m_recDataTable.setName("Receiver");
            this.m_recParser = new TableParser(this.m_recDataTable);
            ArrayList<Segy> segyList = new ArrayList<Segy>();
            this.m_totalTraces = 0L;
            this.m_numRead = 0L;
            this.m_scanLabel.setForeground(Color.red);
            for (String name : this.m_data.Files) {
                Segy segy = new Segy();
                segy.setFileName(name);
                if (segy.isFileOK()) {
                    segyList.add(segy);
                    this.m_totalTraces += segy.traceCount();
                    continue;
                }
                this.m_scanLabel.setText(name + " is not a valid SEG-Y file");
                return;
            }
            this.m_maxTracesPerFile = 1000000000;
            if (this.m_radScanSome.isSelected()) {
                this.m_maxTracesPerFile = Tools_Widget.extractInteger(this.m_txtScanCount, 100000, 1000, 1000000000);
            }
            long totalConflicts = 0L;
            for (Segy segy : segyList) {
                totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
                if (totalConflicts >= 100000L) continue;
                this.importFile(segy);
            }
            this.m_progress.setValue(0);
            totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
            if (totalConflicts < 1L) {
                this.m_scanLabel.setForeground(Color.blue);
                this.m_scanLabel.setText(String.format("%d shots, %d receivers, and %d traces", this.m_shotDataTable.row_count(), this.m_recDataTable.row_count(), (int)this.m_totalTraces));
            } else {
                this.m_scanLabel.setForeground(Color.red);
                this.m_scanLabel.setText("Import conflicts found");
            }
            this.m_shotTable.setModel(new Table_SimpleModel(this.m_shotDataTable));
            this.m_recTable.setModel(new Table_SimpleModel(this.m_recDataTable));
            this.m_shotConflictTable.setModel(new Table_SimpleModel(this.m_shotParser.createSimpleTable()));
            this.m_recConflictTable.setModel(new Table_SimpleModel(this.m_recParser.createSimpleTable()));
            this.loadPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadPlot() {
        try {
            this.m_widget.mainWidget().clearPaintableList();
            this.m_widget.setColorTitle("Elevation");
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            painter.setTable(this.m_recDataTable);
            painter.setAxisC("Elevation");
            painter.UseColorScale = true;
            painter.Size_Pixel = 3;
            painter.Symbol = Java2D_PointSymbol.Plus;
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            this.m_widget.mainWidget().addPaintable(painter, -9999);
            painter = new Java2D_Paintable_Table();
            painter.setTable(this.m_shotDataTable);
            painter.setAxisC("Elevation");
            painter.UseColorScale = true;
            painter.Size_Pixel = 3;
            painter.Symbol = Java2D_PointSymbol.X;
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            this.m_widget.mainWidget().addPaintable(painter, -9999);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.m_widget.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            this.m_widget.mainWidget().mooz();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile(Segy segy) {
        try {
            Ensemble ensemble = new Ensemble();
            this.m_data.Dictionary.prepareSeismicHeaderDictionary(ensemble.dictionary());
            int tracesPerChunk = 2000;
            int bytesPerTrace = segy.bytesPerTrace();
            int bytesPerChunk = bytesPerTrace * tracesPerChunk;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, bytesPerChunk);
            buff.order(segy.binaryHeader().FileByteOrder);
            RandomAccessFile reader = new RandomAccessFile(segy.fileName(), "r");
            long totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
            int maxIndex = Math.min((int)segy.traceCount(), this.m_maxTracesPerFile);
            for (int startIndex = 0; startIndex < maxIndex && totalConflicts < 100000L; startIndex += tracesPerChunk) {
                int lastIndex = startIndex + tracesPerChunk - 1;
                lastIndex = Math.min(lastIndex, (int)segy.traceCount() - 1);
                int num = lastIndex - startIndex + 1;
                ensemble.clearTraces(false);
                if (num >= 1) {
                    long offset = 3600L + (long)startIndex * (long)bytesPerTrace;
                    reader.seek(offset);
                    int numBytes = num * segy.bytesPerTrace();
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < num; ++n) {
                        EnsembleTrace trace = ensemble.addTrace();
                        int buffOffset = n * segy.bytesPerTrace();
                        this.m_data.Dictionary.fillTraceHeader(buff, buffOffset, trace.header());
                    }
                    Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, 1, 0);
                    Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, 1L, 1L);
                    this.m_shotParser.handleEnsemble(ensemble);
                    this.m_recParser.handleEnsemble(ensemble);
                    totalConflicts = this.m_recParser.totalConflicts() + this.m_shotParser.totalConflicts();
                }
                this.m_numRead += (long)ensemble.traceCount();
                double prog = 1000.0 * (double)this.m_numRead / (double)this.m_totalTraces;
                this.m_progress.setValue((int)prog);
                this.m_progress.paintImmediately(0, 0, 1000, 40);
            }
            reader.close();
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_segyCombo) {
                if (this.m_segyCombo.getItemCount() < 1) {
                    return;
                }
                String s = (String)this.m_segyCombo.getSelectedItem();
                Segy segy = new Segy();
                segy.setFileName(s);
                this.m_segyDisplayWidget.setSegy(segy);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return this.m_listener;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            this.m_launchLabel.setText("");
            if (!this.m_data.EchosDictionary.isFileNameValid()) {
                this.m_label.setForeground(Color.red);
                this.m_label.setText("Select or create Echos dictionary file");
                this.m_launchLabel.setForeground(Color.red);
                this.m_launchLabel.setText("Select or create Echos dictionary file");
                return false;
            }
            this.m_label.setText(" ");
            if (!this.m_data.EchosDictionary.isValidPreStack()) {
                this.m_launchLabel.setForeground(Color.red);
                this.m_launchLabel.setText("Dictionary does not have required pre-stack info");
                return false;
            }
            this.m_launchLabel.setForeground(Color.blue);
            this.m_launchLabel.setText("Appears to be a valid dictionary");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void activatePage() {
        try {
            this.m_dictEditor.setEchosFileIndices(this.m_data.EchosSurvey, this.m_data.SelectedFileIndices);
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnReloadSegyList) {
                this.reloadSegyCombo();
                return;
            }
            if (e.getSource() == this.m_scanButton) {
                this.scan();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            Object source = evt.getSource();
            if (source == this.m_dictEditor) {
                boolean bl = this.okayToGoToNextPage();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

