/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Import.Action_ImportAram;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import com.PecosLibrary.Windows.Shared.DimensionSelectionWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.UnitsSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;

public class ImportAramDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Launch import");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected FileWidget m_aramFileWidget;
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Statics);
    protected DimensionSelectionWidget m_dimWidget = new DimensionSelectionWidget(3, "Project dimension");
    protected UnitsSelectionWidget m_unitsWidget = new UnitsSelectionWidget(3);

    public ImportAramDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            middle.addComponent(this.m_nameWidget, 0);
            this.m_aramFileWidget = new FileWidget(false, 3, "Aram .prj file", this);
            middle.addComponent(this.m_aramFileWidget, 0);
            LinearLayoutWidget stuff = middle.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            stuff.addComponent(this.m_dimWidget, 10);
            stuff.addComponent(this.m_unitsWidget, 10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(650, this.getSize().height);
            this.setTitle("Create a new refraction project using ARAM project file");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            if (!this.m_nameWidget.checkName()) {
                return false;
            }
            return Tools_FileSystem.exists_file(this.m_aramFileWidget.getText());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.dataOK()) {
                    return;
                }
                Action_Sequence sequence = new Action_Sequence();
                Action_ImportAram aram = new Action_ImportAram();
                String parentPath = SharedApplicationData.staticsProjectPath();
                aram.Hasher.string_put("ParentPath", parentPath);
                aram.Hasher.string_put("ProjectName", this.m_nameWidget.name());
                aram.Hasher.string_put("Dimension", this.m_dimWidget.dimension());
                aram.Hasher.string_put("Units", this.m_unitsWidget.units());
                aram.Hasher.string_put("FileName", this.m_aramFileWidget.getText());
                sequence.addAction(aram);
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

