/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.GLI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.GLI.GliModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelProfileWidget;
import com.PecosLibrary.Windows.Refraction.GLI.GliNewModelDialog;
import com.PecosLibrary.Windows.Refraction.GLI.GliNewModelLayerSelectionDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class GliWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
ISaveableFrame {
    protected JLabel m_lblXMax = new JLabel("", 4);
    protected JLabel m_lblXMin = new JLabel("", 4);
    protected JLabel m_lblYMax = new JLabel("", 4);
    protected JLabel m_lblYMin = new JLabel("", 4);
    protected JLabel m_lblLayers = new JLabel("", 4);
    protected JLabel m_lblElevNumX = new JLabel("", 4);
    protected JLabel m_lblElevNumY = new JLabel("", 4);
    protected JLabel m_lblVelNumX = new JLabel("", 4);
    protected JLabel m_lblVelNumY = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected JButton m_btnCreateNew;
    protected JButton m_btnUpdate;
    protected JButton m_btnStatics;
    protected JButton m_btnReload;
    protected boolean m_ignoreModelCombo;
    protected int m_maxVisible = 3;
    protected int m_nextIndex = 0;
    protected StackedComposites m_stackedComposites;
    protected Java2D_SimpleComposite m_smallMapWidget;
    protected JComboBox<String> m_cmbNumVisible = new JComboBox();
    protected ComboStringListWrapper m_modelCombo = new ComboStringListWrapper();
    protected GliNewModelDialog m_newModelDialog;
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.GLI.GLI_Widget";
    }

    @Override
    public String TAB_LABEL() {
        return "GLI";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "GLI";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public GliWidget() {
        super(1);
        try {
            System.out.println("Opened GLI window.");
            this.setLeftComponent(this.createLeft());
            this.m_stackedComposites = new StackedComposites(this.m_maxVisible);
            this.setRightComponent(this.m_stackedComposites);
            this.m_stackedComposites.setNumVisible(this.m_cmbNumVisible.getSelectedIndex() + 1);
            Messenger.singleton().addListener(this);
            this.reloadModelCombo();
            this.loadModel();
            this.reloadMap();
            this.m_profileLineUEC.SymmetricLine = false;
            this.m_profileLineUEC.addListener(this);
            this.m_smallMapWidget.mainWidget().addEventConsumer(this.m_profileLineUEC);
            this.m_smallMapWidget.mainWidget().addZoomer();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Model", this.createModelTab());
            topTabs.addTab("Update", this.createUpdateTab());
            return topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            return topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = main.createVertical(0, "Select model", 0);
            sub.addComponent(this.m_modelCombo, 10);
            this.m_modelCombo.listener().addListener(this);
            this.m_btnReload = sub.createButton("Reload list", this, 0);
            this.m_btnCreateNew = sub.createButton("New model", this, 0);
            for (int n = 1; n <= this.m_maxVisible; ++n) {
                String s = Integer.toString(n) + " plots visible";
                this.m_cmbNumVisible.addItem(s);
            }
            this.m_cmbNumVisible.setSelectedIndex(2);
            this.m_cmbNumVisible.addItemListener(this);
            main.addComponent(this.m_cmbNumVisible, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Model description", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Number of layers"), this.m_lblLayers);
            grid.addSimple(row++, new JLabel("Number of elevation grid points, X"), this.m_lblElevNumX);
            grid.addSimple(row++, new JLabel("Number of elevation grid points, Y"), this.m_lblElevNumY);
            grid.addSimple(row++, new JLabel("Number of velocity grid points, X"), this.m_lblVelNumX);
            grid.addSimple(row++, new JLabel("Number of velocity grid points, Y"), this.m_lblVelNumY);
            grid.addSimple(row++, new JLabel("Total model memory (MB)"), this.m_lblMemory);
            JLabel lbl = new JLabel("Left-click and drag to display profiles", 0);
            lbl.setForeground(Color.blue);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            this.m_smallMapWidget = new Java2D_SimpleComposite(true);
            this.m_smallMapWidget.setAxesVisible(false, false);
            main.addComponent(this.m_smallMapWidget, 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createUpdateTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = main.createHorizontal(0, "Update model", 0);
            this.m_btnUpdate = sub.createButton("Update", this, 0);
            this.m_btnStatics = sub.createButton("Statics", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Update options", 0);
            boolean row = false;
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadMap() {
        try {
            System.out.println("reloadMap()");
            Java2D_Widget w = this.m_smallMapWidget.mainWidget();
            this.m_smallMapWidget.setColorTitle("");
            w.clearPaintableList();
            Java2D_Paintable_Table po = Tools_RefractionStaticsProject.loadGeomPO("Shot");
            po.Symbol = Java2D_PointSymbol.FilledSquare;
            w.addPaintable(po, -9999);
            po = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
            po.Symbol = Java2D_PointSymbol.FilledSquare;
            w.addPaintable(po, -9999);
            for (int n = 0; n <= this.m_cmbNumVisible.getSelectedIndex(); ++n) {
                ProfileLine profile = this.m_stackedComposites.ProfileList.get(n);
                w.addPaintable(profile, DelayTimeModelProfileWidget.ProfileLine.PlotLine);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadModelCombo() {
        try {
            this.m_ignoreModelCombo = true;
            String gliPath = RefractionStaticsProject.singleton().gliProjectsPath();
            ArrayList<String> folders = Tools_FileSystem.subdirectories(gliPath, false);
            ArrayList<String> models = new ArrayList<String>();
            for (String folder : folders) {
                if (folder.equalsIgnoreCase("ShotRecStacks")) continue;
                models.add(folder);
            }
            this.m_modelCombo.setStringArray(models);
            this.m_ignoreModelCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadMapProfile() {
        try {
            while (this.m_nextIndex < 0) {
                ++this.m_nextIndex;
            }
            if (this.m_nextIndex > this.m_cmbNumVisible.getSelectedIndex()) {
                this.m_nextIndex = 0;
            }
            ProfileLine pl = this.m_stackedComposites.ProfileList.get(this.m_nextIndex);
            pl.createProfile(this.m_profileLineUEC.StartWorldX, this.m_profileLineUEC.StartWorldY, this.m_profileLineUEC.EndWorldX, this.m_profileLineUEC.EndWorldY);
            this.m_stackedComposites.PlotList.get(this.m_nextIndex).mainWidget().mooz();
            this.reloadMap();
            ++this.m_nextIndex;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createNewModel() {
        try {
            GliNewModelLayerSelectionDialog layerDialog = new GliNewModelLayerSelectionDialog();
            layerDialog.showDialog();
            if (layerDialog.OK) {
                if (this.m_newModelDialog == null) {
                    this.m_newModelDialog = new GliNewModelDialog();
                }
                this.m_newModelDialog.showDialog();
            }
            if (this.m_newModelDialog.OK) {
                this.reloadModelCombo();
                GliModel model = RefractionStaticsProject.singleton().getGliModel();
                if (model != null) {
                    this.m_ignoreModelCombo = true;
                    this.m_modelCombo.setPreferredSelected(model.name());
                    this.m_ignoreModelCombo = false;
                }
                this.handleNewModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleNewModel() {
    }

    public void loadModel() {
        try {
            String name = this.m_modelCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            GliModel model = new GliModel();
            model.load(name);
            RefractionStaticsProject.singleton().setGliModel(model);
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            GliModel model = RefractionStaticsProject.singleton().getGliModel();
            if (e.getSource() == this.m_btnCreateNew) {
                this.createNewModel();
            }
            if (e.getSource() == this.m_btnUpdate) {
                if (model == null) {
                    System.out.println("No model selected.");
                } else {
                    System.out.println("Updating model.");
                    model.testModelUpdate();
                }
            }
            if (e.getSource() == this.m_btnStatics) {
                if (model == null) {
                    System.out.println("No model selected.");
                } else {
                    System.out.println("Computing statics.");
                    model.computeStatics();
                }
            }
            if (e.getSource() == this.m_btnReload) {
                this.reloadModelCombo();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_profileLineUEC) {
                if (this.m_profileLineUEC.Dragging) {
                    return;
                }
                if (this.m_profileLineUEC.TinyLine) {
                    return;
                }
                this.loadMapProfile();
            }
            if (sender == this.m_modelCombo) {
                if (this.m_ignoreModelCombo) {
                    return;
                }
                this.loadModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_cmbNumVisible) {
                this.m_nextIndex = 0;
                this.m_stackedComposites.setNumVisible(this.m_cmbNumVisible.getSelectedIndex() + 1);
                this.reloadMap();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.GliModelChanged) {
                this.reloadModelCombo();
                GliModel model = RefractionStaticsProject.singleton().getGliModel();
                if (model != null) {
                    this.m_modelCombo.setSelectedItem(model.name());
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    public class StackedComposites
    extends JPanel
    implements ComponentListener {
        public int m_numVisible = 1;
        public ArrayList<ProfileLine> ProfileList = new ArrayList();
        public ArrayList<Java2D_SimpleComposite> PlotList = new ArrayList();
        public ArrayList<Java2D_Paintable_AxisLines> LineList = new ArrayList();

        public StackedComposites(int max) {
            try {
                this.setLayout(null);
                for (int n = 0; n < max; ++n) {
                    ProfileLine pl = new ProfileLine();
                    pl.LineIndex = n;
                    Java2D_SimpleComposite w = new Java2D_SimpleComposite(false);
                    this.LineList.add(new Java2D_Paintable_AxisLines());
                    w.mainWidget().addPaintable(pl, pl.PlotProfile);
                    w.mainWidget().addPaintable(this.LineList.get(n), -9999);
                    Color c = Color.BLACK;
                    if (n == 0) {
                        c = Color.RED;
                    }
                    if (n == 1) {
                        c = Color.BLUE;
                    }
                    if (n == 2) {
                        c = Color.MAGENTA;
                    }
                    if (n == 3) {
                        c = Color.YELLOW;
                    }
                    if (n == 4) {
                        c = Color.CYAN;
                    }
                    pl.ProfileLineColor = c;
                    Color axisColor = Tools_GraphicalObjectLibrary.lighten(c);
                    w.setVerticalAxisColor(axisColor);
                    this.PlotList.add(w);
                    this.ProfileList.add(pl);
                    this.add(w);
                }
                this.addComponentListener(this);
                this.placeWidgets();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setLinesVisible(boolean vis) {
            try {
                for (int n = 0; n < this.LineList.size(); ++n) {
                    this.LineList.get((int)n).DrawHorizontalLines = vis;
                    this.PlotList.get(n).mainWidget().mooz();
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            try {
                this.placeWidgets();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        public void placeWidgets() {
            try {
                int width = this.getSize().width;
                int height = this.getSize().height;
                this.m_numVisible = Math.max(1, this.m_numVisible);
                this.m_numVisible = Math.min(this.m_numVisible, this.PlotList.size());
                int pixPer = height / this.m_numVisible;
                for (int n = 0; n < this.PlotList.size(); ++n) {
                    this.PlotList.get(n).setVisible(n < this.m_numVisible);
                }
                int top = 0;
                for (int n = 0; n < this.m_numVisible; ++n) {
                    this.PlotList.get(n).setBounds(0, top, width, pixPer);
                    top += pixPer;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setNumVisible(int num) {
            try {
                this.m_numVisible = num;
                this.placeWidgets();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public class ProfileLine
    implements Java2D_PaintableInterface {
        public int PlotProfile = 1000;
        public int PlotLine = 1001;
        public Color ProfileLineColor = Color.BLACK;
        public boolean Valid = false;
        public int LineIndex = -999;
        public double X1;
        public double Y1;
        public double X2;
        public double Y2;
        public double DX;
        public double DY;
        public double Length;
        public double X1shifted;
        public double X2shifted;
        public double Y1shifted;
        public double Y2shifted;
        public int NumPoints = 500;
        public float[][] Velocity;
        public float[][] Elevation;
        public float[] MaxVelocity = new float[10];
        public float[] MaxElevation = new float[10];
        public float[] MinVelocity = new float[10];
        public float[] MinElevation = new float[10];
        public float PlotMaxY;
        public float PlotMinY;
        public int NumLayers = 0;

        public ProfileLine() {
            try {
                this.Velocity = new float[10][this.NumPoints];
                this.Elevation = new float[10][this.NumPoints];
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void createProfile(double x1, double y1, double x2, double y2) {
            try {
                GliModel model = RefractionStaticsProject.singleton().getGliModel();
                this.Valid = false;
                this.NumLayers = model.LayerCount();
                if (this.NumLayers < 1) {
                    return;
                }
                for (int z = 0; z <= this.NumLayers; ++z) {
                    this.MaxVelocity[z] = -3.4028235E38f;
                    this.MinVelocity[z] = Float.MAX_VALUE;
                    this.MaxElevation[z] = -3.4028235E38f;
                    this.MinElevation[z] = Float.MAX_VALUE;
                }
                this.X1 = x1;
                this.X2 = x2;
                this.Y1 = y1;
                this.Y2 = y2;
                this.DX = this.X2 - this.X1;
                this.DY = this.Y2 - this.Y1;
                this.Length = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
                this.DX /= (double)(this.NumPoints - 1);
                this.DY /= (double)(this.NumPoints - 1);
                for (int n = 0; n < this.NumPoints; ++n) {
                    double x = this.X1 + this.DX * (double)n;
                    double y = this.Y1 + this.DY * (double)n;
                    for (int z = 0; z <= this.NumLayers; ++z) {
                        this.Velocity[z][n] = model.velocityGrid().get(z).getNearestValue(x, y);
                        this.Elevation[z][n] = model.elevationGrid().get(z).getNearestValue(x, y);
                        this.MinElevation[z] = Math.min(this.MinElevation[z], this.Elevation[z][n]);
                        this.MaxElevation[z] = Math.max(this.MaxElevation[z], this.Elevation[z][n]);
                        this.MinVelocity[z] = Math.min(this.MinVelocity[z], this.Velocity[z][n]);
                        this.MaxVelocity[z] = Math.max(this.MaxVelocity[z], this.Velocity[z][n]);
                    }
                }
                float plotRange = this.MaxElevation[0] - this.MinElevation[this.NumLayers];
                this.PlotMaxY = this.MaxElevation[0] + 0.1f * plotRange;
                this.PlotMinY = this.MinElevation[this.NumLayers] - 0.1f * plotRange;
                for (int n = 0; n < this.NumPoints; ++n) {
                    this.Elevation[this.NumLayers + 1][n] = this.PlotMinY;
                }
                this.Valid = true;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                this.Valid = false;
            }
        }

        @Override
        public boolean Java2D_ImageContentsDirty(int supplementalData) {
            return false;
        }

        @Override
        public int Java2D_MaximumPaintLevel(int supplementalData) {
            return 0;
        }

        @Override
        public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
            try {
                int n;
                int r;
                if (!this.Valid) {
                    return;
                }
                if (paintParameter.PaintLevel != 0) {
                    return;
                }
                ProfileLine m_profileLine = new ProfileLine();
                Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
                Java2D_Transform transform = paintParameter.Transform;
                Graphics2D g2d = paintParameter.G2D;
                double scaleX = transform.scaleX();
                double shiftX = transform.shiftX();
                double scaleY = transform.scaleY();
                double shiftY = transform.shiftY();
                if (supplementalData == this.PlotLine) {
                    g2d.setColor(this.ProfileLineColor);
                    g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
                    int x1 = (int)(this.X1 * scaleX + shiftX);
                    int y1 = (int)(this.Y1 * scaleY + shiftY);
                    int x2 = (int)(this.X2 * scaleX + shiftX);
                    int y2 = (int)(this.Y2 * scaleY + shiftY);
                    g2d.drawLine(x1, y1, x2, y2);
                    return;
                }
                double segLength = this.Length / (double)(this.NumPoints - 1);
                int px = 1 + (int)(scaleX * segLength);
                for (r = 0; r <= this.NumLayers; ++r) {
                    for (n = 0; n < this.NumPoints; ++n) {
                        double x = (double)n * this.Length / (double)(this.NumPoints - 1);
                        int ix = (int)(x * scaleX + shiftX);
                        int y1 = (int)((double)this.Elevation[r][n] * scaleY + shiftY);
                        int y2 = (int)((double)this.Elevation[r + 1][n] * scaleY + shiftY);
                        if (!colorWrapper.valueOK(this.Velocity[r][n])) continue;
                        Color c = colorWrapper.colorUsingValue(this.Velocity[r][n]);
                        g2d.setColor(c);
                        g2d.fillRect(ix - px / 2, y1, px + 1, y2 - y1);
                    }
                }
                g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
                g2d.setColor(Color.BLACK);
                for (r = 0; r <= this.NumLayers; ++r) {
                    for (n = 1; n < this.NumPoints; ++n) {
                        double x1 = (double)(n - 1) * this.Length / (double)(this.NumPoints - 1);
                        int ix1 = (int)(x1 * scaleX + shiftX);
                        double x2 = (double)n * this.Length / (double)(this.NumPoints - 1);
                        int ix2 = (int)(x2 * scaleX + shiftX);
                        int iy1 = (int)(scaleY * (double)this.Elevation[r][n - 1] + shiftY);
                        int iy2 = (int)(scaleY * (double)this.Elevation[r][n] + shiftY);
                        g2d.drawLine(ix1, iy1, ix2, iy2);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
            try {
                if (!this.Valid) {
                    return;
                }
                if (supplementalData == this.PlotLine) {
                    return;
                }
                rangeX.expandRange(0.0 - this.Length * 0.05);
                rangeX.expandRange(this.Length * 1.05);
                rangeY.expandRange(this.PlotMaxY);
                rangeY.expandRange(this.PlotMinY);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
            try {
                if (!this.Valid) {
                    return;
                }
                if (supplementalData == this.PlotLine) {
                    return;
                }
                for (int z = 0; z <= this.NumLayers; ++z) {
                    rangeC.expandRange(this.MinVelocity[z]);
                    rangeC.expandRange(this.MaxVelocity[z]);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
        }
    }
}

