/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ElevationStaticsDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener,
DocumentListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnOK = new JButton("Create statics field");
    protected JTextField m_txtStaticsField = new JTextField("ElStat");
    protected JLabel m_lblStaticsField = new JLabel(" ");
    protected JTextField m_txtFinalDatum = new JTextField("6000");
    protected JTextField m_txtRepVel = new JTextField("5000");
    protected JCheckBox m_chkZeroMean = new JCheckBox("Force statics to be zero-mean");
    protected String m_paramFile;
    protected ParameterTree m_tree = new ParameterTree();
    protected RadioPanel m_radUphole;
    protected double m_staticsSum = 0.0;
    protected double m_staticsCount = 1.0E-40;
    protected double m_staticsAverage = 0.0;

    public ElevationStaticsDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.m_paramFile = this.m_project.guiOptionsPath() + "/ElevStatics.xml";
            this.m_tree.read(this.m_paramFile);
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Statics name"), this.m_txtStaticsField);
            grid.addSimple(row++, new JLabel("Database column name"), this.m_lblStaticsField);
            grid.addSimple(row++, new JLabel("Final datum"), this.m_txtFinalDatum);
            grid.addSimple(row++, new JLabel("Replacement velocity"), this.m_txtRepVel);
            grid.addSimple(row++, new JLabel(" "), this.m_chkZeroMean);
            this.m_txtStaticsField.setText(this.m_tree.string_get("Name", "ElevStatics"));
            this.m_txtFinalDatum.setText(Double.toString(this.m_tree.double_get("Datum", 1000.0)));
            this.m_txtRepVel.setText(Double.toString(this.m_tree.double_get("RepVel", 1000.0)));
            this.m_chkZeroMean.setSelected(false);
            this.m_txtStaticsField.getDocument().addDocumentListener(this);
            this.m_radUphole = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Dynamite/OBC options", "Use uphole time", "Use depth", "Ignore depth/uphole");
            this.m_radUphole.setSelectedIndex(1);
            main.addComponent(this.m_radUphole, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 200, this.getSize().height);
            this.setTitle("Compute elevation statics");
            this.setLocationRelativeTo(null);
            this.checkName();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void checkName() {
        try {
            this.m_btnOK.setEnabled(false);
            String name = this.m_txtStaticsField.getText();
            this.m_lblStaticsField.setText("");
            if (name.length() < 3) {
                this.m_lblStaticsField.setForeground(Color.red);
                this.m_lblStaticsField.setText("Name must have at least 3 characters");
                return;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_lblStaticsField.setForeground(Color.red);
                this.m_lblStaticsField.setText("Spaces and special characters not allowed");
                return;
            }
            if (Tools_Strings.startsWithNumber(name)) {
                this.m_lblStaticsField.setForeground(Color.red);
                this.m_lblStaticsField.setText("Name cannot start with a number");
                return;
            }
            String colName = "STATICS_" + name;
            this.m_btnOK.setEnabled(true);
            this.m_lblStaticsField.setForeground(Color.blue);
            this.m_lblStaticsField.setText(colName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected boolean doStuff(String colname, double datum, double vel, Table_Abstract table) {
        try {
            boolean useUpholeTime = this.m_radUphole.getSelectedIndex() == 0 && table.column_exists("UpholeTime");
            boolean useDepth = this.m_radUphole.getSelectedIndex() == 1 && table.column_exists("PointDepth");
            int indexZ = table.column_indexOfColumn("Elevation");
            int indexS = table.column_append(colname, DataType.Double);
            int indexUphole = -9999;
            if (table.column_exists("UpholeTime")) {
                indexUphole = table.column_indexOfColumn("UpholeTime");
            }
            int indexDepth = -9999;
            if (table.column_exists("PointDepth")) {
                indexDepth = table.column_indexOfColumn("PointDepth");
            }
            for (int row = 0; row < table.row_count(); ++row) {
                double depth;
                double z = table.getDouble(row, indexZ);
                if (useDepth && (depth = table.getDouble(row, indexDepth)) > 0.0) {
                    z -= depth;
                }
                double elevStatic = 1000.0 * (datum - z) / vel;
                if (useUpholeTime) {
                    elevStatic += table.getDouble(row, indexUphole);
                }
                table.putDouble(row, indexS, elevStatic);
                this.m_staticsCount += 1.0;
                this.m_staticsSum += elevStatic;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean zero(String colname, Table_Abstract table) {
        try {
            int indexS = table.column_append(colname, DataType.Double);
            for (int row = 0; row < table.row_count(); ++row) {
                double elevStatic = table.getDouble(row, indexS);
                table.putDouble(row, indexS, elevStatic - this.m_staticsAverage);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean doStuff() {
        try {
            String colName = "STATICS_" + this.m_txtStaticsField.getText();
            double datum = Tools_Widget.extractDouble(this.m_txtFinalDatum, 5000.0, -20000.0, 20000.0);
            double vel = Tools_Widget.extractDouble(this.m_txtRepVel, 3000.0, 10.0, 20000.0);
            this.m_tree.string_put("Name", this.m_txtStaticsField.getText());
            this.m_tree.double_put("Datum", datum);
            this.m_tree.double_put("RepVel", vel);
            this.m_tree.bool_put("Zero", this.m_chkZeroMean.isSelected());
            this.m_tree.save(this.m_paramFile);
            this.m_staticsSum = 0.0;
            this.m_staticsCount = 1.0E-40;
            this.doStuff(colName, datum, vel, this.m_project.receiverTable());
            this.doStuff(colName, datum, vel, this.m_project.shotTable());
            this.m_staticsAverage = this.m_staticsSum / this.m_staticsCount;
            if (this.m_chkZeroMean.isSelected()) {
                this.zero(colName, this.m_project.receiverTable());
                this.zero(colName, this.m_project.shotTable());
            }
            this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), colName);
            this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), colName);
            History hist = RefractionStaticsProject.delayTimeData().getHistory();
            hist.addWithTime("Compute elevation statics");
            hist.add("Output column name: " + colName.toUpperCase());
            hist.add(String.format("Final datum = %f", Float.valueOf((float)datum)));
            hist.add(String.format("Replacement velocity = %f", Float.valueOf((float)vel)));
            if (this.m_chkZeroMean.isSelected()) {
                hist.add("STATICS FORCED TO BE ZERO MEAN");
            }
            hist.save();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.doStuff()) {
                    return;
                }
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

