/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.Wizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_StaticsInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class Page_Static_Intermediate
extends LinearLayoutWidget
implements ItemListener,
ActionListener,
ISimpleWizardPage {
    protected DelayTimeModel_StaticsInfo m_staticsInfo;
    protected JComboBox<String> m_combo;
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected GridLayoutWidget m_databaseGrid;
    protected JComboBox<String> m_databaseCombo = new JComboBox();
    protected JButton m_databaseReloadButton = new JButton("Reload");
    protected GridLayoutWidget m_surfaceGrid;
    protected JTextField m_surfaceSmoothRadiusText = new JTextField("1000");
    protected JTextField m_surfaceMoveDistanceText = new JTextField("500");
    protected GridLayoutWidget m_refractorGrid;
    protected JComboBox<String> m_refractorCombo = new JComboBox();
    protected JCheckBox m_refractorSmoothCheck = new JCheckBox("Smooth refractor surface");
    protected JTextField m_refractorSmoothRadiusText = new JTextField("Only used if smoothing");
    protected JTextField m_refractorMoveDistanceText = new JTextField("Only used if smoothing");
    protected boolean m_hasNumbers = false;
    protected LinearLayoutWidget m_fixedDepthWidget;
    protected JTextField m_fixedDepthText = new JTextField("200");
    protected LinearLayoutWidget m_fixedElevWidget;
    protected JTextField m_fixedElevText = new JTextField("1000");
    protected JTable m_table = new JTable();

    public Page_Static_Intermediate(DelayTimeModel_StaticsInfo staticsInfo) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_staticsInfo = staticsInfo;
            this.addComponent(new JLabel("Surface and refractor elevations"), 0);
            this.m_table.setShowGrid(true);
            this.m_table.setGridColor(Color.LIGHT_GRAY);
            this.m_table.setModel(new Table_SimpleModel(this.m_staticsInfo.ElevationTable));
            this.addComponent(new JScrollPane(this.m_table), 11);
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_surfaceGrid = new GridLayoutWidget(0, null);
            int row = 0;
            this.m_surfaceGrid.addSimple(row++, new JLabel("Smooth radius"), this.m_surfaceSmoothRadiusText);
            this.m_surfaceGrid.addSimple(row++, new JLabel("Downward shift"), this.m_surfaceMoveDistanceText);
            this.m_surfaceGrid.addComponent(new JLabel(""), row, 0, 5.0, 5.0);
            this.m_refractorGrid = new GridLayoutWidget(0, null);
            this.m_fixedDepthWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_fixedElevWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_fixedDepthText = this.m_fixedDepthWidget.createSubTextField("Fixed depth (ft/m)", "200", null);
            this.m_fixedDepthWidget.addStretch(10);
            this.m_fixedElevText = this.m_fixedElevWidget.createSubTextField("Fixed Elevation (ft/m)", "0", null);
            this.m_fixedElevWidget.addStretch(10);
            row = 0;
            this.m_refractorGrid.addSimple(row++, new JLabel(" "), this.m_refractorSmoothCheck);
            this.m_refractorGrid.addSimple(row++, new JLabel("Smooth radius"), this.m_refractorSmoothRadiusText);
            this.m_refractorGrid.addSimple(row++, new JLabel("Downward shift"), this.m_refractorMoveDistanceText);
            this.m_refractorGrid.addComponent(new JLabel(""), row, 0, 5.0, 5.0);
            this.m_refractorSmoothCheck.setSelected(false);
            this.m_refractorSmoothCheck.addActionListener(this);
            this.m_refractorSmoothRadiusText.setEnabled(this.m_refractorSmoothCheck.isSelected());
            this.m_refractorMoveDistanceText.setEnabled(this.m_refractorSmoothCheck.isSelected());
            this.m_databaseGrid = new GridLayoutWidget(0, null);
            row = 0;
            this.m_databaseGrid.addSimple(row++, new JLabel("Select column"), this.m_databaseCombo);
            this.m_databaseReloadButton.addActionListener(this);
            this.m_databaseGrid.addComponent(this.m_databaseReloadButton, row++, 1);
            this.m_databaseGrid.addComponent(new JLabel(""), row, 0, 5.0, 5.0);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ArrayList<String> cols = p.getVersionColumnNames(p.versionName(), true);
            for (String c : cols) {
                this.m_databaseCombo.addItem(c);
            }
            this.createGapLabel(10);
            this.m_combo = this.createSubComboBox("Datum specification:", this);
            for (DelayTimeModel_StaticsInfo.IntermediateDatumEnum ide : DelayTimeModel_StaticsInfo.IntermediateDatumEnum.values()) {
                this.m_combo.addItem(ide.Description);
            }
            this.m_combo.setSelectedIndex(0);
            this.m_mainPanel.add((Component)this.m_fixedElevWidget, DelayTimeModel_StaticsInfo.IntermediateDatumEnum.FixedElevation.Description);
            this.m_mainPanel.add((Component)this.m_fixedDepthWidget, DelayTimeModel_StaticsInfo.IntermediateDatumEnum.FixedDepth.Description);
            this.m_mainPanel.add((Component)this.m_refractorGrid, DelayTimeModel_StaticsInfo.IntermediateDatumEnum.RefractorSurface.Description);
            this.m_mainPanel.add((Component)this.m_surfaceGrid, DelayTimeModel_StaticsInfo.IntermediateDatumEnum.Surface.Description);
            this.m_mainPanel.add((Component)this.m_databaseGrid, DelayTimeModel_StaticsInfo.IntermediateDatumEnum.DatabaseColumn.Description);
            this.addComponent(this.m_mainPanel, 10);
            this.m_cardLayout.show(this.m_mainPanel, (String)this.m_combo.getSelectedItem());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_databaseReloadButton) {
                this.m_databaseCombo.removeAllItems();
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                ArrayList<String> cols = p.getVersionColumnNames(p.versionName(), true);
                for (String c : cols) {
                    this.m_databaseCombo.addItem(c);
                }
                return;
            }
            if (e.getSource() == this.m_refractorSmoothCheck) {
                if (this.m_hasNumbers) {
                    this.m_staticsInfo.Intermediate_SmoothRadius = Tools_Widget.extractDouble(this.m_refractorSmoothRadiusText, 100.0, 1.0, 999999.0);
                    this.m_staticsInfo.Intermediate_DownwardDistance = Tools_Widget.extractDouble(this.m_refractorMoveDistanceText, 0.0, -9999.0, 999999.0);
                }
                if (!this.m_refractorSmoothCheck.isSelected()) {
                    this.m_refractorSmoothRadiusText.setText("Only used if smoothing");
                    this.m_refractorMoveDistanceText.setText("Only used if smoothing");
                    this.m_hasNumbers = false;
                } else {
                    this.m_refractorSmoothRadiusText.setText(Double.toString(this.m_staticsInfo.Intermediate_SmoothRadius));
                    this.m_refractorMoveDistanceText.setText(Double.toString(this.m_staticsInfo.Intermediate_DownwardDistance));
                    this.m_hasNumbers = true;
                }
                this.m_refractorSmoothRadiusText.setEnabled(this.m_refractorSmoothCheck.isSelected());
                this.m_refractorMoveDistanceText.setEnabled(this.m_refractorSmoothCheck.isSelected());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
        try {
            this.m_table.setModel(new Table_SimpleModel(this.m_staticsInfo.ElevationTable));
            this.m_refractorCombo.removeAllItems();
            for (int b = 1; b <= this.m_staticsInfo.MaxBranch; ++b) {
                this.m_refractorCombo.addItem(String.format("Refractor %d", b));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.m_cardLayout.show(this.m_mainPanel, (String)this.m_combo.getSelectedItem());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return true;
    }

    @Override
    public void leavingPage() {
        try {
            int index = this.m_combo.getSelectedIndex();
            this.m_staticsInfo.Intermediate_DatabaseColumn = this.m_databaseCombo.getSelectedItem().toString();
            this.m_staticsInfo.IntermediateDatum = DelayTimeModel_StaticsInfo.IntermediateDatumEnum.values()[index];
            this.m_staticsInfo.Intermediate_FixedDepth = Tools_Widget.extractDouble(this.m_fixedDepthText, 200.0, -999999.0, 999999.0);
            this.m_staticsInfo.Intermediate_FixedElevation = Tools_Widget.extractDouble(this.m_fixedElevText, 0.0, -999999.0, 999999.0);
            this.m_staticsInfo.Intermediate_RefractorNumber = 1 + this.m_refractorCombo.getSelectedIndex();
            this.m_staticsInfo.Intermediate_SmoothRefractor = this.m_refractorSmoothCheck.isSelected();
            this.m_staticsInfo.Intermediate_SmoothRadius = Tools_Widget.extractDouble(this.m_refractorSmoothRadiusText, 100.0, 1.0, 999999.0);
            this.m_staticsInfo.Intermediate_DownwardDistance = Tools_Widget.extractDouble(this.m_refractorMoveDistanceText, 0.0, 0.0, 999999.0);
            this.m_staticsInfo.Intermediate_SurfaceSmoothRadius = Tools_Widget.extractDouble(this.m_surfaceSmoothRadiusText, 100.0, 1.0, 999999.0);
            this.m_staticsInfo.Intermediate_SurfaceDownwardDistance = Tools_Widget.extractDouble(this.m_surfaceMoveDistanceText, 0.0, 0.0, 999999.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.m_table.setModel(new Table_SimpleModel(this.m_staticsInfo.ElevationTable));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

