/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_LineSegment;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.TablePlot.Java2D_TablePlotWidget_Stacked;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class VerticalProfileWidget
extends JSplitPane
implements INumberedWidget,
GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener,
ItemListener,
ISaveableFrame {
    protected Java2D_SimpleComposite m_widgetBasemap;
    protected Java2D_TablePlotWidget_Stacked m_stackWidget = new Java2D_TablePlotWidget_Stacked();
    protected int m_elevationRow = 0;
    protected int m_velocityRow = 1;
    protected JComboBox<String> m_plotCountCombo = new JComboBox();
    protected Table_Abstract m_currentTable;
    protected JButton m_reloadSlice;
    protected Java2D_Paintable_LineSegment m_lineSegment;
    protected JRadioButton m_blackRadio = new JRadioButton("No colors");
    protected JRadioButton m_tableRadio = new JRadioButton("Use database value");
    protected ButtonGroup m_plotGroup = new ButtonGroup();
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper();
    protected JButton m_reloadComboButton;
    protected JButton m_reloadPlotButton;
    protected JRadioButton m_squareRadio = new JRadioButton("Inverse square");
    protected JRadioButton m_fourthRadio = new JRadioButton("Inverse fourth");
    protected ButtonGroup m_interpGroup = new ButtonGroup();
    protected JTextField m_interpRadiusText = new JTextField("100");
    protected Java2D_UserEventConsumer_Line m_lineUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected int m_widgetNumber = 1;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.VerticalProfileWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Profiles";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Profiles";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public VerticalProfileWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            this.reloadCombo();
            this.m_lineSegment = new Java2D_Paintable_LineSegment();
            this.m_lineSegment.Valid = false;
            this.m_lineSegment.LineColor = Color.RED;
            this.m_lineSegment.DrawSymbols = false;
            this.reloadMap();
            int row = 0;
            this.m_stackWidget.addColumnName(row++, Pecos.getColNameDT(1));
            this.m_stackWidget.addColumnName(row++, Pecos.getColNameElev(0));
            this.m_stackWidget.addColumnName(row++, Pecos.getColNameVel(0));
            this.m_stackWidget.setNumVisible(row);
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            this.m_lineUEC = new Java2D_UserEventConsumer_Line();
            this.m_lineUEC.SymmetricLine = false;
            this.m_lineUEC.addListener(this);
            this.m_widgetBasemap.mainWidget().addEventConsumer(this.m_lineUEC);
            this.m_widgetBasemap.mainWidget().addEventConsumer(this.m_mapKeyUEC);
            this.m_widgetBasemap.mainWidget().addZoomer();
            this.prepTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            double minVel = 1200.0;
            double maxVel = 10000.0;
            if (!RefractionStaticsProject.singleton().units_feet()) {
                minVel = 360.0;
                maxVel = 3000.0;
            }
            GridLayoutWidget grid = w.createGridLayoutWidget(3, "Interpolation options", 0);
            int row = 0;
            grid.addSimple(row++, this.m_squareRadio, this.m_fourthRadio);
            grid.addSimple(row++, new JLabel("Interpolation radius"), this.m_interpRadiusText);
            this.m_interpGroup.add(this.m_squareRadio);
            this.m_interpGroup.add(this.m_fourthRadio);
            this.m_interpRadiusText.addActionListener(this);
            this.m_squareRadio.addActionListener(this);
            this.m_fourthRadio.addActionListener(this);
            this.m_fourthRadio.setSelected(true);
            LinearLayoutWidget sub = w.createVertical(0, "Plot options", 0);
            sub.addComponent(this.m_blackRadio, 0);
            sub.addComponent(this.m_tableRadio, 0);
            sub.addComponent(this.m_columnCombo, 0);
            this.m_reloadComboButton = sub.createButton("Reload database column list", this, 0);
            this.m_reloadPlotButton = sub.createButton("Reload the plot", this, 0);
            this.m_columnCombo.setPreferredSelected("Elevation");
            this.m_columnCombo.setEnabled(false);
            this.m_columnCombo.listener().addListener(this);
            this.m_plotGroup.add(this.m_blackRadio);
            this.m_plotGroup.add(this.m_tableRadio);
            this.m_blackRadio.setSelected(true);
            this.m_blackRadio.addActionListener(this);
            this.m_tableRadio.addActionListener(this);
            Tools_FontChanger.changeSizeOfFont(w, -2, null, true);
            this.m_widgetBasemap = new Java2D_SimpleComposite(true);
            this.m_widgetBasemap.setAxesVisible(false, false);
            w.addComponent(this.m_widgetBasemap, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            return this.createRightPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top = w.createHorizontal(3, null, 0);
            for (int n = 1; n <= 10; ++n) {
                this.m_plotCountCombo.addItem(String.format("%d plots visible", n));
            }
            this.m_plotCountCombo.setSelectedIndex(3);
            top.addComponent(this.m_plotCountCombo, 0);
            this.m_plotCountCombo.addItemListener(this);
            top.createLabel("Left-click on a plot to show up option menu", 2, 0);
            this.m_reloadSlice = top.createButton("Reload the current profile data", this, 0);
            top.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            w.addComponent(this.m_stackWidget, 10);
            return w;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_plotCountCombo) {
                this.prepTable();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    protected void reloadCombo() {
        try {
            ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
            this.m_columnCombo.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_reloadSlice || e.getSource() == this.m_fourthRadio || e.getSource() == this.m_squareRadio || e.getSource() == this.m_interpRadiusText) {
                this.reloadCurrentSlice();
                return;
            }
            if (e.getSource() == this.m_reloadComboButton) {
                this.reloadCombo();
                return;
            }
            if (this.m_blackRadio == e.getSource() || this.m_tableRadio == e.getSource() || this.m_reloadPlotButton == e.getSource()) {
                this.m_columnCombo.setEnabled(this.m_tableRadio.isSelected());
                this.reloadMap();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepTable() {
        try {
            this.m_stackWidget.setNumVisible(1 + this.m_plotCountCombo.getSelectedIndex());
            int maxBranch = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
            this.m_stackWidget.setTable(this.m_currentTable);
            this.m_stackWidget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadCurrentSlice() {
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.m_currentTable = new Table_Memory();
            this.m_currentTable.setName("Interpolated");
            int numPoints = 200;
            double x1 = this.m_lineUEC.StartWorldX;
            double y1 = this.m_lineUEC.StartWorldY;
            double diffx = this.m_lineUEC.EndWorldX - this.m_lineUEC.StartWorldX;
            double diffy = this.m_lineUEC.EndWorldY - this.m_lineUEC.StartWorldY;
            this.m_lineSegment.X1 = x1;
            this.m_lineSegment.Y1 = y1;
            this.m_lineSegment.X2 = this.m_lineUEC.EndWorldX;
            this.m_lineSegment.Y2 = this.m_lineUEC.EndWorldY;
            this.m_lineSegment.Valid = true;
            double dx = diffx / (double)(numPoints - 1);
            double dy = diffy / (double)(numPoints - 1);
            int indexX = this.m_currentTable.column_append("Easting", DataType.Double);
            int indexY = this.m_currentTable.column_append("Northing", DataType.Double);
            for (int n = 0; n < numPoints; ++n) {
                int row = this.m_currentTable.row_increment();
                this.m_currentTable.putDouble(row, indexX, x1 + dx * (double)n);
                this.m_currentTable.putDouble(row, indexY, y1 + dy * (double)n);
            }
            double smoothRadius = Tools_Widget.extractDouble(this.m_interpRadiusText, 50.0, 1.0, 1000.0);
            boolean inverseFourth = this.m_fourthRadio.isSelected();
            Tools_RefractionStaticsProject.computeInterpolatedTable(this.m_currentTable, smoothRadius, inverseFourth);
            this.prepTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_columnCombo) {
                this.reloadMap();
                return;
            }
            if (sender == this.m_lineUEC) {
                if (this.m_lineUEC.Dragging) {
                    return;
                }
                this.reloadCurrentSlice();
                this.prepTable();
                this.reloadMap();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMap() {
        try {
            Java2D_Paintable_Table po;
            System.out.println("reloadMap()");
            Java2D_Widget w = this.m_widgetBasemap.mainWidget();
            this.m_widgetBasemap.setColorTitle("");
            w.clearPaintableList();
            if (this.m_blackRadio.isSelected()) {
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot");
                po.Symbol = Java2D_PointSymbol.FilledSquare;
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
                po.Symbol = Java2D_PointSymbol.FilledSquare;
                w.addPaintable(po, -9999);
            }
            if (this.m_tableRadio.isSelected()) {
                String col = this.m_columnCombo.getSelectedString();
                this.m_widgetBasemap.setColorTitle(col);
                po = Tools_RefractionStaticsProject.loadGeomPO("Shot", col);
                w.addPaintable(po, -9999);
                po = Tools_RefractionStaticsProject.loadGeomPO("Receiver", col);
                w.addPaintable(po, -9999);
            }
            w.addPaintable(this.m_lineSegment, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

