/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Page_IMB_ModMethod
extends LinearLayoutWidget
implements ISimpleWizardPage,
ListSelectionListener,
ActionListener {
    protected DelayTimeModel_ModInfo m_modelModInfo;
    protected JList<String> m_list = new JList();
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected LinearLayoutWidget m_constantWidget;
    protected JTextField m_constantText = new JTextField("1000");
    protected JComboBox<String> m_constantCombo = new JComboBox();
    protected LinearLayoutWidget m_clipWidget;
    protected JTextField m_clipMinText = new JTextField("1000");
    protected JTextField m_clipMaxText = new JTextField("1000");
    protected JComboBox<String> m_clipCombo = new JComboBox();
    protected LinearLayoutWidget m_upholeWidget;
    protected JTextField m_upholeMinText = new JTextField("1000");
    protected JTextField m_upholeMaxText = new JTextField("6000");
    protected LinearLayoutWidget m_smoothWidget;
    protected JTextField m_smoothText = new JTextField("1000");
    protected JComboBox<String> m_smoothCombo = new JComboBox();
    protected ComboStringListWrapper m_smoothWeightCombo = new ComboStringListWrapper();
    protected JButton m_smoothReloadColumnsButton;
    protected ComboStringListWrapper m_importColumnCombo = new ComboStringListWrapper();
    protected LinearLayoutWidget m_importWidget;
    protected JButton m_reloadColumnsButton;
    protected LinearLayoutWidget m_polyWidget;
    protected JComboBox<String> m_polyCombo = new JComboBox();
    InteractiveModel _model;
    protected boolean m_ignoreSel = false;

    public Page_IMB_ModMethod(DelayTimeModel_ModInfo modelModInfo, InteractiveModel interactiveModel) {
        super(LinearLayoutWidget.Direction.Horizontal, 3, null);
        try {
            this._model = interactiveModel;
            Table_Abstract shotTable = this._model.getSourceTable();
            Table_Abstract recTable = this._model.getReceiverTable();
            this.m_modelModInfo = modelModInfo;
            this.m_constantWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_clipWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_smoothWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_polyWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_importWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_upholeWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_importWidget.addComponent(new JLabel("Select database column"), 0);
            this.m_importWidget.addComponent(this.m_importColumnCombo, 0);
            this.m_reloadColumnsButton = this.m_importWidget.createButton("Reload list of columns", this, 0);
            this.m_importWidget.addStretch(100);
            this.m_importColumnCombo.setStringArray(Tools_RefractionStaticsProject.getColumnList_Intersection(shotTable, recTable));
            this.m_polyCombo.addItem("Delete inside the polygon");
            this.m_polyCombo.addItem("Delete outside the polygon");
            this.m_polyCombo.setSelectedIndex(0);
            this.m_polyWidget.addComponent(new JLabel("Deleted region will be interpolated"), 0);
            this.m_polyWidget.addComponent(this.m_polyCombo, 0);
            this.m_polyWidget.addStretch(100);
            this.m_smoothWidget.addComponent(new JLabel("Smoothing radius (ft/m)"), 0);
            this.m_smoothWidget.addComponent(this.m_smoothText, 0);
            this.m_smoothWidget.createGapLabel(10);
            this.m_smoothWidget.addComponent(this.m_smoothCombo, 0);
            this.m_smoothWidget.createGapLabel(10);
            this.m_smoothWidget.addComponent(new JLabel("Weight the smoothing using a database column:"), 0);
            this.m_smoothWidget.addComponent(this.m_smoothWeightCombo, 0);
            this.m_smoothReloadColumnsButton = this.m_smoothWidget.createButton("Reload list of columns", this, 0);
            this.m_smoothWidget.addStretch(100);
            ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
            cols.add(0, "Do not use a column to weight smoothing");
            this.m_smoothWeightCombo.setStringArray(cols);
            this.addPoly(this.m_smoothCombo);
            this.m_upholeWidget.addComponent(new JLabel("Minimum allowed value:"), 0);
            this.m_upholeWidget.addComponent(this.m_upholeMinText, 0);
            this.m_upholeWidget.addComponent(new JLabel("Maximum allowed value:"), 0);
            this.m_upholeWidget.addComponent(this.m_upholeMaxText, 0);
            this.m_upholeWidget.addStretch(100);
            this.m_clipWidget.addComponent(new JLabel("Minimum allowed value:"), 0);
            this.m_clipWidget.addComponent(this.m_clipMinText, 0);
            this.m_clipWidget.addComponent(new JLabel("Maximum allowed value:"), 0);
            this.m_clipWidget.addComponent(this.m_clipMaxText, 0);
            this.m_clipWidget.createGapLabel(10);
            this.m_clipWidget.addComponent(this.m_clipCombo, 0);
            this.m_clipWidget.addStretch(100);
            this.addPoly(this.m_clipCombo);
            this.m_constantWidget.addComponent(new JLabel("Constant value:"), 0);
            this.m_constantWidget.addComponent(this.m_constantText, 0);
            this.m_constantWidget.createGapLabel(10);
            this.m_constantWidget.addComponent(this.m_constantCombo, 0);
            this.m_constantWidget.addStretch(100);
            this.addPoly(this.m_constantCombo);
            this.m_mainPanel.setLayout(this.m_cardLayout);
            DefaultListModel<String> model = new DefaultListModel<String>();
            model.addElement(this.m_modelModInfo.Mod_Constant);
            model.addElement(this.m_modelModInfo.Mod_Clip);
            model.addElement(this.m_modelModInfo.Mod_GridSmooth);
            model.addElement(this.m_modelModInfo.Mod_PolygonEdit);
            model.addElement(this.m_modelModInfo.Mod_ImportColumn);
            this.m_mainPanel.add((Component)this.m_constantWidget, this.m_modelModInfo.Mod_Constant);
            this.m_mainPanel.add((Component)this.m_clipWidget, this.m_modelModInfo.Mod_Clip);
            this.m_mainPanel.add((Component)this.m_smoothWidget, this.m_modelModInfo.Mod_GridSmooth);
            this.m_mainPanel.add((Component)this.m_polyWidget, this.m_modelModInfo.Mod_PolygonEdit);
            this.m_mainPanel.add((Component)this.m_importWidget, this.m_modelModInfo.Mod_ImportColumn);
            this.m_mainPanel.add((Component)this.m_upholeWidget, this.m_modelModInfo.Mod_UpholeCompute);
            this.m_list.getSelectionModel().setSelectionMode(0);
            this.m_list.getSelectionModel().addListSelectionListener(this);
            this.m_list.setModel(model);
            LinearLayoutWidget left = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null, 0);
            left.addComponent(new JLabel("Modification method:"), 0);
            left.addComponent(new JScrollPane(this.m_list), 10);
            this.createGapLabel(30);
            this.addComponent(this.m_mainPanel, 10);
            this.m_list.setSelectedIndex(0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Table_Abstract shotTable = this._model.getSourceTable();
            Table_Abstract recTable = this._model.getReceiverTable();
            if (e.getSource() == this.m_smoothReloadColumnsButton) {
                ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection(shotTable, recTable);
                cols.add(0, "Do not use a column to weight smoothing");
                this.m_smoothWeightCombo.setStringArray(cols);
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton) {
                this.m_importColumnCombo.setStringArray(Tools_RefractionStaticsProject.getColumnList_Intersection(shotTable, recTable));
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
        try {
            this.m_modelModInfo.Polygon = RefractionStaticsProject.singleton().polygon();
            this.m_constantCombo.setVisible(this.m_modelModInfo.Polygon.valid());
            this.m_smoothCombo.setVisible(this.m_modelModInfo.Polygon.valid());
            this.m_clipCombo.setVisible(this.m_modelModInfo.Polygon.valid());
            if (!this.m_modelModInfo.Polygon.valid()) {
                this.m_constantCombo.setSelectedIndex(0);
                this.m_smoothCombo.setSelectedIndex(0);
                this.m_clipCombo.setSelectedIndex(0);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    protected void addPoly(JComboBox<String> combo) {
        try {
            combo.addItem("Do not use the polygon");
            combo.addItem("Modify INSIDE the polygon");
            combo.addItem("Modify OUTSIDE the polygon");
            combo.setSelectedIndex(0);
            combo.setVisible(this.m_modelModInfo.Polygon.valid());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.m_ignoreSel) {
                return;
            }
            this.m_modelModInfo.ModificationMethod = this.m_list.getSelectedValue();
            this.m_cardLayout.show(this.m_mainPanel, this.m_modelModInfo.ModificationMethod);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected PolygonUsage polyUsage(JComboBox<String> combo) {
        try {
            if (combo.getSelectedIndex() == 1) {
                return PolygonUsage.Inside;
            }
            if (combo.getSelectedIndex() == 2) {
                return PolygonUsage.Outside;
            }
            return PolygonUsage.NotUsed;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return PolygonUsage.NotUsed;
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        return true;
    }

    @Override
    public void leavingPage() {
        try {
            this.m_modelModInfo.ImportColumn = this.m_importColumnCombo.getSelectedString();
            this.m_modelModInfo.CutInside = this.m_polyCombo.getSelectedIndex() == 0;
            this.m_modelModInfo.SmoothRadius = Tools_Widget.extractDouble(this.m_smoothText, 1000.0, 1.0, 100000.0);
            this.m_modelModInfo.SmoothPolygon = this.polyUsage(this.m_smoothCombo);
            this.m_modelModInfo.SmoothUseWeight = this.m_smoothWeightCombo.getSelectedIndex() >= 1;
            this.m_modelModInfo.SmoothColumn = this.m_smoothWeightCombo.getSelectedString();
            this.m_modelModInfo.ClipMin = Tools_Widget.extractDouble(this.m_clipMinText, 0.0, -1.0E20, 1.0E20);
            this.m_modelModInfo.ClipMax = Tools_Widget.extractDouble(this.m_clipMaxText, 0.0, -1.0E20, 1.0E20);
            this.m_modelModInfo.ClipPolygon = this.polyUsage(this.m_clipCombo);
            this.m_modelModInfo.ConstantValue = Tools_Widget.extractDouble(this.m_constantText, 0.0, -1.0E20, 1.0E20);
            this.m_modelModInfo.ConstantPolygon = this.polyUsage(this.m_constantCombo);
            this.m_modelModInfo.UpholeMin = Tools_Widget.extractDouble(this.m_upholeMinText, 1000.0, 100.0, 20000.0);
            this.m_modelModInfo.UpholeMax = Tools_Widget.extractDouble(this.m_upholeMaxText, 1000.0, 100.0, 20000.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.m_ignoreSel = true;
            int curr = this.m_list.getSelectedIndex();
            DefaultListModel<String> model = new DefaultListModel<String>();
            model.addElement(this.m_modelModInfo.Mod_Constant);
            model.addElement(this.m_modelModInfo.Mod_Clip);
            model.addElement(this.m_modelModInfo.Mod_GridSmooth);
            model.addElement(this.m_modelModInfo.Mod_PolygonEdit);
            model.addElement(this.m_modelModInfo.Mod_ImportColumn);
            curr = Math.min(curr, 4);
            this.m_list.setModel(model);
            this.m_list.setSelectedIndex(curr);
            this.m_modelModInfo.ModificationMethod = this.m_list.getSelectedValue();
            this.m_cardLayout.show(this.m_mainPanel, this.m_modelModInfo.ModificationMethod);
            this.m_ignoreSel = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        this.m_ignoreSel = false;
    }

    protected class PolygonCombo
    extends JComboBox<String> {
        public PolygonCombo() {
            this.addItem("Do not use polygon");
            this.addItem("Inside polygon");
            this.addItem("Outside polygon");
        }

        public PolygonUsage getPolygonUsage() {
            return PolygonUsage.values()[this.getSelectedIndex()];
        }
    }
}

