/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.SelectedGeometryItem;

public class ModelSurfaceElevation {
    InteractiveModel _model;
    Table_Abstract _recTable;
    Table_Abstract _shotTable;
    String _sColumnName;
    int _iSrcColumnIndex = -1;
    int _iRecColumnIndex = -1;
    int _iSrcColumnShotIndex = -1;
    int _iRecColumnRecIndex = -1;

    public ModelSurfaceElevation(InteractiveModel model) {
        try {
            this._model = model;
            this._recTable = model.getReceiverTable();
            this._shotTable = model.getSourceTable();
            this._sColumnName = "Elevation";
            if (this._shotTable != null && this._recTable != null) {
                if (this._shotTable.column_exists(this._sColumnName)) {
                    this._iSrcColumnIndex = this._shotTable.column_indexOfColumn(this._sColumnName);
                }
                if (this._recTable.column_exists(this._sColumnName)) {
                    this._iRecColumnIndex = this._recTable.column_indexOfColumn(this._sColumnName);
                }
                if (this._shotTable.column_exists("ShotID")) {
                    this._iSrcColumnShotIndex = this._shotTable.column_indexOfColumn("ShotID");
                }
                if (this._recTable.column_exists("ReceiverID")) {
                    this._iRecColumnRecIndex = this._recTable.column_indexOfColumn("ReceiverID");
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String toString() {
        try {
            SelectedGeometryItem item = this._model.getSelectedItem();
            if (item.IsSrc.booleanValue()) {
                int nSrc = this._model.getSourceCount();
                if (item.Index >= 0 && item.Index < nSrc) {
                    double dVal = this.getShotValue(item.Index);
                    int iShotID = this.getShotID(item.Index);
                    return "Surface: " + String.format("%.2f", dVal) + " S: " + Integer.toString(iShotID);
                }
            } else {
                int nRec = this._model.getReceiverCount();
                if (item.Index >= 0 && item.Index < nRec) {
                    double dVal = this.getRecValue(item.Index);
                    int iRecID = this.getRecID(item.Index);
                    return "Surface : " + String.format("%.2f", dVal) + " R: " + Integer.toString(iRecID);
                }
            }
            return "Surface Elevation";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "error";
        }
    }

    public int getShotID(int iShotIndex) throws Exception {
        int iVal = 0;
        if (this._iSrcColumnIndex >= 0) {
            iVal = this._shotTable.getInt(iShotIndex, this._iSrcColumnShotIndex);
        }
        return iVal;
    }

    public double getShotValue(int iShotIndex) throws Exception {
        double dVal = 0.0;
        if (this._iSrcColumnIndex >= 0) {
            dVal = this._shotTable.getDouble(iShotIndex, this._iSrcColumnIndex);
        }
        return dVal;
    }

    public int getRecID(int iRecIndex) throws Exception {
        int iVal = 0;
        if (this._iSrcColumnIndex >= 0) {
            iVal = this._recTable.getInt(iRecIndex, this._iRecColumnRecIndex);
        }
        return iVal;
    }

    public double getRecValue(int iRecIndex) throws Exception {
        double dVal = 0.0;
        if (this._iRecColumnIndex >= 0) {
            dVal = this._recTable.getDouble(iRecIndex, this._iRecColumnIndex);
        }
        return dVal;
    }
}

